/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOfferWithLocation;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BlueprintOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.WeaponBlueprintOffer;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaponBlueprintOfferCreator
extends BlueprintOfferCreator {
    public static String PREFIX = "wpn_";

    public WeaponBlueprintOfferCreator(float frequency) {
        super(frequency);
    }

    @Override
    protected BaseHistorianOfferWithLocation createOffer(SectorEntityToken entity, String data) {
        return new WeaponBlueprintOffer(entity, data);
    }

    @Override
    protected List<Object> getAllSpecs() {
        return new ArrayList<Object>(Global.getSettings().getAllWeaponSpecs());
    }

    @Override
    protected String getAlreadyUsedIdFromOffer(HistorianData.HistorianOffer offer) {
        if (offer instanceof WeaponBlueprintOffer) {
            WeaponBlueprintOffer wbo = (WeaponBlueprintOffer)offer;
            return wbo.getData();
        }
        return null;
    }

    @Override
    protected String getIdForSpec(Object spec) {
        return ((WeaponSpecAPI)spec).getWeaponId();
    }

    @Override
    protected Set<String> getTagsForSpec(Object spec) {
        return ((WeaponSpecAPI)spec).getTags();
    }

    @Override
    protected float getRarityForSpec(Object spec) {
        return ((WeaponSpecAPI)spec).getRarity();
    }

    @Override
    protected boolean playerKnowsSpecAlready(String id) {
        return Global.getSector().getPlayerFaction().knowsWeapon(id);
    }

    @Override
    protected float getProbabilityRuins() {
        return super.getProbabilityRuins();
    }

    @Override
    public String getOfferId(BaseHistorianOffer offer) {
        if (offer instanceof WeaponBlueprintOffer) {
            return String.valueOf(PREFIX) + ((WeaponBlueprintOffer)offer).getData();
        }
        return null;
    }

    @Override
    public String getBlueprintIdFromOfferId(String offerId) {
        if (offerId.startsWith(PREFIX)) {
            return offerId.replaceAll(PREFIX, "");
        }
        return null;
    }
}

