/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.Tuning;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.ids.MemFlags;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.PersonBountyIntel;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.PirateBaseRumorBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateActivityIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateBasePirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.raid.PirateRaidActionStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.PirateRaidAssembleStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.intel.raid.ReturnStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.TravelStage;
import com.fs.starfarer.api.impl.campaign.procgen.MarkovNames;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirateBaseIntel
extends BaseIntelPlugin
implements EveryFrameScript,
FleetEventListener,
EconomyAPI.EconomyUpdateListener,
RaidIntel.RaidDelegate {
    public static final String PIRATE_BASE_COMMANDER = "$pirateBaseCommander";
    public static final String HAS_DEAL_WITH_BASE_COMMANDER = "$playerHasDealWithPirateBaseCommander";
    public static String MEM_FLAG = "$core_pirateBase";
    public static Object DEAL_MADE_PARAM = new Object();
    public static Object DEAL_BROKEN_PARAM = new Object();
    public static Object DEAL_CANCELLED_PARAM = new Object();
    public static Object BOUNTY_EXPIRED_PARAM = new Object();
    public static Object DISCOVERED_PARAM = new Object();
    public static Logger log = Global.getLogger(PirateBaseIntel.class);
    protected StarSystemAPI system;
    protected MarketAPI market;
    protected PersonAPI baseCommander;
    protected SectorEntityToken entity;
    protected float elapsedDays = 0.0f;
    protected float duration = 45.0f;
    protected BaseBountyData bountyData = null;
    protected PirateBaseTier tier;
    protected PirateBaseTier matchedStationToTier = null;
    protected IntervalUtil monthlyInterval = new IntervalUtil(20.0f, 40.0f);
    protected int raidTimeoutMonths = 0;
    protected CampaignFleetAPI addedListenerTo = null;
    protected PersonBountyIntel.BountyResult result = null;
    protected boolean sentBountyUpdate = false;
    protected int monthsWithSameTarget = 0;
    protected int monthsAtCurrentTier = 0;
    protected StarSystemAPI target = null;
    protected boolean targetPlayerColoniesOnly = false;
    protected StarSystemAPI forceTarget = null;

    public static PirateBaseIntel getIntelFor(StarSystemAPI system) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            if (((PirateBaseIntel)intel).getSystem() != system) continue;
            return (PirateBaseIntel)intel;
        }
        return null;
    }

    public static PirateBaseIntel getIntelFor(SectorEntityToken station) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            if (((PirateBaseIntel)intel).getEntity() != station) continue;
            return (PirateBaseIntel)intel;
        }
        return null;
    }

    public boolean playerHasDealWithBaseCommander() {
        return this.baseCommander != null && this.baseCommander.getMemoryWithoutUpdate().getBoolean(HAS_DEAL_WITH_BASE_COMMANDER);
    }

    public void setPlayerHasDealWithBaseCommander(boolean hasDeal) {
        if (this.baseCommander == null) {
            return;
        }
        this.baseCommander.getMemoryWithoutUpdate().set(HAS_DEAL_WITH_BASE_COMMANDER, hasDeal);
    }

    public PirateBaseIntel(StarSystemAPI system, String factionId, PirateBaseTier tier) {
        this.system = system;
        this.tier = tier;
        this.raidTimeoutMonths = Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + Misc.random.nextInt(Tuning.PIRATE_RAID_MAX_TIMEOUT_MONTHS - Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + 1);
        this.market = Global.getFactory().createMarket(Misc.genUID(), "Pirate Base", 3);
        this.market.setSize(3);
        this.market.setHidden(true);
        this.market.getMemoryWithoutUpdate().set(MEM_FLAG, true);
        this.market.getMemoryWithoutUpdate().set(MemFlags.HIDDEN_BASE_MEM_FLAG, true);
        this.market.setFactionId("pirates");
        this.market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        this.market.setFactionId(factionId);
        this.market.addCondition("population_3");
        this.market.addIndustry("population");
        this.market.addIndustry("spaceport");
        this.market.addIndustry("militarybase");
        this.market.addSubmarket("open_market");
        this.market.addSubmarket("black_market");
        this.market.getTariff().modifyFlat("default_tariff", this.market.getFaction().getTariffFraction());
        LinkedHashMap<BaseThemeGenerator.LocationType, Float> weights = new LinkedHashMap<BaseThemeGenerator.LocationType, Float>();
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_BELT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_FIELD, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_RING, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_SMALL_NEBULA, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.GAS_GIANT_ORBIT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.PLANET_ORBIT, Float.valueOf(10.0f));
        WeightedRandomPicker<BaseThemeGenerator.EntityLocation> locs = BaseThemeGenerator.getLocations(null, system, null, 100.0f, weights);
        BaseThemeGenerator.EntityLocation loc = locs.pick();
        if (loc == null) {
            this.endImmediately();
            return;
        }
        BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(system, loc, "makeshift_station", factionId);
        if (added == null || added.entity == null) {
            this.endImmediately();
            return;
        }
        this.entity = added.entity;
        String name = this.generateName();
        if (name == null) {
            this.endImmediately();
            return;
        }
        this.market.setName(name);
        this.entity.setName(name);
        BaseThemeGenerator.convertOrbitWithSpin(this.entity, -5.0f);
        this.market.setPrimaryEntity(this.entity);
        this.entity.setMarket(this.market);
        this.entity.setSensorProfile(Float.valueOf(1.0f));
        this.entity.setDiscoverable(true);
        this.entity.getDetectedRangeMod().modifyFlat("gen", 5000.0f);
        this.market.setEconGroup(this.market.getId());
        this.market.getMemoryWithoutUpdate().set("$core_noDeciv", true);
        this.market.reapplyIndustries();
        Global.getSector().getEconomy().addMarket(this.market, true);
        this.baseCommander = this.market.getFaction().createRandomPerson(Misc.random);
        this.baseCommander.setRankId(Ranks.SPACE_CAPTAIN);
        this.baseCommander.setPostId(Ranks.POST_STATION_COMMANDER);
        this.baseCommander.setImportanceAndVoice(PersonImportance.HIGH, Misc.random);
        this.baseCommander.addTag("underworld");
        this.baseCommander.getMemoryWithoutUpdate().set(PIRATE_BASE_COMMANDER, true);
        this.market.getCommDirectory().addPerson(this.baseCommander);
        log.info((Object)String.format("Added pirate base in [%s], tier: %s", system.getName(), tier.name()));
        Global.getSector().getIntelManager().addIntel(this, true);
        this.timestamp = null;
        Global.getSector().getListenerManager().addListener(this);
        Global.getSector().getEconomy().addUpdateListener(this);
        this.updateTarget();
        PortsideBarData.getInstance().addEvent(new PirateBaseRumorBarEvent(this));
    }

    @Override
    public boolean isHidden() {
        if (super.isHidden()) {
            return true;
        }
        return this.timestamp == null;
    }

    public float getRaidFP() {
        float base = this.getBaseRaidFP();
        return base * (0.75f + (float)Math.random() * 0.5f);
    }

    public float getBaseRaidFP() {
        float base = 100.0f;
        switch (this.tier) {
            case TIER_1_1MODULE: {
                base = 100.0f;
                break;
            }
            case TIER_2_1MODULE: {
                base = 150.0f;
                break;
            }
            case TIER_3_2MODULE: {
                base = 250.0f;
                break;
            }
            case TIER_4_3MODULE: {
                base = 300.0f;
                break;
            }
            case TIER_5_3MODULE: {
                base = 450.0f;
            }
        }
        return base * (0.75f + (float)Math.random() * 0.5f);
    }

    @Override
    public void notifyRaidEnded(RaidIntel raid, RaidIntel.RaidStageStatus status) {
        if (status == RaidIntel.RaidStageStatus.SUCCESS) {
            this.raidTimeoutMonths = Math.max(this.raidTimeoutMonths, Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + Misc.random.nextInt(Tuning.PIRATE_RAID_MAX_TIMEOUT_MONTHS - Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + 1));
        } else {
            float base = this.getBaseRaidFP();
            float raidFP = raid.getAssembleStage().getOrigSpawnFP();
            this.raidTimeoutMonths += Math.min(Math.round(raidFP / base) * 2, Tuning.PIRATE_RAID_DEFEATED_TIMEOUT_MONTHS);
        }
    }

    public void startRaid(StarSystemAPI target, float raidFP) {
        boolean hasTargets = false;
        for (MarketAPI curr : Misc.getMarketsInLocation(target)) {
            if (!curr.getFaction().isHostileTo(this.getFactionForUIColors())) continue;
            hasTargets = true;
            break;
        }
        if (!hasTargets) {
            return;
        }
        RaidIntel raid = new RaidIntel(target, this.getFactionForUIColors(), this);
        float successMult = 0.5f;
        JumpPointAPI gather = null;
        List points = this.system.getEntities(JumpPointAPI.class);
        float min = Float.MAX_VALUE;
        for (JumpPointAPI curr : points) {
            float dist = Misc.getDistance(this.entity.getLocation(), curr.getLocation());
            if (!(dist < min)) continue;
            min = dist;
            gather = curr;
        }
        JumpPointAPI raidJump = RouteLocationCalculator.findJumpPointToUse(this.getFactionForUIColors(), target.getCenter());
        if (gather == null || raidJump == null) {
            return;
        }
        PirateRaidAssembleStage assemble = new PirateRaidAssembleStage(raid, gather, this);
        assemble.addSource(this.market);
        assemble.setSpawnFP(raidFP);
        assemble.setAbortFP(raidFP * successMult);
        raid.addStage(assemble);
        TravelStage travel = new TravelStage(raid, gather, raidJump, false);
        travel.setAbortFP(raidFP * successMult);
        raid.addStage(travel);
        PirateRaidActionStage action = new PirateRaidActionStage(raid, target);
        action.setAbortFP(raidFP * successMult);
        raid.addStage(action);
        raid.addStage(new ReturnStage(raid));
        boolean shouldNotify = raid.shouldSendUpdate();
        Global.getSector().getIntelManager().addIntel(raid, !shouldNotify);
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    protected String pickStationType() {
        WeightedRandomPicker<String> stations = new WeightedRandomPicker<String>();
        if (this.getFactionForUIColors().getCustom().has("pirateBaseStationTypes")) {
            try {
                JSONObject json = this.getFactionForUIColors().getCustom().getJSONObject("pirateBaseStationTypes");
                String[] stringArray = JSONObject.getNames((JSONObject)json);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    stations.add(key, (float)json.optDouble(key, 0.0));
                    ++n2;
                }
            }
            catch (JSONException e) {
                stations.clear();
            }
        }
        if (stations.isEmpty()) {
            stations.add("orbitalstation", 5.0f);
            stations.add("orbitalstation_mid", 3.0f);
            stations.add("orbitalstation_high", 1.0f);
        }
        return (String)stations.pick();
    }

    protected Industry getStationIndustry() {
        for (Industry curr : this.market.getIndustries()) {
            if (!curr.getSpec().hasTag("station")) continue;
            return curr;
        }
        return null;
    }

    protected void updateStationIfNeeded() {
        if (this.matchedStationToTier == this.tier) {
            return;
        }
        this.matchedStationToTier = this.tier;
        this.monthsAtCurrentTier = 0;
        Industry stationInd = this.getStationIndustry();
        String currIndId = null;
        if (stationInd != null) {
            currIndId = stationInd.getId();
            this.market.removeIndustry(stationInd.getId(), null, false);
            stationInd = null;
        }
        if (currIndId == null) {
            currIndId = this.pickStationType();
        }
        if (currIndId == null) {
            return;
        }
        this.market.addIndustry(currIndId);
        stationInd = this.getStationIndustry();
        if (stationInd == null) {
            return;
        }
        stationInd.finishBuildingOrUpgrading();
        CampaignFleetAPI fleet = Misc.getStationFleet(this.entity);
        if (fleet == null) {
            return;
        }
        List<FleetMemberAPI> members = fleet.getFleetData().getMembersListCopy();
        if (members.size() < 1) {
            return;
        }
        fleet.inflateIfNeeded();
        FleetMemberAPI station = members.get(0);
        WeightedRandomPicker<Integer> picker = new WeightedRandomPicker<Integer>();
        int index = 1;
        for (String slotId : station.getVariant().getModuleSlots()) {
            ShipVariantAPI mv = station.getVariant().getModuleVariant(slotId);
            if (Misc.isActiveModule(mv)) {
                picker.add(index, 1.0f);
            }
            ++index;
        }
        float removeMult = 0.0f;
        switch (this.tier) {
            case TIER_1_1MODULE: 
            case TIER_2_1MODULE: {
                removeMult = 0.67f;
                break;
            }
            case TIER_3_2MODULE: {
                removeMult = 0.33f;
                break;
            }
            case TIER_4_3MODULE: 
            case TIER_5_3MODULE: {
                removeMult = 0.0f;
            }
        }
        int remove = Math.round((float)picker.getItems().size() * removeMult);
        if (remove < 1 && removeMult > 0.0f) {
            remove = 1;
        }
        if (remove >= picker.getItems().size() - 1) {
            remove = picker.getItems().size() - 2;
        }
        int i = 0;
        while (i < remove) {
            Integer pick = (Integer)picker.pickAndRemove();
            if (pick != null) {
                station.getStatus().setHullFraction(pick, 0.0f);
                station.getStatus().setDetached(pick, true);
                station.getStatus().setPermaDetached(pick, true);
            }
            ++i;
        }
        if (this.tier == PirateBaseTier.TIER_5_3MODULE || this.tier == PirateBaseTier.TIER_4_3MODULE) {
            this.baseCommander.setImportance(PersonImportance.VERY_HIGH);
        } else {
            this.baseCommander.setImportance(PersonImportance.HIGH);
        }
    }

    public CampaignFleetAPI getAddedListenerTo() {
        return this.addedListenerTo;
    }

    @Override
    protected void advanceImpl(float amount) {
        CampaignFleetAPI fleet;
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.getPlayerVisibleTimestamp() == null && this.entity.isInCurrentLocation() && this.isHidden()) {
            this.makeKnown();
            this.sendUpdateIfPlayerHasIntel(DISCOVERED_PARAM, false);
        }
        if (!this.sentBountyUpdate && this.bountyData != null && (Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay() || !this.isHidden() && DebugFlags.SEND_UPDATES_WHEN_NO_COMM)) {
            this.makeKnown();
            this.sendUpdateIfPlayerHasIntel((Object)this.bountyData, false);
            this.sentBountyUpdate = true;
        }
        if ((fleet = Misc.getStationFleet(this.market)) != null && this.addedListenerTo != fleet) {
            if (this.addedListenerTo != null) {
                this.addedListenerTo.removeEventListener(this);
            }
            fleet.addEventListener(this);
            this.addedListenerTo = fleet;
        }
        if (this.target != null && this.getAffectedMarkets(this.target).isEmpty()) {
            this.clearTarget();
        }
        if (DebugFlags.RAID_DEBUG) {
            days *= 100.0f;
        }
        this.monthlyInterval.advance(days);
        if (this.monthlyInterval.intervalElapsed()) {
            boolean allowRandomRaids;
            ++this.monthsWithSameTarget;
            --this.raidTimeoutMonths;
            if (this.raidTimeoutMonths < 0) {
                this.raidTimeoutMonths = 0;
            }
            if (this.monthsWithSameTarget > 6 && (float)Math.random() < 0.2f || this.target == null) {
                this.updateTarget();
            }
            if (this.target != null && (float)Math.random() < (float)this.monthsWithSameTarget * 0.05f && this.bountyData == null) {
                this.setBounty();
            }
            boolean bl = allowRandomRaids = PirateBaseManager.getInstance().getDaysSinceStart() > Tuning.NO_PIRATE_RAID_DAYS_FROM_GAME_START;
            if (this.target != null && ((float)Math.random() < 0.2f && allowRandomRaids || this.targetPlayerColoniesOnly) && this.raidTimeoutMonths <= 0) {
                this.startRaid(this.target, this.getRaidFP());
                this.raidTimeoutMonths = Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + Misc.random.nextInt(Tuning.PIRATE_RAID_MAX_TIMEOUT_MONTHS - Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + 1);
            }
            this.checkForTierChange();
        }
        if (this.bountyData != null) {
            boolean canEndBounty = !this.entity.isInCurrentLocation();
            this.bountyData.bountyElapsedDays += days;
            if (this.bountyData.bountyElapsedDays > this.bountyData.bountyDuration && canEndBounty) {
                this.endBounty();
            }
        }
        this.updateStationIfNeeded();
    }

    protected void checkForTierChange() {
        if (this.bountyData != null) {
            return;
        }
        if (this.entity.isInCurrentLocation()) {
            return;
        }
        float minMonths = Global.getSettings().getFloat("pirateBaseMinMonthsForNextTier");
        if ((float)this.monthsAtCurrentTier > minMonths) {
            PirateBaseTier next;
            float prob = ((float)this.monthsAtCurrentTier - minMonths) * 0.1f;
            if ((float)Math.random() < prob && (next = this.getNextTier(this.tier)) != null) {
                this.tier = next;
                this.updateStationIfNeeded();
                this.monthsAtCurrentTier = 0;
                return;
            }
        }
        ++this.monthsAtCurrentTier;
    }

    protected PirateBaseTier getNextTier(PirateBaseTier tier) {
        switch (tier) {
            case TIER_1_1MODULE: {
                return PirateBaseTier.TIER_2_1MODULE;
            }
            case TIER_2_1MODULE: {
                return PirateBaseTier.TIER_3_2MODULE;
            }
            case TIER_3_2MODULE: {
                return PirateBaseTier.TIER_4_3MODULE;
            }
            case TIER_4_3MODULE: {
                return PirateBaseTier.TIER_5_3MODULE;
            }
            case TIER_5_3MODULE: {
                return null;
            }
        }
        return null;
    }

    protected PirateBaseTier getPrevTier(PirateBaseTier tier) {
        switch (tier) {
            case TIER_1_1MODULE: {
                return null;
            }
            case TIER_2_1MODULE: {
                return PirateBaseTier.TIER_1_1MODULE;
            }
            case TIER_3_2MODULE: {
                return PirateBaseTier.TIER_2_1MODULE;
            }
            case TIER_4_3MODULE: {
                return PirateBaseTier.TIER_3_2MODULE;
            }
            case TIER_5_3MODULE: {
                return PirateBaseTier.TIER_4_3MODULE;
            }
        }
        return null;
    }

    public void makeKnown() {
        this.makeKnown(null);
    }

    public void makeKnown(TextPanelAPI text) {
        if (this.getPlayerVisibleTimestamp() == null) {
            Global.getSector().getIntelManager().removeIntel(this);
            Global.getSector().getIntelManager().addIntel(this, text == null, text);
        }
    }

    @Override
    public float getTimeRemainingFraction() {
        float f = 1.0f - this.elapsedDays / this.duration;
        return f;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        log.info((Object)String.format("Removing pirate base at [%s]", this.system.getName()));
        Global.getSector().getListenerManager().removeListener(this);
        this.clearTarget();
        Global.getSector().getEconomy().removeMarket(this.market);
        Global.getSector().getEconomy().removeUpdateListener(this);
        Misc.removeRadioChatter(this.market);
        this.market.advance(0.0f);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (this.isEnding()) {
            return;
        }
        if (this.addedListenerTo != null && fleet == this.addedListenerTo) {
            BattleAPI battle;
            Misc.fadeAndExpire(this.entity);
            this.endAfterDelay();
            this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_OTHER, 0, null);
            if (reason == CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE && param instanceof BattleAPI && (battle = (BattleAPI)param).isPlayerInvolved()) {
                int payment = 0;
                if (this.bountyData != null) {
                    payment = (int)(this.bountyData.baseBounty * battle.getPlayerInvolvementFraction());
                }
                if (payment > 0) {
                    Global.getSector().getPlayerFleet().getCargo().getCredits().add(payment);
                    CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                    impact.delta = this.bountyData.repChange * battle.getPlayerInvolvementFraction();
                    if (impact.delta < 0.01f) {
                        impact.delta = 0.01f;
                    }
                    ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, null, false, true), this.bountyData.bountyFaction.getId());
                    this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY, payment, rep);
                } else {
                    this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD, 0, null);
                }
            }
            boolean sendUpdate = DebugFlags.SEND_UPDATES_WHEN_NO_COMM || this.result.type != PersonBountyIntel.BountyResultType.END_OTHER || Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay();
            sendUpdate = true;
            if (sendUpdate) {
                this.sendUpdateIfPlayerHasIntel((Object)this.result, false);
            }
            PirateBaseManager.getInstance().incrDestroyed();
            PirateBaseManager.markRecentlyUsedForBase(this.system);
        }
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (this.getListInfoParam() == DEAL_BROKEN_PARAM) {
            info.addPara("Agreement broken", initPad, tc, Misc.getNegativeHighlightColor(), "Agreement broken");
            initPad = 0.0f;
        } else if (this.getListInfoParam() == DEAL_CANCELLED_PARAM) {
            info.addPara("Agreement dissolved", tc, initPad);
            initPad = 0.0f;
        } else if ((mode == IntelInfoPlugin.ListInfoMode.INTEL || this.getListInfoParam() == DEAL_MADE_PARAM) && this.playerHasDealWithBaseCommander()) {
            info.addPara("Agreement made with base commander", initPad, tc, Misc.getPositiveHighlightColor(), "Agreement");
            initPad = 0.0f;
        }
        if (this.bountyData != null && this.result == null && this.getListInfoParam() != BOUNTY_EXPIRED_PARAM) {
            if (isUpdate || mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
                FactionAPI faction = this.bountyData.bountyFaction;
                info.addPara("Bounty faction: " + faction.getDisplayName(), initPad, tc, faction.getBaseUIColor(), faction.getDisplayName());
                initPad = 0.0f;
            }
            info.addPara("%s reward", initPad, tc, h, Misc.getDGSCredits(this.bountyData.baseBounty));
            this.addDays(info, "remaining", this.bountyData.bountyDuration - this.bountyData.bountyElapsedDays, tc);
        }
        if (this.result != null && this.bountyData != null) {
            switch (this.result.type) {
                case END_PLAYER_BOUNTY: {
                    info.addPara("%s received", initPad, tc, h, Misc.getDGSCredits(this.result.payment));
                    CoreReputationPlugin.addAdjustmentMessage(this.result.rep.delta, this.bountyData.bountyFaction, null, null, null, info, tc, isUpdate, 0.0f);
                    break;
                }
                case END_TIME: {
                    break;
                }
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        return String.valueOf(base) + " Base";
    }

    @Override
    public String getName() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        if (this.getListInfoParam() == this.bountyData && this.bountyData != null) {
            return String.valueOf(base) + " Base - Bounty Posted";
        }
        if (this.getListInfoParam() == BOUNTY_EXPIRED_PARAM) {
            return String.valueOf(base) + " Base - Bounty Expired";
        }
        if (this.result != null) {
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY) {
                return String.valueOf(base) + " Base - Bounty Completed";
            }
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD) {
                return String.valueOf(base) + " Base - Destroyed";
            }
        }
        String name = this.market.getName();
        if (this.isEnding()) {
            return String.valueOf(base) + " Base - Abandoned";
        }
        if (this.getListInfoParam() == DISCOVERED_PARAM) {
            return String.valueOf(base) + " Base - Discovered";
        }
        if (this.entity.isDiscoverable()) {
            return String.valueOf(base) + " Base - Exact Location Unknown";
        }
        return String.valueOf(base) + " Base - " + name;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.market.getFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.market.getFaction();
        info.addImage(faction.getLogo(), width, 128.0f, opad);
        String has = faction.getDisplayNameHasOrHave();
        info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + has + " established a base in the " + this.market.getContainingLocation().getNameWithLowercaseType() + ". " + "The base serves as a staging ground for raids against nearby colonies.", opad, faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
        if (!this.entity.isDiscoverable()) {
            switch (this.tier) {
                case TIER_1_1MODULE: {
                    info.addPara("It has limited defensive capabilities and is protected by a few fleets.", opad);
                    break;
                }
                case TIER_2_1MODULE: {
                    info.addPara("It has limited defensive capabilities and is protected by a small number of fleets.", opad);
                    break;
                }
                case TIER_3_2MODULE: {
                    info.addPara("It has fairly well-developed defensive capabilities and is protected by a considerable number of fleets.", opad);
                    break;
                }
                case TIER_4_3MODULE: {
                    info.addPara("It has very well-developed defensive capabilities and is protected by a large number of fleets.", opad);
                    break;
                }
                case TIER_5_3MODULE: {
                    info.addPara("It has very well-developed defensive capabilities and is protected by a large number of fleets. Both the base and the fleets have elite-level equipment, at least by pirate standards.", opad);
                }
            }
        } else {
            info.addPara("You have not yet discovered the exact location or capabilities of this base.", opad);
        }
        boolean deal = this.playerHasDealWithBaseCommander();
        if (deal) {
            float feeFraction = Global.getSettings().getFloat("pirateProtectionPaymentFraction");
            String fee = Misc.getDGSCredits(HA_CMD.computePirateProtectionPaymentPerMonth(this));
            LabelAPI label = info.addPara("You have an %s with the base commander, and fleets from this base do not, as a rule, harass your colonies or shipping. The protection payment is %s of the gross income of all of your affected colonies, which amounts to %s per month at their current level of income.", opad, Misc.getPositiveHighlightColor(), "agreement", Math.round(feeFraction * 100.0f) + "%", fee);
            label.setHighlightColors(Misc.getPositiveHighlightColor(), h, h);
            label.setHighlight("agreement", Math.round(feeFraction * 100.0f) + "%", fee);
        }
        info.addSectionHeading("Recent events", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
        if (this.target != null && !this.getAffectedMarkets(this.target).isEmpty() && !this.isEnding()) {
            info.addPara("Pirates operating from this base have been targeting the " + this.target.getNameWithLowercaseType() + ".", opad);
        }
        if (this.bountyData != null) {
            info.addPara(String.valueOf(Misc.ucFirst(this.bountyData.bountyFaction.getDisplayNameWithArticle())) + " " + this.bountyData.bountyFaction.getDisplayNameHasOrHave() + " posted a bounty for the destruction of this base.", opad, this.bountyData.bountyFaction.getBaseUIColor(), this.bountyData.bountyFaction.getDisplayNameWithArticleWithoutArticle());
            if (this.result != null && this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY) {
                info.addPara("You have successfully completed this bounty.", opad);
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
        if (this.result != null) {
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD) {
                info.addPara("You have destroyed this base.", opad);
            } else if (this.result.type == PersonBountyIntel.BountyResultType.END_OTHER) {
                info.addPara("It is rumored that this base is no longer operational.", opad);
            }
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "pirate_base");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        if (this.bountyData != null) {
            tags.add("Bounties");
        }
        tags.add("Exploration");
        if (this.target != null && !Misc.getMarketsInLocation(this.target, "player").isEmpty()) {
            tags.add("Colony threats");
        }
        if (!PirateBasePirateActivityCause2.getColoniesAffectedBy(this).isEmpty()) {
            tags.add("Colony threats");
        }
        tags.add(this.market.getFactionId());
        if (this.bountyData != null) {
            tags.add(this.bountyData.bountyFaction.getId());
        }
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.market.getPrimaryEntity().isDiscoverable()) {
            return this.system.getCenter();
        }
        return this.market.getPrimaryEntity();
    }

    protected String generateName() {
        MarkovNames.loadIfNeeded();
        MarkovNames.MarkovNameResult gen = null;
        int i = 0;
        while (i < 10) {
            String test;
            gen = MarkovNames.generate(null);
            if (gen != null && !(test = gen.name).toLowerCase().startsWith("the ")) {
                String p = this.pickPostfix();
                if (p != null && !p.isEmpty()) {
                    test = String.valueOf(test) + " " + p;
                }
                if (test.length() <= 22) {
                    return test;
                }
            }
            ++i;
        }
        return null;
    }

    protected String pickPostfix() {
        WeightedRandomPicker<String> post = new WeightedRandomPicker<String>();
        post.add("Asylum");
        post.add("Astrome");
        post.add("Barrage");
        post.add("Briganderie");
        post.add("Camp");
        post.add("Cover");
        post.add("Citadel");
        post.add("Den");
        post.add("Donjon");
        post.add("Depot");
        post.add("Fort");
        post.add("Freehold");
        post.add("Freeport");
        post.add("Freehaven");
        post.add("Free Orbit");
        post.add("Galastat");
        post.add("Garrison");
        post.add("Harbor");
        post.add("Haven");
        post.add("Headquarters");
        post.add("Hideout");
        post.add("Hideaway");
        post.add("Hold");
        post.add("Lair");
        post.add("Locus");
        post.add("Main");
        post.add("Mine Depot");
        post.add("Nexus");
        post.add("Orbit");
        post.add("Port");
        post.add("Post");
        post.add("Presidio");
        post.add("Prison");
        post.add("Platform");
        post.add("Corsairie");
        post.add("Refuge");
        post.add("Retreat");
        post.add("Refinery");
        post.add("Shadow");
        post.add("Safehold");
        post.add("Starhold");
        post.add("Starport");
        post.add("Stardock");
        post.add("Sanctuary");
        post.add("Station");
        post.add("Spacedock");
        post.add("Tertiary");
        post.add("Terminus");
        post.add("Terminal");
        post.add("Tortuga");
        post.add("Ward");
        post.add("Warsat");
        return (String)post.pick();
    }

    @Override
    public void commodityUpdated(String commodityId) {
        CommodityOnMarketAPI com = this.market.getCommodityData(commodityId);
        int curr = 0;
        String modId = this.market.getId();
        MutableStat.StatMod mod = com.getAvailableStat().getFlatStatMod(modId);
        if (mod != null) {
            curr = Math.round(mod.value);
        }
        int avWithoutPenalties = Math.round(com.getAvailableStat().getBaseValue());
        for (MutableStat.StatMod m : com.getAvailableStat().getFlatMods().values()) {
            if (m.value < 0.0f) continue;
            avWithoutPenalties += Math.round(m.value);
        }
        int a = com.getAvailable() - curr;
        a = avWithoutPenalties - curr;
        int d = com.getMaxDemand();
        if (d > a) {
            int supply = Math.max(1, d - a);
            com.getAvailableStat().modifyFlat(modId, supply, "Brought in by raiders");
        }
    }

    @Override
    public void economyUpdated() {
        float fleetSizeBonus = 1.0f;
        float qualityBonus = 0.0f;
        int light = 0;
        int medium = 0;
        int heavy = 0;
        switch (this.tier) {
            case TIER_1_1MODULE: {
                qualityBonus = 0.0f;
                fleetSizeBonus = 0.2f;
                break;
            }
            case TIER_2_1MODULE: {
                qualityBonus = 0.2f;
                fleetSizeBonus = 0.3f;
                light = 2;
                break;
            }
            case TIER_3_2MODULE: {
                qualityBonus = 0.3f;
                fleetSizeBonus = 0.4f;
                light = 2;
                medium = 1;
                break;
            }
            case TIER_4_3MODULE: {
                qualityBonus = 0.4f;
                fleetSizeBonus = 0.5f;
                light = 2;
                medium = 2;
                break;
            }
            case TIER_5_3MODULE: {
                qualityBonus = 0.5f;
                fleetSizeBonus = 0.75f;
                light = 2;
                medium = 2;
                heavy = 2;
            }
        }
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlatAlways(this.market.getId(), qualityBonus, "Development level");
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlatAlways(this.market.getId(), fleetSizeBonus, "Development level");
        String modId = this.market.getId();
        this.market.getStats().getDynamic().getMod("patrol_num_light_mod").modifyFlat(modId, light);
        this.market.getStats().getDynamic().getMod("patrol_num_medium_mod").modifyFlat(modId, medium);
        this.market.getStats().getDynamic().getMod("patrol_num_heavy_mod").modifyFlat(modId, heavy);
    }

    @Override
    public boolean isEconomyListenerExpired() {
        return this.isEnded();
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    protected void setBounty() {
        this.bountyData = new BaseBountyData();
        float base = 100000.0f;
        switch (this.tier) {
            case TIER_1_1MODULE: {
                base = Global.getSettings().getFloat("pirateBaseBounty1");
                this.bountyData.repChange = 0.02f;
                break;
            }
            case TIER_2_1MODULE: {
                base = Global.getSettings().getFloat("pirateBaseBounty2");
                this.bountyData.repChange = 0.05f;
                break;
            }
            case TIER_3_2MODULE: {
                base = Global.getSettings().getFloat("pirateBaseBounty3");
                this.bountyData.repChange = 0.06f;
                break;
            }
            case TIER_4_3MODULE: {
                base = Global.getSettings().getFloat("pirateBaseBounty4");
                this.bountyData.repChange = 0.07f;
                break;
            }
            case TIER_5_3MODULE: {
                base = Global.getSettings().getFloat("pirateBaseBounty5");
                this.bountyData.repChange = 0.1f;
            }
        }
        this.bountyData.baseBounty = base * (0.9f + (float)Math.random() * 0.2f);
        this.bountyData.baseBounty = (int)(this.bountyData.baseBounty / 10000.0f) * 10000;
        WeightedRandomPicker<FactionAPI> picker = new WeightedRandomPicker<FactionAPI>();
        for (MarketAPI curr : Global.getSector().getEconomy().getMarkets(this.target)) {
            if (curr.getFaction().isPlayerFaction() || !this.affectsMarket(curr)) continue;
            picker.add(curr.getFaction(), (float)Math.pow(2.0, curr.getSize()));
        }
        FactionAPI faction = (FactionAPI)picker.pick();
        if (faction == null) {
            this.bountyData = null;
            return;
        }
        this.bountyData.bountyFaction = faction;
        this.bountyData.bountyDuration = 180.0f;
        this.bountyData.bountyElapsedDays = 0.0f;
        Misc.makeImportant(this.entity, "baseBounty");
        this.sentBountyUpdate = false;
    }

    protected void endBounty() {
        this.sendUpdateIfPlayerHasIntel(BOUNTY_EXPIRED_PARAM, false);
        this.bountyData = null;
        this.sentBountyUpdate = false;
        Misc.makeUnimportant(this.entity, "baseBounty");
    }

    public void updateTarget() {
        StarSystemAPI newTarget = this.pickTarget();
        if (newTarget == this.target) {
            return;
        }
        this.clearTarget();
        this.target = newTarget;
        this.monthsWithSameTarget = 0;
        if (this.target != null) {
            new PirateActivityIntel(this.target, this);
        }
    }

    public StarSystemAPI getTarget() {
        return this.target;
    }

    protected void clearTarget() {
        if (this.target != null) {
            this.target = null;
            this.monthsWithSameTarget = 0;
        }
    }

    public List<MarketAPI> getAffectedMarkets(StarSystemAPI system) {
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (MarketAPI curr : Global.getSector().getEconomy().getMarkets(system)) {
            if (!this.affectsMarket(curr)) continue;
            result.add(curr);
        }
        return result;
    }

    public boolean affectsMarket(MarketAPI market) {
        if (market.isHidden()) {
            return false;
        }
        if (market.getFaction() == this.market.getFaction()) {
            return false;
        }
        return !market.getFaction().isPlayerFaction();
    }

    public void setTargetPlayerColoniesOnly(boolean targetPlayerColonies) {
        this.targetPlayerColoniesOnly = targetPlayerColonies;
    }

    public boolean isTargetPlayerColoniesOnly() {
        return this.targetPlayerColoniesOnly;
    }

    public StarSystemAPI getForceTarget() {
        return this.forceTarget;
    }

    public void setForceTarget(StarSystemAPI forceTarget) {
        this.forceTarget = forceTarget;
    }

    protected StarSystemAPI pickTarget() {
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>();
        boolean forceTargetIsValid = false;
        for (StarSystemAPI system : Global.getSector().getEconomy().getStarSystemsWithMarkets()) {
            float score = 0.0f;
            for (MarketAPI curr : Global.getSector().getEconomy().getMarkets(system)) {
                if (!this.affectsMarket(curr) || this.targetPlayerColoniesOnly && !curr.getFaction().isPlayerFaction()) continue;
                if (system == this.forceTarget) {
                    forceTargetIsValid = true;
                }
                if (curr.hasCondition("pirate_activity")) continue;
                float w = curr.getSize();
                float dist = Misc.getDistanceLY(curr.getLocationInHyperspace(), this.market.getLocationInHyperspace());
                float mult = 1.0f - Math.max(0.0f, dist - 10.0f) / 10.0f;
                if (mult < 0.1f) {
                    mult = 0.1f;
                }
                if (mult > 1.0f) {
                    mult = 1.0f;
                }
                if (!this.targetPlayerColoniesOnly && curr.getFaction().isPlayerFaction() && dist > 15.0f) continue;
                score += w * mult;
            }
            picker.add(system, score);
        }
        if (forceTargetIsValid) {
            return this.forceTarget;
        }
        return (StarSystemAPI)picker.pick();
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        SectorEntityToken iconEntity;
        if (this.target == null || this.target == this.entity.getContainingLocation()) {
            return null;
        }
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        SectorEntityToken entityFrom = this.entity;
        if (map != null && (iconEntity = map.getIntelIconEntity(this)) != null) {
            entityFrom = iconEntity;
        }
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(entityFrom, this.target.getCenter());
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        result.add(arrow);
        return result;
    }

    public float getAccessibilityPenalty() {
        switch (this.tier) {
            case TIER_1_1MODULE: {
                return 0.1f;
            }
            case TIER_2_1MODULE: {
                return 0.2f;
            }
            case TIER_3_2MODULE: {
                return 0.3f;
            }
            case TIER_4_3MODULE: {
                return 0.4f;
            }
            case TIER_5_3MODULE: {
                return 0.5f;
            }
        }
        return 0.0f;
    }

    public float getStabilityPenalty() {
        switch (this.tier) {
            case TIER_1_1MODULE: {
                return 1.0f;
            }
            case TIER_2_1MODULE: {
                return 1.0f;
            }
            case TIER_3_2MODULE: {
                return 2.0f;
            }
            case TIER_4_3MODULE: {
                return 2.0f;
            }
            case TIER_5_3MODULE: {
                return 3.0f;
            }
        }
        return 0.0f;
    }

    public PirateBaseTier getTier() {
        return this.tier;
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    public PersonAPI getBaseCommander() {
        return this.baseCommander;
    }

    public void setBaseCommander(PersonAPI baseCommander) {
        this.baseCommander = baseCommander;
    }

    public static class BaseBountyData {
        public float bountyElapsedDays = 0.0f;
        public float bountyDuration = 0.0f;
        public float baseBounty = 0.0f;
        public float repChange = 0.0f;
        public FactionAPI bountyFaction = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PirateBaseTier {
        TIER_1_1MODULE,
        TIER_2_1MODULE,
        TIER_3_2MODULE,
        TIER_4_3MODULE,
        TIER_5_3MODULE;

    }
}

