/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class BaseOneTimeFactor
extends BaseEventFactor {
    public static float SHOW_DURATION_DAYS = 30.0f;
    protected int points;
    protected long timestamp;

    public BaseOneTimeFactor(int points) {
        this.points = points;
        this.timestamp = Global.getSector().getClock().getTimestamp();
    }

    public int getProgress(BaseEventIntel intel) {
        return this.points;
    }

    public boolean isOneTime() {
        return true;
    }

    protected String getBulletPointText(BaseEventIntel intel) {
        return null;
    }

    public void addBulletPointForOneTimeFactor(BaseEventIntel intel, TooltipMakerAPI info, Color tc, float initPad) {
        String text = this.getBulletPointText(intel);
        if (text == null) {
            text = this.getDesc(intel);
        }
        if (text != null) {
            info.addPara(String.valueOf(text) + ": %s", initPad, tc, this.getProgressColor(intel), this.getProgressStr(intel));
        }
    }

    public boolean isExpired() {
        return this.timestamp != 0L && Global.getSector().getClock().getElapsedDaysSince(this.timestamp) > SHOW_DURATION_DAYS;
    }

    public boolean hasOtherFactorsOfClass(BaseEventIntel intel, Class c) {
        for (EventFactor factor : intel.getFactors()) {
            if (factor == this || !c.isInstance(factor)) continue;
            return true;
        }
        return false;
    }

    public String getProgressStr(BaseEventIntel intel) {
        if (this.getProgress(intel) == 0) {
            return "";
        }
        return super.getProgressStr(intel);
    }

    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) == 0) {
            return Misc.getGrayColor();
        }
        return super.getDescColor(intel);
    }
}

