/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.fleets.BaseLimitedFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableFleetManager;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityFactor;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Random;

public class DisposableHostileActivityFleetManager
extends DisposableFleetManager {
    protected Random random = new Random();

    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    protected String getSpawnId() {
        return "hostile_activity";
    }

    protected HostileActivityEventIntel getIntel() {
        if (this.currSpawnLoc == null) {
            return null;
        }
        return HostileActivityEventIntel.get();
    }

    protected int getDesiredNumFleetsForSpawnLocation() {
        float daysSince;
        HostileActivityEventIntel intel = this.getIntel();
        if (intel == null) {
            return 0;
        }
        Long timestamp = intel.getPlayerVisibleTimestamp();
        if (timestamp != null && (daysSince = Global.getSector().getClock().getElapsedDaysSince(timestamp)) < 30.0f) {
            return 0;
        }
        float mag = intel.getTotalActivityMagnitude(this.currSpawnLoc);
        float mag2 = intel.getProgressFraction();
        if ((mag = Misc.interpolate(mag, mag2, 0.5f)) <= 0.0f) {
            return 0;
        }
        float desiredNumFleets = 1.0f;
        float max = Global.getSettings().getFloat("maxHostileActivityFleetsPerSystem");
        return Math.round(desiredNumFleets += (float)Math.round(mag * (max - 1.0f)));
    }

    protected StarSystemAPI pickCurrentSpawnLocation() {
        return this.pickNearestPopulatedSystem();
    }

    protected StarSystemAPI pickNearestPopulatedSystem() {
        float distToPlayerLY;
        if (Global.getSector().isInNewGameAdvance()) {
            return null;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return null;
        }
        StarSystemAPI nearest = null;
        float minDist = Float.MAX_VALUE;
        for (StarSystemAPI system : Misc.getSystemsWithPlayerColonies(false)) {
            float distToPlayerLY2 = Misc.getDistanceLY(player.getLocationInHyperspace(), system.getLocation());
            if (distToPlayerLY2 > MAX_RANGE_FROM_PLAYER_LY || !(distToPlayerLY2 < minDist)) continue;
            nearest = system;
            minDist = distToPlayerLY2;
        }
        if (nearest == null && this.currSpawnLoc != null && (distToPlayerLY = Misc.getDistanceLY(player.getLocationInHyperspace(), this.currSpawnLoc.getLocation())) <= DESPAWN_RANGE_LY) {
            nearest = this.currSpawnLoc;
        }
        return nearest;
    }

    protected CampaignFleetAPI spawnFleetImpl() {
        StarSystemAPI system = this.currSpawnLoc;
        if (system == null) {
            return null;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return null;
        }
        HostileActivityEventIntel intel = this.getIntel();
        if (intel == null) {
            return null;
        }
        String idKey = "$dhafm_ID";
        WeightedRandomPicker<HostileActivityFactor> picker = new WeightedRandomPicker<HostileActivityFactor>(this.random);
        for (EventFactor factor : intel.getFactors()) {
            if (!(factor instanceof HostileActivityFactor)) continue;
            HostileActivityFactor curr = (HostileActivityFactor)((Object)factor);
            int count = 0;
            for (BaseLimitedFleetManager.ManagedFleetData data : this.active) {
                if (data.fleet == null || !curr.getId().equals(data.fleet.getMemoryWithoutUpdate().getString(idKey))) continue;
                ++count;
            }
            if (count >= curr.getMaxNumFleets(this.currSpawnLoc)) continue;
            picker.add(curr, curr.getSpawnFrequency(this.currSpawnLoc));
        }
        HostileActivityFactor pick = (HostileActivityFactor)picker.pick();
        if (pick == null) {
            return null;
        }
        CampaignFleetAPI fleet = pick.createFleet(this.currSpawnLoc, this.random);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        fleet.getMemoryWithoutUpdate().set(idKey, pick.getId());
        this.setLocationAndOrders(fleet, pick.getSpawnInHyperProbability(this.currSpawnLoc), pick.getStayInHyperProbability(this.currSpawnLoc));
        return fleet;
    }
}

