/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.PatherCellListener;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class LuddicPathHostileActivityFactor
extends BaseHostileActivityFactor
implements PatherCellListener {
    public LuddicPathHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
        Global.getSector().getListenerManager().addListener(this);
    }

    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    public String getDesc(BaseEventIntel intel) {
        return "Luddic Path";
    }

    public String getNameForThreatList(boolean first) {
        if (first) {
            return "Luddic Path";
        }
        return "Luddic Path";
    }

    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("luddic_path").getBaseUIColor();
    }

    public TooltipMakerAPI.TooltipCreator getMainRowTooltip() {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("Advanced technology and artificial intelligence are anathema to the Luddic Path.", 0.0f);
                tooltip.addPara("Most of the Pather fleets are small, engaging in reconnaissance and demanding tithes from unwary travellers, but occasionaly a larger raiding force will make an appearance.", opad);
                LuddicPathHostileActivityFactor.addAgreementStatus(tooltip, opad);
            }
        };
    }

    public static void addAgreementStatus(TooltipMakerAPI tooltip, float initPad) {
        float opad = 10.0f;
        Color p = Misc.getPositiveHighlightColor();
        Color h = Misc.getHighlightColor();
        if (HA_CMD.playerHasPatherAgreement()) {
            if (!HA_CMD.playerPatherAgreementIsPermanent()) {
                float days = HA_CMD.getPlayerPatherAgreementDays();
                if (days < 1.0f && days > 0.0f) {
                    days = 1.0f;
                }
                days = Math.round(days);
                String dStr = "days";
                if ((int)days == 1) {
                    dStr = "day";
                }
                tooltip.addPara("You've %s a signficant amount to the Pathers, and their fleets and ground-based cells should leave your colonies alone for another %s " + dStr + ".", initPad, new Color[]{p, h}, "tithed", "" + (int)days);
            } else {
                tooltip.addPara("You've reached an understanding with the Pathers, and their fleets and ground-based cells should leave your colonies alone in the future, barring unexpected events.", initPad, p, "understanding");
            }
        } else {
            tooltip.addPara("It's possible that you might reach some kind of understanding with the Pathers, provided you find the right people to talk to.", initPad, h, "find the right people");
        }
    }

    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0 || HA_CMD.playerHasPatherAgreement();
    }

    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("luddicPathMaxFleets");
    }

    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        float f = 0.0f;
        if ((f += this.getEffectMagnitude(system)) > 1.0f) {
            f = 1.0f;
        }
        float p = Global.getSettings().getFloat("luddicPathSmallFleetProb");
        boolean small = random.nextFloat() < p;
        int difficulty = 0;
        if (small) {
            difficulty = 1 + random.nextInt(2);
        } else {
            difficulty = 3;
            difficulty += Math.round(f * 5.0f);
            difficulty += random.nextInt(6);
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "luddic_path";
        if (small) {
            m.createStandardFleet(difficulty, factionId, loc);
        } else {
            m.createStandardFleet(difficulty, factionId, loc);
        }
        m.triggerSetPirateFleet();
        m.triggerMakeLowRepImpact();
        if (!small) {
            m.triggerFleetAllowLongPursuit();
        }
        CampaignFleetAPI fleet = m.createFleet();
        return fleet;
    }

    public void notifyEventEnding() {
        Global.getSector().getListenerManager().removeListener(this);
    }

    public HAPatherCellsEventData getPatherCellData(BaseEventIntel.EventStageData stage) {
        if (stage == null) {
            return null;
        }
        if (stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData) {
            HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
            if (data.custom instanceof HAPatherCellsEventData) {
                HAPatherCellsEventData attackData = (HAPatherCellsEventData)data.custom;
                return attackData;
            }
        }
        return null;
    }

    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        HAPatherCellsEventData data = this.getPatherCellData(stage);
        Color c = Global.getSector().getFaction("luddic_path").getBaseUIColor();
        if (data != null && data.target != null) {
            LabelAPI label = info.addPara("%s on %s disrupted for %s days by %s sabotage", initPad, tc, c, data.target.getNameForModifier(), data.market.getName(), "" + (int)data.target.getDisruptedDays(), "Luddic Path");
            label.setHighlight(data.target.getNameForModifier(), data.market.getName(), "" + (int)data.target.getDisruptedDays(), "Luddic Path");
            label.setHighlightColors(tc, Misc.getBasePlayerColor(), Misc.getHighlightColor(), c);
            return;
        }
        LabelAPI label = info.addPara("Signs of impending %s attack targeting %s", initPad, tc, c, "Luddic Path", data.market.getName());
        label.setHighlight("Luddic Path", data.market.getName());
        label.setHighlightColors(Misc.getTextColor(), Misc.getBasePlayerColor());
    }

    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Luddic Path attack averted", tc, initPad);
    }

    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        HAPatherCellsEventData data = this.getPatherCellData(stage);
        if (data == null) {
            return;
        }
        Color c = Global.getSector().getFaction("luddic_path").getBaseUIColor();
        float small = 0.0f;
        float opad = 10.0f;
        small = 5.0f;
        LabelAPI label = info.addPara("Recent intelligence indicates that a Luddic Path cell is preparing an act of industrial sabotage targeting %s.", small, Misc.getBasePlayerColor(), data.market.getName());
        label.setHighlight("Luddic Path", data.market.getName());
        label.setHighlightColors(c, Misc.getBasePlayerColor());
        stage.beginResetReqList(info, true, opad);
        info.addPara("The Luddic Path cells on %s are disrupted", 0.0f, Misc.getTextColor(), data.market.getName());
        stage.endResetReqList(info, false);
        this.addBorder(info, Global.getSector().getFaction("luddic_path").getBaseUIColor());
    }

    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("luddic_path").getCrest();
    }

    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, final BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return new BaseFactorTooltip(){

                public void createTooltip(TooltipMakerAPI info, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    info.addTitle("Luddic Path attack");
                    HAPatherCellsEventData data = LuddicPathHostileActivityFactor.this.getPatherCellData(stage);
                    if (data == null) {
                        return;
                    }
                    info.addPara("A Luddic Path cell will perform an act of terror or industrial sabotage targeting %s.", opad, Misc.getBasePlayerColor(), data.market.getName());
                    stage.beginResetReqList(info, true, opad);
                    Color c = Global.getSector().getFaction("luddic_path").getBaseUIColor();
                    LabelAPI label = info.addPara("The Luddic Path cells on %s are disrupted", 0.0f, Misc.getBasePlayerColor(), data.market.getName());
                    label.setHighlight("Luddic Path", data.market.getName());
                    label.setHighlightColors(c, Misc.getBasePlayerColor());
                    stage.endResetReqList(info, true);
                }
            };
        }
        return null;
    }

    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (HA_CMD.playerHasPatherAgreement()) {
            return 0.0f;
        }
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT && this.pickTargetMarket() != null) {
            return 10.0f;
        }
        return 0.0f;
    }

    public MarketAPI pickTargetMarket() {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom());
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            LuddicPathCellsIntel cells;
            if (market.getDaysInExistence() < 180.0f && !Global.getSettings().isDevMode() || (cells = LuddicPathCellsIntel.getCellsForMarket(market)) == null || cells.isSleeper()) continue;
            float w = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
            picker.add(market, w);
        }
        return (MarketAPI)picker.pick();
    }

    public void resetEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        super.resetEvent(intel, stage);
    }

    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI market = this.pickTargetMarket();
        LuddicPathCellsIntel cells = LuddicPathCellsIntel.getCellsForMarket(market);
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        data.custom = new HAPatherCellsEventData(cells, market);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HAPatherCellsEventData data = this.getPatherCellData(stage);
        if (data == null || data.market == null || data.cells == null || data.cells.isSleeper()) {
            return false;
        }
        WeightedRandomPicker<Industry> picker = new WeightedRandomPicker<Industry>(intel.getRandom());
        for (Industry ind : data.market.getIndustries()) {
            if (!ind.canBeDisrupted()) continue;
            float mult = 1.0f;
            if (ind.isStructure()) {
                mult = 0.1f;
            }
            picker.add(ind, ind.getPatherInterest() * mult);
        }
        Industry target = (Industry)picker.pick();
        if (target == null) {
            return false;
        }
        data.target = target;
        float disruptionDur = LuddicPathCellsIntel.MIN_SABOTAGE + intel.getRandom().nextFloat() * (LuddicPathCellsIntel.MAX_SABOTAGE - LuddicPathCellsIntel.MIN_SABOTAGE);
        target.setDisrupted(disruptionDur, true);
        intel.sendUpdateIfPlayerHasIntel(stage.rollData, false);
        return true;
    }

    public void reportCellsDisrupted(LuddicPathCellsIntel cell) {
        HostileActivityEventIntel intel = HostileActivityEventIntel.get();
        if (intel == null) {
            return;
        }
        BaseEventIntel.EventStageData stage = intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        HAPatherCellsEventData data = this.getPatherCellData(stage);
        if (data != null && data.cells == cell && stage.rollData != null) {
            intel.resetHA_EVENT();
        }
    }

    public static class HAPatherCellsEventData {
        public LuddicPathCellsIntel cells;
        public MarketAPI market;
        public Industry target;

        public HAPatherCellsEventData(LuddicPathCellsIntel cells, MarketAPI market) {
            this.cells = cells;
            this.market = market;
        }
    }
}

