/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events.ht;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.CharacterStatsRefreshListener;
import com.fs.starfarer.api.campaign.listeners.CurrentLocationChangedListener;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperspaceTopographyEventIntel
extends BaseEventIntel
implements FleetEventListener,
CharacterStatsRefreshListener,
CurrentLocationChangedListener {
    public static Color BAR_COLOR = Global.getSettings().getColor("progressBarFleetPointsColor");
    public static int PROGRESS_MAX = 500;
    public static int PROGRESS_1 = 100;
    public static int PROGRESS_2 = 250;
    public static int PROGRESS_3 = 400;
    public static float BASE_DETECTION_RANGE_LY = 3.0f;
    public static float RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY = 5.0f;
    public static float RANGE_PER_DOMAIN_SENSOR_ARRAY = 2.0f;
    public static float RANGE_PER_MAKESHIFT_SENSOR_ARRAY = 1.0f;
    public static int MAX_SENSOR_ARRAYS = 3;
    public static float WAYSTATION_BONUS = 2.0f;
    public static float SLIPSTREAM_FUEL_MULT = 0.5f;
    public static float HYPER_BURN_BONUS = 3.0f;
    public static String KEY = "$hte_ref";
    public static float RECENT_READINGS_TIMEOUT = 30.0f;
    public static float RECENT_READINGS_RANGE_LY = 10.0f;
    protected TimeoutTracker<RecentTopographyReadings> recent = new TimeoutTracker();

    public static void addFactorCreateIfNecessary(EventFactor factor, InteractionDialogAPI dialog) {
        if (HyperspaceTopographyEventIntel.get() == null) {
            new HyperspaceTopographyEventIntel(null, false);
        }
        if (HyperspaceTopographyEventIntel.get() != null) {
            HyperspaceTopographyEventIntel.get().addFactor(factor, dialog);
        }
    }

    public static HyperspaceTopographyEventIntel get() {
        return (HyperspaceTopographyEventIntel)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public HyperspaceTopographyEventIntel(TextPanelAPI text, boolean withIntelNotification) {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.setMaxProgress(PROGRESS_MAX);
        this.addStage((Object)Stage.START, 0);
        this.addStage((Object)Stage.SLIPSTREAM_NAVIGATION, PROGRESS_1, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.SLIPSTREAM_DETECTION, PROGRESS_2, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.HYPERFIELD_OPTIMIZATION, PROGRESS_3, false, BaseEventIntel.StageIconSize.LARGE);
        this.addStage((Object)Stage.TOPOGRAPHIC_DATA, PROGRESS_MAX, true, BaseEventIntel.StageIconSize.SMALL);
        this.getDataFor((Object)((Object)Stage.SLIPSTREAM_NAVIGATION)).keepIconBrightWhenLaterStageReached = true;
        this.getDataFor((Object)((Object)Stage.SLIPSTREAM_DETECTION)).keepIconBrightWhenLaterStageReached = true;
        this.getDataFor((Object)((Object)Stage.HYPERFIELD_OPTIMIZATION)).keepIconBrightWhenLaterStageReached = true;
        Global.getSector().getIntelManager().addIntel(this, !withIntelNotification, text);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        if (this.addEventFactorBulletPoints(info, mode, isUpdate, tc, initPad)) {
            return;
        }
        Color h = Misc.getHighlightColor();
        if (isUpdate && this.getListInfoParam() instanceof BaseEventIntel.EventStageData) {
            BaseEventIntel.EventStageData esd = (BaseEventIntel.EventStageData)this.getListInfoParam();
            if (esd.id == Stage.SLIPSTREAM_DETECTION) {
                info.addPara("Able to detect slipstreams near your spaceports", tc, initPad);
            }
            if (esd.id == Stage.SLIPSTREAM_NAVIGATION) {
                info.addPara("Fuel use while traversing slipstreams reduced by %s", initPad, tc, h, Math.round((1.0f - SLIPSTREAM_FUEL_MULT) * 100.0f) + "%");
            }
            if (esd.id == Stage.HYPERFIELD_OPTIMIZATION) {
                info.addPara("Maximum burn increased by %s while in hyperspace", initPad, tc, h, "" + (int)HYPER_BURN_BONUS);
            }
            if (esd.id == Stage.TOPOGRAPHIC_DATA) {
                info.addPara("Topographic data gained", tc, initPad);
            }
            return;
        }
    }

    @Override
    public void addStageDescriptionText(TooltipMakerAPI info, float width, Object stageId) {
        float opad = 10.0f;
        float small = 0.0f;
        Color h = Misc.getHighlightColor();
        BaseEventIntel.EventStageData stage = this.getDataFor(stageId);
        if (stage == null) {
            return;
        }
        if (this.isStageActive(stageId)) {
            this.addStageDesc(info, stageId, small, false);
        }
    }

    public void addStageDesc(TooltipMakerAPI info, Object stageId, float initPad, boolean forTooltip) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (stageId == Stage.START) {
            info.addPara("Detailed sensor readings greatly aid hyperspace navigation. There are many ways of acquiring this data, including using in-system sensor arrays, using an Active Sensor Burst near interesting phenomena, traveling through hyperspace at a very high burn level, or simply buying the data from scavengers.", initPad);
        } else if (stageId == Stage.SLIPSTREAM_DETECTION) {
            info.addPara("The facilities and staff at a Spaceport are able to interpret data from various sources to discover the presence of nearby slipstreams. The detection range is increased for larger colonies. Claimed sensor arrays within %s light-years provide an additional bonus - %s ly for Domain-era arrays, and %s ly for makeshift ones. Up to %s sensor arrays can be of use.", initPad, Misc.getHighlightColor(), "" + (int)RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY, "+" + (int)RANGE_PER_DOMAIN_SENSOR_ARRAY, "+" + (int)RANGE_PER_MAKESHIFT_SENSOR_ARRAY, "" + MAX_SENSOR_ARRAYS);
        } else if (stageId == Stage.SLIPSTREAM_NAVIGATION) {
            info.addPara("Fuel use while traveling inside slipstreams reduced by %s. This reduction is multiplicative with the baseline fuel use reduction for traveling inside a slipstream.", initPad, h, Math.round((1.0f - SLIPSTREAM_FUEL_MULT) * 100.0f) + "%");
        } else if (stageId == Stage.HYPERFIELD_OPTIMIZATION) {
            info.addPara("Maximum burn increased by %s while in hyperspace.", initPad, h, "" + (int)HYPER_BURN_BONUS);
        } else if (stageId == Stage.TOPOGRAPHIC_DATA) {
            int min = this.getTopoResetMin();
            int max = this.getTopoResetMax();
            info.addPara("A batch of topographic data that can be sold for a considerable number of credits.", initPad);
            info.addPara("Event progress will be reset to between %s and %s points when this outcome is reached.", opad, h, "" + min, "" + max);
        }
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(Object stageId) {
        final BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && EnumSet.of(Stage.SLIPSTREAM_DETECTION, Stage.SLIPSTREAM_NAVIGATION, Stage.HYPERFIELD_OPTIMIZATION, Stage.TOPOGRAPHIC_DATA).contains(esd.id)) {
            return new BaseFactorTooltip(){

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    if (esd.id == Stage.SLIPSTREAM_DETECTION) {
                        tooltip.addTitle("Slipstream detection");
                    } else if (esd.id == Stage.SLIPSTREAM_NAVIGATION) {
                        tooltip.addTitle("Slipstream navigation");
                    } else if (esd.id == Stage.HYPERFIELD_OPTIMIZATION) {
                        tooltip.addTitle("Hyperfield optimization");
                    } else if (esd.id == Stage.TOPOGRAPHIC_DATA) {
                        tooltip.addTitle("Topographic data");
                    }
                    HyperspaceTopographyEventIntel.this.addStageDesc(tooltip, esd.id, opad, true);
                    esd.addProgressReq(tooltip, opad);
                }
            };
        }
        return null;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("events", "hyperspace_topography");
    }

    @Override
    protected String getStageIconImpl(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd == null) {
            return null;
        }
        if (EnumSet.of(Stage.SLIPSTREAM_DETECTION, Stage.SLIPSTREAM_NAVIGATION, Stage.HYPERFIELD_OPTIMIZATION, Stage.TOPOGRAPHIC_DATA, Stage.START).contains(esd.id)) {
            return Global.getSettings().getSpriteName("events", "hyperspace_topography_" + ((Stage)((Object)esd.id)).name());
        }
        return Global.getSettings().getSpriteName("events", "hyperspace_topography");
    }

    @Override
    public Color getBarColor() {
        Color color = BAR_COLOR;
        color = Misc.interpolateColor(color, Color.black, 0.25f);
        return color;
    }

    @Override
    public Color getBarProgressIndicatorColor() {
        return super.getBarProgressIndicatorColor();
    }

    @Override
    protected int getStageImportance(Object stageId) {
        return super.getStageImportance(stageId);
    }

    @Override
    protected String getName() {
        return "Hyperspace Topography";
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    public int getTopoResetMin() {
        BaseEventIntel.EventStageData stage = this.getDataFor((Object)Stage.HYPERFIELD_OPTIMIZATION);
        return stage.progress;
    }

    public int getTopoResetMax() {
        return this.getTopoResetMin() + 50;
    }

    public void resetTopographicData() {
        int resetProgress = this.getTopoResetMin() + this.getRandom().nextInt(this.getTopoResetMax() - this.getTopoResetMin() + 1);
        this.setProgress(resetProgress);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Exploration");
        return tags;
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        this.applyFleetEffects();
        float days = Global.getSector().getClock().convertToDays(amount);
        this.recent.advance(days);
    }

    @Override
    protected void notifyStageReached(BaseEventIntel.EventStageData stage) {
        if (stage.id == Stage.TOPOGRAPHIC_DATA) {
            this.resetTopographicData();
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            cargo.addSpecial(new SpecialItemData("topographic_data", null), 1.0f);
        }
    }

    @Override
    public void reportCurrentLocationChanged(LocationAPI prev, LocationAPI curr) {
    }

    @Override
    public void reportAboutToRefreshCharacterStatEffects() {
    }

    @Override
    public void reportRefreshedCharacterStatEffects() {
        this.updateMarketDetectionRanges();
        this.applyFleetEffects();
    }

    public void applyFleetEffects() {
        String id1 = "hypertopology1";
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        pf.getStats().getFleetwideMaxBurnMod().unmodifyFlat(id1);
        MutableStat stat = pf.getStats().getDynamic().getStat("fuel_use_not_shown_on_map_mult");
        stat.unmodifyMult(id1);
        if (Global.getSector().getCurrentLocation().isHyperspace()) {
            if (this.isStageActive((Object)Stage.SLIPSTREAM_NAVIGATION)) {
                for (MutableStat.StatMod mod : stat.getMultMods().values()) {
                    if (!SlipstreamTerrainPlugin2.FUEL_USE_MODIFIER_DESC.equals(mod.desc)) continue;
                    stat.modifyMult(id1, SLIPSTREAM_FUEL_MULT, String.valueOf(SlipstreamTerrainPlugin2.FUEL_USE_MODIFIER_DESC) + " (hyperspace topography)");
                    break;
                }
            }
            if (this.isStageActive((Object)Stage.HYPERFIELD_OPTIMIZATION)) {
                pf.getStats().getFleetwideMaxBurnMod().modifyFlat(id1, HYPER_BURN_BONUS, "Hyperspace topography");
            }
        }
    }

    public void updateMarketDetectionRanges() {
        if (this.isStageActive((Object)Stage.SLIPSTREAM_DETECTION)) {
            String id1 = "hypertopology1";
            String id2 = "hypertopology2";
            String id3 = "hypertopology3";
            String id4 = "hypertopology4";
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                if (market.isHidden()) continue;
                boolean unapplicable = false;
                Industry spaceport = market.getIndustry("spaceport");
                if (spaceport == null) {
                    spaceport = market.getIndustry("megaport");
                }
                if (spaceport == null || !spaceport.isFunctional()) {
                    unapplicable = true;
                }
                StatBonus mod = market.getStats().getDynamic().getMod("slipstream_reveal_range_ly_mod");
                if (!market.isPlayerOwned() || unapplicable) {
                    mod.unmodify(id1);
                    mod.unmodify(id2);
                    mod.unmodify(id3);
                    mod.unmodify(id4);
                    continue;
                }
                mod.modifyFlat(id1, BASE_DETECTION_RANGE_LY, "Base detection range");
                mod.modifyFlat(id2, market.getSize(), "Colony size");
                float arraysBonus = this.gerSensorArrayBonusFor(market, RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY);
                mod.modifyFlatAlways(id3, arraysBonus, "Claimed sensor arrays within " + (int)RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY + " ly (max: " + MAX_SENSOR_ARRAYS + " arrays)");
            }
        }
    }

    public float gerSensorArrayBonusFor(MarketAPI market, float range) {
        int countDomain = 0;
        int countMakeshift = 0;
        Vector2f locInHyper = market.getLocationInHyperspace();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float dist = Misc.getDistanceLY(locInHyper, system.getLocation());
            if (dist > range && (float)Math.round(dist * 10.0f) <= range * 10.0f) {
                dist = range;
            }
            if (!(dist <= range)) continue;
            for (SectorEntityToken entity : system.getEntitiesWithTag("sensor_array")) {
                if (entity.getFaction() == null || !entity.getFaction().isPlayerFaction()) continue;
                if (entity.hasTag("makeshift")) {
                    ++countMakeshift;
                    continue;
                }
                ++countDomain;
            }
        }
        float bonus = (float)Math.min(countDomain, MAX_SENSOR_ARRAYS) * RANGE_PER_DOMAIN_SENSOR_ARRAY;
        return bonus += (float)Math.min(Math.max(0, countMakeshift - countDomain), MAX_SENSOR_ARRAYS) * RANGE_PER_MAKESHIFT_SENSOR_ARRAY;
    }

    @Override
    public boolean withMonthlyFactors() {
        return false;
    }

    public void addRecentReadings(Vector2f loc) {
        this.recent.add(new RecentTopographyReadings(loc), RECENT_READINGS_TIMEOUT);
    }

    public static boolean hasRecentReadingsNearPlayer() {
        return HyperspaceTopographyEventIntel.get() != null && HyperspaceTopographyEventIntel.get().hasRecentReadingsNear(Global.getSector().getPlayerFleet().getLocationInHyperspace());
    }

    public boolean hasRecentReadingsNear(Vector2f loc) {
        for (RecentTopographyReadings curr : this.recent.getItems()) {
            float distLY = Misc.getDistanceLY(loc, curr.loc);
            if (!(distLY <= RECENT_READINGS_RANGE_LY)) continue;
            return true;
        }
        return false;
    }

    public static class RecentTopographyReadings {
        public Vector2f loc;

        public RecentTopographyReadings(Vector2f loc) {
            this.loc = loc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        START,
        SLIPSTREAM_DETECTION,
        SLIPSTREAM_NAVIGATION,
        HYPERFIELD_OPTIMIZATION,
        TOPOGRAPHIC_DATA;

    }
}

