/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.FleetLogIntel;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadcrumbIntel
extends FleetLogIntel {
    protected SectorEntityToken foundAt;
    protected SectorEntityToken target;
    protected String title;
    protected String text;
    protected Boolean showSpecificEntity = null;

    public BreadcrumbIntel(SectorEntityToken foundAt, SectorEntityToken target) {
        if (foundAt != null) {
            this.foundAt = BreadcrumbIntel.makeDoubleWithSameOrbit(foundAt);
        }
        this.target = BreadcrumbIntel.makeDoubleWithSameOrbit(target);
        target.getContainingLocation().addEntity(target);
        this.setRemoveTrigger(target);
    }

    @Override
    public void reportRemovedIntel() {
        super.reportRemovedIntel();
        this.target.getContainingLocation().removeEntity(this.target);
    }

    public static SectorEntityToken makeDoubleWithSameOrbit(SectorEntityToken entity) {
        SectorEntityToken copy = entity.getContainingLocation().createToken(entity.getLocation().x, entity.getLocation().y);
        if (entity.getOrbit() != null) {
            copy.setOrbit(entity.getOrbit().makeCopy());
        }
        return copy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.text, opad);
        float days = this.getDaysSincePlayerVisible();
        if (days >= 1.0f) {
            this.addDays(info, "ago.", days, tc, opad);
        }
        this.addDeleteButton(info, width);
    }

    @Override
    public String getIcon() {
        return super.getIcon();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Exploration");
        return tags;
    }

    @Override
    public String getSortString() {
        return "Location";
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return super.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.target.getStarSystem() != null && this.showSpecificEntity == null) {
            return this.target.getStarSystem().getCenter();
        }
        return this.target;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return super.shouldRemoveIntel();
    }

    @Override
    public String getCommMessageSound() {
        if (this.sound != null) {
            return this.sound;
        }
        return BreadcrumbIntel.getSoundMinorMessage();
    }

    public Boolean getShowSpecificEntity() {
        return this.showSpecificEntity;
    }

    public void setShowSpecificEntity(Boolean showPlanet) {
        if (showPlanet != null && !showPlanet.booleanValue()) {
            showPlanet = null;
        }
        this.showSpecificEntity = showPlanet;
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        if (this.foundAt == null) {
            return null;
        }
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        if (this.foundAt.getContainingLocation() == this.target.getContainingLocation() && this.foundAt.getContainingLocation() != null && !this.foundAt.getContainingLocation().isHyperspace()) {
            return null;
        }
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(this.foundAt, this.target);
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        result.add(arrow);
        return result;
    }
}

