/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class DistressCallIntel
extends BreadcrumbIntel {
    protected StarSystemAPI system;

    public DistressCallIntel(StarSystemAPI system) {
        super(null, system.getCenter());
        this.system = system;
        Global.getSector().addScript(this);
        this.setIcon(Global.getSettings().getSpriteName("intel", "distress_call"));
        this.setSound("ui_intel_distress_call");
        this.setDuration(60.0f);
        this.setTitle("Distress Call");
        this.setText("You receive a distress call from the nearby " + system.getNameWithLowercaseType() + ". " + "There's no additional information, but that's not surprising - " + "a typical fleet doesn't carry the equipment to broadcast a full-fledged data " + "stream into hyperspace.");
    }

    public void advance(float amount) {
        super.advance(amount);
        if (this.system == Global.getSector().getCurrentLocation()) {
            this.endAfterDelay();
        }
    }

    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        if (this.system != null) {
            this.bullet(info);
            info.addPara("Originating in the " + this.system.getNameWithLowercaseType(), tc, initPad);
            this.unindent(info);
        }
    }

    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.text, opad);
        float days = this.getDaysSincePlayerVisible();
        if (days >= 1.0f) {
            this.addDays(info, "ago.", days, tc, opad);
        }
        if (this.isEnding()) {
            info.addPara("You've investigated the system this distress call came from.", opad);
        }
    }

    public String getSortString() {
        return "Distress Call";
    }

    public String getName() {
        if (this.isEnding()) {
            return String.valueOf(this.title) + " - Investigated";
        }
        return this.title;
    }

    public boolean shouldRemoveIntel() {
        if (this.isEnded()) {
            return true;
        }
        return super.shouldRemoveIntel();
    }
}

