/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.ui.SectorMapAPI;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FleetLogIntel
extends BaseIntelPlugin {
    public static float DEFAULT_DURATION = 365.0f;
    protected Float duration = null;
    protected SectorEntityToken removeTrigger = null;
    protected String icon = null;
    protected String sound = null;

    public FleetLogIntel() {
    }

    public FleetLogIntel(float duration) {
        this.duration = Float.valueOf(duration);
    }

    public void setDefaultExpiration() {
        this.duration = Float.valueOf(DEFAULT_DURATION);
    }

    public void setDuration(float days) {
        this.duration = Float.valueOf(days);
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (this.isEnded()) {
            return true;
        }
        if (this.removeTrigger != null) {
            if (!this.removeTrigger.isAlive()) {
                return true;
            }
            if (this.removeTrigger instanceof CampaignTerrainAPI) {
                DebrisFieldTerrainPlugin debris;
                CampaignTerrainAPI terrain = (CampaignTerrainAPI)this.removeTrigger;
                if (terrain.getPlugin() instanceof DebrisFieldTerrainPlugin && (debris = (DebrisFieldTerrainPlugin)terrain.getPlugin()).isScavenged()) {
                    return true;
                }
            } else {
                boolean cfr_ignored_0 = this.removeTrigger instanceof PlanetAPI;
            }
        }
        if (this.isImportant() || this.duration == null) {
            return false;
        }
        Long ts = this.getPlayerVisibleTimestamp();
        if (ts == null) {
            return false;
        }
        return Global.getSector().getClock().getElapsedDaysSince(ts) >= this.duration.floatValue();
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public String getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        return Global.getSettings().getSpriteName("intel", "fleet_log");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Fleet log");
        return tags;
    }

    public SectorEntityToken getRemoveTrigger() {
        return this.removeTrigger;
    }

    public void setRemoveTrigger(SectorEntityToken removeTrigger) {
        this.removeTrigger = removeTrigger;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    @Override
    public String getCommMessageSound() {
        if (this.sound != null) {
            return this.sound;
        }
        return FleetLogIntel.getSoundLogUpdate();
    }
}

