/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.raid;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseRaidStage
implements RaidIntel.RaidStage {
    public static final String STRAGGLER = "raid_straggler";
    protected RaidIntel intel;
    protected IntervalUtil statusInterval = new IntervalUtil(0.1f, 0.2f);
    protected RaidIntel.RaidStageStatus status = RaidIntel.RaidStageStatus.ONGOING;
    protected float elapsed = 0.0f;
    protected float maxDays = 1.0f;
    protected float abortFP = 0.0f;

    public BaseRaidStage(RaidIntel raid) {
        this.intel = raid;
    }

    public float getAbortFP() {
        return this.abortFP;
    }

    public void setAbortFP(float abortFP) {
        this.abortFP = abortFP;
    }

    public void resetRoutes() {
        List<RouteManager.RouteData> routes = RouteManager.getInstance().getRoutesForSource(this.intel.getRouteSourceId());
        for (RouteManager.RouteData route : routes) {
            this.resetRoute(route);
        }
    }

    public void resetRoute(RouteManager.RouteData route) {
        CampaignFleetAPI fleet = route.getActiveFleet();
        if (fleet != null) {
            fleet.clearAssignments();
        }
        route.getSegments().clear();
        route.setCurrent(null);
    }

    public List<RouteManager.RouteData> getRoutes() {
        List<RouteManager.RouteData> routes = RouteManager.getInstance().getRoutesForSource(this.intel.getRouteSourceId());
        ArrayList<RouteManager.RouteData> result = new ArrayList<RouteManager.RouteData>();
        for (RouteManager.RouteData route : routes) {
            if (STRAGGLER.equals(route.getCustom())) continue;
            result.add(route);
        }
        return result;
    }

    public void giveReturnOrdersToStragglers(List<RouteManager.RouteData> stragglers) {
        for (RouteManager.RouteData route : stragglers) {
            SectorEntityToken from = Global.getSector().getHyperspace().createToken(route.getInterpolatedHyperLocation());
            route.setCustom(STRAGGLER);
            this.resetRoute(route);
            float travelDays = RouteLocationCalculator.getTravelDays(from, route.getMarket().getPrimaryEntity());
            if (DebugFlags.RAID_DEBUG || DebugFlags.FAST_RAIDS) {
                travelDays *= 0.1f;
            }
            float orbitDays = 1.0f + 1.0f * (float)Math.random();
            route.addSegment(new RouteManager.RouteSegment(travelDays, from, route.getMarket().getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(orbitDays, route.getMarket().getPrimaryEntity()));
        }
    }

    @Override
    public void advance(float amount) {
        float days = Misc.getDays(amount);
        this.elapsed += days;
        this.statusInterval.advance(days);
        if (this.statusInterval.intervalElapsed()) {
            this.updateStatus();
        }
    }

    @Override
    public RaidIntel.RaidStageStatus getStatus() {
        return this.status;
    }

    @Override
    public void notifyStarted() {
    }

    protected boolean enoughMadeIt(List<RouteManager.RouteData> routes, List<RouteManager.RouteData> stragglers) {
        float madeItFP = 0.0f;
        for (RouteManager.RouteData route : routes) {
            if (stragglers.contains(route)) continue;
            CampaignFleetAPI fleet = route.getActiveFleet();
            if (fleet != null) {
                float mult = Misc.getSpawnFPMult(fleet);
                madeItFP += (float)fleet.getFleetPoints() / mult;
                continue;
            }
            madeItFP += route.getExtra().fp.floatValue();
        }
        return madeItFP >= this.abortFP;
    }

    protected void updateStatus() {
        this.abortIfNeededBasedOnFP(true);
    }

    protected void abortIfNeededBasedOnFP(boolean giveReturnOrders) {
        ArrayList<RouteManager.RouteData> stragglers;
        List<RouteManager.RouteData> routes = this.getRoutes();
        boolean enoughMadeIt = this.enoughMadeIt(routes, stragglers = new ArrayList<RouteManager.RouteData>());
        if (!enoughMadeIt) {
            this.status = RaidIntel.RaidStageStatus.FAILURE;
            if (giveReturnOrders) {
                this.giveReturnOrdersToStragglers(routes);
            }
            return;
        }
    }

    protected void updateStatusBasedOnReaching(SectorEntityToken dest, boolean giveReturnOrders) {
        this.updateStatusBasedOnReaching(dest, giveReturnOrders, true);
    }

    protected void updateStatusBasedOnReaching(SectorEntityToken dest, boolean giveReturnOrders, boolean requireNearTarget) {
        List<RouteManager.RouteData> routes = this.getRoutes();
        float maxRange = 2000.0f;
        if (!requireNearTarget) {
            maxRange = 1.0E7f;
        }
        List<RouteManager.RouteData> stragglers = this.getStragglers(routes, dest, maxRange);
        boolean enoughMadeIt = this.enoughMadeIt(routes, stragglers);
        if (stragglers.isEmpty() && enoughMadeIt) {
            this.status = RaidIntel.RaidStageStatus.SUCCESS;
            return;
        }
        if (this.elapsed > this.maxDays + this.intel.getExtraDays()) {
            if (enoughMadeIt) {
                this.status = RaidIntel.RaidStageStatus.SUCCESS;
                if (giveReturnOrders) {
                    this.giveReturnOrdersToStragglers(stragglers);
                }
            } else {
                this.status = RaidIntel.RaidStageStatus.FAILURE;
                if (giveReturnOrders) {
                    this.giveReturnOrdersToStragglers(routes);
                }
            }
            return;
        }
    }

    @Override
    public float getExtraDaysUsed() {
        return Math.max(0.0f, this.elapsed - this.maxDays);
    }

    public List<RouteManager.RouteData> getStragglers(List<RouteManager.RouteData> routes, SectorEntityToken dest, float maxRange) {
        ArrayList<RouteManager.RouteData> stragglers = new ArrayList<RouteManager.RouteData>();
        for (RouteManager.RouteData route : routes) {
            CampaignFleetAPI fleet = route.getActiveFleet();
            if (fleet != null) {
                if (fleet.getContainingLocation() == dest.getContainingLocation()) {
                    float dist = Misc.getDistance(fleet, dest);
                    if (!(dist > maxRange)) continue;
                    stragglers.add(route);
                    continue;
                }
                stragglers.add(route);
                continue;
            }
            if (route.isExpired()) continue;
            boolean waiting = false;
            if (route.getCurrent() != null && "wait_stage".equals(route.getCurrent().custom)) {
                waiting = true;
            }
            if (waiting) continue;
            stragglers.add(route);
        }
        return stragglers;
    }

    @Override
    public float getElapsed() {
        return this.elapsed;
    }

    @Override
    public float getMaxDays() {
        return this.maxDays;
    }

    @Override
    public void showStageInfo(TooltipMakerAPI info) {
    }
}

