/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.CargoGainedListener;
import com.fs.starfarer.api.campaign.listeners.ShowLootListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintIntel
extends HubMissionWithBarEvent
implements ShowLootListener,
CargoGainedListener {
    public static float PROB_PATHER = 0.5f;
    public static float PROB_MERC = 0.5f;
    public static float PROB_TRY_TO_FIND_RUINS = 0.5f;
    public static float FREQ_WEAPON = 10.0f;
    public static float FREQ_FIGHTER = 10.0f;
    public static float FREQ_SHIP = 10.0f;
    protected StarSystemAPI system;
    protected SpecialItemData item;
    protected int price;
    protected SectorEntityToken entity;

    protected float getQualityMultForTier(int tier) {
        float q = this.getQuality();
        float qWeight = 1.0f;
        if (tier <= 0) {
            qWeight = 0.0f;
        } else if (tier == 1) {
            qWeight = 1.0f;
        } else if (tier == 2) {
            qWeight = 2.0f;
        } else if (tier >= 3) {
            qWeight = 4.0f;
        }
        return 1.0f - qWeight + qWeight * (1.0f + q);
    }

    protected void pickItem() {
        WeightedRandomPicker<String> typePicker = new WeightedRandomPicker<String>(this.genRandom);
        typePicker.add("fighter_bp", FREQ_FIGHTER);
        typePicker.add("weapon_bp", FREQ_WEAPON);
        typePicker.add("ship_bp", FREQ_SHIP);
        while (this.item == null && !typePicker.isEmpty()) {
            float w;
            WeightedRandomPicker<Object> picker;
            String type = (String)typePicker.pick();
            if (type.equals("fighter_bp")) {
                picker = new WeightedRandomPicker<Object>(this.genRandom);
                for (FighterWingSpecAPI fighterWingSpecAPI : Global.getSettings().getAllFighterWingSpecs()) {
                    if (!fighterWingSpecAPI.hasTag("rare_bp") || fighterWingSpecAPI.hasTag("no_drop") || Global.getSector().getPlayerFaction().knowsFighter(fighterWingSpecAPI.getId())) continue;
                    w = fighterWingSpecAPI.getRarity() * this.getQualityMultForTier(fighterWingSpecAPI.getTier());
                    picker.add(fighterWingSpecAPI, w);
                }
                FighterWingSpecAPI fighterWingSpecAPI = (FighterWingSpecAPI)picker.pick();
                if (fighterWingSpecAPI != null) {
                    this.item = new SpecialItemData(type, fighterWingSpecAPI.getId());
                    this.price = (int)fighterWingSpecAPI.getBaseValue();
                    continue;
                }
                typePicker.remove(type);
                continue;
            }
            if (type.equals("weapon_bp")) {
                picker = new WeightedRandomPicker(this.genRandom);
                for (WeaponSpecAPI weaponSpecAPI : Global.getSettings().getAllWeaponSpecs()) {
                    if (!weaponSpecAPI.hasTag("rare_bp") || weaponSpecAPI.hasTag("no_drop") || Global.getSector().getPlayerFaction().knowsWeapon(weaponSpecAPI.getWeaponId())) continue;
                    w = weaponSpecAPI.getRarity() * this.getQualityMultForTier(weaponSpecAPI.getTier());
                    picker.add(weaponSpecAPI, w);
                }
                WeaponSpecAPI weaponSpecAPI = (WeaponSpecAPI)picker.pick();
                if (weaponSpecAPI != null) {
                    this.item = new SpecialItemData(type, weaponSpecAPI.getWeaponId());
                    this.price = (int)weaponSpecAPI.getBaseValue();
                    continue;
                }
                typePicker.remove(type);
                continue;
            }
            if (!type.equals("ship_bp")) break;
            picker = new WeightedRandomPicker(this.genRandom);
            for (ShipHullSpecAPI shipHullSpecAPI : Global.getSettings().getAllShipHullSpecs()) {
                if (!shipHullSpecAPI.hasTag("rare_bp") || shipHullSpecAPI.hasTag("no_drop") || Global.getSector().getPlayerFaction().knowsShip(shipHullSpecAPI.getHullId())) continue;
                w = shipHullSpecAPI.getRarity() * this.getQualityMultForTier(shipHullSpecAPI.getFleetPoints() / 6);
                picker.add(shipHullSpecAPI, w);
            }
            ShipHullSpecAPI shipHullSpecAPI = (ShipHullSpecAPI)picker.pick();
            if (shipHullSpecAPI != null) {
                this.item = new SpecialItemData(type, shipHullSpecAPI.getHullId());
                this.price = (int)shipHullSpecAPI.getBaseValue();
                continue;
            }
            typePicker.remove(type);
        }
        if (this.price != 0) {
            this.price = BlueprintIntel.getRoundNumber((float)this.price * (1.5f + (1.0f - this.getRewardMultFraction())));
        }
    }

    protected String getItemNameLowercaseItem() {
        String item = this.getItemName();
        item = item.replaceFirst(" Item", " item");
        item = item.replaceFirst(" Blueprint", " blueprint");
        return item;
    }

    protected String getItemName() {
        if (this.item == null) {
            return "an Invalid Item";
        }
        String name = "Invalid Item";
        if (this.item.getId().equals("fighter_bp")) {
            FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(this.item.getData());
            name = String.valueOf(spec.getWingName()) + " Blueprint";
        } else if (this.item.getId().equals("weapon_bp")) {
            WeaponSpecAPI spec = Global.getSettings().getWeaponSpec(this.item.getData());
            name = String.valueOf(spec.getWeaponName()) + " Blueprint";
        } else if (this.item.getId().equals("ship_bp")) {
            ShipHullSpecAPI spec = Global.getSettings().getHullSpec(this.item.getData());
            name = String.valueOf(spec.getHullName()) + " Blueprint";
        }
        return String.valueOf(Misc.getAOrAnFor(name)) + " " + name;
    }

    protected boolean isVeryValuable() {
        if (this.item.getId().equals("fighter_bp")) {
            return false;
        }
        if (this.item.getId().equals("weapon_bp")) {
            WeaponSpecAPI spec = Global.getSettings().getWeaponSpec(this.item.getData());
            return spec.getSize() == WeaponAPI.WeaponSize.LARGE;
        }
        if (this.item.getId().equals("ship_bp")) {
            ShipHullSpecAPI spec = Global.getSettings().getHullSpec(this.item.getData());
            return spec.getHullSize().ordinal() >= ShipAPI.HullSize.DESTROYER.ordinal();
        }
        return false;
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            this.setGiverPost(this.pickOne(Ranks.POST_AGENT, Ranks.POST_SMUGGLER, Ranks.POST_GANGSTER, Ranks.POST_FENCE, Ranks.POST_CRIMINAL));
            this.setGiverImportance(this.pickImportance());
            this.setGiverFaction("pirates");
            this.setGiverTags("underworld");
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        this.pickItem();
        if (this.item == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$sitm_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        this.requireSystemInterestingAndNotCore();
        this.preferSystemUnexplored();
        this.preferSystemTags(ReqMode.NOT_ANY, "theme_derelict");
        this.entity = null;
        if (this.rollProbability(PROB_TRY_TO_FIND_RUINS)) {
            this.requirePlanetUnpopulated();
            this.requirePlanetWithRuins();
            this.requirePlanetNotFullySurveyed();
            this.requirePlanetUnexploredRuins();
            this.preferPlanetInDirectionOfOtherMissions();
            this.entity = this.pickPlanet();
        }
        if (this.entity == null) {
            this.requireEntityTags(ReqMode.ANY, "salvageable");
            this.preferEntityInDirectionOfOtherMissions();
            this.entity = this.pickEntity();
        }
        if (this.entity == null) {
            return false;
        }
        this.system = this.entity.getStarSystem();
        if (this.system == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GET_ITEM);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.addTag("Exploration");
        boolean veryValuable = this.isVeryValuable();
        int numScav = this.genRandom.nextInt(3);
        if (veryValuable) {
            numScav += 2;
        }
        int i = 0;
        while (i < numScav) {
            this.beginWithinHyperspaceRangeTrigger(this.system, 3.0f, false, new Object[]{Stage.GET_ITEM});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "scavengers", "scavengerMedium", this.system);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerSetFleetFaction("independent");
            this.triggerMakeLowRepImpact();
            this.triggerSpawnFleetNear(this.system.getCenter(), null, "$sitm_ref");
            this.triggerFleetSetTravelActionText("exploring system");
            this.triggerFleetSetPatrolActionText("scanning local volume");
            this.triggerOrderFleetPatrol(this.system, true, "salvageable", "planet");
            this.triggerFleetSetWarnAttack("SITMScavWarning", "SITMScavAttack", new Object[]{Stage.GET_ITEM});
            this.endTrigger();
            ++i;
        }
        if (veryValuable && this.rollProbability(PROB_MERC)) {
            this.beginWithinHyperspaceRangeTrigger(this.system, 3.0f, false, new Object[]{Stage.GET_ITEM});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "patrolLarge", this.system);
            this.triggerSetFleetFaction("independent");
            this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerMakeLowRepImpact();
            this.triggerFleetAllowLongPursuit();
            this.triggerSetFleetAlwaysPursue();
            this.triggerSpawnFleetNear(this.system.getCenter(), null, "$sitm_ref");
            this.triggerOrderFleetPatrol(this.system, true, "jump_point");
            this.triggerFleetSetWarnAttack("SITMMercWarning", "SITMMercAttack", new Object[]{Stage.GET_ITEM});
            this.endTrigger();
        }
        return true;
    }

    @Override
    public void reportAboutToShowLootToPlayer(CargoAPI loot, InteractionDialogAPI dialog) {
        for (CargoStackAPI stack : loot.getStacksCopy()) {
            if (!this.item.equals(stack.getData())) continue;
            Global.getSector().getListenerManager().removeListener(this);
            this.setCurrentStage((Object)Stage.COMPLETED, dialog, dialog.getPlugin().getMemoryMap());
            break;
        }
    }

    @Override
    public void reportSpecialCargoGainedFromRecoveredDerelict(CargoAPI loot, InteractionDialogAPI dialog) {
        this.reportAboutToShowLootToPlayer(loot, dialog);
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.acceptImpl(dialog, memoryMap);
        this.addSpecialItemDropOnlyUseInAcceptImplNotUndoneOnAbort(this.entity, this.item);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getListenerManager().removeListener(this);
        if (!this.rollProbability(PROB_PATHER)) {
            return;
        }
        PersonAPI person = this.getPerson();
        if (person == null || person.getMarket() == null) {
            return;
        }
        String patrolFaction = person.getMarket().getFactionId();
        if (patrolFaction.equals(person.getFaction().getId()) || Misc.isPirateFaction(person.getMarket().getFaction())) {
            return;
        }
        DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
        e.setDelayNone();
        e.setEncounterInHyper();
        e.setLocationAnywhere(true, "luddic_path");
        e.beginCreate();
        e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "luddic_path", "patrolLarge", this.system);
        e.triggerSetAdjustStrengthBasedOnQuality(true, this.getQuality());
        e.triggerSetStandardAggroInterceptFlags();
        e.triggerSetFleetGenericHailPermanent("SITMPatherHail");
        e.triggerFleetPatherNoDefaultTithe();
        e.endCreate();
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$sitm_barEvent", this.isBarEvent());
        this.set("$sitm_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$sitm_heOrShe", this.getPerson().getHeOrShe());
        this.set("$sitm_price", Misc.getWithDGS(this.price));
        this.set("$sitm_aOrAnItem", this.getItemNameLowercaseItem());
        this.set("$sitm_item", this.getWithoutArticle(this.getItemNameLowercaseItem()));
        this.set("$sitm_personName", this.getPerson().getNameString());
        this.set("$sitm_systemName", this.system.getNameWithLowercaseTypeShort());
        this.set("$sitm_dist", this.getDistanceLY(this.system));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GET_ITEM) {
            info.addPara("There is " + this.getItemNameLowercaseItem() + " to be found somewhere in the " + this.system.getNameWithLowercaseTypeShort() + ".", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GET_ITEM) {
            info.addPara("There is " + this.getItemNameLowercaseItem() + " in the " + this.system.getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return String.valueOf(Misc.ucFirst(this.getWithoutArticle(this.getItemName()))) + " Intel";
    }

    @Override
    protected String getMissionTypeNoun() {
        return "intel";
    }

    @Override
    protected String getMissionCompletionVerb() {
        return "acted on";
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.getMapLocationFor(this.system.getHyperspaceAnchor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GET_ITEM,
        COMPLETED;

    }
}

