/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheapCommodityMission
extends HubMissionWithBarEvent {
    public static boolean SAME_CONTACT_DEBUG = false;
    public static float MISSION_DAYS = 60.0f;
    public static float MIN_BASE_VALUE = 10000.0f;
    public static float MAX_BASE_VALUE = 100000.0f;
    public static float BASE_PRICE_MULT = 0.75f;
    public static float PROB_REMOTE = 0.5f;
    public static float PROB_BAR_UNDERWORLD = 0.25f;
    public static float PROB_ILLEGAL_IF_UNDERWORLD = 0.75f;
    public static float ILLEGAL_QUANTITY_MULT = 0.5f;
    protected String commodityId;
    protected int quantity;
    protected int pricePerUnit;
    protected Variation variation;
    protected MarketAPI remoteMarket;
    protected PersonAPI remoteContact;
    protected transient CommoditySpecAPI spec;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonImportance importance;
        PersonAPI person;
        if (barEvent) {
            if (this.rollProbability(PROB_BAR_UNDERWORLD)) {
                this.setGiverRank(Ranks.CITIZEN);
                this.setGiverPost(this.pickOne(Ranks.POST_SMUGGLER, Ranks.POST_GANGSTER, Ranks.POST_FENCE, Ranks.POST_CRIMINAL));
                this.setGiverImportance(this.pickImportance());
                this.setGiverFaction("pirates");
                this.setGiverTags("underworld");
            } else {
                this.setGiverRank(Ranks.CITIZEN);
                this.setGiverPost(this.pickOne(Ranks.POST_TRADER, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_MERCHANT, Ranks.POST_INVESTOR, Ranks.POST_PORTMASTER));
                this.setGiverImportance(this.pickImportance());
                this.setGiverTags("trade");
            }
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        MarketAPI market = person.getMarket();
        if (market == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$cheapCom_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        boolean canOfferRemote = (importance = person.getImportance()).ordinal() >= PersonImportance.MEDIUM.ordinal();
        boolean preferExpensive = this.getQuality() >= PersonImportance.HIGH.getValue();
        this.variation = Variation.LOCAL;
        if (canOfferRemote && this.rollProbability(PROB_REMOTE)) {
            this.variation = Variation.REMOTE;
        }
        if (SAME_CONTACT_DEBUG) {
            this.variation = Variation.REMOTE;
        }
        CommodityOnMarketAPI com = null;
        if (this.variation == Variation.LOCAL) {
            this.requireMarketIs(market);
            this.requireCommodityIsNotPersonnel();
            this.requireCommodityDeficitAtMost(0);
            this.requireCommodityAvailableAtLeast(1);
            this.requireCommoditySurplusAtLeast(1);
            if (person.hasTag("underworld") && this.rollProbability(PROB_ILLEGAL_IF_UNDERWORLD)) {
                this.preferCommodityIllegal();
            } else {
                this.requireCommodityLegal();
            }
            if (preferExpensive) {
                this.preferCommodityTags(ReqMode.ALL, "expensive");
            }
            com = this.pickCommodity();
        }
        if (com == null && canOfferRemote) {
            this.variation = Variation.REMOTE;
        }
        if (this.variation == Variation.REMOTE) {
            this.requireMarketIsNot(market);
            this.requireMarketFaction(market.getFactionId());
            if (SAME_CONTACT_DEBUG) {
                this.requireMarketIs("jangala");
            }
            this.requireCommodityIsNotPersonnel();
            this.requireCommodityDeficitAtMost(0);
            this.requireCommodityAvailableAtLeast(1);
            this.requireCommoditySurplusAtLeast(1);
            this.preferMarketInDirectionOfOtherMissions();
            if (person.hasTag("underworld") && this.rollProbability(PROB_ILLEGAL_IF_UNDERWORLD)) {
                this.preferCommodityIllegal();
            } else {
                this.requireMarketFactionNotHostileTo("player");
                this.requireCommodityLegal();
            }
            if (preferExpensive) {
                this.preferCommodityTags(ReqMode.ALL, "expensive");
            }
            if ((com = this.pickCommodity()) != null) {
                this.remoteMarket = com.getMarket();
            }
        }
        if (SAME_CONTACT_DEBUG) {
            com = Global.getSector().getEconomy().getMarket("jangala").getCommodityData("organics");
            this.remoteMarket = com.getMarket();
        }
        if (com == null) {
            return false;
        }
        this.commodityId = com.getId();
        float value = MIN_BASE_VALUE + (MAX_BASE_VALUE - MIN_BASE_VALUE) * this.getQuality();
        this.quantity = CheapCommodityMission.getRoundNumber(value / com.getCommodity().getBasePrice());
        if (com.isIllegal()) {
            this.quantity = (int)((float)this.quantity * ILLEGAL_QUANTITY_MULT);
        }
        if (this.quantity < 10) {
            this.quantity = 10;
        }
        this.pricePerUnit = (int)(com.getMarket().getSupplyPrice(com.getId(), this.quantity, true) / (float)this.quantity * BASE_PRICE_MULT / this.getRewardMult());
        this.pricePerUnit = CheapCommodityMission.getRoundNumber(this.pricePerUnit);
        if (this.pricePerUnit < 2) {
            this.pricePerUnit = 2;
        }
        if (this.variation == Variation.REMOTE) {
            this.remoteContact = this.findOrCreateTrader(this.remoteMarket.getFactionId(), this.remoteMarket, true);
            if (this.remoteContact == null || !this.setPersonMissionRef(this.remoteContact, "$cheapCom_ref")) {
                return false;
            }
            this.setPersonDoGenericPortAuthorityCheck(this.remoteContact);
            this.makeImportant(this.remoteContact, "$cheapCom_hasCommodity", Stage.TALK_TO_PERSON);
            this.setStartingStage((Object)Stage.TALK_TO_PERSON);
            this.setSuccessStage((Object)Stage.COMPLETED);
            this.setFailureStage((Object)Stage.FAILED);
            this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.remoteContact, "$cheapCom_completed");
            this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        }
        if (this.getQuality() < 0.5f) {
            this.setRepFactionChangesVeryLow();
        } else {
            this.setRepFactionChangesLow();
        }
        this.setRepPersonChangesMedium();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$cheapCom_ref2", this);
        this.set("$cheapCom_barEvent", this.isBarEvent());
        this.set("$cheapCom_underworld", this.getPerson().hasTag("underworld"));
        this.set("$cheapCom_commodityId", this.commodityId);
        this.set("$cheapCom_commodityName", this.getSpec().getLowerCaseName());
        this.set("$cheapCom_quantity", Misc.getWithDGS(this.quantity));
        this.set("$cheapCom_pricePerUnit", Misc.getDGSCredits(this.pricePerUnit));
        this.set("$cheapCom_totalPrice", Misc.getDGSCredits(this.pricePerUnit * this.quantity));
        this.set("$cheapCom_variation", (Object)this.variation);
        this.set("$cheapCom_manOrWoman", this.getPerson().getManOrWoman());
        if (this.variation == Variation.REMOTE) {
            this.set("$cheapCom_personName", this.remoteContact.getNameString());
            this.set("$cheapCom_personPost", this.remoteContact.getPost().toLowerCase());
            this.set("$cheapCom_marketName", this.remoteMarket.getName());
            this.set("$cheapCom_marketOnOrAt", this.remoteMarket.getOnOrAt());
            this.set("$cheapCom_dist", this.getDistanceLY(this.remoteMarket));
        }
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TALK_TO_PERSON) {
            TooltipMakerAPI text = info.beginImageWithText(this.remoteContact.getPortraitSprite(), 48.0f);
            text.addPara("Go to " + this.remoteMarket.getName() + " and contact " + this.remoteContact.getNameString() + " to pick up %s units of " + this.getSpec().getLowerCaseName() + " " + "for %s per unit, or %s total.", 0.0f, h, Misc.getWithDGS(this.quantity), Misc.getDGSCredits(this.pricePerUnit), Misc.getDGSCredits(this.pricePerUnit * this.quantity));
            info.addImageWithText(opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TALK_TO_PERSON) {
            info.addPara("Go to " + this.remoteMarket.getName() + " and contact " + this.remoteContact.getNameString() + " to arrange pickup", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return String.valueOf(this.getSpec().getName()) + " Pickup";
    }

    @Override
    public void accept(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        if (this.variation == Variation.REMOTE) {
            super.accept(dialog, memoryMap);
            if (this.remoteMarket != null && this.remoteMarket.getCommDirectory() != null && this.remoteMarket.getCommDirectory().getEntryForPerson(this.remoteContact) == null) {
                this.remoteMarket.getCommDirectory().addPerson(this.remoteContact);
            }
        } else {
            this.currentStage = new Object();
            this.abort();
        }
    }

    protected CommoditySpecAPI getSpec() {
        if (this.spec == null) {
            this.spec = Global.getSettings().getCommoditySpec(this.commodityId);
        }
        return this.spec;
    }

    @Override
    public String getBlurbText() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        TALK_TO_PERSON,
        COMPLETED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        LOCAL,
        REMOTE;

    }
}

