/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomProductionPickerDelegateImpl;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.ShipQuality;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.ProductionReportIntel;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.submarkets.StoragePlugin;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomProductionContract
extends HubMissionWithBarEvent {
    public static float ARMS_DEALER_PROB_PATROL_AFTER = 0.5f;
    public static float PROD_DAYS = 60.0f;
    public static float PROB_ARMS_DEALER_BAR = 0.25f;
    public static float PROB_MILITARY_BAR = 0.33f;
    public static float PROB_INDEPENDENT_BAR = 0.5f;
    public static float PROB_ARMS_DEALER_IS_CONTACT = 0.05f;
    public static float MIN_CAPACITY = 50000.0f;
    public static float MAX_CAPACITY = 500000.0f;
    public static int BAR_CAPACITY_BONUS_MIN = 50000;
    public static int BAR_CAPACITY_BONUS_MAX = 150000;
    public static float MAX_PROD_CAPACITY_AT_SHIP_UNITS = 10.0f;
    public static float MAX_PROD_CAPACITY_MULT = 0.25f;
    public static float DEALER_MIN_CAPACITY = 1000000.0f;
    public static float DEALER_MAX_CAPACITY = 2000000.0f;
    public static Map<PersonImportance, Float> DEALER_MULT = new LinkedHashMap<PersonImportance, Float>();
    public static float MILITARY_CAP_MULT;
    public static float MILITARY_MAX_COST_DECREASE;
    public static float TRADE_MAX_COST_INCREASE;
    public static float DEALER_FIXED_COST_INCREASE;
    public static float DEALER_VARIABLE_COST_INCREASE;
    protected Set<String> ships = new LinkedHashSet<String>();
    protected Set<String> weapons = new LinkedHashSet<String>();
    protected Set<String> fighters = new LinkedHashSet<String>();
    protected boolean armsDealer = false;
    protected int maxCapacity;
    protected float costMult;
    protected ProductionReportIntel.ProductionData data;
    protected int cost;
    protected FactionAPI faction;
    protected MarketAPI market;

    static {
        DEALER_MULT.put(PersonImportance.VERY_LOW, Float.valueOf(0.1f));
        DEALER_MULT.put(PersonImportance.LOW, Float.valueOf(0.2f));
        DEALER_MULT.put(PersonImportance.MEDIUM, Float.valueOf(0.3f));
        DEALER_MULT.put(PersonImportance.HIGH, Float.valueOf(0.6f));
        DEALER_MULT.put(PersonImportance.VERY_HIGH, Float.valueOf(1.0f));
        MILITARY_CAP_MULT = 0.6f;
        MILITARY_MAX_COST_DECREASE = 0.3f;
        TRADE_MAX_COST_INCREASE = 0.3f;
        DEALER_FIXED_COST_INCREASE = 0.5f;
        DEALER_VARIABLE_COST_INCREASE = 0.5f;
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        float capMult;
        PersonAPI person;
        boolean allowMilitary;
        boolean allowArmsDealer = true;
        boolean allowTrader = createdAt != null && createdAt.getCommodityData("ships").getMaxSupply() > 0;
        boolean bl = allowMilitary = allowTrader && createdAt != null && Misc.isMilitary(createdAt);
        if (createdAt.isPlayerOwned()) {
            allowTrader = false;
            allowMilitary = false;
        }
        if ("pirates".equals(createdAt.getFaction().getId())) {
            allowMilitary = false;
        }
        if (barEvent) {
            String post = null;
            if (this.rollProbability(PROB_ARMS_DEALER_BAR) && allowArmsDealer) {
                this.setGiverRank(Ranks.CITIZEN);
                post = Ranks.POST_ARMS_DEALER;
                this.setGiverTags("underworld");
                this.setGiverFaction("pirates");
            } else if (this.rollProbability(PROB_MILITARY_BAR) && allowMilitary) {
                ArrayList<String> posts = new ArrayList<String>();
                posts.add(Ranks.POST_SUPPLY_OFFICER);
                if (Misc.isMilitary(createdAt)) {
                    posts.add(Ranks.POST_BASE_COMMANDER);
                }
                if (Misc.hasOrbitalStation(createdAt)) {
                    posts.add(Ranks.POST_STATION_COMMANDER);
                }
                post = this.pickOne(posts);
                this.setGiverRank(this.pickOne(Ranks.GROUND_CAPTAIN, Ranks.GROUND_COLONEL, Ranks.GROUND_MAJOR, Ranks.SPACE_COMMANDER, Ranks.SPACE_CAPTAIN, Ranks.SPACE_ADMIRAL));
                this.setGiverTags("military");
            } else if (allowTrader) {
                this.setGiverRank(Ranks.CITIZEN);
                post = this.pickOne(Ranks.POST_TRADER, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_PORTMASTER, Ranks.POST_MERCHANT, Ranks.POST_INVESTOR, Ranks.POST_EXECUTIVE, Ranks.POST_SENIOR_EXECUTIVE, Ranks.POST_ADMINISTRATOR);
                this.setGiverTags("trade");
                if (this.rollProbability(PROB_INDEPENDENT_BAR)) {
                    this.setGiverFaction("independent");
                }
            }
            if (post == null && allowArmsDealer) {
                this.setGiverRank(Ranks.CITIZEN);
                post = Ranks.POST_ARMS_DEALER;
                this.setGiverTags("underworld");
                this.setGiverFaction("pirates");
            }
            if (post == null) {
                return false;
            }
            this.setGiverPost(post);
            if (post.equals(Ranks.POST_SENIOR_EXECUTIVE) || post.equals(Ranks.POST_BASE_COMMANDER) || post.equals(Ranks.POST_ADMINISTRATOR)) {
                this.setGiverImportance(this.pickHighImportance());
            } else if (post.equals(Ranks.POST_ARMS_DEALER)) {
                this.setGiverImportance(this.pickArmsDealerImportance());
            } else {
                this.setGiverImportance(this.pickImportance());
            }
            this.findOrCreateGiver(createdAt, false, false);
            this.setGiverIsPotentialContactOnSuccess();
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$cpc_ref")) {
            return false;
        }
        this.market = this.getPerson().getMarket();
        if (this.market == null) {
            return false;
        }
        if (Misc.getStorage(this.market) == null) {
            return false;
        }
        this.faction = person.getFaction();
        this.armsDealer = this.getPerson().hasTag("underworld");
        this.maxCapacity = CustomProductionContract.getRoundNumber(MIN_CAPACITY + (MAX_CAPACITY - MIN_CAPACITY) * this.getQuality());
        if (barEvent) {
            this.maxCapacity += this.genRoundNumber(BAR_CAPACITY_BONUS_MIN, BAR_CAPACITY_BONUS_MAX);
        }
        if ((capMult = (float)this.market.getCommodityData("ships").getMaxSupply() / MAX_PROD_CAPACITY_AT_SHIP_UNITS) > 1.0f) {
            capMult = 1.0f;
        }
        if (capMult < MAX_PROD_CAPACITY_MULT) {
            capMult = MAX_PROD_CAPACITY_MULT;
        }
        this.maxCapacity = (int)((float)this.maxCapacity * capMult);
        if (person.hasTag("military") && allowMilitary) {
            this.maxCapacity = (int)((float)this.maxCapacity * MILITARY_CAP_MULT);
        }
        this.maxCapacity = CustomProductionContract.getRoundNumber(this.maxCapacity);
        if (this.armsDealer && allowArmsDealer) {
            PersonImportance imp = this.getPerson().getImportance();
            float mult = DEALER_MULT.get((Object)imp).floatValue();
            this.maxCapacity = CustomProductionContract.getRoundNumber(mult * (DEALER_MIN_CAPACITY + (DEALER_MAX_CAPACITY - DEALER_MIN_CAPACITY) * this.getQuality()));
        }
        if (this.armsDealer && allowArmsDealer) {
            this.costMult = 1.0f + DEALER_FIXED_COST_INCREASE + DEALER_VARIABLE_COST_INCREASE * (1.0f - this.getRewardMultFraction());
            this.addArmsDealerBlueprints();
            if (this.ships.isEmpty() && this.weapons.isEmpty() && this.fighters.isEmpty()) {
                return false;
            }
        } else if (person.hasTag("military") && allowMilitary) {
            this.costMult = 1.0f - MILITARY_MAX_COST_DECREASE * this.getRewardMultFraction();
            this.addMilitaryBlueprints();
            if (this.ships.isEmpty() && this.weapons.isEmpty() && this.fighters.isEmpty()) {
                return false;
            }
        } else if (person.hasTag("trade") && allowTrader) {
            this.costMult = 1.0f + TRADE_MAX_COST_INCREASE * (1.0f - this.getRewardMultFraction());
        } else {
            return false;
        }
        this.setStartingStage((Object)Stage.WAITING);
        this.setSuccessStage((Object)Stage.DELIVERED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setNoAbandon();
        this.connectWithDaysElapsed((Object)Stage.WAITING, (Object)Stage.DELIVERED, PROD_DAYS);
        this.setStageOnMarketDecivilized((Object)Stage.FAILED, this.market);
        return true;
    }

    protected void addArmsDealerBlueprints() {
        int i;
        int num;
        float cost;
        WeightedRandomPicker<String> picker;
        boolean[] add = new boolean[3];
        add[this.genRandom.nextInt((int)add.length)] = true;
        add[this.genRandom.nextInt((int)add.length)] = true;
        add[this.genRandom.nextInt((int)add.length)] = true;
        PersonImportance imp = this.getPerson().getImportance();
        if (imp == PersonImportance.VERY_HIGH) {
            add[0] = true;
            add[1] = true;
            add[2] = true;
        }
        LinkedHashSet<WeaponAPI.WeaponType> wTypes = new LinkedHashSet<WeaponAPI.WeaponType>();
        LinkedHashSet<WeaponAPI.WeaponSize> wSizes = new LinkedHashSet<WeaponAPI.WeaponSize>();
        LinkedHashSet<ShipAPI.HullSize> hullSizes = new LinkedHashSet<ShipAPI.HullSize>();
        WeightedRandomPicker<WeaponAPI.WeaponType> wTypePicker = new WeightedRandomPicker<WeaponAPI.WeaponType>(this.genRandom);
        wTypePicker.add(WeaponAPI.WeaponType.BALLISTIC);
        wTypePicker.add(WeaponAPI.WeaponType.ENERGY);
        wTypePicker.add(WeaponAPI.WeaponType.MISSILE);
        WeightedRandomPicker<WeaponAPI.WeaponSize> wSizePicker = new WeightedRandomPicker<WeaponAPI.WeaponSize>(this.genRandom);
        wSizePicker.add(WeaponAPI.WeaponSize.SMALL);
        wSizePicker.add(WeaponAPI.WeaponSize.MEDIUM);
        wSizePicker.add(WeaponAPI.WeaponSize.LARGE);
        int nWeapons = 0;
        int nShips = 0;
        int nFighters = 0;
        switch (imp) {
            case VERY_LOW: {
                add[1] = true;
                wSizes.add(WeaponAPI.WeaponSize.SMALL);
                wTypes.add((WeaponAPI.WeaponType)((Object)wTypePicker.pickAndRemove()));
                nWeapons = 5 + this.genRandom.nextInt(6);
                nFighters = 1 + this.genRandom.nextInt(3);
                break;
            }
            case LOW: {
                add[1] = true;
                wSizePicker.remove(WeaponAPI.WeaponSize.LARGE);
                wSizes.add((WeaponAPI.WeaponSize)((Object)wSizePicker.pickAndRemove()));
                wTypes.add((WeaponAPI.WeaponType)((Object)wTypePicker.pickAndRemove()));
                hullSizes.add(ShipAPI.HullSize.FRIGATE);
                nWeapons = 10 + this.genRandom.nextInt(6);
                nShips = 5 + this.genRandom.nextInt(3);
                nFighters = 3 + this.genRandom.nextInt(3);
                break;
            }
            case MEDIUM: {
                add[1] = true;
                wSizes.add((WeaponAPI.WeaponSize)((Object)wSizePicker.pickAndRemove()));
                wSizes.add((WeaponAPI.WeaponSize)((Object)wSizePicker.pickAndRemove()));
                wTypes.add((WeaponAPI.WeaponType)((Object)wTypePicker.pickAndRemove()));
                hullSizes.add(ShipAPI.HullSize.FRIGATE);
                hullSizes.add(ShipAPI.HullSize.DESTROYER);
                nWeapons = 20 + this.genRandom.nextInt(6);
                nShips = 10 + this.genRandom.nextInt(3);
                nFighters = 5 + this.genRandom.nextInt(3);
                break;
            }
            case HIGH: {
                add[1] = true;
                wSizes.add((WeaponAPI.WeaponSize)((Object)wSizePicker.pickAndRemove()));
                wSizes.add((WeaponAPI.WeaponSize)((Object)wSizePicker.pickAndRemove()));
                wTypes.add((WeaponAPI.WeaponType)((Object)wTypePicker.pickAndRemove()));
                wTypes.add((WeaponAPI.WeaponType)((Object)wTypePicker.pickAndRemove()));
                hullSizes.add(ShipAPI.HullSize.FRIGATE);
                hullSizes.add(ShipAPI.HullSize.DESTROYER);
                hullSizes.add(ShipAPI.HullSize.CRUISER);
                nWeapons = 20 + this.genRandom.nextInt(6);
                nShips = 10 + this.genRandom.nextInt(3);
                nFighters = 7 + this.genRandom.nextInt(3);
                break;
            }
            case VERY_HIGH: {
                wSizes.add(WeaponAPI.WeaponSize.SMALL);
                wSizes.add(WeaponAPI.WeaponSize.MEDIUM);
                wSizes.add(WeaponAPI.WeaponSize.LARGE);
                hullSizes.add(ShipAPI.HullSize.FRIGATE);
                hullSizes.add(ShipAPI.HullSize.DESTROYER);
                hullSizes.add(ShipAPI.HullSize.CRUISER);
                hullSizes.add(ShipAPI.HullSize.CAPITAL_SHIP);
                wTypes.add(WeaponAPI.WeaponType.BALLISTIC);
                wTypes.add(WeaponAPI.WeaponType.ENERGY);
                wTypes.add(WeaponAPI.WeaponType.MISSILE);
                nWeapons = 1000;
                nShips = 1000;
                nFighters = 1000;
            }
        }
        FactionProductionAPI prod = Global.getSector().getPlayerFaction().getProduction().clone();
        prod.clear();
        if (add[0]) {
            picker = new WeightedRandomPicker<String>(this.genRandom);
            for (ShipHullSpecAPI spec : Global.getSettings().getAllShipHullSpecs()) {
                if (spec.hasTag("no_dealer") || spec.hasTag("no_sell") && !spec.hasTag("dealer") || spec.hasTag("restricted") || spec.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.HIDE_IN_CODEX) || spec.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.UNBOARDABLE) || spec.isDefaultDHull() || "shuttlepod".equals(spec.getHullId()) || this.ships.contains(spec.getHullId()) || !hullSizes.contains((Object)spec.getHullSize())) continue;
                cost = prod.createSampleItem(FactionProductionAPI.ProductionItemType.SHIP, spec.getHullId(), 1).getBaseCost();
                if ((cost = (float)Math.round(cost * this.costMult)) > (float)this.maxCapacity) continue;
                picker.add(spec.getHullId(), 10.0f);
            }
            num = nShips;
            i = 0;
            while (i < num && !picker.isEmpty()) {
                this.ships.add((String)picker.pickAndRemove());
                ++i;
            }
        }
        if (add[1]) {
            picker = new WeightedRandomPicker(this.genRandom);
            for (WeaponSpecAPI spec : Global.getSettings().getAllWeaponSpecs()) {
                if (spec.hasTag("no_dealer") || spec.hasTag("no_sell") && !spec.hasTag("dealer") || spec.hasTag("restricted") || spec.getAIHints().contains((Object)WeaponAPI.AIHints.SYSTEM) || this.weapons.contains(spec.getWeaponId()) || !wTypes.contains((Object)spec.getType()) || !wSizes.contains((Object)spec.getSize())) continue;
                cost = prod.createSampleItem(FactionProductionAPI.ProductionItemType.WEAPON, spec.getWeaponId(), 1).getBaseCost();
                if ((cost = (float)Math.round(cost * this.costMult)) > (float)this.maxCapacity) continue;
                picker.add(spec.getWeaponId(), 10.0f);
            }
            num = nWeapons;
            i = 0;
            while (i < num && !picker.isEmpty()) {
                this.weapons.add((String)picker.pickAndRemove());
                ++i;
            }
        }
        if (add[2]) {
            picker = new WeightedRandomPicker(this.genRandom);
            for (FighterWingSpecAPI spec : Global.getSettings().getAllFighterWingSpecs()) {
                if (spec.hasTag("no_dealer") || spec.hasTag("no_sell") && !spec.hasTag("dealer") || spec.hasTag("restricted") || this.fighters.contains(spec.getId())) continue;
                cost = prod.createSampleItem(FactionProductionAPI.ProductionItemType.FIGHTER, spec.getId(), 1).getBaseCost();
                if ((cost = (float)Math.round(cost * this.costMult)) > (float)this.maxCapacity) continue;
                picker.add(spec.getId(), 10.0f);
            }
            int num2 = nFighters;
            int i2 = 0;
            while (i2 < num2 && !picker.isEmpty()) {
                this.fighters.add((String)picker.pickAndRemove());
                ++i2;
            }
        }
    }

    protected void addMilitaryBlueprints() {
        Object spec;
        for (String id : this.faction.getKnownShips()) {
            spec = Global.getSettings().getHullSpec(id);
            if (spec.hasTag("no_sell")) continue;
            this.ships.add(id);
        }
        for (String id : this.faction.getKnownWeapons()) {
            spec = Global.getSettings().getWeaponSpec(id);
            if (spec.hasTag("no_drop") || spec.hasTag("no_sell")) continue;
            this.weapons.add(id);
        }
        for (String id : this.faction.getKnownFighters()) {
            spec = Global.getSettings().getFighterWingSpec(id);
            if (spec.hasTag("no_drop") || spec.hasTag("no_sell")) continue;
            this.fighters.add(id);
        }
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$cpc_military", this.getPerson().hasTag("military"));
        this.set("$cpc_trade", this.getPerson().hasTag("trade"));
        this.set("$cpc_armsDealer", this.armsDealer);
        this.set("$cpc_barEvent", this.isBarEvent());
        this.set("$cpc_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$cpc_maxCapacity", Misc.getWithDGS(this.maxCapacity));
        this.set("$cpc_costPercent", String.valueOf(Math.round(this.costMult * 100.0f)) + "%");
        this.set("$cpc_days", "" + (int)PROD_DAYS);
    }

    @Override
    public void addDescriptionForCurrentStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.WAITING) {
            float elapsed = this.getElapsedInCurrentStage();
            int d = Math.round(PROD_DAYS - elapsed);
            PersonAPI person = this.getPerson();
            LabelAPI label = info.addPara("The order will be delivered to storage " + this.market.getOnOrAt() + " " + this.market.getName() + " in %s " + this.getDayOrDays(d) + ".", opad, Misc.getHighlightColor(), "" + d);
            label.setHighlight(this.market.getName(), "" + d);
            label.setHighlightColors(this.market.getFaction().getBaseUIColor(), h);
            this.showCargoContents(info, width, height);
        } else if (this.currentStage == Stage.DELIVERED) {
            float elapsed = this.getElapsedInCurrentStage();
            int d = Math.round(elapsed);
            LabelAPI label = info.addPara("The order was delivered to storage " + this.market.getOnOrAt() + " " + this.market.getName() + " %s " + this.getDayOrDays(d) + " ago.", opad, Misc.getHighlightColor(), "" + d);
            label.setHighlight(this.market.getName(), "" + d);
            label.setHighlightColors(this.market.getFaction().getBaseUIColor(), h);
            this.showCargoContents(info, width, height);
            this.addDeleteButton(info, width);
        } else if (this.currentStage == Stage.FAILED) {
            if (this.market.hasCondition("decivilized")) {
                info.addPara("This order will not be completed because %s has decivilized.", opad, this.faction.getBaseUIColor(), this.market.getName());
            } else {
                info.addPara("You've learned that this order will not be completed.", opad);
            }
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.WAITING) {
            float elapsed = this.getElapsedInCurrentStage();
            this.addDays(info, "until delivery", PROD_DAYS - elapsed, tc, pad);
            return true;
        }
        if (this.currentStage == Stage.DELIVERED) {
            info.addPara("Delivered to %s", pad, tc, this.market.getFaction().getBaseUIColor(), this.market.getName());
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Custom Production Order";
    }

    @Override
    protected String getMissionTypeNoun() {
        return "contract";
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.market.getPrimaryEntity();
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        float f = (float)this.cost / (float)this.maxCapacity;
        float p = ContactIntel.DEFAULT_POTENTIAL_CONTACT_PROB * f;
        if (this.armsDealer) {
            p = PROB_ARMS_DEALER_IS_CONTACT * f;
        }
        if (this.potentialContactsOnMissionSuccess != null) {
            for (BaseHubMission.PotentialContactData data : this.potentialContactsOnMissionSuccess) {
                data.probability = p;
            }
        }
        AddRemoveCommodity.addCreditsLossText(this.cost, dialog.getTextPanel());
        Global.getSector().getPlayerFleet().getCargo().getCredits().subtract(this.cost);
        this.adjustRep(dialog.getTextPanel(), null, CoreReputationPlugin.RepActions.MISSION_SUCCESS);
        this.addPotentialContacts(dialog);
        this.ships = null;
        this.fighters = null;
        this.weapons = null;
    }

    @Override
    public void setCurrentStage(Object next, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.setCurrentStage(next, dialog, memoryMap);
        if (this.currentStage == Stage.DELIVERED) {
            StoragePlugin plugin = (StoragePlugin)Misc.getStorage(this.getPerson().getMarket());
            if (plugin == null) {
                return;
            }
            plugin.setPlayerPaidToUnlock(true);
            CargoAPI cargo = plugin.getCargo();
            for (CargoAPI curr : this.data.data.values()) {
                cargo.addAll(curr, true);
            }
            if (this.armsDealer && this.rollProbability(ARMS_DEALER_PROB_PATROL_AFTER)) {
                PersonAPI person = this.getPerson();
                if (person == null || person.getMarket() == null) {
                    return;
                }
                String patrolFaction = person.getMarket().getFactionId();
                if (patrolFaction.equals(person.getFaction().getId()) || Misc.isPirateFaction(person.getMarket().getFaction()) || Misc.isDecentralized(person.getMarket().getFaction()) || patrolFaction.equals("player")) {
                    return;
                }
                DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
                e.setDelayMedium();
                e.setLocationCoreOnly(true, patrolFaction);
                e.beginCreate();
                e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, patrolFaction, "patrolLarge", new Vector2f());
                e.setFleetWantsThing(patrolFaction, "information regarding the arms dealer", "it", "information concerning the activities of known arms dealer, " + person.getNameString(), CustomProductionContract.getRoundNumber(this.cost / 2), false, HubMissionWithTriggers.ComplicationRepImpact.FULL, DelayedFleetEncounter.TRIGGER_REP_LOSS_HIGH, this.getPerson());
                e.triggerSetAdjustStrengthBasedOnQuality(true, this.getQuality());
                e.triggerSetPatrol();
                e.triggerSetStandardAggroInterceptFlags();
                e.endCreate();
            }
        }
    }

    @Override
    protected boolean callAction(String action, String ruleId, final InteractionDialogAPI dialog, List<Misc.Token> params, final Map<String, MemoryAPI> memoryMap) {
        if ("pickPlayerBP".equals(action)) {
            dialog.showCustomProductionPicker(new BaseCustomProductionPickerDelegateImpl(){

                public float getCostMult() {
                    return CustomProductionContract.this.costMult;
                }

                public float getMaximumValue() {
                    return CustomProductionContract.this.maxCapacity;
                }

                public void notifyProductionSelected(FactionProductionAPI production) {
                    CustomProductionContract.this.convertProdToCargo(production);
                    FireBest.fire(null, dialog, memoryMap, "CPCBlueprintsPicked");
                }
            });
            return true;
        }
        if ("pickContactBP".equals(action)) {
            dialog.showCustomProductionPicker(new BaseCustomProductionPickerDelegateImpl(){

                @Override
                public Set<String> getAvailableFighters() {
                    return CustomProductionContract.this.fighters;
                }

                @Override
                public Set<String> getAvailableShipHulls() {
                    return CustomProductionContract.this.ships;
                }

                @Override
                public Set<String> getAvailableWeapons() {
                    return CustomProductionContract.this.weapons;
                }

                @Override
                public float getCostMult() {
                    return CustomProductionContract.this.costMult;
                }

                @Override
                public float getMaximumValue() {
                    return CustomProductionContract.this.maxCapacity;
                }

                @Override
                public void notifyProductionSelected(FactionProductionAPI production) {
                    CustomProductionContract.this.convertProdToCargo(production);
                    FireBest.fire(null, dialog, memoryMap, "CPCBlueprintsPicked");
                }
            });
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    protected void convertProdToCargo(FactionProductionAPI prod) {
        this.cost = prod.getTotalCurrentCost();
        this.data = new ProductionReportIntel.ProductionData();
        CargoAPI cargo = this.data.getCargo("Order manifest");
        float quality = ShipQuality.getShipQuality(this.market, this.market.getFactionId());
        if (this.armsDealer) {
            quality = Math.max(quality, 1.5f);
        }
        CampaignFleetAPI ships = Global.getFactory().createEmptyFleet(this.market.getFactionId(), "temp", true);
        ships.setCommander(Global.getSector().getPlayerPerson());
        ships.getFleetData().setShipNameRandom(this.genRandom);
        DefaultFleetInflaterParams p = new DefaultFleetInflaterParams();
        p.quality = quality;
        p.mode = FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
        p.persistent = false;
        p.seed = this.genRandom.nextLong();
        p.timestamp = null;
        FleetInflater inflater = Misc.getInflater(ships, p);
        ships.setInflater(inflater);
        for (FactionProductionAPI.ItemInProductionAPI item : prod.getCurrent()) {
            int count = item.getQuantity();
            if (item.getType() == FactionProductionAPI.ProductionItemType.SHIP) {
                int i = 0;
                while (i < count) {
                    ships.getFleetData().addFleetMember(String.valueOf(item.getSpecId()) + "_Hull");
                    ++i;
                }
                continue;
            }
            if (item.getType() == FactionProductionAPI.ProductionItemType.FIGHTER) {
                cargo.addFighters(item.getSpecId(), count);
                continue;
            }
            if (item.getType() != FactionProductionAPI.ProductionItemType.WEAPON) continue;
            cargo.addWeapons(item.getSpecId(), count);
        }
        ships.inflateIfNeeded();
        for (FleetMemberAPI member : ships.getFleetData().getMembersListCopy()) {
            if (member.getVariant().getSource() == VariantSource.REFIT) {
                member.getVariant().clear();
            }
            cargo.getMothballedShips().addFleetMember(member);
        }
    }

    public void showCargoContents(TooltipMakerAPI info, float width, float height) {
        if (this.data == null) {
            return;
        }
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float small = 3.0f;
        float opad = 10.0f;
        ArrayList<String> keys = new ArrayList<String>(this.data.data.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        for (String key : keys) {
            CargoAPI cargo = this.data.data.get(key);
            if (cargo.isEmpty() && (cargo.getMothballedShips() == null || cargo.getMothballedShips().getMembersListCopy().isEmpty())) continue;
            info.addSectionHeading(key, this.faction.getBaseUIColor(), this.faction.getDarkUIColor(), Alignment.MID, opad);
            if (!cargo.getStacksCopy().isEmpty()) {
                info.addPara("Ship weapons and fighters:", opad);
                info.showCargo(cargo, 20, true, opad);
            }
            if (cargo.getMothballedShips().getMembersListCopy().isEmpty()) continue;
            CountingMap<String> counts = new CountingMap<String>();
            for (FleetMemberAPI member : cargo.getMothballedShips().getMembersListCopy()) {
                counts.add(String.valueOf(member.getVariant().getHullSpec().getHullName()) + " " + member.getVariant().getDesignation());
            }
            info.addPara("Ship hulls:", opad);
            info.showShips(cargo.getMothballedShips().getMembersListCopy(), 20, true, this.getCurrentStage() == Stage.WAITING, opad);
        }
    }

    public PersonImportance pickArmsDealerImportance() {
        WeightedRandomPicker<PersonImportance> picker = new WeightedRandomPicker<PersonImportance>(this.genRandom);
        picker.add(PersonImportance.VERY_LOW, 10.0f);
        picker.add(PersonImportance.LOW, 10.0f);
        float cycles = PirateBaseManager.getInstance().getDaysSinceStart() / 365.0f;
        if (cycles > 1.0f) {
            picker.remove(PersonImportance.VERY_LOW);
            picker.add(PersonImportance.MEDIUM, 20.0f);
        }
        if (cycles > 3.0f) {
            picker.remove(PersonImportance.LOW);
            picker.add(PersonImportance.HIGH, 10.0f);
        }
        if (cycles > 5.0f) {
            return PersonImportance.VERY_HIGH;
        }
        return (PersonImportance)((Object)picker.pick());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        WAITING,
        DELIVERED,
        COMPLETED,
        FAILED;

    }
}

