/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirateSystemBounty
extends HubMissionWithBarEvent
implements FleetEventListener {
    public static float BOUNTY_DAYS = 120.0f;
    public static float BASE_BOUNTY = 1000.0f;
    protected StarSystemAPI system;
    protected MarketAPI market;
    protected FactionAPI faction;
    protected FactionAPI enemy;
    protected int baseBounty;
    protected BountyResult latestResult;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            String post = null;
            this.setGiverRank(Ranks.CITIZEN);
            post = this.pickOne(Ranks.POST_TRADER, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_MERCHANT, Ranks.POST_INVESTOR, Ranks.POST_EXECUTIVE, Ranks.POST_PORTMASTER, Ranks.POST_SENIOR_EXECUTIVE);
            this.setGiverTags("trade");
            this.setGiverPost(post);
            if (post.equals(Ranks.POST_SENIOR_EXECUTIVE)) {
                this.setGiverImportance(this.pickHighImportance());
            } else {
                this.setGiverImportance(this.pickImportance());
            }
            this.findOrCreateGiver(createdAt, false, false);
            this.setGiverIsPotentialContactOnSuccess();
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if ("pirates".equals(person.getFaction().getId())) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$psb_ref")) {
            return false;
        }
        this.requireMarketFactionCustom(ReqMode.ALL, "makesPirateBases");
        this.requireMarketMemoryFlag(PirateBaseIntel.MEM_FLAG, true);
        this.requireMarketFactionNot(person.getFaction().getId());
        this.requireMarketHidden();
        this.requireMarketIsMilitary();
        this.preferMarketInDirectionOfOtherMissions();
        this.market = this.pickMarket();
        if (this.market == null || this.market.getStarSystem() == null) {
            return false;
        }
        if (!this.setMarketMissionRef(this.market, "$psb_ref")) {
            return false;
        }
        this.makeImportant(this.market, "$psb_target", Stage.BOUNTY);
        this.system = this.market.getStarSystem();
        this.faction = person.getFaction();
        this.enemy = this.market.getFaction();
        this.baseBounty = PirateSystemBounty.getRoundNumber(BASE_BOUNTY * this.getRewardMult());
        this.setStartingStage((Object)Stage.BOUNTY);
        this.setSuccessStage((Object)Stage.DONE);
        this.setNoAbandon();
        this.setNoRepChanges();
        this.connectWithDaysElapsed((Object)Stage.BOUNTY, (Object)Stage.DONE, BOUNTY_DAYS);
        this.addTag("Bounties");
        int numPirates = 2 + this.genRandom.nextInt(3);
        HubMissionWithTriggers.FleetSize[] sizes = new HubMissionWithTriggers.FleetSize[]{HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetSize.VERY_LARGE};
        int i = 0;
        while (i < numPirates) {
            HubMissionWithTriggers.FleetSize size = sizes[i % sizes.length];
            this.beginWithinHyperspaceRangeTrigger(this.system, 3.0f, false, new Object[]{Stage.BOUNTY});
            this.triggerCreateFleet(size, HubMissionWithTriggers.FleetQuality.DEFAULT, this.market.getFactionId(), "patrolMedium", this.system);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerSetPirateFleet();
            this.triggerSpawnFleetNear(this.system.getCenter(), null, null);
            this.triggerOrderFleetPatrol(this.system, true, "station", "jump_point");
            this.endTrigger();
            ++i;
        }
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$psb_barEvent", this.isBarEvent());
        this.set("$psb_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$psb_baseBounty", Misc.getWithDGS(this.baseBounty));
        this.set("$psb_days", "" + (int)BOUNTY_DAYS);
        this.set("$psb_systemName", this.system.getNameWithLowercaseType());
        this.set("$psb_systemNameShort", this.system.getNameWithLowercaseTypeShort());
        this.set("$psb_baseName", this.market.getName());
        this.set("$psb_dist", this.getDistanceLY(this.market));
    }

    @Override
    public void addDescriptionForCurrentStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        Color tc = this.getBulletColorForMode(IntelInfoPlugin.ListInfoMode.IN_DESC);
        if (this.currentStage == Stage.BOUNTY) {
            float elapsed = this.getElapsedInCurrentStage();
            int d = Math.round(BOUNTY_DAYS - elapsed);
            PersonAPI person = this.getPerson();
            String locStr = "in or near the " + this.market.getStarSystem().getNameWithLowercaseType();
            info.addPara("Applies to all %s fleets " + locStr + ", which is home to " + this.market.getName() + ", a pirate base.", opad, this.enemy.getBaseUIColor(), this.enemy.getPersonNamePrefix());
            if (this.isEnding()) {
                info.addPara("This bounty is no longer on offer.", opad);
                return;
            }
            this.bullet(info);
            info.addPara("%s base reward per frigate", opad, tc, h, Misc.getDGSCredits(this.baseBounty));
            this.addDays(info, "remaining", d, tc);
            this.unindent(info);
            info.addPara("Payment depends on the number and size of ships destroyed. Standing with " + this.faction.getDisplayNameWithArticle() + ", as well as " + "with " + person.getNameString() + ", will improve.", opad);
        } else if (this.currentStage == Stage.DONE) {
            info.addPara("This bounty is no longer on offer.", opad);
        }
        if (this.latestResult != null) {
            info.addPara("Most recent bounty payment:", opad);
            this.bullet(info);
            info.addPara("%s received", pad, tc, h, Misc.getDGSCredits(this.latestResult.payment));
            if ((float)Math.round(this.latestResult.fraction * 100.0f) < 100.0f) {
                info.addPara("%s share based on damage dealt", 0.0f, tc, h, Math.round(this.latestResult.fraction * 100.0f) + "%");
            }
            if (this.latestResult.repPerson != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.latestResult.repPerson.delta, null, this.getPerson(), null, null, info, tc, false, 0.0f);
            }
            if (this.latestResult.repFaction != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.latestResult.repFaction.delta, this.faction, null, null, null, info, tc, false, 0.0f);
            }
            this.unindent(info);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (isUpdate && this.latestResult == this.getListInfoParam()) {
            info.addPara("%s received", pad, tc, h, Misc.getDGSCredits(this.latestResult.payment));
            if ((float)Math.round(this.latestResult.fraction * 100.0f) < 100.0f) {
                info.addPara("%s share based on damage dealt", 0.0f, tc, h, Math.round(this.latestResult.fraction * 100.0f) + "%");
            }
            if (this.latestResult.repPerson != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.latestResult.repPerson.delta, null, this.getPerson(), null, null, info, tc, isUpdate, 0.0f);
            }
            if (this.latestResult.repFaction != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.latestResult.repFaction.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
            }
            return true;
        }
        if (this.currentStage == Stage.BOUNTY) {
            float elapsed = this.getElapsedInCurrentStage();
            int d = Math.round(BOUNTY_DAYS - elapsed);
            info.addPara("%s base reward per frigate", pad, tc, h, Misc.getDGSCredits(this.baseBounty));
            this.addDays(info, "remaining", d, tc);
            return true;
        }
        if (this.currentStage == Stage.DONE) {
            return false;
        }
        return false;
    }

    @Override
    public String getPostfixForState() {
        if (this.currentStage == Stage.DONE) {
            return " - Over";
        }
        return super.getPostfixForState();
    }

    @Override
    public String getBaseName() {
        return "Pirate Fleet Bounty";
    }

    @Override
    protected String getMissionTypeNoun() {
        return "bounty";
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.getMapLocationFor(this.market.getPrimaryEntity());
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected void notifyEnding() {
        Global.getSector().getListenerManager().removeListener(this);
        super.notifyEnding();
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (this.isEnded() || this.isEnding()) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        if (!Misc.isNear(primaryWinner, this.market.getLocationInHyperspace())) {
            return;
        }
        int payment = 0;
        float fpDestroyed = 0.0f;
        for (CampaignFleetAPI otherFleet : battle.getNonPlayerSideSnapshot()) {
            if (this.enemy != otherFleet.getFaction()) continue;
            float bounty = 0.0f;
            for (FleetMemberAPI loss : Misc.getSnapshotMembersLost(otherFleet)) {
                float mult = Misc.getSizeNum(loss.getHullSpec().getHullSize());
                bounty += mult * (float)this.baseBounty;
                fpDestroyed += (float)loss.getFleetPointCost();
            }
            payment += (int)(bounty * battle.getPlayerInvolvementFraction());
        }
        if (payment > 0) {
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep;
            Global.getSector().getPlayerFleet().getCargo().getCredits().add(payment);
            float repFP = (int)(fpDestroyed * battle.getPlayerInvolvementFraction());
            float fDelta = 0.0f;
            float pDelta = 0.0f;
            if (repFP < 30.0f) {
                fDelta = 0.01f;
                pDelta = 0.01f;
            } else if (repFP < 70.0f) {
                fDelta = 0.02f;
                pDelta = 0.02f;
            } else {
                fDelta = 0.02f;
                pDelta = 0.03f;
            }
            CoreReputationPlugin.MissionCompletionRep completionRepPerson = new CoreReputationPlugin.MissionCompletionRep(pDelta, this.getRewardLimitPerson(), 0.0f, null);
            CoreReputationPlugin.MissionCompletionRep completionRepFaction = new CoreReputationPlugin.MissionCompletionRep(fDelta, this.getRewardLimitFaction(), 0.0f, null);
            boolean addContacts = this.latestResult == null;
            this.latestResult = new BountyResult(payment, battle.getPlayerInvolvementFraction(), null, null);
            if (pDelta != 0.0f) {
                this.latestResult.repPerson = rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)completionRepPerson, null, true, false), this.getPerson());
            }
            if (completionRepFaction.successDelta != 0.0f) {
                this.latestResult.repFaction = rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)completionRepFaction, null, true, false), this.getPerson().getFaction().getId());
            }
            this.sendUpdateIfPlayerHasIntel((Object)this.latestResult, false);
            if (addContacts) {
                this.addPotentialContacts(null);
            }
        }
    }

    public static class BountyResult {
        public int payment;
        public float fraction;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult repFaction;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult repPerson;

        public BountyResult(int payment, float fraction, ReputationActionResponsePlugin.ReputationAdjustmentResult repPerson, ReputationActionResponsePlugin.ReputationAdjustmentResult repFaction) {
            this.payment = payment;
            this.fraction = fraction;
            this.repFaction = repFaction;
            this.repPerson = repPerson;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        BOUNTY,
        DONE;

    }
}

