/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.CheapCommodityMission;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcurementMission
extends HubMissionWithBarEvent {
    public static float PROB_COMPLICATIONS = 0.5f;
    public static float MISSION_DAYS = 60.0f;
    public static float MIN_BASE_VALUE = 10000.0f;
    public static float MAX_BASE_VALUE = 100000.0f;
    public static float BASE_PRICE_MULT = 1.5f;
    public static float PROB_REMOTE = 0.5f;
    public static float PROB_BAR_UNDERWORLD = 0.25f;
    public static float PROB_ILLEGAL_IF_UNDERWORLD = 0.5f;
    public static float ILLEGAL_QUANTITY_MULT = 0.5f;
    protected String commodityId;
    protected int quantity;
    protected int pricePerUnit;
    protected Variation variation;
    protected MarketAPI deliveryMarket;
    protected PersonAPI deliveryContact;
    protected transient CommoditySpecAPI spec;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonImportance importance;
        PersonAPI person;
        if (barEvent) {
            if (this.rollProbability(PROB_BAR_UNDERWORLD)) {
                this.setGiverRank(Ranks.CITIZEN);
                this.setGiverPost(this.pickOne(Ranks.POST_SMUGGLER, Ranks.POST_GANGSTER, Ranks.POST_FENCE, Ranks.POST_CRIMINAL));
                this.setGiverImportance(this.pickImportance());
                this.setGiverTags("underworld");
                this.setGiverFaction("pirates");
            } else {
                this.setGiverRank(Ranks.CITIZEN);
                String post = this.pickOne(Ranks.POST_TRADER, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_MERCHANT, Ranks.POST_INVESTOR, Ranks.POST_EXECUTIVE, Ranks.POST_SENIOR_EXECUTIVE, Ranks.POST_PORTMASTER);
                this.setGiverPost(post);
                if (post.equals(Ranks.POST_SENIOR_EXECUTIVE)) {
                    this.setGiverImportance(this.pickHighImportance());
                } else {
                    this.setGiverImportance(this.pickImportance());
                }
                this.setGiverTags("trade");
            }
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        MarketAPI market = person.getMarket();
        if (market == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$proCom_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        boolean canOfferRemote = (importance = person.getImportance()).ordinal() >= PersonImportance.MEDIUM.ordinal();
        boolean preferExpensive = this.getQuality() >= PersonImportance.HIGH.getValue();
        this.variation = Variation.LOCAL;
        if (canOfferRemote && this.rollProbability(PROB_REMOTE)) {
            this.variation = Variation.REMOTE;
        }
        if (CheapCommodityMission.SAME_CONTACT_DEBUG) {
            this.variation = Variation.REMOTE;
        }
        CommodityOnMarketAPI com = null;
        if (this.variation == Variation.LOCAL) {
            this.requireMarketIs(market);
            this.requireCommodityIsNotPersonnel();
            if (person.hasTag("underworld") && this.rollProbability(PROB_ILLEGAL_IF_UNDERWORLD)) {
                this.preferCommodityIllegal();
            } else {
                this.requireCommodityLegal();
                this.requireCommodityDemandAtLeast(1);
            }
            this.requireCommoditySurplusAtMost(0);
            this.requireCommodityDeficitAtLeast(1);
            if (preferExpensive) {
                this.preferCommodityTags(ReqMode.ALL, "expensive");
            }
            com = this.pickCommodity();
        }
        if (com == null && canOfferRemote) {
            this.variation = Variation.REMOTE;
        }
        if (this.variation == Variation.REMOTE) {
            if (CheapCommodityMission.SAME_CONTACT_DEBUG) {
                this.requireMarketIs("jangala");
            } else {
                this.requireMarketIsNot(market);
            }
            this.requireMarketFaction(market.getFactionId());
            this.requireMarketNotHidden();
            this.requireMarketLocationNot(createdAt.getContainingLocation());
            this.requireCommodityIsNotPersonnel();
            if (person.hasTag("underworld") && this.rollProbability(PROB_ILLEGAL_IF_UNDERWORLD)) {
                this.preferCommodityIllegal();
            } else {
                this.requireMarketFactionNotHostileTo("player");
                this.requireCommodityLegal();
                this.requireCommodityDemandAtLeast(1);
            }
            this.requireCommoditySurplusAtMost(0);
            this.requireCommodityDeficitAtLeast(1);
            if (preferExpensive) {
                this.preferCommodityTags(ReqMode.ALL, "expensive");
            }
            com = this.pickCommodity();
        }
        if (com == null) {
            return false;
        }
        this.deliveryMarket = com.getMarket();
        this.commodityId = com.getId();
        float value = MIN_BASE_VALUE + (MAX_BASE_VALUE - MIN_BASE_VALUE) * this.getQuality();
        this.quantity = ProcurementMission.getRoundNumber(value / com.getCommodity().getBasePrice());
        if (com.isIllegal()) {
            this.quantity = (int)((float)this.quantity * ILLEGAL_QUANTITY_MULT);
        }
        if (this.quantity < 10) {
            this.quantity = 10;
        }
        this.pricePerUnit = (int)(com.getMarket().getSupplyPrice(com.getId(), this.quantity, true) / (float)this.quantity * BASE_PRICE_MULT / this.getRewardMult());
        this.pricePerUnit = ProcurementMission.getRoundNumber(this.pricePerUnit);
        if (this.pricePerUnit < 2) {
            this.pricePerUnit = 2;
        }
        this.deliveryContact = this.variation == Variation.REMOTE ? (com.isIllegal() ? this.findOrCreateCriminal(this.deliveryMarket, true) : this.findOrCreateTrader(this.deliveryMarket.getFactionId(), this.deliveryMarket, true)) : person;
        this.ensurePersonIsInCommDirectory(this.deliveryMarket, this.deliveryContact);
        if (this.deliveryContact == null || this.variation == Variation.REMOTE && !this.setPersonMissionRef(this.deliveryContact, "$proCom_ref")) {
            return false;
        }
        this.setPersonDoGenericPortAuthorityCheck(this.deliveryContact);
        this.makeImportant(this.deliveryContact, "$proCom_needsCommodity", Stage.TALK_TO_PERSON);
        this.setStartingStage((Object)Stage.TALK_TO_PERSON);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.deliveryContact, "$proCom_completed");
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        if (this.getQuality() < 0.5f) {
            this.setRepFactionChangesVeryLow();
        } else {
            this.setRepFactionChangesLow();
        }
        this.setRepPersonChangesMedium();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$proCom_barEvent", this.isBarEvent());
        this.set("$proCom_commodityId", this.commodityId);
        this.set("$proCom_underworld", this.getPerson().hasTag("underworld"));
        this.set("$proCom_playerHasEnough", ProcurementMission.playerHasEnough(this.commodityId, this.quantity));
        this.set("$proCom_commodityName", this.getSpec().getLowerCaseName());
        this.set("$proCom_quantity", Misc.getWithDGS(this.quantity));
        this.set("$proCom_pricePerUnit", Misc.getDGSCredits(this.pricePerUnit));
        this.set("$proCom_totalPrice", Misc.getDGSCredits(this.pricePerUnit * this.quantity));
        this.set("$proCom_variation", (Object)this.variation);
        this.set("$proCom_manOrWoman", this.getPerson().getManOrWoman());
        if (this.variation == Variation.REMOTE) {
            this.set("$proCom_personName", this.deliveryContact.getNameString());
            this.set("$proCom_personPost", this.deliveryContact.getPost().toLowerCase());
            this.set("$proCom_PersonPost", Misc.ucFirst(this.deliveryContact.getPost()));
            this.set("$proCom_marketName", this.deliveryMarket.getName());
            this.set("$proCom_marketOnOrAt", this.deliveryMarket.getOnOrAt());
            this.set("$proCom_dist", this.getDistanceLY(this.deliveryMarket));
        }
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TALK_TO_PERSON) {
            TooltipMakerAPI text = info.beginImageWithText(this.deliveryContact.getPortraitSprite(), 48.0f);
            text.addPara("Deliver %s units of " + this.getSpec().getLowerCaseName() + " to " + this.deliveryContact.getNameString() + " " + this.deliveryMarket.getOnOrAt() + " " + this.deliveryMarket.getName() + ". You will be paid %s per unit, or " + "%s total.", 0.0f, h, Misc.getWithDGS(this.quantity), Misc.getDGSCredits(this.pricePerUnit), Misc.getDGSCredits(this.pricePerUnit * this.quantity));
            info.addImageWithText(opad);
            if (ProcurementMission.playerHasEnough(this.commodityId, this.quantity)) {
                info.addPara("You have enough " + this.getSpec().getLowerCaseName() + " in your cargo holds to complete " + "the delivery.", opad);
            } else {
                info.addPara("You do not have enough " + this.getSpec().getLowerCaseName() + " in your cargo holds to complete " + "the delivery.", opad);
            }
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TALK_TO_PERSON) {
            if (ProcurementMission.playerHasEnough(this.commodityId, this.quantity)) {
                info.addPara("Go to " + this.deliveryMarket.getName() + " and contact " + this.deliveryContact.getNameString() + " to arrange delivery", tc, pad);
            } else {
                String name = this.getSpec().getLowerCaseName();
                info.addPara("Acquire %s units of " + name, pad, tc, h, "" + this.quantity);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return String.valueOf(this.getSpec().getName()) + " Procurement";
    }

    @Override
    public void accept(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.accept(dialog, memoryMap);
        if (this.variation == Variation.REMOTE && this.rollProbability(PROB_COMPLICATIONS)) {
            DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
            e.setDelay(10.0f);
            e.setLocationCoreOnly(true, "pirates");
            e.setEncounterInHyper();
            e.beginCreate();
            e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolMedium", new Vector2f());
            e.triggerSetAdjustStrengthBasedOnQuality(true, this.getQuality());
            e.triggerSetStandardAggroPirateFlags();
            e.triggerSetStandardAggroInterceptFlags();
            e.triggerSetFleetMemoryValue("$proCom_commodityName", this.getSpec().getLowerCaseName());
            e.triggerSetFleetGenericHailPermanent("PROCOMPirateHail");
            e.endCreate();
        }
    }

    protected CommoditySpecAPI getSpec() {
        if (this.spec == null) {
            this.spec = Global.getSettings().getCommoditySpec(this.commodityId);
        }
        return this.spec;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        TALK_TO_PERSON,
        COMPLETED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        LOCAL,
        REMOTE;

    }
}

