/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.procgen.themes.MiscellaneousThemeGenerator;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoverAPlanetkiller
extends HubMissionWithSearch {
    public static boolean startedAtPather() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$pk_startedAtPather");
    }

    public static boolean startedAtNexus() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$pk_startedAtNexus");
    }

    public static boolean gotDataFromMysteryAI() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$pk_gotDataFromMysteryAI");
    }

    public CampaignFleetAPI getNexus() {
        return (CampaignFleetAPI)Global.getSector().getPersistentData().get(MiscellaneousThemeGenerator.PK_NEXUS_KEY);
    }

    public StarSystemAPI getNexusSystem() {
        CampaignFleetAPI nexus = this.getNexus();
        if (nexus != null && nexus.isAlive()) {
            return nexus.getStarSystem();
        }
        return null;
    }

    public static MarketAPI getTundraMarket() {
        PlanetAPI p = RecoverAPlanetkiller.getTundra();
        if (p == null) {
            return null;
        }
        return p.getMarket();
    }

    public static PlanetAPI getTundra() {
        return (PlanetAPI)Global.getSector().getPersistentData().get(MiscellaneousThemeGenerator.PK_PLANET_KEY);
    }

    public static StarSystemAPI getPKSystem() {
        return (StarSystemAPI)Global.getSector().getPersistentData().get(MiscellaneousThemeGenerator.PK_SYSTEM_KEY);
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        this.setPersonOverride(null);
        this.setStoryMission();
        this.setNoAbandon();
        if (!this.setGlobalReference("$pk_ref", "$pk_inProgress")) {
            return false;
        }
        CampaignFleetAPI nexus = this.getNexus();
        if (nexus != null && nexus.isAlive()) {
            this.makeImportant(nexus, "$pk_nexus", Stage.GO_TO_NEXUS);
        }
        if (RecoverAPlanetkiller.startedAtNexus()) {
            this.setStartingStage((Object)Stage.RECOVER_PK);
        } else {
            if (nexus == null || !nexus.isAlive() || this.getNexusSystem() == null) {
                return false;
            }
            this.setStartingStage((Object)Stage.GO_TO_NEXUS);
        }
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setRepPenaltyFaction(Float.valueOf(0.0f));
        this.setRepPenaltyPerson(Float.valueOf(0.0f));
        this.connectWithGlobalFlag((Object)Stage.GO_TO_NEXUS, (Object)Stage.RECOVER_PK, "$pk_nexusDataGained");
        if (nexus != null) {
            this.connectWithEntityNotAlive((Object)Stage.GO_TO_NEXUS, (Object)Stage.RECOVER_PK, nexus);
        }
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$pk_completed");
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$pk_recovered", true);
        this.triggerSetGlobalMemoryValue("$pk_missionCompleted", true);
        this.endTrigger();
        return true;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map, Object currentStage) {
        if (currentStage == Stage.RECOVER_PK) {
            return RecoverAPlanetkiller.getPKSystem().getCenter();
        }
        return super.getMapLocation(map, currentStage);
    }

    @Override
    protected void endFailureImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
    }

    @Override
    protected void updateInteractionDataImpl() {
        CampaignFleetAPI nexus = this.getNexus();
        StarSystemAPI ns = this.getNexusSystem();
        StarSystemAPI pks = RecoverAPlanetkiller.getPKSystem();
        if (this.getCurrentStage() != null) {
            this.set("$pk_stage", ((Enum)this.getCurrentStage()).name());
        }
        if (ns != null) {
            this.set("$pk_nexusSystemName", ns.getNameWithLowercaseTypeShort());
        }
        if (pks != null) {
            this.set("$pk_pkSystemName", pks.getNameWithLowercaseTypeShort());
        }
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        block1: {
            StarSystemAPI pks;
            float opad;
            block2: {
                block0: {
                    opad = 10.0f;
                    Color h = Misc.getHighlightColor();
                    if (this.currentStage != Stage.GO_TO_NEXUS) break block0;
                    StarSystemAPI ns = this.getNexusSystem();
                    if (ns == null) break block1;
                    info.addPara("Recover information about a Hegemony fleet last seen in a Tri-Tachyon held system during the first AI War, more than a hundred cycles ago. The fleet is rumored to have been carrying a planetkiller weapon.", opad);
                    info.addPara("The information should be contained in the data banks of a remnant Nexus located in the " + ns.getNameWithLowercaseType() + ".", opad);
                    break block1;
                }
                if (this.currentStage != Stage.RECOVER_PK) break block1;
                pks = RecoverAPlanetkiller.getPKSystem();
                if (pks == null) break block1;
                if (!RecoverAPlanetkiller.startedAtNexus()) break block2;
                info.addPara("You've destroyed a remnant Nexus and recovered information about a Hegemony fleet estimated to be carrying a planetkiller weapon.", opad);
                info.addPara("A log entry records a large Ordo sent in pursuit; its last hyperwave report placed it near the " + pks.getNameWithLowercaseTypeShort() + ". The log entry dates to the first AI War, more than a hundred cycles ago", opad);
                if (!RecoverAPlanetkiller.gotDataFromMysteryAI()) break block1;
                info.addPara("A mysterious voice, some kind of AI, provided you with coordinates for the " + pks.getNameWithLowercaseTypeShort() + ", and implied that the planetkiller weapon could be found there.", opad);
                info.addPara("Perhaps it brings 'much amusement' to this AI to not provide more detailed instructions.", opad);
                break block1;
            }
            info.addPara("The data banks of the remnant Nexus contained information about the Hegemony fleet rumored to be carrying a planetkiller weapon. ", opad);
            info.addPara("A log entry records a large Ordo sent in pursuit; its last hyperwave report placed it near the " + pks.getNameWithLowercaseTypeShort() + ". The log entry dates to the first AI War, more than a hundred cycles ago", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_NEXUS) {
            StarSystemAPI ns = this.getNexusSystem();
            if (ns != null) {
                info.addPara("Recover information from remnant Nexus in the " + ns.getNameWithLowercaseTypeShort(), tc, pad);
            }
            return true;
        }
        if (this.currentStage == Stage.RECOVER_PK) {
            StarSystemAPI pks = RecoverAPlanetkiller.getPKSystem();
            if (pks != null) {
                info.addPara("Investigate the " + pks.getNameWithLowercaseTypeShort(), tc, pad);
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getMissionTypeNoun() {
        return "task";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    @Override
    public String getBaseName() {
        return "The Scythe of Orion";
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.acceptImpl(dialog, memoryMap);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (action.equals("showNexusSystem")) {
            StarSystemAPI system = this.getNexusSystem();
            if (system != null) {
                dialog.getVisualPanel().showMapMarker(system.getHyperspaceAnchor(), system.getNameWithLowercaseTypeShort(), this.getFactionForUIColors().getBaseUIColor(), true, this.getIcon(), null, this.getIntelTags(null));
            }
            return true;
        }
        if (action.equals("hideNexusSystem")) {
            dialog.getVisualPanel().removeMapMarkerFromPersonInfo();
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_NEXUS,
        RECOVER_PK,
        COMPLETED,
        FAILED;

    }
}

