/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.BaseFleetEventListener;
import com.fs.starfarer.api.campaign.listeners.CurrentLocationChangedListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.GateEntityPlugin;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.missions.GateCMD;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAAtTheGates
extends GABaseMission
implements CurrentLocationChangedListener {
    public static String SHOW_GATE_SCAN_COUNT = "show_gate_scan_count";
    protected PersonAPI baird;
    protected PersonAPI coureuse;
    protected PersonAPI gargoyle;
    protected PersonAPI horus_yaribay;
    protected PersonAPI siyavong;
    protected MarketAPI kazeron;
    protected SectorEntityToken magecGate;
    protected SectorEntityToken galatiaGate;
    protected PersonAPI daud;
    protected MarketAPI chicomoztoc;
    protected PersonAPI kanta;
    protected PersonAPI loke;
    protected PersonAPI cotton;
    protected PersonAPI zal;
    protected PersonAPI kantasDenStationCommander;
    protected MarketAPI kantasDen;
    protected MarketAPI epiphany;
    protected SectorEntityToken encounterGateHegemony;
    protected CampaignFleetAPI encounterHegemonyFleet;
    protected SectorEntityToken encounterGateLuddic;
    protected CampaignFleetAPI encounterLuddicFleet;
    protected SectorEntityToken encounterGateTT;
    protected CampaignFleetAPI encounterTTFleet;
    protected int ttScanCost;
    protected int pirateScanCost;
    protected int coureuseCredits;
    protected SectorEntityToken encounterGatePirate;
    protected CampaignFleetAPI encounterPirateFleet;
    protected List<ScanEncounterVariation> scanEncounterVariations;
    public static float SYSTEM_NO_GATE_ENCOUNTER_CHANCE = 0.2f;
    public static float FACTION_GATE_ENCOUNTER_CHANCE = 0.5f;
    public static float KANTA_RAID_DIFFICULTY = 1000.0f;
    public static float COTTON_RAID_DIFFICULTY = 1000.0f;
    public static String CHECKED_FOR_ENCOUNTER = "$gaATG_checkedForEncounter";

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaATG_ref", "$gaATG_inProgress")) {
            return false;
        }
        this.baird = this.getImportantPerson(People.BAIRD);
        if (this.baird == null) {
            return false;
        }
        this.coureuse = this.getImportantPerson(People.COUREUSE);
        if (this.coureuse == null) {
            return false;
        }
        this.gargoyle = this.getImportantPerson(People.GARGOYLE);
        if (this.gargoyle == null) {
            return false;
        }
        this.horus_yaribay = this.getImportantPerson(People.HORUS_YARIBAY);
        if (this.horus_yaribay == null) {
            return false;
        }
        this.siyavong = this.getImportantPerson(People.SIYAVONG);
        if (this.siyavong == null) {
            return false;
        }
        this.daud = this.getImportantPerson(People.DAUD);
        if (this.daud == null) {
            return false;
        }
        this.kanta = this.getImportantPerson(People.KANTA);
        if (this.kanta == null) {
            return false;
        }
        this.loke = this.getImportantPerson(People.CLONE_LOKE);
        if (this.loke == null) {
            return false;
        }
        this.cotton = this.getImportantPerson(People.COTTON);
        if (this.cotton == null) {
            return false;
        }
        this.zal = this.getImportantPerson(People.ZAL);
        if (this.zal == null) {
            return false;
        }
        this.kazeron = Global.getSector().getEconomy().getMarket("kazeron");
        if (this.kazeron == null) {
            return false;
        }
        this.chicomoztoc = Global.getSector().getEconomy().getMarket("chicomoztoc");
        if (this.chicomoztoc == null) {
            return false;
        }
        this.kantasDen = Global.getSector().getEconomy().getMarket("kantas_den");
        if (this.kantasDen == null) {
            return false;
        }
        this.kantasDenStationCommander = this.getPersonAtMarketPost(this.kantasDen, Ranks.POST_STATION_COMMANDER);
        if (this.kantasDenStationCommander == null) {
            return false;
        }
        this.epiphany = Global.getSector().getEconomy().getMarket("epiphany");
        if (this.epiphany == null) {
            return false;
        }
        StarSystemAPI magec = this.kantasDen.getStarSystem();
        Iterator<CustomCampaignEntityAPI> iterator = magec.getCustomEntitiesWithTag("gate").iterator();
        if (iterator.hasNext()) {
            SectorEntityToken curr;
            this.magecGate = curr = (SectorEntityToken)iterator.next();
        }
        if (this.magecGate == null) {
            return false;
        }
        StarSystemAPI galatia = Global.getSector().getStarSystem("galatia");
        Iterator<CustomCampaignEntityAPI> iterator2 = galatia.getCustomEntitiesWithTag("gate").iterator();
        if (iterator2.hasNext()) {
            SectorEntityToken curr;
            this.galatiaGate = curr = (SectorEntityToken)iterator2.next();
        }
        if (this.galatiaGate == null) {
            return false;
        }
        this.setName("At The Gates");
        this.setRepFactionChangesNone();
        this.setRepPersonChangesNone();
        this.beginStageTrigger(new Object[]{Stage.TALK_TO_HEGEMON});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.HIGHER, "persean", "patrolMedium", this.kazeron.getStarSystem());
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerMakeNonHostile();
        this.triggerMakeFleetIgnoreOtherFleetsExceptPlayer();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerFleetMakeFaster(true, 1, true);
        this.triggerPickLocationAroundEntity(this.kazeron.getStarSystem().getHyperspaceAnchor(), 250.0f);
        this.triggerSpawnFleetAtPickedLocation("$gaATG_siyavongFleet", null);
        this.triggerSetFleetMissionRef("$gaATG_ref");
        this.triggerOrderFleetInterceptPlayer();
        this.triggerOrderFleetEBurn(1.0f);
        this.triggerFleetMakeImportant(null, Stage.TALK_TO_HEGEMON);
        this.endTrigger();
        List<SectorEntityToken> jumpPoints = this.magecGate.getStarSystem().getJumpPoints();
        for (SectorEntityToken point : jumpPoints) {
            this.spawnKantaVengeanceFleetPirateScout(point);
            this.spawnKantaVengeanceFleetPirateScout(point);
            this.spawnKantaVengeanceFleetPirateArmada(point);
            this.spawnKantaVengeanceFleetMerc(point);
        }
        this.spawnKantaVengeanceFleetPirateArmada(this.kantasDen.getPrimaryEntity());
        this.scanEncounterVariations = new ArrayList<ScanEncounterVariation>(Arrays.asList(ScanEncounterVariation.values()));
        this.ttScanCost = this.genRoundNumber(20000, 30000);
        this.pirateScanCost = this.genRoundNumber(10000, 20000);
        this.coureuseCredits = this.genRoundNumber(10000, 20000);
        this.setStoryMission();
        this.setStartingStage((Object)Stage.TALK_TO_COUREUSE);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.makeImportant(this.coureuse, null, Stage.TALK_TO_COUREUSE);
        this.makeImportant(this.horus_yaribay, null, Stage.TALK_TO_YARIBAY);
        this.makeImportant(this.daud, null, Stage.TALK_TO_HEGEMON);
        this.makeImportant(this.chicomoztoc, null, Stage.MEET_DAUD);
        this.makeImportant(this.baird, null, Stage.RETURN_WITH_DEAL_AND_SCANS);
        this.makeImportant(this.baird, null, Stage.FIRST_JANUS_RESULTS);
        this.makeImportant(this.coureuse, null, Stage.COUREUSE_MISSION);
        this.makeImportant(this.kantasDen, "$gaATG_talkToKanta", Stage.TALK_TO_KANTA);
        this.makeImportant(this.epiphany, "$gaATG_findingLoke", Stage.FINDING_LOKE);
        this.makeImportant(this.kanta.getMarket(), null, Stage.RETURN_TO_KANTA);
        this.makeImportant(this.magecGate, null, Stage.GO_TO_MAGEC_GATE);
        this.makeImportant(this.baird.getMarket(), null, Stage.ZAL_TO_GALATIA);
        this.connectWithGlobalFlag((Object)Stage.TALK_TO_COUREUSE, (Object)Stage.TALK_TO_YARIBAY, "$gaATG_goTalkToYaribay");
        this.connectWithGlobalFlag((Object)Stage.TALK_TO_YARIBAY, (Object)Stage.TALK_TO_HEGEMON, "$gaATG_goTalkToDaud");
        this.connectWithGlobalFlag((Object)Stage.TALK_TO_HEGEMON, (Object)Stage.MEET_DAUD, "$gaATG_goToDaudMeeting");
        this.connectWithGlobalFlag((Object)Stage.MEET_DAUD, (Object)Stage.DO_SCANS, "$gaATG_gotDaudDeal");
        this.connectWithGlobalFlag((Object)Stage.DO_SCANS, (Object)Stage.RETURN_WITH_DEAL_AND_SCANS, "$gaATG_scannedSixGates");
        this.setStageOnGlobalFlag((Object)Stage.FIRST_JANUS_EXPERIMENT, "$gaATG_useJanusPrototype");
        this.setStageOnGlobalFlag((Object)Stage.FIRST_JANUS_RESULTS, "$gaATG_firstJanusResults");
        this.setStageOnGlobalFlag((Object)Stage.COUREUSE_MISSION, "$gaATG_getMissionFromCoureuse");
        this.setStageOnGlobalFlag((Object)Stage.TALK_TO_KANTA, "$gaATG_gotKantaToken");
        this.setStageOnGlobalFlag((Object)Stage.FINDING_LOKE, "$gaATG_findingLoke");
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_KANTA, "$gaATG_foundLoke");
        this.setStageOnGlobalFlag((Object)Stage.GO_TO_MAGEC_GATE, "$gaATG_foundZal");
        this.connectWithEnteredLocation((Object)Stage.GO_TO_MAGEC_GATE, (Object)Stage.ZAL_TO_GALATIA, galatia);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaATG_completed");
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$gaATG_missionCompleted", true);
        this.triggerMakeNonStoryCritical(this.kazeron, this.chicomoztoc, this.epiphany, this.siyavong.getMarket(), this.kanta.getMarket());
        this.endTrigger();
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("scannedGateForCoureuse".equals(action)) {
            this.sendUpdate(SHOW_GATE_SCAN_COUNT, dialog.getTextPanel());
            return true;
        }
        if ("setGalatiaGateScanned".equals(action)) {
            this.galatiaGate.getMemoryWithoutUpdate().set(GateEntityPlugin.GATE_SCANNED, true);
            GateCMD.notifyScanned(this.galatiaGate);
            return true;
        }
        if ("clearedHegemonyGate".equals(action)) {
            this.encounterGateHegemony.getMemoryWithoutUpdate().unset("$GAATGhegemonyScanFleet");
            return true;
        }
        if ("clearedHegemonyGateSendScans".equals(action)) {
            this.encounterGateHegemony.getMemoryWithoutUpdate().set("$GAATGhegSendScan", true);
            this.encounterGateHegemony.getMemoryWithoutUpdate().unset("$GAATGhegemonyScanFleet");
            this.encounterHegemonyFleet.getMemoryWithoutUpdate().unset("$youDoTheScan");
            this.encounterHegemonyFleet.getMemoryWithoutUpdate().set("$youDidTheScan", true);
            return true;
        }
        if ("sentHegemonyScan".equals(action)) {
            this.encounterHegemonyFleet.getMemoryWithoutUpdate().set("$ignorePlayerCommRequests", true);
            return true;
        }
        if ("clearedLuddicGate".equals(action)) {
            this.encounterGateLuddic.getMemoryWithoutUpdate().unset("$GAATGluddicScanGate");
            return true;
        }
        if ("luddicGateFleetMoveAway".equals(action)) {
            this.encounterGateLuddic.getMemoryWithoutUpdate().unset("$GAATGluddicScanGate");
            this.encounterGateLuddic.getMemoryWithoutUpdate().set("$GAATGluddicPostScan", true);
            this.encounterLuddicFleet.getMemoryWithoutUpdate().set("$cfai_avoidPlayerSlowly", true);
            this.encounterLuddicFleet.getMemoryWithoutUpdate().set("$ignorePlayerCommRequests", true);
            return true;
        }
        if ("luddicGateFleetMoveBack".equals(action)) {
            this.encounterLuddicFleet.getMemoryWithoutUpdate().unset("$cfai_avoidPlayerSlowly");
            this.encounterLuddicFleet.getMemoryWithoutUpdate().unset("$ignorePlayerCommRequests");
            this.encounterLuddicFleet.getMemoryWithoutUpdate().set("$resumedVigil", true);
            return true;
        }
        if ("boughtTTscan".equals(action)) {
            this.encounterGateTT.getMemoryWithoutUpdate().unset("$GAATGttScanGate");
            this.encounterGateTT.getMemoryWithoutUpdate().set(GateEntityPlugin.GATE_SCANNED, true);
            GateCMD.notifyScanned(this.encounterGateTT);
            this.sendUpdate(SHOW_GATE_SCAN_COUNT, dialog.getTextPanel());
            return true;
        }
        if ("clearedTTGate".equals(action)) {
            this.encounterGateTT.getMemoryWithoutUpdate().unset("$GAATGttScanGate");
            return true;
        }
        if ("clearedPirateGate".equals(action)) {
            this.encounterGatePirate.getMemoryWithoutUpdate().unset("$GAATGpirateScanGate");
            this.encounterPirateFleet.getMemoryWithoutUpdate().unset("$gaATG_pirateScanFleet");
            return true;
        }
        if ("doZalEscape".equals(action)) {
            Global.getSector().layInCourseFor(this.magecGate);
            this.galatiaGate.getMemoryWithoutUpdate().set(GateEntityPlugin.GATE_SCANNED, true);
            return true;
        }
        if ("giveJanusDevice".equals(action)) {
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            cargo.addSpecial(new SpecialItemData("janus", null), 1.0f);
            CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("janus", null), null);
            AddRemoveCommodity.addStackGainText(stack, dialog.getTextPanel());
            return true;
        }
        if ("endMissionCleanup".equals(action)) {
            this.epiphany.getMemoryWithoutUpdate().unset("$askedForKidnapperCotton");
            this.epiphany.getMemoryWithoutUpdate().unset("$offeredBribeForCotton");
            this.epiphany.getMemoryWithoutUpdate().unset("$setUpCottonMeeting");
            this.epiphany.getMemoryWithoutUpdate().unset("$askedBarCotton");
            this.epiphany.getMemoryWithoutUpdate().unset("$setUpCottonMeeting");
            return true;
        }
        if ("zalCommHack".equals(action)) {
            TextPanelAPI text = dialog.getTextPanel();
            text.setFontVictor();
            Color red = Misc.getNegativeHighlightColor();
            text.addParagraph("COMM FEED 0 INTERRUPTED \nCOMM FEED 1 INTERRUPTED", red);
            text.setFontInsignia();
            return true;
        }
        if ("zalMinesHack".equals(action)) {
            Global.getSoundPlayer().playSound("hit_heavy", 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
            return true;
        }
        if ("giveJanusDevice".equals(action)) {
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            cargo.addSpecial(new SpecialItemData("janus", null), 1.0f);
            CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("janus", null), null);
            AddRemoveCommodity.addStackGainText(stack, dialog.getTextPanel());
            return true;
        }
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaATG_stage", this.getCurrentStage());
        this.set("$gaATG_gatesScanned", GateEntityPlugin.getNumGatesScanned());
        this.set("$gaATG_ttScanCost", Misc.getWithDGS(this.ttScanCost));
        this.set("$gaATG_pirateScanCost", Misc.getWithDGS(this.pirateScanCost));
        this.set("$gaATG_coureuseCredits", Misc.getWithDGS(this.coureuseCredits));
        this.set("$gaATG_kantaRaidDifficulty", Float.valueOf(KANTA_RAID_DIFFICULTY));
        this.set("$gaATG_cottonRaidDifficulty", Float.valueOf(COTTON_RAID_DIFFICULTY));
        this.set("$kantasDenStationCommander", this.kantasDenStationCommander.getId());
    }

    @Override
    public void advance(float amount) {
        int scanned;
        super.advance(amount);
        if (!(this.currentStage != Stage.TALK_TO_COUREUSE && this.currentStage != Stage.TALK_TO_YARIBAY && this.currentStage != Stage.TALK_TO_HEGEMON && this.currentStage != Stage.DO_SCANS || (scanned = GateEntityPlugin.getNumGatesScanned()) < 6 || Global.getSector().getMemoryWithoutUpdate().contains("$gaATG_scannedSixGates"))) {
            Global.getSector().getMemoryWithoutUpdate().set("$gaATG_scannedSixGates", true);
            this.checkStageChangesAndTriggers(null, null);
        }
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TALK_TO_COUREUSE || this.currentStage == Stage.TALK_TO_YARIBAY) {
            info.addPara("Contact Horus Yaribay to get envoy credentials so you can contact High Hegemon Daud.", opad);
            this.addStandardMarketDesc("Gens Yaribay is based " + this.kazeron.getOnOrAt(), this.kazeron, info, opad);
        } else if (this.currentStage == Stage.TALK_TO_HEGEMON) {
            info.addPara("Set up a private meeting with High Hegemon Baikal Daud and get him to accept the deal with Provost Baird.", opad);
            info.addPara("Optional: provide Daud with encrypted Yaribay comm codes.", opad);
            this.addStandardMarketDesc("The High Hegemon's office is based " + this.chicomoztoc.getOnOrAt(), this.chicomoztoc, info, opad);
        } else if (this.currentStage == Stage.MEET_DAUD) {
            info.addPara("Meet with High Hegemon Baikal Daud on a shipyard orbiting Chicomoztoc.", opad);
            info.addPara("Optional: provide Daud with encrypted Yaribay comm codes.", opad);
            this.addStandardMarketDesc("The High Hegemon's office is based " + this.chicomoztoc.getOnOrAt(), this.chicomoztoc, info, opad);
        } else if (this.currentStage != Stage.MEET_DAUD && this.currentStage == Stage.RETURN_WITH_DEAL_AND_SCANS) {
            info.addPara("You've arranged a deal between High Hegemon Daud and Provost Baird which allows the Galatia Academy to resume overt research on Gate technology.", opad);
        }
        if (this.currentStage == Stage.TALK_TO_COUREUSE) {
            info.addPara("Get the Gate scanning instrument from Academician Coureuse.", opad);
        } else if (this.currentStage == Stage.TALK_TO_COUREUSE || this.currentStage == Stage.TALK_TO_YARIBAY || this.currentStage == Stage.TALK_TO_HEGEMON || this.currentStage == Stage.DO_SCANS && GateEntityPlugin.getNumGatesScanned() < 6) {
            info.addPara("Scan six Gates with the instruments provided by Academician Coureuse.", opad);
            this.bullet(info);
            info.addPara("%s Gates scanned", opad, Misc.getHighlightColor(), GateEntityPlugin.getNumGatesScanned() + " / 6");
            this.unindent(info);
        }
        if (this.currentStage == Stage.RETURN_WITH_DEAL_AND_SCANS) {
            info.addPara("Return to the Galatia Academy with the six completed Gate scans.", opad);
        } else if (this.currentStage == Stage.FIRST_JANUS_EXPERIMENT) {
            info.addPara("Use the prototype Janus Device on a Gate in an uninhabited system outside of the Core worlds.", opad);
        } else if (this.currentStage == Stage.FIRST_JANUS_RESULTS) {
            info.addPara("Return to the Galatia Academy to report the results of the first Janus Prototype experiment.", opad);
        } else if (this.currentStage == Stage.COUREUSE_MISSION) {
            info.addPara("Contact Academician Scylla Coureuse about what she needs you to do.", opad);
        } else if (this.currentStage == Stage.TALK_TO_KANTA) {
            info.addPara("Use Gargoyle's token to arrange a meeting with Warlord Kanta in the Magec system - or find some other way to extract Zal.", opad);
        } else if (this.currentStage == Stage.FINDING_LOKE) {
            info.addPara("Find and extract the clone of Loke from the Pather kidnappers.", opad);
        } else if (this.currentStage == Stage.RETURN_TO_KANTA) {
            info.addPara("Return Clone Loke to Warlord Kanta.", opad);
        } else if (this.currentStage == Stage.GO_TO_MAGEC_GATE) {
            info.addPara("Go to the Magec Gate.", opad);
        } else if (this.currentStage == Stage.ZAL_TO_GALATIA) {
            info.addPara("Return to the Galatia Academy with Elissa Zal and the working Janus Device.", opad);
        }
    }

    @Override
    protected boolean shouldSendUpdateForStage(Object id) {
        if (this.getCurrentStage() == Stage.DO_SCANS && GateEntityPlugin.getNumGatesScanned() >= 6) {
            return false;
        }
        return super.shouldSendUpdateForStage(id);
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.getListInfoParam() == SHOW_GATE_SCAN_COUNT) {
            info.addPara("%s Gates scanned", pad, tc, Misc.getHighlightColor(), GateEntityPlugin.getNumGatesScanned() + " / 6");
            return true;
        }
        if (this.currentStage == Stage.TALK_TO_COUREUSE) {
            info.addPara("Get the Gate scanning device from Scylla Coureuse", tc, pad);
            pad = 0.0f;
        }
        if (this.currentStage == Stage.TALK_TO_COUREUSE || this.currentStage == Stage.TALK_TO_YARIBAY) {
            info.addPara("Contact Horus Yaribay on Kazeron to get envoy credentials", tc, pad);
            pad = 0.0f;
        } else if (this.currentStage == Stage.TALK_TO_HEGEMON) {
            info.addPara("Horus Yaribay has provided you with official envoy credentials to set up a private meeting with High Hegemon Baikal Daud", tc, pad);
            pad = 0.0f;
        } else if (this.currentStage == Stage.MEET_DAUD) {
            info.addPara("Meet with the High Hegemon in Chicomoztoc orbit and secure Baird's deal", tc, pad);
            pad = 0.0f;
        } else if (this.currentStage == Stage.RETURN_WITH_DEAL_AND_SCANS) {
            info.addPara("Return to Provost Baird at the Galatia Academy with news of the deal made with High Hegemon Daud", tc, pad);
            pad = 0.0f;
        }
        if ((this.currentStage == Stage.TALK_TO_YARIBAY || this.currentStage == Stage.TALK_TO_HEGEMON || this.currentStage == Stage.MEET_DAUD || this.currentStage == Stage.DO_SCANS) && GateEntityPlugin.getNumGatesScanned() < 6) {
            info.addPara("Scan six Gates with the instruments provided by Academician Coureuse", tc, pad);
            pad = 0.0f;
        }
        if (this.currentStage == Stage.RETURN_WITH_DEAL_AND_SCANS) {
            info.addPara("Return to the Galatia Academy with the six completed Gate scans", tc, pad);
        } else if (this.currentStage == Stage.FIRST_JANUS_EXPERIMENT) {
            info.addPara("Use the prototype Janus Device on a Gate in an uninhabited system outside of the Core worlds", tc, pad);
        } else if (this.currentStage == Stage.FIRST_JANUS_RESULTS) {
            info.addPara("Return to the Galatia Academy to report the results of the first Janus Prototype experiment", tc, pad);
        } else if (this.currentStage == Stage.COUREUSE_MISSION) {
            info.addPara("Contact Academician Scylla Coureuse about what she needs you to do", tc, pad);
        } else if (this.currentStage == Stage.TALK_TO_KANTA) {
            info.addPara("Use Gargoyle's token to arrange a meeting with Warlord Kanta in the Magec system - or find some other way to extract Zal", tc, pad);
        } else if (this.currentStage == Stage.FINDING_LOKE) {
            info.addPara("Find and extract the clone of Loke from the Pather kidnappers", tc, pad);
        } else if (this.currentStage == Stage.RETURN_TO_KANTA) {
            info.addPara("Return Clone Loke to Warlord Kanta", tc, pad);
        } else if (this.currentStage == Stage.GO_TO_MAGEC_GATE) {
            info.addPara("Go to the Magec Gate", tc, pad);
        } else if (this.currentStage == Stage.ZAL_TO_GALATIA) {
            info.addPara("Return to the Galatia Academy with Elissa Zal and the working Janus Device", tc, pad);
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "At The Gates";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.acceptImpl(dialog, memoryMap);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected void notifyEnding() {
        Global.getSector().getListenerManager().removeListener(this);
        super.notifyEnding();
    }

    public ScanEncounterVariation pickGateEvent() {
        WeightedRandomPicker<ScanEncounterVariation> picker = new WeightedRandomPicker<ScanEncounterVariation>(this.genRandom);
        for (ScanEncounterVariation event : this.scanEncounterVariations) {
            picker.add(event, 1.0f);
        }
        return (ScanEncounterVariation)((Object)picker.pick());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportCurrentLocationChanged(LocationAPI prev, LocationAPI currLoc) {
        CampaignFleetAPI fleet;
        List<CampaignFleetAPI> fleets;
        void var5_15;
        void var5_13;
        if (this.getCurrentStage() == null) {
            return;
        }
        if (((Enum)this.getCurrentStage()).ordinal() >= Stage.RETURN_WITH_DEAL_AND_SCANS.ordinal()) {
            return;
        }
        if (((Enum)this.getCurrentStage()).ordinal() < Stage.TALK_TO_YARIBAY.ordinal()) {
            return;
        }
        if (!(currLoc instanceof StarSystemAPI)) {
            return;
        }
        if (this.scanEncounterVariations.isEmpty()) {
            return;
        }
        StarSystemAPI system = (StarSystemAPI)currLoc;
        if (system.getMemoryWithoutUpdate().getBoolean(CHECKED_FOR_ENCOUNTER)) {
            return;
        }
        system.getMemoryWithoutUpdate().set(CHECKED_FOR_ENCOUNTER, true);
        if (system.hasTag("theme_unsafe")) {
            return;
        }
        if (Misc.hasPulsar(system)) {
            return;
        }
        SectorEntityToken gate = null;
        for (SectorEntityToken sectorEntityToken : system.getCustomEntitiesWithTag("gate")) {
            if (GateEntityPlugin.isScanned(sectorEntityToken) || GateEntityPlugin.isActive(sectorEntityToken)) continue;
            gate = sectorEntityToken;
            break;
        }
        if (gate == null) {
            return;
        }
        if (this.rollProbability(SYSTEM_NO_GATE_ENCOUNTER_CHANCE)) {
            return;
        }
        Object var5_7 = null;
        for (MarketAPI market : Global.getSector().getEconomy().getMarkets(system)) {
            if (this.scanEncounterVariations.contains((Object)ScanEncounterVariation.HEGEMONY) && market.getFactionId().equals("hegemony") && this.rollProbability(FACTION_GATE_ENCOUNTER_CHANCE)) {
                ScanEncounterVariation scanEncounterVariation = ScanEncounterVariation.HEGEMONY;
                break;
            }
            if (this.scanEncounterVariations.contains((Object)ScanEncounterVariation.TRITACHYON) && market.getFactionId().equals("tritachyon") && this.rollProbability(FACTION_GATE_ENCOUNTER_CHANCE)) {
                ScanEncounterVariation scanEncounterVariation = ScanEncounterVariation.TRITACHYON;
                break;
            }
            if (this.scanEncounterVariations.contains((Object)ScanEncounterVariation.LUDDIC) && market.getFactionId().equals("luddic_church") && this.rollProbability(FACTION_GATE_ENCOUNTER_CHANCE)) {
                ScanEncounterVariation scanEncounterVariation = ScanEncounterVariation.LUDDIC;
                break;
            }
            if (this.scanEncounterVariations.contains((Object)ScanEncounterVariation.LUDDIC) && market.getFactionId().equals("luddic_church") && this.rollProbability(FACTION_GATE_ENCOUNTER_CHANCE)) {
                ScanEncounterVariation scanEncounterVariation = ScanEncounterVariation.LUDDIC;
                break;
            }
            if (!this.scanEncounterVariations.contains((Object)ScanEncounterVariation.PIRATE) || !market.getFactionId().equals("pirates") || !this.rollProbability(FACTION_GATE_ENCOUNTER_CHANCE)) continue;
            ScanEncounterVariation scanEncounterVariation = ScanEncounterVariation.PIRATE;
            break;
        }
        if (var5_13 == null) {
            ScanEncounterVariation scanEncounterVariation = this.pickGateEvent();
        }
        if (var5_15 == null) {
            return;
        }
        this.scanEncounterVariations.remove(var5_15);
        if (var5_15 == ScanEncounterVariation.DERELICT) {
            DerelictShipEntityPlugin.DerelictShipData params = new DerelictShipEntityPlugin.DerelictShipData(new ShipRecoverySpecial.PerShipData("apogee_Balanced", ShipRecoverySpecial.ShipCondition.BATTERED, 0.0f), false);
            SectorEntityToken ship = BaseThemeGenerator.addSalvageEntity(system, "wreck", "neutral", params);
            ship.setDiscoverable(true);
            ship.setCircularOrbit(gate, (float)Math.random() * 360.0f, 40.0f, 20.0f);
            SalvageSpecialAssigner.ShipRecoverySpecialCreator creator = new SalvageSpecialAssigner.ShipRecoverySpecialCreator(null, 0, 0, false, null, null);
            Misc.setSalvageSpecial(ship, creator.createSpecial(ship, null));
            ship.getMemoryWithoutUpdate().set("$gateScanDerelict", true);
        } else if (var5_15 == ScanEncounterVariation.HEGEMONY) {
            this.beginStageTrigger(this.getCurrentStage());
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.HIGHER, "hegemony", "patrolMedium", gate);
            this.triggerMakeNonHostile();
            this.triggerPickLocationAroundEntity(gate, 100.0f);
            this.triggerSpawnFleetAtPickedLocation("$gaATG_hegScanFleet", null);
            this.triggerFleetSetPatrolActionText("scanning");
            this.triggerFleetSetTravelActionText("repositioning");
            this.triggerOrderFleetPatrol(true, gate);
            this.triggerMakeFleetIgnoreOtherFleets();
            this.triggerMakeFleetGoAwayAfterDefeat();
            this.triggerFleetSetPatrolLeashRange(100.0f);
            this.triggerSetFleetMissionRef("$gaATG_ref");
            this.triggerFleetAddDefeatTrigger("GAATGhegGateScanFleetDefeated");
            this.triggerFleetSetName("Special Task Force");
            this.endTrigger();
            fleets = this.runStageTriggersReturnFleets(this.getCurrentStage());
            if (fleets.isEmpty()) {
                return;
            }
            fleet = fleets.get(0);
            fleet.addEventListener(new BaseFleetEventListener(){

                public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
                    if (reason == CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE) {
                        fleet.getMemoryWithoutUpdate().unset("$gaATG_hegScanFleet");
                        GAAtTheGates.this.encounterGateHegemony.getMemoryWithoutUpdate().unset("$GAATGhegemonyScanFleet");
                    }
                }
            });
            this.encounterHegemonyFleet = fleets.get(0);
            this.encounterGateHegemony = gate;
            this.setFlag(gate, "$GAATGhegemonyScanFleet", true);
        } else if (var5_15 == ScanEncounterVariation.JAMMER) {
            this.setFlag(gate, "$GAATGscanJammer", true);
        } else if (var5_15 == ScanEncounterVariation.ALARM) {
            this.setFlag(gate, "$GAATGscanAlarm", true);
        } else if (var5_15 == ScanEncounterVariation.LUDDIC) {
            this.beginStageTrigger(this.getCurrentStage());
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.LOWER, "luddic_church", "tradeLiner", gate);
            this.triggerMakeNonHostile();
            this.triggerSetFleetSizeFraction(0.5f);
            this.triggerSetFleetComposition(2.0f, 1.0f, 1.0f, 10.0f, 1.0f);
            this.triggerPickLocationAroundEntity(gate, 50.0f);
            this.triggerSpawnFleetAtPickedLocation("$gaATG_luddicScanFleet", null);
            this.triggerFleetSetTravelActionText("holding vigil");
            this.triggerFleetSetPatrolActionText("holding vigil");
            this.triggerOrderFleetPatrol(true, gate);
            this.triggerMakeFleetIgnoreOtherFleets();
            this.triggerMakeFleetGoAwayAfterDefeat();
            this.triggerFleetSetPatrolLeashRange(30.0f);
            this.triggerSetFleetMissionRef("$gaATG_ref");
            this.triggerFleetAddDefeatTrigger("GAATGluddicScanFleetDefeated");
            this.triggerFleetSetName("Sacred Vigil Flotilla");
            this.endTrigger();
            fleets = this.runStageTriggersReturnFleets(this.getCurrentStage());
            if (fleets.isEmpty()) {
                return;
            }
            this.encounterLuddicFleet = fleet = fleets.get(0);
            this.encounterGateLuddic = gate;
            this.setFlag(gate, "$GAATGluddicScanGate", true);
            fleet.addEventListener(new BaseFleetEventListener(){

                public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
                    if (reason == CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE) {
                        fleet.getMemoryWithoutUpdate().unset("$gaATG_luddicScanFleet");
                        GAAtTheGates.this.encounterGateLuddic.getMemoryWithoutUpdate().unset("$GAATGluddicScanGate");
                    }
                }
            });
        } else if (var5_15 == ScanEncounterVariation.PATHER) {
            this.beginStageTrigger(this.getCurrentStage());
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.HIGHER, "luddic_path", "mercPrivateer", gate);
            this.triggerFleetPatherNoDefaultTithe();
            this.triggerPickLocationAroundEntity(gate, 200.0f);
            this.triggerSpawnFleetAtPickedLocation("$gaATG_patherScanFleet", null);
            this.triggerOrderFleetPatrol(true, gate);
            this.triggerMakeFleetGoAwayAfterDefeat();
            this.triggerFleetSetPatrolLeashRange(60.0f);
            this.triggerSetFleetMissionRef("$gaATG_ref");
            this.triggerFleetSetName("Ambush Fleet");
            this.endTrigger();
        } else if (var5_15 == ScanEncounterVariation.PIRATE) {
            this.beginStageTrigger(this.getCurrentStage());
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "pirates", "patrolLarge", gate);
            this.triggerMakeNonHostile();
            this.triggerMakeLowRepImpact();
            this.triggerPickLocationAroundEntity(gate, 250.0f);
            this.triggerSpawnFleetAtPickedLocation("$gaATG_pirateScanFleet", null);
            this.triggerFleetSetPatrolActionText("loitering");
            this.triggerFleetSetTravelActionText("maneuvering");
            this.triggerOrderFleetPatrol(true, gate);
            this.triggerFleetSetPatrolLeashRange(250.0f);
            this.triggerSetFleetMissionRef("$gaATG_ref");
            this.triggerFleetAddDefeatTrigger("GAATGpirateScanFleetDefeated");
            this.triggerMakeFleetGoAwayAfterDefeat();
            this.endTrigger();
            fleets = this.runStageTriggersReturnFleets(this.getCurrentStage());
            if (fleets.isEmpty()) {
                return;
            }
            fleet = fleets.get(0);
            fleet.addEventListener(new BaseFleetEventListener(){

                public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
                    if (reason == CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE) {
                        fleet.getMemoryWithoutUpdate().unset("$gaATG_pirateScanFleet");
                        GAAtTheGates.this.encounterGatePirate.getMemoryWithoutUpdate().unset("$GAATGpirateScanGate");
                    }
                }
            });
            this.encounterGatePirate = gate;
            this.encounterPirateFleet = fleet;
            this.setFlag(gate, "$GAATGpirateScanGate", true);
        } else if (var5_15 == ScanEncounterVariation.SCAVENGER) {
            this.beginStageTrigger(this.getCurrentStage());
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.DEFAULT, "independent", "scavengerMedium", gate);
            this.triggerMakeNonHostile();
            this.triggerMakeLowRepImpact();
            this.triggerPickLocationAroundEntity(gate, 100.0f);
            this.triggerSpawnFleetAtPickedLocation("$gaATG_scavScanFleet", null);
            this.triggerFleetSetPatrolActionText("observing");
            this.triggerFleetSetTravelActionText("observing");
            this.triggerOrderFleetPatrol(true, gate);
            this.triggerMakeFleetIgnoreOtherFleets();
            this.triggerFleetSetPatrolLeashRange(250.0f);
            this.triggerMakeFleetIgnoredByOtherFleets();
            this.triggerSetFleetMissionRef("$gaATG_ref");
            this.triggerFleetSetName("Suspect Scavenger");
            this.triggerMakeFleetGoAwayAfterDefeat();
            this.endTrigger();
            fleets = this.runStageTriggersReturnFleets(this.getCurrentStage());
            if (fleets.isEmpty()) {
                return;
            }
        } else if (var5_15 == ScanEncounterVariation.TRITACHYON) {
            this.beginStageTrigger(this.getCurrentStage());
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.HIGHER, "tritachyon", "patrolLarge", gate);
            this.triggerMakeNonHostile();
            this.triggerPickLocationAroundEntity(gate, 100.0f);
            this.triggerSpawnFleetAtPickedLocation("$gaATG_ttScanFleet", null);
            this.triggerFleetSetTravelActionText("repositioning");
            this.triggerFleetSetPatrolActionText("scanning");
            this.triggerOrderFleetPatrol(true, gate);
            this.triggerMakeFleetIgnoreOtherFleets();
            this.triggerMakeFleetGoAwayAfterDefeat();
            this.triggerFleetSetPatrolLeashRange(100.0f);
            this.triggerSetFleetMissionRef("$gaATG_ref");
            this.triggerFleetAddDefeatTrigger("GAATGttGateScanFleetDefeated");
            this.triggerFleetSetName("Special Projects Detachment");
            this.endTrigger();
            fleets = this.runStageTriggersReturnFleets(this.getCurrentStage());
            if (fleets.isEmpty()) {
                return;
            }
            fleet = fleets.get(0);
            fleet.addEventListener(new BaseFleetEventListener(){

                public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
                    if (reason == CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE) {
                        fleet.getMemoryWithoutUpdate().unset("$gaATG_ttScanFleet");
                        GAAtTheGates.this.encounterGateTT.getMemoryWithoutUpdate().unset("$GAATGttScanGate");
                    }
                }
            });
            this.encounterGateTT = gate;
            this.setFlag(gate, "$GAATGttScanGate", true);
        } else {
            return;
        }
    }

    protected void spawnKantaVengeanceFleetPirateArmada(SectorEntityToken spawnPoint) {
        this.beginWithinHyperspaceRangeTrigger(this.magecGate, 3.0f, false, new Object[]{Stage.GO_TO_MAGEC_GATE});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.HUGE, HubMissionWithTriggers.FleetQuality.HIGHER, "pirates", "patrolLarge", spawnPoint);
        this.triggerSetFleetFaction("pirates");
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerAutoAdjustFleetStrengthMajor();
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeNoRepImpact();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerPickLocationAroundEntity(spawnPoint, 100.0f);
        this.triggerSetFleetMissionRef("$gaATG_ref");
        this.triggerSpawnFleetAtPickedLocation("$gaATG_kantaVengeanceFleet", null);
        this.triggerOrderFleetInterceptPlayer();
        this.endTrigger();
    }

    protected void spawnKantaVengeanceFleetPirateScout(SectorEntityToken spawnPoint) {
        this.beginWithinHyperspaceRangeTrigger(this.magecGate, 3.0f, false, new Object[]{Stage.GO_TO_MAGEC_GATE});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.HIGHER, "pirates", "patrolSmall", spawnPoint);
        this.triggerSetFleetFaction("pirates");
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.DEFAULT);
        this.triggerAutoAdjustFleetStrengthMajor();
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeNoRepImpact();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerFleetMakeFaster(true, 0, true);
        this.triggerPickLocationAroundEntity(spawnPoint, 100.0f);
        this.triggerSetFleetMissionRef("$gaATG_ref");
        this.triggerSpawnFleetAtPickedLocation("$gaATG_kantaVengeanceFleet", null);
        this.triggerOrderFleetInterceptPlayer();
        this.endTrigger();
    }

    protected void spawnKantaVengeanceFleetMerc(SectorEntityToken spawnPoint) {
        this.beginWithinHyperspaceRangeTrigger(this.magecGate, 3.0f, false, new Object[]{Stage.GO_TO_MAGEC_GATE});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "mercArmada", spawnPoint);
        this.triggerSetFleetFaction("pirates");
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerAutoAdjustFleetStrengthMajor();
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeNoRepImpact();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerFleetMakeFaster(true, 1, true);
        this.triggerPickLocationAroundEntity(spawnPoint, 100.0f);
        this.triggerSetFleetMissionRef("$gaATG_ref");
        this.triggerSpawnFleetAtPickedLocation("$gaATG_kantaVengeanceFleet", null);
        this.triggerOrderFleetInterceptPlayer();
        this.endTrigger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScanEncounterVariation {
        HEGEMONY,
        TRITACHYON,
        LUDDIC,
        PIRATE,
        DERELICT,
        JAMMER,
        SCAVENGER,
        PATHER,
        ALARM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        TALK_TO_COUREUSE,
        TALK_TO_YARIBAY,
        TALK_TO_HEGEMON,
        MEET_DAUD,
        DO_SCANS,
        RETURN_WITH_DEAL_AND_SCANS,
        FIRST_JANUS_EXPERIMENT,
        FIRST_JANUS_RESULTS,
        COUREUSE_MISSION,
        TALK_TO_KANTA,
        FINDING_LOKE,
        RETURN_TO_KANTA,
        GO_TO_MAGEC_GATE,
        ZAL_TO_GALATIA,
        COMPLETED;

    }
}

