/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.ImportantPeopleAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GADeliverVIP
extends GABaseMission {
    public static float MISSION_DAYS = 60.0f;
    public static float PROB_KANTA = 0.1f;
    public static float PROB_MERC_KIDNAPPER = 0.5f;
    public static float PROB_PIRATE_KIDNAPPER = 0.5f;
    public static float SPECIFIC_FACTION_SUBJECT_EVENT_LIKELIHOOD = 2.0f;
    public static FactionData ALL_FACTIONS;
    public static Map<String, FactionData> FACTION_DATA;
    public static List<String> ALLOWED_FACTIONS;
    public static List<String> MERC_FACTIONS;
    protected StarSystemAPI system;
    protected MarketAPI destination;
    protected Variation variation;
    protected FactionAPI faction;
    protected String theMercFaction;
    protected String mercFactionId;
    protected String subjectRelation;
    protected String event;
    protected PersonAPI target;
    protected String kantaRelationFirstName;
    protected int piratePayment;
    protected int mercPayment;

    static {
        FACTION_DATA = new HashMap<String, FactionData>();
        ALLOWED_FACTIONS = new ArrayList<String>();
        MERC_FACTIONS = new ArrayList<String>();
        ALLOWED_FACTIONS.add("independent");
        ALLOWED_FACTIONS.add("persean");
        ALLOWED_FACTIONS.add("tritachyon");
        ALLOWED_FACTIONS.add("hegemony");
        ALLOWED_FACTIONS.add("luddic_church");
        MERC_FACTIONS.add("tritachyon");
        MERC_FACTIONS.add("hegemony");
        MERC_FACTIONS.add("sindrian_diktat");
        MERC_FACTIONS.add("luddic_church");
        ALL_FACTIONS = new FactionData();
        GADeliverVIP.ALL_FACTIONS.subjects = new String[]{"child", "son", "daughter", "niece", "nephew", "ward"};
        GADeliverVIP.ALL_FACTIONS.events = new String[]{"a wedding", "a funeral", "a reunion", "a judicial procedure", "an operation", "a family gathering", "their legitimation"};
        FactionData luddic = new FactionData();
        FACTION_DATA.put("luddic_church", luddic);
        luddic.subjects = new String[]{"godchild", "goddaughter", "godson", "apprentice"};
        luddic.events = new String[]{"a spiritual retreat", "a penitent seclusion", "their Path-stepping", "their godnaming", "their blessing", "their contemplation", "their consecration", "their invocation", "their witnessing", "their ministration", "an ordination ceremony", "an Exodus Fast"};
        FactionData hegemony = new FactionData();
        FACTION_DATA.put("hegemony", hegemony);
        hegemony.subjects = new String[]{"unit-ward"};
        hegemony.events = new String[]{"their service induction", "cadet training", "survival school", "a warship launching", "a COMSEC interview", "a unit commemoration", "Legion remembrance day"};
        FactionData tritach = new FactionData();
        FACTION_DATA.put("tritachyon", tritach);
        tritach.subjects = new String[]{"contract-ward"};
        tritach.events = new String[]{"a cybernetic enhancement", "gene therapy", "an enrichment retreat", "a cryo-sabbatical ceremony", "a promotion celebration"};
        FactionData league = new FactionData();
        FACTION_DATA.put("persean", league);
        league.subjects = new String[]{"gensheir"};
        league.events = new String[]{"a coronation", "a premiere", "their coming-of-majority", "a landing commemoration", "a titanium jubilee", "a grand fete", "a carnival"};
        FactionData pirates = new FactionData();
        FACTION_DATA.put("pirates", pirates);
        pirates.subjects = new String[]{"clanward", "clone-variant"};
        pirates.events = new String[]{"a \"blooding\"", "their induction", "their \"making\"", "a grand castigation", "a Grand Division", "an \"unmaking\""};
    }

    public String pickSubject(String factionId) {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.genRandom);
        String[] stringArray = GADeliverVIP.ALL_FACTIONS.subjects;
        int n = GADeliverVIP.ALL_FACTIONS.subjects.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            picker.add(p, 1.0f);
            ++n2;
        }
        FactionData data = FACTION_DATA.get(factionId);
        if (data != null) {
            float w = Math.max(1.0f, (float)data.subjects.length) / Math.max(1.0f, picker.getTotal());
            w *= SPECIFIC_FACTION_SUBJECT_EVENT_LIKELIHOOD;
            String[] stringArray2 = data.subjects;
            int n3 = data.subjects.length;
            int n4 = 0;
            while (n4 < n3) {
                String p = stringArray2[n4];
                picker.add(p, w);
                ++n4;
            }
        }
        return (String)picker.pick();
    }

    public String pickEvent(String factionId) {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.genRandom);
        String[] stringArray = GADeliverVIP.ALL_FACTIONS.events;
        int n = GADeliverVIP.ALL_FACTIONS.events.length;
        int n2 = 0;
        while (n2 < n) {
            String event = stringArray[n2];
            picker.add(event, 1.0f);
            ++n2;
        }
        FactionData data = FACTION_DATA.get(factionId);
        if (data != null) {
            float w = Math.max(1.0f, (float)data.events.length) / Math.max(1.0f, picker.getTotal());
            w *= SPECIFIC_FACTION_SUBJECT_EVENT_LIKELIHOOD;
            String[] stringArray2 = data.events;
            int n3 = data.events.length;
            int n4 = 0;
            while (n4 < n3) {
                String event = stringArray2[n4];
                picker.add(event, w);
                ++n4;
            }
        }
        return (String)picker.pick();
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        ImportantPeopleAPI.PersonDataAPI pd;
        MarketAPI kantasDen;
        if (!this.setGlobalReference("$gaVIP_ref")) {
            return false;
        }
        this.requireMarketFaction(ALLOWED_FACTIONS.toArray(new String[0]));
        this.requireMarketLocationNot("galatia");
        this.requireMarketNotHidden();
        this.requireMarketNotInHyperspace();
        this.preferMarketInDirectionOfOtherMissions();
        this.destination = this.pickMarket();
        this.variation = Variation.BASIC;
        if (this.rollProbability(PROB_KANTA) && (kantasDen = Global.getSector().getEconomy().getMarket("kantas_den")) != null) {
            this.destination = kantasDen;
            this.variation = Variation.KANTA;
            this.kantaRelationFirstName = Global.getSector().getFaction("pirates").createRandomPerson(this.genRandom).getName().getFirst();
        }
        if (this.destination == null) {
            return false;
        }
        this.faction = this.destination.getFaction();
        this.subjectRelation = this.pickSubject(this.faction.getId());
        if (this.subjectRelation == null) {
            return false;
        }
        this.event = this.pickEvent(this.faction.getId());
        if (this.event == null) {
            return false;
        }
        if (this.variation == Variation.BASIC) {
            this.target = this.findOrCreatePerson(this.faction.getId(), this.destination, true, Ranks.CITIZEN, Ranks.POST_ADMINISTRATOR, Ranks.POST_BASE_COMMANDER, Ranks.POST_STATION_COMMANDER, Ranks.POST_OUTPOST_COMMANDER, Ranks.POST_PORTMASTER, Ranks.POST_FACTION_LEADER);
        } else if (this.variation == Variation.KANTA && (pd = Global.getSector().getImportantPeople().getData("kanta")) != null) {
            this.target = pd.getPerson();
        }
        if (this.target == null) {
            return false;
        }
        this.system = this.destination.getStarSystem();
        this.setStartingStage((Object)Stage.DELIVER_VIP);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.addNoPenaltyFailureStages(new Object[]{Stage.FAILED_DECIV});
        this.setGlobalFlag("$gaVIP_workingForKanta", true, new Object[]{Stage.DELIVER_VIP});
        this.makeImportant(this.destination, "$gaVIP_target", Stage.DELIVER_VIP);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaVIP_delivered");
        this.setStageOnGlobalFlag((Object)Stage.FAILED, "$gaVIP_failed");
        this.connectWithMarketDecivilized((Object)Stage.DELIVER_VIP, (Object)Stage.FAILED_DECIV, this.destination);
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        if (this.variation == Variation.BASIC) {
            this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
            this.setRepPenaltyPerson(Float.valueOf(0.07f));
            this.setRepPenaltyFaction(Float.valueOf(0.05f));
        } else {
            this.setCreditReward(BaseHubMission.CreditReward.HIGH);
            this.setRepPenaltyPerson(Float.valueOf(0.1f));
            this.setRepPenaltyFaction(Float.valueOf(0.05f));
        }
        this.setDefaultGARepRewards();
        this.piratePayment = this.genRoundNumber(40000, 60000);
        this.mercPayment = this.getCreditsReward() / 2;
        if (this.variation == Variation.BASIC && this.rollProbability(PROB_PIRATE_KIDNAPPER)) {
            this.beginWithinHyperspaceRangeTrigger(this.destination, 3.0f, false, new Object[]{Stage.DELIVER_VIP});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.HIGHER, "pirates", "patrolMedium", this.system);
            this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerSetStandardAggroPirateFlags();
            this.triggerFleetAllowLongPursuit();
            this.triggerSetFleetAlwaysPursue();
            this.triggerPickLocationTowardsPlayer(this.system.getHyperspaceAnchor(), 90.0f, GADeliverVIP.getUnits(1.5f));
            this.triggerSpawnFleetAtPickedLocation("$gaVIP_pirate", null);
            this.triggerOrderFleetInterceptPlayer();
            this.triggerFleetMakeImportant(null, Stage.DELIVER_VIP);
            this.endTrigger();
        }
        if (this.variation == Variation.KANTA && this.rollProbability(PROB_MERC_KIDNAPPER)) {
            this.mercFactionId = this.pickOne(MERC_FACTIONS.toArray(new String[0]));
            FactionAPI mercFaction = Global.getSector().getFaction(this.mercFactionId);
            this.theMercFaction = mercFaction.getDisplayNameWithArticle();
            this.beginWithinHyperspaceRangeTrigger(this.destination, 3.0f, true, new Object[]{Stage.DELIVER_VIP});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "patrolLarge", this.system);
            this.triggerSetFleetFaction("independent");
            this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerMakeHostileAndAggressive();
            this.triggerFleetMakeFaster(true, 2, true);
            this.triggerFleetAllowLongPursuit();
            this.triggerSetFleetAlwaysPursue();
            this.triggerPickLocationTowardsPlayer(this.system.getHyperspaceAnchor(), 90.0f, GADeliverVIP.getUnits(1.5f));
            this.triggerSpawnFleetAtPickedLocation("$gaVIP_merc", null);
            this.triggerOrderFleetInterceptPlayer();
            this.triggerFleetMakeImportant(null, Stage.DELIVER_VIP);
            this.endTrigger();
        }
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (action.equals("betrayal")) {
            DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
            e.setDelayMedium();
            e.setLocationInnerSector(false, "independent");
            e.beginCreate();
            e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "patrolLarge", new Vector2f());
            e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.UNUSUALLY_HIGH);
            e.triggerFleetSetFaction("independent");
            e.triggerFleetMakeFaster(true, 2, true);
            e.triggerSetFleetFlag("$gaVIP_kantaConsequences");
            e.triggerMakeNoRepImpact();
            e.triggerSetStandardAggroInterceptFlags();
            e.endCreate();
            return true;
        }
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        if (this.getCurrentStage() != null) {
            this.set("$gaVIP_stage", ((Enum)this.getCurrentStage()).name());
        }
        this.set("$gaVIP_starName", this.system.getNameWithNoType());
        this.set("$gaVIP_marketName", this.destination.getName());
        this.set("$gaVIP_systemName", this.system.getNameWithLowercaseTypeShort());
        this.set("$gaVIP_subjectRelation", this.subjectRelation);
        this.set("$gaVIP_kantaRelationFirstName", this.kantaRelationFirstName);
        this.set("$gaVIP_VIP", this.target);
        this.set("$gaVIP_VIP_faction", this.target.getFaction().getId());
        this.set("$gaVIP_VIPName", this.target.getNameString());
        this.set("$gaVIP_VIPhisOrHer", this.target.getHisOrHer());
        this.set("$gaVIP_VIPPost", this.target.getPost().toLowerCase());
        this.set("$gaVIP_event", this.event);
        this.set("$gaVIP_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaVIP_piratePayment", Misc.getWithDGS(this.piratePayment));
        this.set("$gaVIP_mercPayment", Misc.getWithDGS(this.mercPayment));
        this.set("$gaVIP_theMercFaction", this.theMercFaction);
        this.set("$gaVIP_mercFactionId", this.mercFactionId);
        this.set("$gaVIP_timeLimit", (int)MISSION_DAYS);
        this.set("$gaVIP_variation", (Object)this.variation);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DELIVER_VIP) {
            if (this.variation == Variation.BASIC) {
                info.addPara("Deliver the " + this.subjectRelation + " of " + this.target.getNameString() + " to " + this.destination.getName() + " in the " + this.system.getNameWithLowercaseTypeShort() + ", for " + this.event + ". " + this.target.getNameString() + " is the " + this.target.getPost().toLowerCase() + ".", opad);
            } else if (this.variation == Variation.KANTA) {
                info.addPara("Deliver the " + this.subjectRelation + " of " + this.kantaRelationFirstName + " Kanta to " + this.destination.getName() + " in the " + this.system.getNameWithLowercaseTypeShort() + ", for " + this.event + ". " + this.kantaRelationFirstName + " is kin to Kanta herself.", opad);
            }
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DELIVER_VIP) {
            info.addPara("Deliver student to " + this.destination.getName() + " in the " + this.system.getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Deliver VIP";
    }

    public static class FactionData {
        public String[] subjects;
        public String[] events;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        DELIVER_VIP,
        COMPLETED,
        FAILED,
        FAILED_DECIV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        BASIC,
        KANTA;

    }
}

