/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.impl.campaign.world.TTBlackSite;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAProjectZiggurat
extends GABaseMission {
    public static String SCANNED_ZIGGURAT = "$gaPZ_scannedZiggurat";
    protected PersonAPI callisto;
    protected MarketAPI culann;
    protected MarketAPI donn;
    protected PersonAPI baird;
    protected PersonAPI arroyo;
    protected PersonAPI gargoyle;
    protected PersonAPI culannAdmin;
    protected NascentGravityWellAPI well;
    protected StarSystemAPI relaySystem;
    protected StarSystemAPI alphaSite;
    protected CampaignFleetAPI zigFleet;
    protected SectorEntityToken relay;
    protected PlanetAPI baseRuins;
    protected boolean pointAtArroyo = false;
    protected boolean pointAtCulannAdmin = false;
    protected int culannBribe;
    protected int paymentForCommFakes;
    protected int paymentForCommFakesHigh;
    protected int rkTithe;
    private SectorEntityToken hamatsu;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaPZ_ref", "$gaPZ_inProgress")) {
            return false;
        }
        this.baird = this.getImportantPerson(People.BAIRD);
        if (this.baird == null) {
            return false;
        }
        this.callisto = this.getImportantPerson(People.IBRAHIM);
        if (this.callisto == null) {
            return false;
        }
        this.gargoyle = this.getImportantPerson(People.GARGOYLE);
        if (this.gargoyle == null) {
            return false;
        }
        this.culann = Global.getSector().getEconomy().getMarket("culann");
        if (this.culann == null) {
            return false;
        }
        this.donn = Global.getSector().getEconomy().getMarket("donn");
        if (this.donn == null) {
            return false;
        }
        this.arroyo = this.getImportantPerson(People.ARROYO);
        if (this.arroyo == null) {
            return false;
        }
        this.culannAdmin = this.getPersonAtMarketPost(this.culann, Ranks.POST_ADMINISTRATOR);
        if (this.culannAdmin == null) {
            return false;
        }
        this.well = (NascentGravityWellAPI)Global.getSector().getMemoryWithoutUpdate().get(TTBlackSite.NASCENT_WELL_KEY);
        if (this.well == null || !this.well.isAlive()) {
            return false;
        }
        float dir = Misc.getAngleInDegrees(this.culann.getLocationInHyperspace(), this.well.getLocationInHyperspace());
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_unsafe", "theme_core", "system_already_used_for_story");
        this.preferSystemInDirectionFrom(this.culann.getLocationInHyperspace(), dir, 30.0f);
        this.preferSystemWithinRangeOf(this.culann.getLocationInHyperspace(), 15.0f, 30.0f);
        this.preferSystemWithinRangeOf(this.culann.getLocationInHyperspace(), 15.0f, 40.0f);
        this.preferSystemUnexplored();
        this.preferSystemNotPulsar();
        this.requirePlanetNotGasGiant();
        this.requirePlanetNotStar();
        this.preferPlanetUnsurveyed();
        this.baseRuins = this.pickPlanet(true);
        if (this.baseRuins == null) {
            return false;
        }
        this.relaySystem = this.baseRuins.getStarSystem();
        if (this.relaySystem == null) {
            return false;
        }
        this.relay = this.spawnEntity("generic_probe", new BaseHubMission.LocData(BaseHubMission.EntityLocationType.HIDDEN, null, this.relaySystem));
        if (this.relay == null) {
            return false;
        }
        this.relay.setCustomDescriptionId("gaPZ_relay");
        this.alphaSite = (StarSystemAPI)this.well.getTarget().getContainingLocation();
        for (CampaignFleetAPI fleet : this.alphaSite.getFleets()) {
            if (!fleet.getMemoryWithoutUpdate().getBoolean("$ziggurat")) continue;
            this.zigFleet = fleet;
            break;
        }
        if (this.zigFleet == null) {
            return false;
        }
        this.requireSystemIs(this.alphaSite);
        this.requireEntityMemoryFlags("$hamatsu");
        this.hamatsu = this.pickEntity();
        this.paymentForCommFakes = this.genRoundNumber(10000, 15000);
        this.paymentForCommFakesHigh = this.genRoundNumber(40000, 60000);
        this.culannBribe = this.genRoundNumber(20000, 30000);
        this.rkTithe = this.genRoundNumber(80000, 120000);
        this.setStartingStage((Object)Stage.GET_KELISE_LEAD);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.setStoryMission();
        this.connectWithGlobalFlag((Object)Stage.GET_KELISE_LEAD, (Object)Stage.SELL_BLACKMAIL_MATERIAL, "$gaPZ_sellBlackmail");
        this.connectWithGlobalFlag((Object)Stage.SELL_BLACKMAIL_MATERIAL, (Object)Stage.SOLD_BLACKMAIL_MATERIAL, "$gaPZ_soldBlackmail");
        this.connectWithGlobalFlag((Object)Stage.GET_KELISE_LEAD, (Object)Stage.TALK_TO_CALLISTO, "$gaPZ_talkToCallisto");
        this.connectWithGlobalFlag((Object)Stage.SOLD_BLACKMAIL_MATERIAL, (Object)Stage.TALK_TO_CALLISTO, "$gaPZ_talkToCallisto");
        this.connectWithGlobalFlag((Object)Stage.TALK_TO_CALLISTO, (Object)Stage.GO_TO_RELAY_SYSTEM, "$gaPZ_goToRelaySystem");
        this.connectWithGlobalFlag((Object)Stage.GO_TO_RELAY_SYSTEM, (Object)Stage.GO_TO_NASCENT_WELL, "$gaPZ_goToWell");
        this.setStageOnEnteredLocation((Object)Stage.INVESTIGATE_SITE, this.alphaSite);
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, SCANNED_ZIGGURAT);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaPZ_completed");
        this.makeImportant(this.culann, null, Stage.GET_KELISE_LEAD);
        this.makeImportant(this.donn, null, Stage.SELL_BLACKMAIL_MATERIAL);
        this.makeImportant(this.arroyo, null, Stage.SOLD_BLACKMAIL_MATERIAL);
        this.makeImportant(this.callisto, null, Stage.TALK_TO_CALLISTO);
        this.makeImportant(this.relay, "$gaPZ_relayImportant", Stage.GO_TO_RELAY_SYSTEM);
        this.makeImportant(this.well, null, Stage.GO_TO_NASCENT_WELL);
        this.makeImportant(this.zigFleet, "$gaPZ_ziggurat", Stage.INVESTIGATE_SITE);
        this.makeImportant(this.baird, "$gaPZ_returnHere", Stage.RETURN_TO_ACADEMY);
        this.setFlag(this.relay, "$gaPZ_relay", false);
        this.setFlag(this.culannAdmin, "$gaPZ_culannAdmin", false, new Object[]{Stage.GET_KELISE_LEAD});
        this.setFlag(this.baseRuins, "$gaPZ_baseRuins", false, new Object[]{Stage.GO_TO_RELAY_SYSTEM, Stage.GO_TO_NASCENT_WELL});
        this.beginWithinHyperspaceRangeTrigger(this.callisto.getMarket(), 3.0f, true, new Object[]{Stage.TALK_TO_CALLISTO});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.HIGHER, "luddic_church", "patrolLarge", this.culann.getLocationInHyperspace());
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeLowRepImpact();
        this.triggerFleetMakeFaster(true, 2, true);
        this.triggerSetFleetAlwaysPursue();
        this.triggerPickLocationTowardsEntity(this.callisto.getMarket().getStarSystem().getHyperspaceAnchor(), 30.0f, GAProjectZiggurat.getUnits(1.5f));
        this.triggerSpawnFleetAtPickedLocation("$gaPZ_rogueKnight", null);
        this.triggerOrderFleetInterceptPlayer();
        this.triggerOrderFleetEBurn(1.0f);
        this.triggerFleetMakeImportant(null, Stage.TALK_TO_CALLISTO);
        this.endTrigger();
        this.beginEnteredLocationTrigger(this.relaySystem, new Object[]{Stage.GO_TO_RELAY_SYSTEM});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_2, "mercenary", "mercBountyHunter", this.culann.getLocationInHyperspace());
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerSetFleetFaction("tritachyon");
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeLowRepImpact();
        this.triggerSetFleetDoctrineComp(0, 0, 5);
        this.triggerFleetMakeFaster(true, 1, true);
        this.triggerPickLocationAtInSystemJumpPoint(this.relaySystem);
        this.triggerSpawnFleetAtPickedLocation("$gaPZ_ttMerc", null);
        this.triggerOrderFleetInterceptPlayer();
        this.triggerFleetMakeImportant(null, Stage.GO_TO_RELAY_SYSTEM);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$gaPZ_missionCompleted", true);
        this.triggerSetGlobalMemoryValue(SCANNED_ZIGGURAT, true);
        this.triggerMakeNonStoryCritical(this.culann, this.donn, this.callisto.getMarket(), this.arroyo.getMarket(), this.gargoyle.getMarket());
        this.endTrigger();
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("makeArroyoImportant".equals(action)) {
            if (!this.pointAtArroyo) {
                this.makeImportant(this.arroyo, null, Stage.GET_KELISE_LEAD);
                this.makePrimaryObjective(this.arroyo);
                this.makeUnimportant(this.culann);
                this.makeUnimportant(this.culannAdmin);
                this.pointAtArroyo = true;
            }
            return true;
        }
        if ("makeCulannAdminImportant".equals(action)) {
            if (!this.pointAtCulannAdmin) {
                this.makeImportant(this.culannAdmin, null, Stage.GET_KELISE_LEAD);
                this.makePrimaryObjective(this.culannAdmin);
                this.makeUnimportant(this.arroyo);
                this.pointAtCulannAdmin = true;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().getMemoryWithoutUpdate().unset("$gaPZ_pointedToCulannAdmin");
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaPZ_stage", this.getCurrentStage());
        this.set("$gaPZ_culannBribe", Misc.getWithDGS(this.culannBribe));
        this.set("$gaPZ_paymentForCommFakes", Misc.getWithDGS(this.paymentForCommFakes));
        this.set("$gaPZ_paymentForCommFakesHigh", Misc.getWithDGS(this.paymentForCommFakesHigh));
        this.set("$gaPZ_rkTithe", Misc.getWithDGS(this.rkTithe));
        this.set("$gaPZ_relaySystem", this.relaySystem.getNameWithNoType());
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GET_KELISE_LEAD || this.currentStage == Stage.SELL_BLACKMAIL_MATERIAL || this.currentStage == Stage.GO_TO_RELAY_SYSTEM || this.currentStage == Stage.TALK_TO_CALLISTO || this.currentStage == Stage.SOLD_BLACKMAIL_MATERIAL) {
            info.addPara("Get a lead on the whereabouts of Kelise Astraia, who is associated with a secret Tri-Tachyon research base called \"Alpha Site\".", opad);
        }
        if (this.currentStage == Stage.GET_KELISE_LEAD) {
            this.addStandardMarketDesc("She was formerly employed as a weapons engineer " + this.culann.getOnOrAt(), this.culann, info, opad);
            if (this.pointAtArroyo) {
                info.addPara("You've talked to Gargoyle, who advised you to talk to Rayan Arroyo, \"a Tri-Tach goon from top to bottom\", who is likely to have the right connections to help with the investigation.", opad);
                this.addStandardMarketDesc("Arroyo is located " + this.arroyo.getMarket().getOnOrAt(), this.arroyo.getMarket(), info, opad);
            }
            if (this.pointAtCulannAdmin) {
                info.addPara("You've learned that the administrator of Culann Starforge will have access to personnel records that may shed light on Kelise's whereabouts.", opad);
                this.addStandardMarketDesc("", this.culannAdmin.getMarket(), info, opad);
            }
        } else if (this.currentStage == Stage.SELL_BLACKMAIL_MATERIAL) {
            info.addPara("Rayan Arroyo has agreed to help locate her, in exchange for a favor - selling bad comm fakes to any reasonably highly placed pirate leader, which would serve his ends as part of a disinformation campaign.", opad);
            this.addStandardMarketDesc("A reasonable place to find such a pirate would be " + this.donn.getOnOrAt(), this.donn, info, opad);
        } else if (this.currentStage == Stage.SOLD_BLACKMAIL_MATERIAL) {
            info.addPara("You've sold the blackmail materials to a pirate leader, in exchange for which Arroyo has agreed to help you find Kelise Astraia.", opad);
            info.addPara(String.valueOf(this.getGoTalkToPersonText(this.arroyo)) + ".", opad);
        } else if (this.currentStage == Stage.TALK_TO_CALLISTO) {
            info.addPara("You've learned that Kelise chartered - and paid for unknown special modifications to - the ISS Hamatsu, a Venture-class starship, before flying it out of the system. The ship's owner is one " + this.callisto.getNameString() + ". She may have more information.", opad);
            info.addPara(String.valueOf(this.getGoTalkToPersonText(this.callisto)) + ".", opad);
        } else if (this.currentStage == Stage.GO_TO_RELAY_SYSTEM) {
            info.addPara("You've learned that the flight plan of the ISS Hamatsu - the ship chartered by Kelise Astraia - led to the " + this.relaySystem.getNameWithLowercaseTypeShort() + ".", opad);
        } else if (this.currentStage == Stage.GO_TO_NASCENT_WELL) {
            info.addPara("You've found a hidden relay in the " + this.relaySystem.getNameWithLowercaseTypeShort() + ", " + "that was likely used for communications with \"Alpha Site\". " + "Investigate the hyperspace coordinates that the relay was transmitting to.", opad);
            if (this.well.isInCurrentLocation() && Misc.getDistanceToPlayerLY(this.well) < 0.2f) {
                info.addPara("Use %s to traverse the nascent gravity well located at the coordinates.", opad, Misc.getHighlightColor(), "Transverse Jump");
            }
        } else if (this.currentStage == Stage.INVESTIGATE_SITE) {
            info.addPara("Learn what Tri-Tachyon was doing at Alpha Site.", opad);
            info.addPara("Optional: look for the ISS Hamatsu and, if found, return it to " + this.callisto.getNameString() + ".", opad);
            info.addPara("Optional: locate Kelise Astraia.", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("Return to the Galatia Academy with the scan data and report your findings to Provost " + this.getPerson().getNameString() + ".", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GET_KELISE_LEAD) {
            info.addPara("Get a lead on the whereabouts of Kelise Astraia", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.SELL_BLACKMAIL_MATERIAL) {
            info.addPara("Sell Arroyo's comm fakes to any highly-placed pirate", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.SOLD_BLACKMAIL_MATERIAL) {
            info.addPara(this.getGoTalkToPersonText(this.arroyo), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.TALK_TO_CALLISTO) {
            info.addPara(this.getGoTalkToPersonText(this.callisto), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GO_TO_RELAY_SYSTEM) {
            info.addPara(this.getGoToSystemTextShort(this.relaySystem), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GO_TO_NASCENT_WELL) {
            info.addPara("Investigate hyperspace area the relay was transmitting to", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.INVESTIGATE_SITE) {
            info.addPara("Investigate Alpha Site", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("Return to the Galatia Academy and report to Provost Baird", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Project Ziggurat";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    @Override
    public void setCurrentStage(Object next, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.setCurrentStage(next, dialog, memoryMap);
        if (next == Stage.RETURN_TO_ACADEMY) {
            Global.getSector().getMemoryWithoutUpdate().unset(SCANNED_ZIGGURAT);
        } else if (next == Stage.GO_TO_RELAY_SYSTEM && this.hamatsu != null) {
            Misc.makeImportant(this.hamatsu, this.getReason());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GET_KELISE_LEAD,
        SELL_BLACKMAIL_MATERIAL,
        SOLD_BLACKMAIL_MATERIAL,
        TALK_TO_CALLISTO,
        GO_TO_RELAY_SYSTEM,
        GO_TO_NASCENT_WELL,
        INVESTIGATE_SITE,
        RETURN_TO_ACADEMY,
        COMPLETED;

    }
}

