/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BaseCustomBountyCreator
implements CustomBountyCreator {
    public static float DEFAULT_FREQUENCY = 10.0f;
    protected static Object STAGE = new Object();

    public float getBountyDays() {
        return CBStats.DEFAULT_DAYS;
    }

    public void addTargetLocationAndDescriptionBulletPoint(TooltipMakerAPI info, Color tc, float pad, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        if (data.system != null) {
            info.addPara("Target is in the " + data.system.getNameWithLowercaseTypeShort(), tc, pad);
        }
    }

    public void addTargetLocationAndDescription(TooltipMakerAPI info, float width, float height, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        if (data.system != null) {
            info.addPara("The target is located in the " + data.system.getNameWithLowercaseType() + ".", opad);
        }
    }

    public void addIntelAssessment(TextPanelAPI text, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        float opad = 10.0f;
        ArrayList<FleetMemberAPI> list = new ArrayList<FleetMemberAPI>();
        List<FleetMemberAPI> members = data.fleet.getFleetData().getMembersListCopy();
        int max = 7;
        int cols = 7;
        float iconSize = 440 / cols;
        Color h = Misc.getHighlightColor();
        for (FleetMemberAPI member : members) {
            if (list.size() >= max) break;
            if (member.isFighterWing()) continue;
            FleetMemberAPI copy = Global.getFactory().createFleetMember(FleetMemberType.SHIP, member.getVariant());
            if (member.isFlagship()) {
                copy.setCaptain(data.fleet.getCommander());
            }
            list.add(copy);
        }
        if (!list.isEmpty()) {
            TooltipMakerAPI info = text.beginTooltip();
            info.setParaSmallInsignia();
            info.addPara(String.valueOf(Misc.ucFirst(mission.getPerson().getHeOrShe())) + " taps a data pad, and " + "an intel assessment shows up on your tripad.", 0.0f);
            info.addShipList(cols, 1, iconSize, data.fleet.getFaction().getBaseUIColor(), list, opad);
            int num = members.size() - list.size();
            num = num < 5 ? 0 : (num < 10 ? 5 : (num < 20 ? 10 : 20));
            if (num > 1) {
                info.addPara("The assessment notes the fleet may contain upwards of %s other ships of lesser significance.", opad, h, "" + num);
            } else if (num > 0) {
                info.addPara("The assessment notes the fleet may contain several other ships of lesser significance.", opad);
            } else {
                info.addPara("It appears to contain complete information about the scope of the assignment.", opad);
            }
            text.addTooltip();
        }
    }

    public void addFleetDescription(TooltipMakerAPI info, float width, float height, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        PersonAPI person = data.fleet.getCommander();
        FactionAPI faction = person.getFaction();
        int cols = 7;
        float iconSize = width / (float)cols;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        boolean deflate = false;
        if (!data.fleet.isInflated()) {
            data.fleet.inflateIfNeeded();
            deflate = true;
        }
        ArrayList<FleetMemberAPI> list = new ArrayList<FleetMemberAPI>();
        Random random = new Random(person.getNameString().hashCode() * 170000);
        List<FleetMemberAPI> members = data.fleet.getFleetData().getMembersListCopy();
        int max = 7;
        for (FleetMemberAPI member : members) {
            if (list.size() >= max) break;
            if (member.isFighterWing()) continue;
            FleetMemberAPI copy = Global.getFactory().createFleetMember(FleetMemberType.SHIP, member.getVariant());
            if (member.isFlagship()) {
                copy.setCaptain(person);
            }
            list.add(copy);
        }
        if (!list.isEmpty()) {
            info.addPara("The bounty posting contains partial intel on some of the ships in the target fleet.", opad);
            info.addShipList(cols, 1, iconSize, faction.getBaseUIColor(), list, opad);
            int num = members.size() - list.size();
            num = num < 5 ? 0 : (num < 10 ? 5 : (num < 20 ? 10 : 20));
            if (num > 1) {
                info.addPara("The intel assessment notes the fleet may contain upwards of %s other ships of lesser significance.", opad, h, "" + num);
            } else if (num > 0) {
                info.addPara("The intel assessment notes the fleet may contain several other ships of lesser significance.", opad);
            }
        }
        if (deflate) {
            data.fleet.deflate();
        }
    }

    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        PersonAPI person = mission.getPerson();
        if (!this.isRepeatableGlobally() && this.getNumCompletedGlobal() > 0) {
            return 0.0f;
        }
        if (!this.isRepeatablePerPerson() && this.getNumCompletedForPerson(person) > 0) {
            return 0.0f;
        }
        float mult = 1.0f;
        if (this.isReduceFrequencyBasedOnNumberOfCompletions()) {
            mult = 1.0f / (1.0f + (float)this.getNumCompletedGlobal() * 0.5f);
        }
        return DEFAULT_FREQUENCY * mult;
    }

    public String getNumCompletedPerPersonKey() {
        return "$" + this.getId() + "_numCompleted";
    }

    public String getNumCompletedGlobalKey() {
        return "$" + this.getId() + "_numCompleted";
    }

    protected boolean isRepeatablePerPerson() {
        return true;
    }

    protected boolean isRepeatableGlobally() {
        return true;
    }

    protected boolean isReduceFrequencyBasedOnNumberOfCompletions() {
        return false;
    }

    public String getId() {
        return this.getClass().getSimpleName();
    }

    public boolean systemMatchesRequirement(StarSystemAPI system) {
        return true;
    }

    public float getRepFaction() {
        return 0.01f;
    }

    public float getRepPerson() {
        return 0.03f;
    }

    protected void beginFleet(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        mission.beginStageTrigger(STAGE);
    }

    protected CampaignFleetAPI createFleet(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        mission.triggerMakeFleetIgnoreOtherFleetsExceptPlayer();
        mission.triggerFleetOnlyEngageableWhenVisibleToPlayer();
        mission.endTrigger();
        ArrayList<BaseHubMission.Abortable> before = new ArrayList<BaseHubMission.Abortable>(mission.getChanges());
        List<CampaignFleetAPI> fleets = mission.runStageTriggersReturnFleets(STAGE);
        if (fleets.isEmpty()) {
            return null;
        }
        CampaignFleetAPI fleet = fleets.get(0);
        mission.getChanges().add(new BaseHubMission.EntityAdded(fleet));
        for (BaseHubMission.Abortable curr : mission.getChanges()) {
            if (before.contains(curr)) continue;
            data.abortWhenOtherVersionAccepted.add(curr);
        }
        return fleet;
    }

    public void notifyCompleted(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        PersonAPI person = mission.getPerson();
        String key = this.getNumCompletedGlobalKey();
        Integer num = (Integer)Global.getSector().getMemoryWithoutUpdate().get(key);
        if (num == null) {
            num = 0;
        }
        num = num + 1;
        Global.getSector().getMemoryWithoutUpdate().set(key, num);
        key = this.getNumCompletedPerPersonKey();
        num = (Integer)person.getMemoryWithoutUpdate().get(key);
        if (num == null) {
            num = 0;
        }
        num = num + 1;
        person.getMemoryWithoutUpdate().set(key, num);
    }

    public void notifyFailed(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
    }

    public int getNumCompletedForPerson(PersonAPI person) {
        String key = this.getNumCompletedPerPersonKey();
        Integer num = (Integer)person.getMemoryWithoutUpdate().get(key);
        if (num == null) {
            num = 0;
        }
        return num;
    }

    public int getNumCompletedGlobal() {
        String key = this.getNumCompletedGlobalKey();
        Integer num = (Integer)Global.getSector().getMemoryWithoutUpdate().get(key);
        if (num == null) {
            num = 0;
        }
        return num;
    }

    public int getMinDifficulty() {
        return 0;
    }

    public int getMaxDifficulty() {
        return 10;
    }

    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        return null;
    }

    public void notifyAccepted(MarketAPI createdAt, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
    }

    public StarSystemAPI getSystemWithNoTimeLimit(CustomBountyCreator.CustomBountyData data) {
        return data.system;
    }

    public String getBaseBountyName(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return "Bounty";
    }

    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return null;
    }

    public void setRepChangesBasedOnDifficulty(CustomBountyCreator.CustomBountyData data, int difficulty) {
        if (difficulty <= 3) {
            data.repPerson = 0.02f;
            data.repFaction = 0.01f;
        } else if (difficulty <= 7) {
            data.repPerson = 0.03f;
            data.repFaction = 0.02f;
        } else {
            data.repPerson = 0.05f;
            data.repFaction = 0.02f;
        }
    }

    public void updateInteractionData(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
    }

    public String getIconName() {
        return null;
    }
}

