/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class CBPatrol
extends BaseCustomBountyCreator {
    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        return super.getFrequency(mission, difficulty) * CBStats.PATROL_FREQ;
    }

    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return " - Patrol";
    }

    public void addTargetLocationAndDescriptionBulletPoint(TooltipMakerAPI info, Color tc, float pad, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        if (data.system != null) {
            info.addPara("Target is a %s patrol located in the " + data.system.getNameWithLowercaseType() + ".", pad, tc, data.fleet.getFaction().getBaseUIColor(), data.fleet.getFaction().getPersonNamePrefix());
        }
    }

    public void addTargetLocationAndDescription(TooltipMakerAPI info, float width, float height, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        if (data.system != null && data.fleet != null && data.market != null) {
            info.addPara("The target is a %s patrol and is located in the " + data.system.getNameWithLowercaseType() + ".", opad, data.fleet.getFaction().getBaseUIColor(), data.fleet.getFaction().getPersonNamePrefix());
            info.addPara("It will most likely be found either in orbit around " + data.market.getName() + ", or patrolling one of the system's objectives " + "(such as a comm relay) or jump-points.", opad);
        }
    }

    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        StarSystemAPI system;
        CustomBountyCreator.CustomBountyData data = new CustomBountyCreator.CustomBountyData();
        data.difficulty = difficulty;
        mission.requireMarketSizeAtLeast(4);
        mission.requireMarketNotHidden();
        mission.requireMarketHasSpaceport();
        mission.requireMarketNotInHyperspace();
        mission.requireMarketFactionCustom(ReqMode.NOT_ANY, "decentralized");
        mission.requireMarketFactionNot("pirates");
        mission.requireMarketFactionNotPlayer();
        mission.requireMarketLocationNot(createdAt.getContainingLocation());
        MarketAPI target = mission.pickMarket();
        if (target == null || target.getStarSystem() == null) {
            return null;
        }
        data.system = system = target.getStarSystem();
        data.market = target;
        int num = 1;
        if (difficulty > 6) {
            num = 2;
        }
        if (difficulty > 8) {
            num = 3;
        }
        float protectorDiff = difficulty - 3;
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.MEDIUM;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
        String type = "patrolMedium";
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
        int i = 0;
        while (i < num) {
            float diff = difficulty;
            if (i > 0) {
                diff = protectorDiff;
            }
            if (diff <= 2.0f) {
                size = HubMissionWithTriggers.FleetSize.TINY;
                type = "patrolSmall";
            } else if (diff <= 3.0f) {
                size = HubMissionWithTriggers.FleetSize.VERY_SMALL;
                type = "patrolSmall";
            } else if (diff <= 4.0f) {
                size = HubMissionWithTriggers.FleetSize.SMALL;
                type = "patrolSmall";
            } else if (difficulty <= 5) {
                size = HubMissionWithTriggers.FleetSize.MEDIUM;
                type = "patrolMedium";
            } else {
                size = HubMissionWithTriggers.FleetSize.LARGE;
                type = "patrolLarge";
            }
            this.beginFleet(mission, data);
            mission.triggerCreateFleet(size, quality, target.getFactionId(), type, data.system);
            mission.triggerSetFleetOfficers(oNum, oQuality);
            mission.triggerAutoAdjustFleetSize(size, size.next());
            mission.triggerFleetAllowLongPursuit();
            mission.triggerFleetSetAllWeapons();
            mission.triggerSetPatrol();
            if (i == 0) {
                mission.triggerSpawnFleetNear(target.getPrimaryEntity(), null, null);
                mission.triggerFleetSetPatrolActionText("patrolling");
                mission.triggerOrderFleetPatrol(data.system, true, "jump_point", "objective");
                mission.triggerOrderExtraPatrolPoints(target.getPrimaryEntity());
            } else {
                mission.triggerSpawnFleetNear(data.fleet, null, null);
                mission.triggerFleetSetPatrolActionText("guarding " + data.fleet.getName().toLowerCase());
                mission.triggerFleetSetPatrolLeashRange(100.0f);
                mission.triggerOrderFleetPatrol(data.system, true, data.fleet);
            }
            CampaignFleetAPI fleet = this.createFleet(mission, data);
            if (i == 0) {
                data.fleet = fleet;
            }
            ++i;
        }
        if (data.fleet == null) {
            return null;
        }
        this.setRepChangesBasedOnDifficulty(data, difficulty);
        data.baseReward = CBStats.getBaseBounty(difficulty, CBStats.PATROL_MULT, mission);
        return data;
    }

    public void updateInteractionData(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        String id = mission.getMissionId();
        String faction = data.fleet.getFaction().getPersonNamePrefix();
        Color factionColor = data.fleet.getFaction().getBaseUIColor();
        mission.set("$" + id + "_patrolFaction", faction);
        mission.set("$bcb_patrolFaction", faction);
        mission.set("$" + id + "_patrolFactionColor", factionColor);
        mission.set("$bcb_patrolFactionColor", factionColor);
    }

    public int getMaxDifficulty() {
        return super.getMaxDifficulty();
    }

    public int getMinDifficulty() {
        return 0;
    }
}

