/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;

public class CBRemnant
extends BaseCustomBountyCreator {
    public static float PROB_IN_SYSTEM_WITH_BASE = 0.5f;
    public static float PROB_IN_SYSTEM_WITH_TAP = 0.25f;

    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        return super.getFrequency(mission, difficulty) * CBStats.REMNANT_FREQ;
    }

    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return " - Remnant Fleet";
    }

    public String getIconName() {
        return Global.getSettings().getSpriteName("campaignMissions", "remnant_bounty");
    }

    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        StarSystemAPI system;
        CustomBountyCreator.CustomBountyData data = new CustomBountyCreator.CustomBountyData();
        data.difficulty = difficulty;
        mission.requireSystemTags(ReqMode.NOT_ANY, "theme_core");
        mission.preferSystemInteresting();
        mission.preferSystemUnexplored();
        mission.requireSystemNotHasPulsar();
        if (difficulty >= 9 && mission.rollProbability(PROB_IN_SYSTEM_WITH_BASE)) {
            mission.preferSystemTags(ReqMode.ANY, "theme_remnant_main");
            mission.requireSystemTags(ReqMode.NOT_ANY, "theme_remnant_destroyed");
        } else if (mission.rollProbability(PROB_IN_SYSTEM_WITH_TAP)) {
            mission.preferSystemTags(ReqMode.ANY, "has_coronal_tap");
        } else {
            mission.preferSystemBlackHoleOrNebula();
            mission.preferSystemOnFringeOfSector();
        }
        data.system = system = mission.pickSystem();
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.MEDIUM;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.VERY_HIGH;
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.AI_MIXED;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.ALL_SHIPS;
        String type = "patrolSmall";
        if (difficulty == 7) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            type = "patrolMedium";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_BETA_OR_GAMMA;
        } else if (difficulty == 8) {
            size = HubMissionWithTriggers.FleetSize.VERY_LARGE;
            type = "patrolLarge";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_MIXED;
        } else if (difficulty == 9) {
            size = HubMissionWithTriggers.FleetSize.HUGE;
            type = "patrolLarge";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_ALPHA;
        } else if (difficulty >= 10) {
            size = HubMissionWithTriggers.FleetSize.MAXIMUM;
            type = "patrolLarge";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_ALPHA;
        }
        this.beginFleet(mission, data);
        mission.triggerCreateFleet(size, quality, "remnant", type, data.system);
        mission.triggerSetFleetDoctrineQuality(5, 3, 5);
        mission.triggerSetFleetOfficers(oNum, oQuality);
        mission.triggerAutoAdjustFleetSize(size, size.next());
        mission.triggerSetRemnantConfigActive();
        mission.triggerSetFleetNoCommanderSkills();
        mission.triggerFleetAddCommanderSkill("flux_regulation", 1);
        mission.triggerFleetAddCommanderSkill("electronic_warfare", 1);
        mission.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
        mission.triggerFleetSetAllWeapons();
        mission.triggerPickLocationAtInSystemJumpPoint(data.system);
        mission.triggerSpawnFleetAtPickedLocation(null, null);
        mission.triggerOrderFleetPatrol(data.system, true, "jump_point", "neutrino", "neutrino_high", "station", "salvageable", "gas_giant");
        data.fleet = this.createFleet(mission, data);
        if (data.fleet == null) {
            return null;
        }
        this.setRepChangesBasedOnDifficulty(data, difficulty);
        data.baseReward = CBStats.getBaseBounty(difficulty, CBStats.REMNANT_MULT, mission);
        return data;
    }

    public int getMaxDifficulty() {
        return super.getMaxDifficulty();
    }

    public int getMinDifficulty() {
        return 7;
    }
}

