/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.population;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.econ.ImmigrationPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;

public class CoreImmigrationPluginImpl
implements ImmigrationPlugin {
    public static float GROWTH_NO_INDUSTRIES = 0.01f;
    public static float IMMIGRATION_PER_HAZARD = Global.getSettings().getFloat("immigrationPerHazard");
    public static float HAZARD_SIZE_MULT = Global.getSettings().getFloat("immigrationHazardMultExtraPerColonySizeAbove3");
    public static float INCENTIVE_CREDITS_PER_POINT = Global.getSettings().getFloat("immigrationIncentiveCostPerPoint");
    public static float INCENTIVE_POINTS_EXTRA = Global.getSettings().getFloat("immigrationIncentivePointsAboveHazardPenalty");
    public static final float FACTION_HOSTILITY_IMPACT = 2.0f;
    protected MarketAPI market;
    public static final float ZERO_STABILITY_PENALTY = -5.0f;
    public static final float MAX_DIST_PENALTY = -5.0f;

    public CoreImmigrationPluginImpl(MarketAPI market) {
        this.market = market;
    }

    public void advance(float days, boolean uiUpdateOnly) {
        float f = days / 30.0f;
        boolean firstTime = !this.market.wasIncomingSetBefore();
        Global.getSettings().profilerBegin("Computing incoming");
        this.market.setIncoming(this.computeIncoming(uiUpdateOnly, f));
        Global.getSettings().profilerEnd();
        if (uiUpdateOnly) {
            return;
        }
        int iter = 1;
        if (firstTime) {
            iter = 100;
        }
        int i = 0;
        while (i < iter) {
            if (iter > 1) {
                f = (float)(iter - i) * 0.1f;
            }
            PopulationComposition pop = this.market.getPopulation();
            PopulationComposition inc = this.market.getIncoming();
            for (String id : inc.getComp().keySet()) {
                pop.add(id, inc.get(id) * f);
            }
            float min = this.getWeightForMarketSize(this.market.getSize());
            float max = this.getWeightForMarketSize(this.market.getSize() + 1);
            float newWeight = pop.getWeightValue() + inc.getWeightValue() * f;
            if (newWeight < min || Global.getSector().isInNewGameAdvance()) {
                newWeight = min;
            }
            if (newWeight > max) {
                this.increaseMarketSize();
                newWeight = max;
            }
            pop.setWeight(newWeight);
            pop.normalize();
            float conversionFraction = 0.05f * this.market.getStabilityValue() / 10.0f;
            conversionFraction *= f;
            if (conversionFraction > 0.0f) {
                pop.add(this.market.getFactionId(), (pop.getWeightValue() - pop.get(this.market.getFactionId())) * conversionFraction);
            }
            float pirateFraction = 0.01f * Math.max(0.0f, (5.0f - this.market.getStabilityValue()) / 5.0f);
            if ((pirateFraction *= f) > 0.0f) {
                pop.add("pirates", pop.getWeightValue() * pirateFraction);
                pop.add("poor", pop.getWeightValue() * pirateFraction);
            }
            for (String fid : new ArrayList<String>(pop.getComp().keySet())) {
                if (Global.getSector().getFaction(fid) != null) continue;
                pop.getComp().remove(fid);
            }
            pop.normalize();
            ++i;
        }
    }

    public void increaseMarketSize() {
        if (this.market.getSize() >= Misc.MAX_COLONY_SIZE || !this.market.isPlayerOwned()) {
            this.market.getPopulation().setWeight(CoreImmigrationPluginImpl.getWeightForMarketSizeStatic(this.market.getSize()));
            this.market.getPopulation().normalize();
            return;
        }
        CoreImmigrationPluginImpl.increaseMarketSize(this.market);
        if (this.market.isPlayerOwned()) {
            MessageIntel intel = new MessageIntel("Colony Growth - " + this.market.getName(), Misc.getBasePlayerColor());
            intel.addLine("    - Size increased to %s", Misc.getTextColor(), new String[]{"" + Math.round(this.market.getSize())}, Misc.getHighlightColor());
            intel.setIcon(Global.getSector().getPlayerFaction().getCrest());
            intel.setSound(BaseIntelPlugin.getSoundMajorPosting());
            Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.COLONY_INFO, this.market);
        }
    }

    public static void increaseMarketSize(MarketAPI market) {
        if (market.getSize() >= Misc.MAX_COLONY_SIZE) {
            return;
        }
        int i = 0;
        while (i <= 10) {
            market.removeCondition("population_" + i);
            ++i;
        }
        market.removeCondition("population_" + market.getSize());
        market.addCondition("population_" + (market.getSize() + 1));
        market.setSize(market.getSize() + 1);
        market.reapplyConditions();
        market.reapplyIndustries();
        if (market.getSize() >= Misc.MAX_COLONY_SIZE) {
            market.setImmigrationIncentivesOn(false);
        }
    }

    public static void reduceMarketSize(MarketAPI market) {
        if (market.getSize() <= 3) {
            return;
        }
        market.removeCondition("population_" + market.getSize());
        market.addCondition("population_" + (market.getSize() - 1));
        market.setSize(market.getSize() - 1);
        market.getPopulation().setWeight(CoreImmigrationPluginImpl.getWeightForMarketSizeStatic(market.getSize()));
        market.getPopulation().normalize();
        market.reapplyConditions();
        market.reapplyIndustries();
    }

    public PopulationComposition computeIncoming(boolean uiUpdateOnly, float f) {
        int numInd;
        PopulationComposition inc = new PopulationComposition();
        float stability = this.market.getStabilityValue();
        if (stability < 5.0f) {
            inc.getWeight().modifyFlat("inc_st", stability - 5.0f, "Instability");
        }
        if ((numInd = Misc.getNumIndustries(this.market)) <= 0 && GROWTH_NO_INDUSTRIES != 0.0f && this.market.getSize() > 3) {
            float weight = this.getWeightForMarketSize(this.market.getSize());
            float penalty = -Math.round(weight * GROWTH_NO_INDUSTRIES);
            inc.getWeight().modifyFlat("inc_noInd", penalty, "No industries");
        }
        float a = (float)Math.round(this.market.getAccessibilityMod().computeEffective(0.0f) * 100.0f) / 100.0f;
        int accessibilityMod = (int)(a / Misc.PER_UNIT_SHIPPING);
        inc.getWeight().modifyFlat("inc_access", accessibilityMod, "Accessibility");
        float hazMod = CoreImmigrationPluginImpl.getImmigrationHazardPenalty(this.market);
        if (hazMod != 0.0f) {
            float hazardSizeMult = CoreImmigrationPluginImpl.getImmigrationHazardPenaltySizeMult(this.market);
            inc.getWeight().modifyFlat("inc_hazard", hazMod, "Hazard rating (\u00d7" + Misc.getRoundedValueMaxOneAfterDecimal(hazardSizeMult) + " based on colony size)");
        }
        MarketAPI biggestInSystem = null;
        List<MarketAPI> inReach = Global.getSector().getEconomy().getMarketsWithSameGroup(this.market);
        for (MarketAPI curr : inReach) {
            if (curr == this.market || curr.getFaction().isHostileTo(this.market.getFaction()) || !(Misc.getDistanceLY(curr.getLocationInHyperspace(), this.market.getLocationInHyperspace()) <= 0.0f) || biggestInSystem != null && curr.getSize() <= biggestInSystem.getSize()) continue;
            biggestInSystem = curr;
        }
        if (biggestInSystem != null) {
            float sDiff = biggestInSystem.getSize() - this.market.getSize();
            if ((sDiff *= 2.0f) > 0.0f) {
                inc.getWeight().modifyFlat("inc_insys", sDiff, "Larger non-hostile colony in same system");
            }
        }
        float numIndustries = this.market.getIndustries().size();
        inc.add("pirates", 1.0f * numIndustries);
        inc.add("poor", 1.0f * numIndustries);
        String bulkFaction = "independent";
        if (this.market.getFaction().isHostileTo(bulkFaction)) {
            bulkFaction = this.market.getFactionId();
        }
        inc.add(bulkFaction, 10.0f * numIndustries);
        this.applyIncentives(inc, uiUpdateOnly, f);
        for (MarketImmigrationModifier mod : this.market.getAllImmigrationModifiers()) {
            mod.modifyIncoming(this.market, inc);
        }
        for (String fid : new ArrayList<String>(inc.getComp().keySet())) {
            if (Global.getSector().getFaction(fid) != null) continue;
            inc.getComp().remove(fid);
        }
        inc.normalizeToPositive();
        return inc;
    }

    public static float getImmigrationHazardPenalty(MarketAPI market) {
        float hazMod = Math.round((market.getHazardValue() - 1.0f) / IMMIGRATION_PER_HAZARD);
        if (hazMod < 0.0f) {
            hazMod = 0.0f;
        }
        float hazardSizeMult = CoreImmigrationPluginImpl.getImmigrationHazardPenaltySizeMult(market);
        return -hazMod * hazardSizeMult;
    }

    public static float getImmigrationHazardPenaltySizeMult(MarketAPI market) {
        float hazardSizeMult = 1.0f + ((float)market.getSize() - 3.0f) * HAZARD_SIZE_MULT;
        return hazardSizeMult;
    }

    protected void applyIncentives(PopulationComposition inc, boolean uiUpdateOnly, float f) {
        if (!this.market.isImmigrationIncentivesOn()) {
            return;
        }
        if (this.market.getSize() >= Misc.MAX_COLONY_SIZE) {
            this.market.setImmigrationIncentivesOn(false);
            return;
        }
        float points = -CoreImmigrationPluginImpl.getImmigrationHazardPenalty(this.market) + INCENTIVE_POINTS_EXTRA;
        float cost = this.market.getImmigrationIncentivesCost() * f;
        if (points > 0.0f) {
            inc.getWeight().modifyFlat("inc_incentives", points, "Hazard pay");
            if (!uiUpdateOnly) {
                this.market.setIncentiveCredits(this.market.getIncentiveCredits() + cost);
            }
        }
    }

    public float getPopulationPointsForFraction(float fraction) {
        float min = this.getWeightForMarketSize(this.market.getSize());
        float max = this.getWeightForMarketSize(this.market.getSize() + 1);
        return (max - min) * fraction;
    }

    public float getFractionForPopulationPoints(float points) {
        float min = this.getWeightForMarketSize(this.market.getSize());
        float max = this.getWeightForMarketSize(this.market.getSize() + 1);
        return points / (max - min);
    }

    public static float getWeightForMarketSizeStatic(float size) {
        return (float)(300.0 * Math.pow(2.0, size - 3.0f));
    }

    public float getWeightForMarketSize(float size) {
        return CoreImmigrationPluginImpl.getWeightForMarketSizeStatic(size);
    }
}

