/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColdConditionGenerator
implements PlanetConditionGenerator.ConditionGenerator {
    @Override
    public void addConditions(Set<String> conditionsSoFar, StarSystemGenerator.GenContext context, PlanetAPI planet) {
        boolean matchEither;
        int orbitIndex = context.orbitIndex;
        if (context.parent != null) {
            orbitIndex = context.parentOrbitIndex;
        }
        float normalIndex = context.starData.getHabZoneStart() + 2.0f;
        float veryIndex = context.starData.getHabZoneStart() + 4.0f;
        float eitherIndex = context.starData.getHabZoneStart() + 3.0f;
        boolean matchVery = (float)orbitIndex >= veryIndex;
        boolean matchNormal = !matchVery && (float)orbitIndex >= normalIndex;
        boolean bl = matchEither = (float)orbitIndex == eitherIndex;
        if (matchEither) {
            matchNormal = StarSystemGenerator.random.nextFloat() < 0.5f;
            matchVery = !matchNormal;
        }
        boolean hasNormal = conditionsSoFar.contains("cold");
        boolean hasVery = conditionsSoFar.contains("very_cold");
        if (matchNormal && !hasVery && !hasNormal && PlanetConditionGenerator.preconditionsMet("cold", conditionsSoFar)) {
            conditionsSoFar.add("cold");
            return;
        }
        if (matchVery && !hasVery && PlanetConditionGenerator.preconditionsMet("very_cold", conditionsSoFar)) {
            conditionsSoFar.remove("cold");
            conditionsSoFar.add("very_cold");
            return;
        }
    }
}

