/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropGroupRow
implements Cloneable {
    public static final String NOTHING = "nothing";
    public static final String WEAPON_PREFIX = "wpn_";
    public static final String FIGHTER_PREFIX = "ftr_";
    public static final String ITEM_PREFIX = "item_";
    private String commodity;
    private String group;
    private float freq;
    private boolean percent = false;
    private boolean multiValued = false;
    private int tier = -1;
    private List<String> tags = new ArrayList<String>();
    private WeaponAPI.WeaponType weaponType = null;
    private WeaponAPI.WeaponSize weaponSize = null;

    Object writeReplace() {
        DropGroupRow copy = this.clone();
        if (this.tags != null && this.tags.isEmpty()) {
            copy.tags = null;
        }
        return copy;
    }

    public DropGroupRow clone() {
        try {
            DropGroupRow copy = (DropGroupRow)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public DropGroupRow(JSONObject row) throws JSONException {
        this.commodity = row.getString("commodity");
        this.group = row.getString("group");
        String fStr = row.getString("freq");
        if (fStr.endsWith("%")) {
            this.percent = true;
            fStr = fStr.substring(0, fStr.length() - 1);
            this.freq = Float.parseFloat(fStr);
        } else {
            this.freq = (float)row.getDouble("freq");
        }
        this.parseData();
    }

    private void parseData() throws JSONException {
        if (this.commodity.contains(":")) {
            this.multiValued = true;
            if (this.commodity.startsWith(ITEM_PREFIX)) {
                String test = this.commodity.replaceFirst(ITEM_PREFIX, "");
                int index = test.indexOf(58);
                if (index < 0) {
                    this.multiValued = false;
                } else {
                    String itemId = test.substring(0, index);
                    String secondPart = test.substring(index + 1);
                    if (itemId.isEmpty() && secondPart.startsWith("{")) {
                        JSONObject json = new JSONObject(secondPart);
                        this.tier = json.optInt("tier", -1);
                        if (json.has("tags")) {
                            JSONArray tags = json.getJSONArray("tags");
                            int i = 0;
                            while (i < tags.length()) {
                                this.tags.add(tags.getString(i));
                                ++i;
                            }
                        }
                    } else if (!secondPart.startsWith("{")) {
                        this.multiValued = false;
                    }
                }
                return;
            }
            JSONObject json = new JSONObject(this.commodity.substring(this.commodity.indexOf(":") + 1));
            this.tier = json.optInt("tier", -1);
            if (json.has("tags")) {
                JSONArray tags = json.getJSONArray("tags");
                int i = 0;
                while (i < tags.length()) {
                    this.tags.add(tags.getString(i));
                    ++i;
                }
            }
            if (json.has("weaponType")) {
                this.weaponType = Misc.mapToEnum(json, "weaponType", WeaponAPI.WeaponType.class, null);
            }
            if (json.has("weaponSize")) {
                this.weaponSize = Misc.mapToEnum(json, "weaponSize", WeaponAPI.WeaponSize.class, null);
            }
        }
    }

    public DropGroupRow(String commodity, String group, float freq) {
        this.commodity = commodity;
        this.group = group;
        this.freq = freq;
        try {
            this.parseData();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public CommoditySpecAPI getSpec() {
        if (this.isNothing() || this.isWeapon()) {
            return null;
        }
        CommoditySpecAPI spec = Global.getSector().getEconomy().getCommoditySpec(this.commodity);
        return spec;
    }

    public WeaponSpecAPI getWeaponSpec() {
        if (!this.isWeapon()) {
            return null;
        }
        WeaponSpecAPI spec = Global.getSettings().getWeaponSpec(this.getWeaponId());
        return spec;
    }

    public float getBaseUnitValue() {
        if (this.isMultiValued()) {
            throw new RuntimeException("Call resolveToSpecificItem() before calling getBaseUnitValue()");
        }
        if (this.isWeapon()) {
            return this.getWeaponSpec().getBaseValue();
        }
        if (this.isFighterWing()) {
            return this.getFighterWingSpec().getBaseValue();
        }
        if (this.isSpecialItem()) {
            CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData(this.getSpecialItemId(), this.getSpecialItemData()), null);
            return stack.getPlugin().getPrice(null, null);
        }
        return this.getSpec().getBasePrice();
    }

    public FighterWingSpecAPI getFighterWingSpec() {
        if (!this.isFighterWing()) {
            return null;
        }
        FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(this.getFighterWingId());
        return spec;
    }

    public boolean isCommodity() {
        return !this.isNothing() && !this.isWeapon() && !this.isFighterWing() && !this.isSpecialItem();
    }

    public boolean isWeapon() {
        return this.commodity != null && this.commodity.startsWith(WEAPON_PREFIX);
    }

    public String getWeaponId() {
        return this.commodity.substring(WEAPON_PREFIX.length());
    }

    public String getSpecialItemId() {
        String afterPrefix = this.commodity.substring(ITEM_PREFIX.length());
        int index = afterPrefix.indexOf(":");
        if (index >= 0) {
            afterPrefix = afterPrefix.substring(0, index);
        }
        return afterPrefix;
    }

    public String getSpecialItemData() {
        String afterPrefix = this.commodity.substring(ITEM_PREFIX.length());
        int index = afterPrefix.indexOf(":");
        if (index >= 0) {
            afterPrefix = afterPrefix.substring(index + 1);
            return afterPrefix;
        }
        return null;
    }

    public SpecialItemSpecAPI getSpecialItemSpec() {
        if (!this.isSpecialItem()) {
            return null;
        }
        SpecialItemSpecAPI spec = Global.getSettings().getSpecialItemSpec(this.getSpecialItemId());
        return spec;
    }

    public boolean isFighterWing() {
        return this.commodity != null && this.commodity.startsWith(FIGHTER_PREFIX);
    }

    public boolean isSpecialItem() {
        return this.commodity != null && this.commodity.startsWith(ITEM_PREFIX);
    }

    public String getFighterWingId() {
        return this.commodity.substring(FIGHTER_PREFIX.length());
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public boolean isNothing() {
        return this.commodity == null || this.commodity.equals(NOTHING);
    }

    public String getCommodity() {
        return this.commodity;
    }

    public void setCommodity(String commodity) {
        this.commodity = commodity;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public float getFreq() {
        return this.freq;
    }

    public void setFreq(float freq) {
        this.freq = freq;
    }

    public static WeightedRandomPicker<DropGroupRow> getPicker(String group) {
        WeightedRandomPicker<DropGroupRow> picker = new WeightedRandomPicker<DropGroupRow>();
        Collection<DropGroupRow> specs = Global.getSettings().getAllSpecs(DropGroupRow.class);
        for (DropGroupRow spec : specs) {
            if (!spec.isMultiValued() && spec.isFighterWing() && spec.getFighterWingSpec().hasTag("no_drop") || !spec.getGroup().equals(group)) continue;
            picker.add(spec, spec.getFreq());
        }
        for (DropGroupRow curr : picker.getItems()) {
            if (!curr.isNothing() || !curr.percent) continue;
            float totalOther = picker.getTotal() - curr.freq;
            float fNothing = curr.freq / 100.0f;
            if (fNothing < 0.0f) {
                fNothing = 0.0f;
            }
            if (fNothing > 1.0f) {
                fNothing = 1.0f;
            }
            float weightNothing = totalOther * fNothing / (1.0f - fNothing);
            picker.setWeight(picker.getItems().indexOf(curr), weightNothing);
            break;
        }
        if (picker.isEmpty()) {
            throw new RuntimeException("No drop data found for drop group [" + group + "], probably an error in drop_groups.csv");
        }
        return picker;
    }

    /*
     * WARNING - void declaration
     */
    public DropGroupRow resolveToSpecificItem(Random random) {
        if (random == null) {
            random = new Random();
        }
        if (!this.isMultiValued()) {
            return this;
        }
        DropGroupRow copy = this.clone();
        copy.multiValued = false;
        if (this.isSpecialItem()) {
            String test = this.commodity.replaceFirst(ITEM_PREFIX, "");
            int index = test.indexOf(58);
            if (index >= 0) {
                void var6_14;
                boolean getParamsFromP = false;
                String string = test.substring(0, index);
                String params = test.substring(index + 1);
                if (string.isEmpty()) {
                    List<SpecialItemSpecAPI> specs = Global.getSettings().getAllSpecialItemSpecs();
                    Iterator<SpecialItemSpecAPI> iter = specs.iterator();
                    if (!this.tags.isEmpty()) {
                        iter = specs.iterator();
                        block2: while (iter.hasNext()) {
                            SpecialItemSpecAPI curr = iter.next();
                            for (String tag : this.tags) {
                                boolean not;
                                tag = (not = tag.startsWith("!")) ? tag.substring(1) : tag;
                                boolean has = curr.hasTag(tag);
                                if (not != has) continue;
                                iter.remove();
                                continue block2;
                            }
                        }
                    }
                    WeightedRandomPicker<SpecialItemSpecAPI> picker = new WeightedRandomPicker<SpecialItemSpecAPI>(random);
                    for (SpecialItemSpecAPI spec : specs) {
                        picker.add(spec, 1.0f * spec.getRarity());
                    }
                    SpecialItemSpecAPI pick = (SpecialItemSpecAPI)picker.pick();
                    if (pick == null) {
                        copy.commodity = NOTHING;
                    } else {
                        String string2 = pick.getId();
                        getParamsFromP = true;
                    }
                }
                if (!var6_14.isEmpty()) {
                    try {
                        SpecialItemSpecAPI spec;
                        SpecialItemPlugin plugin;
                        String itemData;
                        if (getParamsFromP) {
                            JSONObject json = new JSONObject(params);
                            params = json.has("p") ? json.getJSONObject("p").toString() : "{}";
                        }
                        if ((itemData = (plugin = (spec = Global.getSettings().getSpecialItemSpec((String)var6_14)).getNewPluginInstance(null)).resolveDropParamsToSpecificItemData(params, random)) == null) {
                            copy.commodity = NOTHING;
                        }
                        if (itemData.isEmpty()) {
                            copy.commodity = ITEM_PREFIX + (String)var6_14;
                        }
                        copy.commodity = ITEM_PREFIX + (String)var6_14 + ":" + itemData;
                    }
                    catch (JSONException e) {
                        throw new RuntimeException("Params: " + params, e);
                    }
                } else {
                    copy.commodity = NOTHING;
                }
            }
        } else if (this.isWeapon()) {
            WeaponSpecAPI curr;
            Iterator<WeaponSpecAPI> iter;
            List<WeaponSpecAPI> specs = Global.getSettings().getAllWeaponSpecs();
            if (this.tier >= 0) {
                iter = specs.iterator();
                while (iter.hasNext()) {
                    curr = iter.next();
                    if (curr.getTier() == this.tier) continue;
                    iter.remove();
                }
            }
            if (!this.tags.isEmpty()) {
                iter = specs.iterator();
                block6: while (iter.hasNext()) {
                    curr = iter.next();
                    for (String string : this.tags) {
                        boolean not;
                        String string3 = (not = string.startsWith("!")) ? string.substring(1) : string;
                        boolean has = curr.hasTag(string3);
                        if (not != has) continue;
                        iter.remove();
                        continue block6;
                    }
                }
            }
            if (this.weaponType != null || this.weaponSize != null) {
                iter = specs.iterator();
                while (iter.hasNext()) {
                    curr = iter.next();
                    if ((this.weaponType == null || curr.getType() == this.weaponType) && (this.weaponSize == null || curr.getSize() == this.weaponSize)) continue;
                    iter.remove();
                }
            }
            WeightedRandomPicker<WeaponSpecAPI> picker = new WeightedRandomPicker<WeaponSpecAPI>(random);
            for (WeaponSpecAPI spec : specs) {
                picker.add(spec, 1.0f * spec.getRarity());
            }
            WeaponSpecAPI pick = (WeaponSpecAPI)picker.pick();
            copy.commodity = pick == null ? NOTHING : WEAPON_PREFIX + pick.getWeaponId();
        } else if (this.isFighterWing()) {
            FighterWingSpecAPI curr;
            List<FighterWingSpecAPI> specs = Global.getSettings().getAllFighterWingSpecs();
            Iterator<FighterWingSpecAPI> iter = specs.iterator();
            while (iter.hasNext()) {
                curr = iter.next();
                if (!curr.hasTag("no_drop")) continue;
                iter.remove();
            }
            if (this.tier >= 0) {
                iter = specs.iterator();
                while (iter.hasNext()) {
                    curr = iter.next();
                    if (curr.getTier() == this.tier) continue;
                    iter.remove();
                }
            }
            if (!this.tags.isEmpty()) {
                iter = specs.iterator();
                block12: while (iter.hasNext()) {
                    curr = iter.next();
                    for (String string : this.tags) {
                        boolean not;
                        String string4 = (not = string.startsWith("!")) ? string.substring(1) : string;
                        boolean has = curr.hasTag(string4);
                        if (not != has) continue;
                        iter.remove();
                        continue block12;
                    }
                }
            }
            WeightedRandomPicker<FighterWingSpecAPI> picker = new WeightedRandomPicker<FighterWingSpecAPI>(random);
            for (FighterWingSpecAPI fighterWingSpecAPI : specs) {
                picker.add(fighterWingSpecAPI, 1.0f * fighterWingSpecAPI.getRarity());
            }
            FighterWingSpecAPI fighterWingSpecAPI = (FighterWingSpecAPI)picker.pick();
            copy.commodity = fighterWingSpecAPI == null ? NOTHING : FIGHTER_PREFIX + fighterWingSpecAPI.getId();
        }
        return copy;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.commodity;
    }
}

