/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarGenDataSpec {
    private String id;
    private float minRadius;
    private float maxRadius;
    private float coronaMin;
    private float coronaMult;
    private float coronaVar;
    private float solarWind;
    private float minFlare;
    private float maxFlare;
    private float crLossMult;
    private float freqYOUNG;
    private float freqAVERAGE;
    private float freqOLD;
    private float probOrbits;
    private float minOrbits;
    private float maxOrbits;
    private float habZoneStart;
    private Color lightColorMin;
    private Color lightColorMax;
    private StarAge age;
    private Set<String> tags = new HashSet<String>();

    public StarGenDataSpec(JSONObject row) throws JSONException {
        this.id = row.getString("id");
        this.minRadius = (float)row.getDouble("minRadius");
        this.maxRadius = (float)row.getDouble("maxRadius");
        this.coronaMin = (float)row.getDouble("coronaMin");
        this.coronaMult = (float)row.getDouble("coronaMult");
        this.coronaVar = (float)row.getDouble("coronaVar");
        this.solarWind = (float)row.getDouble("solarWind");
        this.minFlare = (float)row.getDouble("minFlare");
        this.maxFlare = (float)row.getDouble("maxFlare");
        this.crLossMult = (float)row.getDouble("crLossMult");
        this.freqYOUNG = (float)row.getDouble("freqYOUNG");
        this.freqAVERAGE = (float)row.getDouble("freqAVERAGE");
        this.freqOLD = (float)row.getDouble("freqOLD");
        this.probOrbits = (float)row.optDouble("probOrbits", 0.0);
        this.minOrbits = (float)row.optDouble("minOrbits", 0.0);
        this.maxOrbits = (float)row.optDouble("maxOrbits", 0.0);
        this.habZoneStart = (float)row.optDouble("habZoneStart", 2.0);
        this.age = Misc.mapToEnum(row, "age", StarAge.class, StarAge.ANY);
        this.lightColorMin = StarGenDataSpec.parseColor(String.valueOf(row.optString("lightColorMin", null)) + " 255", " ");
        this.lightColorMax = StarGenDataSpec.parseColor(String.valueOf(row.optString("lightColorMax", null)) + " 255", " ");
        String tags = row.optString("tags", null);
        if (tags != null) {
            String[] split;
            String[] stringArray = split = tags.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (!(tag = tag.trim()).isEmpty()) {
                    this.addTag(tag);
                }
                ++n2;
            }
        }
    }

    public static Color parseColor(String str, String sep) {
        if (str == null) {
            return Color.white;
        }
        String[] parts = str.split(sep);
        if (parts.length != 4) {
            return Color.white;
        }
        return new Color(Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim()), Integer.parseInt(parts[3].trim()));
    }

    public String getId() {
        return this.id;
    }

    public float getMinRadius() {
        return this.minRadius;
    }

    public float getMaxRadius() {
        return this.maxRadius;
    }

    public float getCoronaMin() {
        return this.coronaMin;
    }

    public float getCoronaMult() {
        return this.coronaMult;
    }

    public float getCoronaVar() {
        return this.coronaVar;
    }

    public float getSolarWind() {
        return this.solarWind;
    }

    public float getMinFlare() {
        return this.minFlare;
    }

    public float getMaxFlare() {
        return this.maxFlare;
    }

    public float getCrLossMult() {
        return this.crLossMult;
    }

    public Color getLightColorMin() {
        return this.lightColorMin;
    }

    public Color getLightColorMax() {
        return this.lightColorMax;
    }

    public float getFreqYOUNG() {
        return this.freqYOUNG;
    }

    public float getFreqAVERAGE() {
        return this.freqAVERAGE;
    }

    public float getFreqOLD() {
        return this.freqOLD;
    }

    public StarAge getAge() {
        return this.age;
    }

    public float getProbOrbits() {
        return this.probOrbits;
    }

    public float getMinOrbits() {
        return this.minOrbits;
    }

    public float getMaxOrbits() {
        return this.maxOrbits;
    }

    public float getHabZoneStart() {
        return this.habZoneStart;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }
}

