/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainPlugin;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CircularOrbitWithSpinAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.ObjectiveGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.DerelictThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageEntityGeneratorOld;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ThemeGenContext;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageEntity;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidBeltTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.NebulaTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.PulsarBeamTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.RadioChatterTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.RingSystemTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseThemeGenerator
implements ThemeGenerator {
    public static boolean DEBUG = Global.getSettings().isDevMode();
    protected Random random = StarSystemGenerator.random;
    public static float NOT_HABITABLE_PLANET_PROB = 0.1f;
    public static float ORBITAL_HABITAT_PROB = 0.5f;

    @Override
    public abstract int getOrder();

    @Override
    public abstract String getThemeId();

    @Override
    public float getWeight() {
        return 100.0f;
    }

    @Override
    public abstract void generateForSector(ThemeGenContext var1, float var2);

    public void addShipGraveyard(StarSystemData data, float chanceToAddAny, int min, int max, WeightedRandomPicker<String> factions) {
        if (this.random.nextFloat() >= chanceToAddAny) {
            return;
        }
        int num = min + this.random.nextInt(max - min + 1);
        int i = 0;
        while (i < num) {
            LinkedHashMap<LocationType, Float> weights = new LinkedHashMap<LocationType, Float>();
            weights.put(LocationType.STAR_ORBIT, Float.valueOf(5.0f));
            WeightedRandomPicker<EntityLocation> locs = BaseThemeGenerator.getLocations(this.random, data.system, null, 1000.0f, weights);
            EntityLocation loc = locs.pick();
            if (loc != null) {
                SectorEntityToken token = data.system.createToken(0.0f, 0.0f);
                data.system.addEntity(token);
                BaseThemeGenerator.setEntityLocation(token, loc, null);
                this.addShipGraveyard(data, token, factions);
            }
            ++i;
        }
    }

    public void addShipGraveyard(StarSystemData data, SectorEntityToken focus, WeightedRandomPicker<String> factions) {
        this.addShipGraveyard(data, focus, factions, null);
    }

    public void addShipGraveyard(StarSystemData data, SectorEntityToken focus, WeightedRandomPicker<String> factions, WeightedRandomPicker<String> hulls) {
        int numShips = this.random.nextInt(9) + 3;
        if (DEBUG) {
            System.out.println("    Adding ship graveyard (" + numShips + " ships)");
        }
        WeightedRandomPicker<Float> bands = new WeightedRandomPicker<Float>(this.random);
        int i = 0;
        while (i < numShips + 5) {
            bands.add(new Float(140 + i * 20), (i + 1) * (i + 1));
            ++i;
        }
        i = 0;
        while (i < numShips) {
            float radius = ((Float)bands.pickAndRemove()).floatValue();
            DerelictShipEntityPlugin.DerelictShipData params = DerelictShipEntityPlugin.createRandom(factions.pick(), null, this.random, DerelictShipEntityPlugin.getDefaultSModProb());
            if (hulls != null && !hulls.isEmpty()) {
                params = DerelictShipEntityPlugin.createHull(hulls.pickAndRemove(), this.random, DerelictShipEntityPlugin.getDefaultSModProb());
            }
            if (params != null) {
                CustomCampaignEntityAPI entity = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(this.random, focus.getContainingLocation(), "wreck", "neutral", params);
                entity.setDiscoverable(true);
                float orbitDays = radius / (5.0f + this.random.nextFloat() * 10.0f);
                entity.setCircularOrbit(focus, this.random.nextFloat() * 360.0f, radius, orbitDays);
                if (DEBUG) {
                    System.out.println("      Added ship: " + ((DerelictShipEntityPlugin)entity.getCustomPlugin()).getData().ship.variantId);
                }
                AddedEntity added = new AddedEntity(entity, null, "wreck");
                data.generated.add(added);
            }
            ++i;
        }
    }

    public void addDerelictShips(StarSystemData data, float chanceToAddAny, int min, int max, WeightedRandomPicker<String> factions) {
        if (this.random.nextFloat() >= chanceToAddAny) {
            return;
        }
        int num = min + this.random.nextInt(max - min + 1);
        int i = 0;
        while (i < num) {
            EntityLocation loc = BaseThemeGenerator.pickAnyLocation(this.random, data.system, 70.0f, null);
            this.addDerelictShip(data, loc, factions);
            ++i;
        }
    }

    public void addMiningStations(StarSystemData data, float chanceToAddAny, int min, int max, WeightedRandomPicker<String> stationTypes) {
        if (this.random.nextFloat() >= chanceToAddAny) {
            return;
        }
        int num = min + this.random.nextInt(max - min + 1);
        if (DEBUG) {
            System.out.println("    Adding " + num + " mining stations");
        }
        int i = 0;
        while (i < num) {
            ArrayList<PlanetAPI> miningCandidates = new ArrayList<PlanetAPI>();
            miningCandidates.addAll(data.gasGiants);
            miningCandidates.addAll(data.resourceRich);
            LinkedHashMap<LocationType, Float> weights = new LinkedHashMap<LocationType, Float>();
            weights.put(LocationType.IN_ASTEROID_BELT, Float.valueOf(10.0f));
            weights.put(LocationType.IN_ASTEROID_FIELD, Float.valueOf(10.0f));
            weights.put(LocationType.IN_RING, Float.valueOf(10.0f));
            weights.put(LocationType.IN_SMALL_NEBULA, Float.valueOf(10.0f));
            WeightedRandomPicker<EntityLocation> locs = BaseThemeGenerator.getLocations(this.random, data.system, null, 100.0f, weights);
            EntityLocation loc = locs.pick();
            String type = stationTypes.pick();
            if (loc != null || !miningCandidates.isEmpty()) {
                if (this.random.nextFloat() > 0.5f && loc != null || miningCandidates.isEmpty()) {
                    this.addStation(loc, data, type, "neutral");
                } else {
                    PlanetAPI planet = (PlanetAPI)miningCandidates.get(this.random.nextInt(miningCandidates.size()));
                    EntityLocation planetOrbitLoc = BaseThemeGenerator.createLocationAtRandomGap(this.random, planet, 100.0f);
                    this.addStation(planetOrbitLoc, data, type, "neutral");
                    data.alreadyUsed.add(planet);
                }
            }
            ++i;
        }
    }

    public void addHabCenters(StarSystemData data, float chanceToAddAny, int min, int max, WeightedRandomPicker<String> stationTypes) {
        if (this.random.nextFloat() >= chanceToAddAny) {
            return;
        }
        WeightedRandomPicker<PlanetAPI> habPlanets = new WeightedRandomPicker<PlanetAPI>(this.random);
        for (PlanetAPI planet : data.habitable) {
            float h = planet.getMarket().getHazardValue();
            if ((h -= 0.5f) < 0.1f) {
                h = 0.1f;
            }
            float w = 1.0f / h;
            habPlanets.add(planet, w);
        }
        WeightedRandomPicker<PlanetAPI> otherPlanets = new WeightedRandomPicker<PlanetAPI>(this.random);
        for (PlanetAPI planet : data.planets) {
            if (data.habitable.contains(planet)) continue;
            otherPlanets.add(planet);
        }
        int num = min + this.random.nextInt(max - min + 1);
        if (DEBUG) {
            System.out.println("    Adding up to " + num + " hab centers on planets/in orbit");
        }
        int i = 0;
        while (i < num) {
            PlanetAPI planet;
            int option = 0;
            option = !habPlanets.isEmpty() && (this.random.nextFloat() > NOT_HABITABLE_PLANET_PROB || i == 0) ? 0 : (otherPlanets.isEmpty() || this.random.nextFloat() < ORBITAL_HABITAT_PROB ? 2 : 1);
            if (option == 0) {
                planet = (PlanetAPI)habPlanets.pickAndRemove();
                this.addRuins(planet);
                data.alreadyUsed.add(planet);
            } else if (option == 1) {
                planet = (PlanetAPI)otherPlanets.pickAndRemove();
                this.addRuins(planet);
                data.alreadyUsed.add(planet);
            } else if (option == 2) {
                String type = stationTypes.pick();
                EntityLocation loc = BaseThemeGenerator.pickCommonLocation(this.random, data.system, 100.0f, true, null);
                this.addStation(loc, data, type, "neutral");
            }
            ++i;
        }
    }

    public void addResearchStations(StarSystemData data, float chanceToAddAny, int min, int max, WeightedRandomPicker<String> stationTypes) {
        if (this.random.nextFloat() >= chanceToAddAny) {
            return;
        }
        int num = min + this.random.nextInt(max - min + 1);
        if (DEBUG) {
            System.out.println("    Adding " + num + " research stations");
        }
        int i = 0;
        while (i < num) {
            String type = stationTypes.pick();
            ArrayList<PlanetAPI> researchCandidates = new ArrayList<PlanetAPI>();
            researchCandidates.addAll(data.gasGiants);
            LinkedHashMap<LocationType, Float> weights = new LinkedHashMap<LocationType, Float>();
            weights.put(LocationType.IN_SMALL_NEBULA, Float.valueOf(5.0f));
            weights.put(LocationType.GAS_GIANT_ORBIT, Float.valueOf(10.0f));
            weights.put(LocationType.NEAR_STAR, Float.valueOf(5.0f));
            WeightedRandomPicker<EntityLocation> locs = BaseThemeGenerator.getLocations(this.random, data.system, data.alreadyUsed, 100.0f, weights);
            EntityLocation loc = locs.pick();
            if (loc != null) {
                PlanetAPI planet;
                AddedEntity added = this.addStation(loc, data, type, "neutral");
                if (loc.orbit != null && loc.orbit.getFocus() instanceof PlanetAPI && !(planet = (PlanetAPI)loc.orbit.getFocus()).isStar()) {
                    data.alreadyUsed.add(planet);
                }
            }
            ++i;
        }
    }

    public void addRuins(PlanetAPI planet) {
        if (planet == null) {
            return;
        }
        MarketAPI market = planet.getMarket();
        BaseThemeGenerator.clearRuins(market);
        String ruins = this.pickRuinsType(planet);
        if (DEBUG) {
            System.out.println("      Added " + ruins + " to " + market.getName());
        }
        market.addCondition(ruins);
        if (this.shouldHaveDecivilized(planet, ruins)) {
            if (DEBUG) {
                System.out.println("        Added decivilized to " + market.getName());
            }
            market.addCondition("decivilized");
        }
    }

    public boolean shouldHaveDecivilized(PlanetAPI planet, String ruins) {
        float chance = 0.25f;
        if (planet.getMarket().hasCondition("habitable")) {
            chance += 0.25f;
        }
        if (ruins != null && ruins.equals("ruins_extensive")) {
            chance += 0.1f;
        }
        if (ruins != null && ruins.equals("ruins_vast")) {
            chance += 0.2f;
        }
        return this.random.nextFloat() < chance;
    }

    public List<AddedEntity> addObjectives(StarSystemData data, float prob) {
        ArrayList<AddedEntity> result = new ArrayList<AddedEntity>();
        HashSet<String> used = new HashSet<String>();
        float mult = 2.0f;
        for (SectorEntityToken loc : data.system.getEntitiesWithTag("stable_location")) {
            if (this.random.nextFloat() >= prob * (mult *= 0.5f)) continue;
            WeightedRandomPicker<ObjectiveGenDataSpec> picker = new WeightedRandomPicker<ObjectiveGenDataSpec>(this.random);
            for (ObjectiveGenDataSpec o : Global.getSettings().getAllSpecs(ObjectiveGenDataSpec.class)) {
                ObjectiveGenDataSpec spec = o;
                if (used.contains(spec.getCategory())) continue;
                picker.add(spec, spec.getFrequency());
            }
            ObjectiveGenDataSpec pick = (ObjectiveGenDataSpec)picker.pick();
            if (pick == null) break;
            used.add(pick.getCategory());
            CustomCampaignEntityAPI built = data.system.addCustomEntity(null, null, pick.getId(), "neutral");
            built.getMemoryWithoutUpdate().set("$objectiveNonFunctional", true);
            if (loc.getOrbit() != null) {
                built.setOrbit(loc.getOrbit().makeCopy());
            }
            built.setLocation(loc.getLocation().x, loc.getLocation().y);
            data.system.removeEntity(loc);
            AddedEntity e = new AddedEntity(built, null, pick.getId());
            result.add(e);
        }
        return result;
    }

    public static ObjectiveGenDataSpec getObjectiveSpec(String id) {
        ObjectiveGenDataSpec spec = (ObjectiveGenDataSpec)Global.getSettings().getSpec(ObjectiveGenDataSpec.class, id, false);
        return spec;
    }

    public AddedEntity addCommRelay(StarSystemData data, float prob) {
        if (this.random.nextFloat() >= prob) {
            return null;
        }
        LinkedHashMap<LocationType, Float> weights = new LinkedHashMap<LocationType, Float>();
        weights.put(LocationType.STAR_ORBIT, Float.valueOf(10.0f));
        weights.put(LocationType.OUTER_SYSTEM, Float.valueOf(10.0f));
        WeightedRandomPicker<EntityLocation> locs = BaseThemeGenerator.getLocations(this.random, data.system, null, 100.0f, weights);
        EntityLocation loc = locs.pick();
        AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(data.system, loc, "comm_relay", "neutral");
        if (DEBUG && added != null) {
            System.out.println("    Added comm relay");
        }
        if (added != null) {
            BaseThemeGenerator.convertOrbitNoSpin(added.entity);
            added.entity.getMemoryWithoutUpdate().set("$objectiveNonFunctional", true);
        }
        return added;
    }

    public AddedEntity addInactiveGate(StarSystemData data, float prob, float probDebris, float probShips, WeightedRandomPicker<String> factions) {
        if (this.random.nextFloat() >= prob) {
            return null;
        }
        LinkedHashMap<LocationType, Float> weights = new LinkedHashMap<LocationType, Float>();
        weights.put(LocationType.STAR_ORBIT, Float.valueOf(10.0f));
        weights.put(LocationType.OUTER_SYSTEM, Float.valueOf(10.0f));
        WeightedRandomPicker<EntityLocation> locs = BaseThemeGenerator.getLocations(this.random, data.system, null, 100.0f, weights);
        EntityLocation loc = locs.pick();
        AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(data.system, loc, "inactive_gate", "neutral");
        if (DEBUG && added != null) {
            System.out.println("    Added inactive gate to " + data.system.getNameWithLowercaseTypeShort());
        }
        if (added != null) {
            BaseThemeGenerator.convertOrbitNoSpin(added.entity);
            if (this.random.nextFloat() < probDebris) {
                if (DEBUG && added != null) {
                    System.out.println("      Added debris field around gate");
                }
                this.addDebrisField(data, added.entity, 500.0f + this.random.nextFloat() * 100.0f);
                if (this.random.nextFloat() < probShips) {
                    if (DEBUG && added != null) {
                        System.out.println("      Added ship graveyard around gate");
                    }
                    this.addShipGraveyard(data, added.entity, factions);
                }
            }
        }
        return added;
    }

    public String pickRuinsType(PlanetAPI planet) {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.random);
        float hazard = planet.getMarket().getHazardValue();
        float add1 = 0.0f;
        float add2 = 0.0f;
        if (hazard <= 1.0f) {
            add1 = 10.0f;
            add2 = 5.0f;
        } else if (hazard <= 1.25f) {
            add1 = 5.0f;
            add2 = 1.0f;
        }
        picker.add("ruins_scattered", 10.0f);
        picker.add("ruins_widespread", 10.0f);
        picker.add("ruins_extensive", 3.0f + add1);
        picker.add("ruins_vast", 1.0f + add2);
        return (String)picker.pick();
    }

    public AddedEntity addStation(EntityLocation loc, StarSystemData data, String customEntityId, String factionId) {
        if (loc == null) {
            return null;
        }
        AddedEntity station = BaseThemeGenerator.addEntity(this.random, (LocationAPI)data.system, loc, customEntityId, factionId);
        if (station != null) {
            data.generated.add(station);
        }
        SectorEntityToken focus = station.entity.getOrbitFocus();
        if (DEBUG) {
            System.out.println("      Added " + customEntityId);
        }
        if (focus instanceof PlanetAPI) {
            boolean nearStar;
            PlanetAPI planet = (PlanetAPI)focus;
            data.alreadyUsed.add(planet);
            boolean bl = nearStar = planet.isStar() && station.entity.getOrbit() != null && station.entity.getCircularOrbitRadius() < 5000.0f;
            if (!planet.isStar() || nearStar) {
                BaseThemeGenerator.convertOrbitPointingDown(station.entity);
            }
        }
        return station;
    }

    public void addCaches(StarSystemData data, float chanceToAddAny, int min, int max, WeightedRandomPicker<String> cacheTypes) {
        if (this.random.nextFloat() >= chanceToAddAny) {
            return;
        }
        int num = min + this.random.nextInt(max - min + 1);
        if (DEBUG) {
            System.out.println("    Adding " + num + " resource caches");
        }
        int i = 0;
        while (i < num) {
            String type;
            EntityLocation loc = BaseThemeGenerator.pickHiddenLocation(this.random, data.system, 70.0f, null);
            AddedEntity added = BaseThemeGenerator.addEntity(this.random, (LocationAPI)data.system, loc, type = cacheTypes.pick(), "neutral");
            if (added != null) {
                data.generated.add(added);
            }
            if (DEBUG && added != null) {
                System.out.println("      Added resource cache: " + type);
            }
            ++i;
        }
    }

    public void addDebrisFields(StarSystemData data, float chanceToAddAny, int min, int max) {
        this.addDebrisFields(data, chanceToAddAny, min, max, null, 0.0f, 0, 0);
    }

    public void addDebrisFields(StarSystemData data, float chanceToAddAny, int min, int max, String defFaction, float defProb, int minStr, int maxStr) {
        if (this.random.nextFloat() >= chanceToAddAny) {
            return;
        }
        int numDebrisFields = min + this.random.nextInt(max - min + 1);
        if (DEBUG) {
            System.out.println("    Adding up to " + numDebrisFields + " debris fields");
        }
        int i = 0;
        while (i < numDebrisFields) {
            float radius = 150.0f + this.random.nextFloat() * 300.0f;
            EntityLocation loc = BaseThemeGenerator.pickAnyLocation(this.random, data.system, radius + 100.0f, null);
            if (loc != null) {
                DebrisFieldTerrainPlugin.DebrisFieldParams params = new DebrisFieldTerrainPlugin.DebrisFieldParams(radius, -1.0f, 1.0E7f, 0.0f);
                if (defFaction != null) {
                    params.defFaction = defFaction;
                    params.defenderProb = defProb;
                    params.minStr = minStr;
                    params.maxStr = maxStr;
                }
                params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.GEN;
                SectorEntityToken debris = Misc.addDebrisField(data.system, params, this.random);
                BaseThemeGenerator.setEntityLocation(debris, loc, "debris_field_shared");
                AddedEntity added = new AddedEntity(debris, loc, "debris_field_shared");
                data.generated.add(added);
                if (DEBUG) {
                    System.out.println("      Added debris field");
                }
            }
            ++i;
        }
    }

    public AddedEntity addDebrisField(StarSystemData data, SectorEntityToken focus, float radius) {
        DebrisFieldTerrainPlugin.DebrisFieldParams params = new DebrisFieldTerrainPlugin.DebrisFieldParams(radius, -1.0f, 1.0E7f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.GEN;
        SectorEntityToken debris = Misc.addDebrisField(focus.getContainingLocation(), params, this.random);
        debris.setCircularOrbit(focus, 0.0f, 0.0f, 100.0f);
        if (DEBUG) {
            System.out.println("      Added debris field");
        }
        EntityLocation loc = new EntityLocation();
        loc.type = LocationType.OUTER_SYSTEM;
        AddedEntity added = new AddedEntity(debris, loc, "debris_field_shared");
        data.generated.add(added);
        return added;
    }

    public WeightedRandomPicker<String> createStringPicker(Object ... params) {
        return BaseThemeGenerator.createStringPicker(this.random, params);
    }

    public static WeightedRandomPicker<String> createStringPicker(Random random, Object ... params) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        int i = 0;
        while (i < params.length) {
            String item = (String)params[i];
            float weight = 0.0f;
            if (params[i + 1] instanceof Float) {
                weight = ((Float)params[i + 1]).floatValue();
            } else if (params[i + 1] instanceof Integer) {
                weight = ((Integer)params[i + 1]).intValue();
            }
            picker.add(item, weight);
            i += 2;
        }
        return picker;
    }

    public void addDerelictShip(StarSystemData data, EntityLocation loc, WeightedRandomPicker<String> factions) {
        if (loc == null) {
            return;
        }
        String faction = factions.pick();
        DerelictShipEntityPlugin.DerelictShipData params = DerelictShipEntityPlugin.createRandom(faction, null, this.random, DerelictShipEntityPlugin.getDefaultSModProb());
        if (params != null) {
            CustomCampaignEntityAPI entity = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(this.random, data.system, "wreck", "neutral", params);
            entity.setDiscoverable(true);
            BaseThemeGenerator.setEntityLocation(entity, loc, "wreck");
            if (DEBUG) {
                System.out.println("      Added ship: " + ((DerelictShipEntityPlugin)entity.getCustomPlugin()).getData().ship.variantId);
            }
            AddedEntity added = new AddedEntity(entity, null, "wreck");
            data.generated.add(added);
        }
    }

    public AddedEntity addDerelictShip(StarSystemData data, EntityLocation loc, String variantId) {
        if (loc == null) {
            return null;
        }
        DerelictShipEntityPlugin.DerelictShipData params = DerelictShipEntityPlugin.createVariant(variantId, this.random, DerelictShipEntityPlugin.getDefaultSModProb());
        if (params != null) {
            CustomCampaignEntityAPI entity = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(this.random, data.system, "wreck", "neutral", params);
            entity.setDiscoverable(true);
            BaseThemeGenerator.setEntityLocation(entity, loc, "wreck");
            if (DEBUG) {
                System.out.println("      Added ship: " + ((DerelictShipEntityPlugin)entity.getCustomPlugin()).getData().ship.variantId);
            }
            AddedEntity added = new AddedEntity(entity, null, "wreck");
            data.generated.add(added);
            return added;
        }
        return null;
    }

    public static EntityLocation pickCommonLocation(Random random, StarSystemAPI system, float gap, boolean allowStarOrbit, Set<SectorEntityToken> exclude) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        LinkedHashMap<LocationType, Float> weights = new LinkedHashMap<LocationType, Float>();
        weights.put(LocationType.PLANET_ORBIT, Float.valueOf(10.0f));
        if (allowStarOrbit) {
            weights.put(LocationType.STAR_ORBIT, Float.valueOf(10.0f));
        }
        weights.put(LocationType.GAS_GIANT_ORBIT, Float.valueOf(5.0f));
        WeightedRandomPicker<EntityLocation> locs = BaseThemeGenerator.getLocations(random, system, exclude, gap, weights);
        if (locs.isEmpty()) {
            return BaseThemeGenerator.pickAnyLocation(random, system, gap, exclude);
        }
        return locs.pick();
    }

    public static EntityLocation pickUncommonLocation(Random random, StarSystemAPI system, float gap, Set<SectorEntityToken> exclude) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        LinkedHashMap<LocationType, Float> weights = new LinkedHashMap<LocationType, Float>();
        weights.put(LocationType.IN_ASTEROID_BELT, Float.valueOf(5.0f));
        weights.put(LocationType.IN_ASTEROID_FIELD, Float.valueOf(5.0f));
        weights.put(LocationType.IN_RING, Float.valueOf(5.0f));
        weights.put(LocationType.IN_SMALL_NEBULA, Float.valueOf(5.0f));
        weights.put(LocationType.L_POINT, Float.valueOf(5.0f));
        weights.put(LocationType.GAS_GIANT_ORBIT, Float.valueOf(5.0f));
        weights.put(LocationType.JUMP_ORBIT, Float.valueOf(5.0f));
        weights.put(LocationType.NEAR_STAR, Float.valueOf(5.0f));
        weights.put(LocationType.OUTER_SYSTEM, Float.valueOf(5.0f));
        WeightedRandomPicker<EntityLocation> locs = BaseThemeGenerator.getLocations(random, system, exclude, gap, weights);
        if (locs.isEmpty()) {
            return BaseThemeGenerator.pickAnyLocation(random, system, gap, exclude);
        }
        return locs.pick();
    }

    public static EntityLocation pickAnyLocation(Random random, StarSystemAPI system, float gap, Set<SectorEntityToken> exclude) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        LinkedHashMap<LocationType, Float> weights = new LinkedHashMap<LocationType, Float>();
        weights.put(LocationType.PLANET_ORBIT, Float.valueOf(10.0f));
        weights.put(LocationType.STAR_ORBIT, Float.valueOf(10.0f));
        weights.put(LocationType.IN_ASTEROID_BELT, Float.valueOf(5.0f));
        weights.put(LocationType.IN_ASTEROID_FIELD, Float.valueOf(5.0f));
        weights.put(LocationType.IN_RING, Float.valueOf(5.0f));
        weights.put(LocationType.IN_SMALL_NEBULA, Float.valueOf(5.0f));
        weights.put(LocationType.L_POINT, Float.valueOf(5.0f));
        weights.put(LocationType.GAS_GIANT_ORBIT, Float.valueOf(5.0f));
        weights.put(LocationType.JUMP_ORBIT, Float.valueOf(5.0f));
        weights.put(LocationType.NEAR_STAR, Float.valueOf(5.0f));
        weights.put(LocationType.OUTER_SYSTEM, Float.valueOf(5.0f));
        WeightedRandomPicker<EntityLocation> locs = BaseThemeGenerator.getLocations(random, system, exclude, gap, weights);
        return locs.pick();
    }

    public static EntityLocation pickHiddenLocation(Random random, StarSystemAPI system, float gap, Set<SectorEntityToken> exclude) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        LinkedHashMap<LocationType, Float> weights = new LinkedHashMap<LocationType, Float>();
        weights.put(LocationType.IN_ASTEROID_BELT, Float.valueOf(5.0f));
        weights.put(LocationType.IN_ASTEROID_FIELD, Float.valueOf(5.0f));
        weights.put(LocationType.IN_RING, Float.valueOf(5.0f));
        weights.put(LocationType.IN_SMALL_NEBULA, Float.valueOf(5.0f));
        weights.put(LocationType.L_POINT, Float.valueOf(5.0f));
        weights.put(LocationType.GAS_GIANT_ORBIT, Float.valueOf(5.0f));
        weights.put(LocationType.NEAR_STAR, Float.valueOf(5.0f));
        weights.put(LocationType.OUTER_SYSTEM, Float.valueOf(5.0f));
        WeightedRandomPicker<EntityLocation> locs = BaseThemeGenerator.getLocations(random, system, exclude, gap, weights);
        if (locs.isEmpty()) {
            return BaseThemeGenerator.pickAnyLocation(random, system, gap, exclude);
        }
        return locs.pick();
    }

    public static EntityLocation pickHiddenLocationNotNearStar(Random random, StarSystemAPI system, float gap, Set<SectorEntityToken> exclude) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        LinkedHashMap<LocationType, Float> weights = new LinkedHashMap<LocationType, Float>();
        weights.put(LocationType.IN_ASTEROID_BELT, Float.valueOf(5.0f));
        weights.put(LocationType.IN_ASTEROID_FIELD, Float.valueOf(5.0f));
        weights.put(LocationType.IN_RING, Float.valueOf(5.0f));
        weights.put(LocationType.IN_SMALL_NEBULA, Float.valueOf(5.0f));
        weights.put(LocationType.L_POINT, Float.valueOf(5.0f));
        weights.put(LocationType.GAS_GIANT_ORBIT, Float.valueOf(5.0f));
        weights.put(LocationType.OUTER_SYSTEM, Float.valueOf(5.0f));
        WeightedRandomPicker<EntityLocation> locs = BaseThemeGenerator.getLocations(random, system, exclude, gap, weights);
        if (locs.isEmpty()) {
            return BaseThemeGenerator.pickAnyLocation(random, system, gap, exclude);
        }
        return locs.pick();
    }

    public static WeightedRandomPicker<EntityLocation> getLocations(Random random, StarSystemAPI system, float minGap, LinkedHashMap<LocationType, Float> weights) {
        return BaseThemeGenerator.getLocations(random, system, null, minGap, weights);
    }

    public static WeightedRandomPicker<EntityLocation> getLocations(Random random, StarSystemAPI system, Set<SectorEntityToken> exclude, float minGap, LinkedHashMap<LocationType, Float> weights) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        WeightedRandomPicker<EntityLocation> result = new WeightedRandomPicker<EntityLocation>(random);
        system.updateAllOrbits();
        float inner = BaseThemeGenerator.getInnerRadius(system);
        float outer = BaseThemeGenerator.getOuterRadius(system);
        if (outer < 3000.0f) {
            outer = 3000.0f;
        }
        if (outer > 25000.0f) {
            outer = 25000.0f;
        }
        StarSystemGenerator.StarSystemType systemType = system.getType();
        for (LocationType type : weights.keySet()) {
            float weight = weights.get((Object)type).floatValue();
            ArrayList<EntityLocation> locs = new ArrayList<EntityLocation>();
            switch (type) {
                case PLANET_ORBIT: {
                    for (PlanetAPI planet : system.getPlanets()) {
                        float ow;
                        List<OrbitGap> gaps;
                        EntityLocation entityLocation;
                        if (planet.isGasGiant() || planet.isStar() || exclude != null && exclude.contains(planet) || (entityLocation = BaseThemeGenerator.createLocationAtRandomGap(random, planet, gaps = BaseThemeGenerator.findGaps(planet, 100.0f, 100.0f + (ow = BaseThemeGenerator.getOrbitalRadius(planet)) + minGap, minGap), type)) == null) continue;
                        locs.add(entityLocation);
                    }
                    break;
                }
                case L_POINT: {
                    EntityLocation loc;
                    for (PlanetAPI planet : system.getPlanets()) {
                        if (planet.isStar() || planet.isMoon() || planet.getRadius() < 100.0f || planet.getOrbit() == null || planet.getOrbit().getFocus() == null || planet.getCircularOrbitRadius() <= 0.0f) continue;
                        for (StarSystemGenerator.LagrangePointType lpt : EnumSet.of(StarSystemGenerator.LagrangePointType.L4, StarSystemGenerator.LagrangePointType.L5)) {
                            float f = planet.getCircularOrbitRadius();
                            float angleOffset = -30.0f;
                            if (lpt == StarSystemGenerator.LagrangePointType.L5) {
                                angleOffset = 30.0f;
                            }
                            float angle = planet.getCircularOrbitAngle() + angleOffset;
                            Vector2f location = Misc.getUnitVectorAtDegreeAngle(angle);
                            location.scale(f);
                            Vector2f.add((Vector2f)location, (Vector2f)planet.getOrbit().getFocus().getLocation(), (Vector2f)location);
                            boolean clear = BaseThemeGenerator.isAreaEmpty(system, location);
                            if (!clear) continue;
                            loc = new EntityLocation();
                            loc.type = type;
                            float orbitDays = planet.getCircularOrbitPeriod();
                            loc.orbit = Global.getFactory().createCircularOrbitWithSpin(planet.getOrbitFocus(), angle, f, orbitDays, random.nextFloat() * 10.0f + 1.0f);
                            locs.add(loc);
                        }
                    }
                    break;
                }
                case GAS_GIANT_ORBIT: {
                    for (PlanetAPI planet : system.getPlanets()) {
                        float ow;
                        List<OrbitGap> gaps;
                        EntityLocation entityLocation;
                        if (planet.isStar() || !planet.isGasGiant() || exclude != null && exclude.contains(planet) || (entityLocation = BaseThemeGenerator.createLocationAtRandomGap(random, planet, gaps = BaseThemeGenerator.findGaps(planet, 100.0f, 100.0f + (ow = BaseThemeGenerator.getOrbitalRadius(planet)) + minGap, minGap), type)) == null) continue;
                        locs.add(entityLocation);
                    }
                    break;
                }
                case JUMP_ORBIT: {
                    List<SectorEntityToken> jumpPoints = system.getEntitiesWithTag("jump_point");
                    for (SectorEntityToken point : jumpPoints) {
                        List<OrbitGap> gaps;
                        EntityLocation entityLocation;
                        if (exclude != null && exclude.contains(point) || (entityLocation = BaseThemeGenerator.createLocationAtRandomGap(random, point, gaps = BaseThemeGenerator.findGaps(point, 200.0f, 200.0f + point.getRadius() + minGap, minGap), type)) == null) continue;
                        locs.add(entityLocation);
                    }
                    break;
                }
                case NEAR_STAR: {
                    if (systemType == StarSystemGenerator.StarSystemType.NEBULA) break;
                    float r = system.getStar().getRadius();
                    float extra = 500.0f;
                    List<OrbitGap> gaps = BaseThemeGenerator.findGaps(system.getStar(), 200.0f, 200.0f + (r += extra) + minGap, minGap);
                    EntityLocation entityLocation = BaseThemeGenerator.createLocationAtRandomGap(random, system.getStar(), gaps, type);
                    if (entityLocation != null) {
                        locs.add(entityLocation);
                    }
                    if (system.getSecondary() != null) {
                        r = system.getSecondary().getRadius();
                        gaps = BaseThemeGenerator.findGaps(system.getSecondary(), 200.0f, 200.0f + r + minGap, minGap);
                        EntityLocation entityLocation2 = BaseThemeGenerator.createLocationAtRandomGap(random, system.getSecondary(), gaps, type);
                        if (entityLocation2 != null) {
                            locs.add(entityLocation2);
                        }
                    }
                    if (system.getTertiary() == null) break;
                    r = system.getTertiary().getRadius();
                    gaps = BaseThemeGenerator.findGaps(system.getTertiary(), 200.0f, 200.0f + r + minGap, minGap);
                    EntityLocation entityLocation3 = BaseThemeGenerator.createLocationAtRandomGap(random, system.getTertiary(), gaps, type);
                    if (entityLocation3 == null) break;
                    locs.add(entityLocation3);
                    break;
                }
                case IN_RING: {
                    for (CampaignTerrainAPI terrain : system.getTerrainCopy()) {
                        CampaignTerrainPlugin plugin;
                        if (exclude != null && exclude.contains(terrain) || terrain.hasTag("accretion_disk") || !((plugin = terrain.getPlugin()) instanceof RingSystemTerrainPlugin)) continue;
                        RingSystemTerrainPlugin ringSystemTerrainPlugin = (RingSystemTerrainPlugin)plugin;
                        float start = ringSystemTerrainPlugin.params.middleRadius - ringSystemTerrainPlugin.params.bandWidthInEngine / 2.0f;
                        List<OrbitGap> gaps = BaseThemeGenerator.findGaps(terrain, start - 100.0f, start + ringSystemTerrainPlugin.params.bandWidthInEngine + 100.0f, minGap);
                        EntityLocation loc = BaseThemeGenerator.createLocationAtRandomGap(random, terrain, gaps, type);
                        if (loc == null) continue;
                        locs.add(loc);
                    }
                    break;
                }
                case IN_SMALL_NEBULA: {
                    for (CampaignTerrainAPI terrain : system.getTerrainCopy()) {
                        CampaignTerrainPlugin plugin;
                        if (exclude != null && exclude.contains(terrain) || !((plugin = terrain.getPlugin()) instanceof NebulaTerrainPlugin)) continue;
                        NebulaTerrainPlugin nebulaTerrainPlugin = (NebulaTerrainPlugin)plugin;
                        float tilesHigh = nebulaTerrainPlugin.getTiles()[0].length;
                        float tilesWide = nebulaTerrainPlugin.getTiles().length;
                        float ts = nebulaTerrainPlugin.getTileSize();
                        float w = ts * tilesWide;
                        float h = ts * tilesHigh;
                        if (!(w <= 10000.0f)) continue;
                        float r = (float)Math.sqrt(w * w + h * h);
                        if (terrain.getOrbit() == null) {
                            Vector2f point = Misc.getPointWithinRadius(terrain.getLocation(), r * 0.5f, random);
                            EntityLocation loc = new EntityLocation();
                            loc.type = type;
                            loc.location = point;
                            loc.orbit = null;
                            locs.add(loc);
                            continue;
                        }
                        float min = Math.min(100.0f, r * 0.25f);
                        float max = r;
                        EntityLocation loc = new EntityLocation();
                        loc.type = type;
                        float orbitRadius = min + (max - min) * (0.75f * random.nextFloat());
                        float orbitDays = orbitRadius / (20.0f + random.nextFloat() * 5.0f);
                        loc.orbit = Global.getFactory().createCircularOrbitWithSpin(terrain, random.nextFloat() * 360.0f, orbitRadius, orbitDays, random.nextFloat() * 10.0f + 1.0f);
                        locs.add(loc);
                    }
                    break;
                }
                case IN_ASTEROID_BELT: {
                    for (CampaignTerrainAPI terrain : system.getTerrainCopy()) {
                        float start;
                        List<OrbitGap> gaps;
                        EntityLocation loc;
                        CampaignTerrainPlugin plugin;
                        if (exclude != null && exclude.contains(terrain) || !((plugin = terrain.getPlugin()) instanceof AsteroidBeltTerrainPlugin) || plugin instanceof AsteroidFieldTerrainPlugin) continue;
                        AsteroidBeltTerrainPlugin asteroidBeltTerrainPlugin = (AsteroidBeltTerrainPlugin)plugin;
                        if (asteroidBeltTerrainPlugin.params == null || (loc = BaseThemeGenerator.createLocationAtRandomGap(random, terrain, gaps = BaseThemeGenerator.findGaps(terrain, (start = asteroidBeltTerrainPlugin.params.middleRadius - asteroidBeltTerrainPlugin.params.bandWidthInEngine / 2.0f) - 100.0f, start + asteroidBeltTerrainPlugin.params.bandWidthInEngine + 100.0f, minGap), type)) == null) continue;
                        locs.add(loc);
                    }
                    break;
                }
                case IN_ASTEROID_FIELD: {
                    for (CampaignTerrainAPI terrain : system.getTerrainCopy()) {
                        CampaignTerrainPlugin plugin;
                        if (exclude != null && exclude.contains(terrain) || !((plugin = terrain.getPlugin()) instanceof AsteroidFieldTerrainPlugin)) continue;
                        AsteroidFieldTerrainPlugin asteroidFieldTerrainPlugin = (AsteroidFieldTerrainPlugin)plugin;
                        if (!BaseThemeGenerator.isAreaEmpty(system, terrain.getLocation())) continue;
                        float min = Math.min(100.0f, asteroidFieldTerrainPlugin.params.bandWidthInEngine * 0.25f);
                        float max = asteroidFieldTerrainPlugin.params.bandWidthInEngine;
                        EntityLocation loc = new EntityLocation();
                        loc.type = type;
                        float orbitRadius = min + (max - min) * (0.75f * random.nextFloat());
                        float orbitDays = orbitRadius / (20.0f + random.nextFloat() * 5.0f);
                        loc.orbit = Global.getFactory().createCircularOrbitWithSpin(terrain, random.nextFloat() * 360.0f, orbitRadius, orbitDays, random.nextFloat() * 10.0f + 1.0f);
                        locs.add(loc);
                    }
                    break;
                }
                case OUTER_SYSTEM: {
                    SectorEntityToken near = BaseThemeGenerator.pickOuterEntityToSpawnNear(random, system);
                    if (near != null && near.getCircularOrbitRadius() > 0.0f) {
                        EntityLocation loc = new EntityLocation();
                        loc.type = type;
                        float orbitRadius = near.getCircularOrbitRadius() + 1000.0f + 1500.0f * random.nextFloat();
                        float f = near.getCircularOrbitPeriod();
                        loc.orbit = Global.getFactory().createCircularOrbitWithSpin(system.getCenter(), near.getCircularOrbitAngle() + 15.0f - 30.0f * random.nextFloat(), orbitRadius, f, random.nextFloat() * 10.0f + 1.0f);
                        locs.add(loc);
                        break;
                    }
                    if (near == null) break;
                    EntityLocation loc = new EntityLocation();
                    loc.type = type;
                    float orbitRadius = outer + 500.0f + 500.0f * random.nextFloat();
                    float f = orbitRadius / (20.0f + random.nextFloat() * 5.0f);
                    loc.orbit = Global.getFactory().createCircularOrbitWithSpin(system.getCenter(), random.nextFloat() * 360.0f, orbitRadius, f, random.nextFloat() * 10.0f + 1.0f);
                    locs.add(loc);
                    break;
                }
                case STAR_ORBIT: {
                    EntityLocation loc;
                    SectorEntityToken main = system.getCenter();
                    ArrayList<PlanetAPI> secondary = new ArrayList<PlanetAPI>();
                    switch (system.getType()) {
                        case BINARY_FAR: {
                            secondary.add(system.getSecondary());
                            break;
                        }
                        case TRINARY_1CLOSE_1FAR: {
                            secondary.add(system.getTertiary());
                            break;
                        }
                        case TRINARY_2FAR: {
                            secondary.add(system.getSecondary());
                            secondary.add(system.getTertiary());
                        }
                    }
                    if (main != null) {
                        List<OrbitGap> list = BaseThemeGenerator.findGaps(main, inner, outer + minGap, minGap);
                        for (OrbitGap gap : list) {
                            EntityLocation loc2 = BaseThemeGenerator.createLocationAtGap(random, main, gap, type);
                            if (loc2 == null) continue;
                            locs.add(loc2);
                        }
                    }
                    for (SectorEntityToken sectorEntityToken : secondary) {
                        float ow = BaseThemeGenerator.getOrbitalRadius((PlanetAPI)sectorEntityToken);
                        if (ow < 3000.0f) {
                            ow = 3000.0f;
                        }
                        float r = sectorEntityToken.getRadius();
                        List<OrbitGap> gaps = BaseThemeGenerator.findGaps(sectorEntityToken, r, ow + r + minGap, minGap);
                        for (OrbitGap gap : gaps) {
                            loc = BaseThemeGenerator.createLocationAtGap(random, sectorEntityToken, gap, type);
                            if (loc == null) continue;
                            locs.add(loc);
                        }
                    }
                    break;
                }
            }
            if (system.getType() == StarSystemGenerator.StarSystemType.NEBULA) {
                for (EntityLocation loc : locs) {
                    if (loc.orbit == null || loc.orbit.getFocus() != system.getCenter()) continue;
                    loc.location = loc.orbit.computeCurrentLocation();
                    loc.orbit = null;
                }
            }
            if (locs.isEmpty()) continue;
            float weightPer = weight / (float)locs.size();
            for (EntityLocation loc : locs) {
                result.add(loc, weightPer);
            }
        }
        return result;
    }

    public static EntityLocation createLocationAtRandomGap(Random random, SectorEntityToken center, float minGap) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        float ow = BaseThemeGenerator.getOrbitalRadius(center);
        List<OrbitGap> gaps = BaseThemeGenerator.findGaps(center, 100.0f, 100.0f + ow + minGap, minGap);
        EntityLocation loc = BaseThemeGenerator.createLocationAtRandomGap(random, center, gaps, LocationType.PLANET_ORBIT);
        return loc;
    }

    private static EntityLocation createLocationAtRandomGap(Random random, SectorEntityToken center, List<OrbitGap> gaps, LocationType type) {
        if (gaps.isEmpty()) {
            return null;
        }
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        WeightedRandomPicker<OrbitGap> picker = new WeightedRandomPicker<OrbitGap>(random);
        picker.addAll(gaps);
        OrbitGap gap = (OrbitGap)picker.pick();
        return BaseThemeGenerator.createLocationAtGap(random, center, gap, type);
    }

    private static EntityLocation createLocationAtGap(Random random, SectorEntityToken center, OrbitGap gap, LocationType type) {
        if (gap != null) {
            if (random == null) {
                random = StarSystemGenerator.random;
            }
            EntityLocation loc = new EntityLocation();
            loc.type = type;
            float orbitRadius = gap.start + (gap.end - gap.start) * (0.25f + 0.5f * random.nextFloat());
            float orbitDays = orbitRadius / (20.0f + random.nextFloat() * 5.0f);
            loc.orbit = Global.getFactory().createCircularOrbitWithSpin(center, random.nextFloat() * 360.0f, orbitRadius, orbitDays, random.nextFloat() * 10.0f + 1.0f);
            return loc;
        }
        return null;
    }

    public static List<OrbitGap> findGaps(SectorEntityToken center, float minPad, float maxDist, float minGap) {
        OrbitItem item;
        ArrayList<OrbitGap> gaps = new ArrayList<OrbitGap>();
        LocationAPI loc = center.getContainingLocation();
        if (loc == null) {
            return gaps;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        for (PlanetAPI planet : loc.getPlanets()) {
            if (planet.getOrbitFocus() != center) continue;
            OrbitItem item2 = new OrbitItem();
            item2.item = planet;
            item2.orbitRadius = planet.getCircularOrbitRadius();
            if (item2.orbitRadius > maxDist) continue;
            item2.orbitalWidth = BaseThemeGenerator.getOrbitalRadius(planet) * 2.0f;
            items.add(item2);
        }
        for (CampaignTerrainAPI terrain : loc.getTerrainCopy()) {
            Object plugin;
            if (terrain.getOrbitFocus() != center || (plugin = terrain.getPlugin()) instanceof StarCoronaTerrainPlugin || plugin instanceof MagneticFieldTerrainPlugin || plugin instanceof PulsarBeamTerrainPlugin || !(plugin instanceof BaseRingTerrain)) continue;
            BaseRingTerrain ring = (BaseRingTerrain)plugin;
            item = new OrbitItem();
            item.item = terrain;
            item.orbitRadius = ring.params.middleRadius;
            if (item.orbitRadius > maxDist) continue;
            item.orbitalWidth = ring.params.bandWidthInEngine;
            items.add(item);
        }
        List entities = loc.getEntities(CustomCampaignEntityAPI.class);
        for (SectorEntityToken custom : entities) {
            if (custom.getOrbitFocus() != center) continue;
            Object item3 = new OrbitItem();
            ((OrbitItem)item3).item = custom;
            ((OrbitItem)item3).orbitRadius = custom.getCircularOrbitRadius();
            if (((OrbitItem)item3).orbitRadius > maxDist) continue;
            ((OrbitItem)item3).orbitalWidth = custom.getRadius() * 2.0f;
            items.add(item3);
        }
        List<SectorEntityToken> jumpPoints = loc.getJumpPoints();
        for (SectorEntityToken point : jumpPoints) {
            if (point.getOrbitFocus() != center) continue;
            item = new OrbitItem();
            item.item = point;
            item.orbitRadius = point.getCircularOrbitRadius();
            if (item.orbitRadius > maxDist) continue;
            item.orbitalWidth = point.getRadius() * 2.0f;
            items.add(item);
        }
        Collections.sort(items, new Comparator<OrbitItem>(){

            @Override
            public int compare(OrbitItem o1, OrbitItem o2) {
                return (int)Math.signum(o1.orbitRadius - o2.orbitRadius);
            }
        });
        float prev = center.getRadius() + minPad;
        for (Object item3 : items) {
            float next = ((OrbitItem)item3).orbitRadius - ((OrbitItem)item3).orbitalWidth / 2.0f;
            if (next - prev >= minGap) {
                OrbitGap gap = new OrbitGap();
                gap.start = prev;
                gap.end = next;
                gaps.add(gap);
            }
            prev = Math.max(prev, ((OrbitItem)item3).orbitRadius + ((OrbitItem)item3).orbitalWidth / 2.0f);
        }
        if (maxDist - prev >= minGap) {
            OrbitGap gap = new OrbitGap();
            gap.start = prev;
            gap.end = maxDist;
            gaps.add(gap);
        }
        return gaps;
    }

    public static float getInnerRadius(StarSystemAPI system) {
        switch (system.getType()) {
            case NEBULA: {
                return 0.0f;
            }
            case SINGLE: 
            case BINARY_FAR: 
            case TRINARY_2FAR: {
                if (system.getStar() == null) {
                    return 0.0f;
                }
                return system.getStar().getRadius();
            }
            case BINARY_CLOSE: 
            case TRINARY_1CLOSE_1FAR: {
                return Math.max(system.getStar().getCircularOrbitRadius() + system.getStar().getRadius(), system.getSecondary().getCircularOrbitRadius() + system.getSecondary().getRadius());
            }
            case TRINARY_2CLOSE: {
                float max = Math.max(system.getStar().getCircularOrbitRadius() + system.getStar().getRadius(), system.getSecondary().getCircularOrbitRadius() + system.getSecondary().getRadius());
                max = Math.max(max, system.getTertiary().getCircularOrbitRadius() + system.getTertiary().getRadius());
                return max;
            }
        }
        return 0.0f;
    }

    public static SectorEntityToken pickOuterEntityToSpawnNear(Random random, StarSystemAPI system) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(random);
        float max = BaseThemeGenerator.getOuterRadius(system);
        float threshold = max * 0.75f;
        for (PlanetAPI planet : system.getPlanets()) {
            float r = planet.getLocation().length() + BaseThemeGenerator.getOrbitalRadius(planet);
            if (!(r > threshold)) continue;
            picker.add(planet);
        }
        List<SectorEntityToken> jumpPoints = system.getEntitiesWithTag("jump_point");
        for (SectorEntityToken point : jumpPoints) {
            float r = Misc.getDistance(system.getCenter().getLocation(), point.getLocation());
            if (!((r += point.getRadius()) > threshold)) continue;
            picker.add(point);
        }
        return (SectorEntityToken)picker.pick();
    }

    public static float getOuterRadius(StarSystemAPI system) {
        float max = 0.0f;
        for (PlanetAPI planet : system.getPlanets()) {
            float r = planet.getLocation().length() + BaseThemeGenerator.getOrbitalRadius(planet);
            if (!(r > max)) continue;
            max = r;
        }
        for (CampaignTerrainAPI terrain : system.getTerrainCopy()) {
            float r;
            CampaignTerrainPlugin plugin = terrain.getPlugin();
            if (plugin instanceof BaseRingTerrain && !(plugin instanceof PulsarBeamTerrainPlugin)) {
                BaseRingTerrain ring = (BaseRingTerrain)plugin;
                r = ring.params.middleRadius + ring.params.bandWidthInEngine * 0.5f;
                if (!((r += Misc.getDistance(system.getCenter().getLocation(), terrain.getLocation())) > max)) continue;
                max = r;
                continue;
            }
            if (!(plugin instanceof BaseTiledTerrain) || plugin instanceof NebulaTerrainPlugin) continue;
            BaseTiledTerrain tiles = (BaseTiledTerrain)plugin;
            r = tiles.getRenderRange();
            if (!((r += Misc.getDistance(system.getCenter().getLocation(), terrain.getLocation())) > max)) continue;
            max = r;
        }
        List<SectorEntityToken> jumpPoints = system.getEntitiesWithTag("jump_point");
        for (SectorEntityToken point : jumpPoints) {
            float r = Misc.getDistance(system.getCenter().getLocation(), point.getLocation());
            if (!((r += point.getRadius()) > max)) continue;
            max = r;
        }
        return max;
    }

    public static boolean isAreaEmpty(LocationAPI loc, Vector2f coords) {
        float range = 400.0f;
        for (PlanetAPI planet : loc.getPlanets()) {
            float dist = Misc.getDistance(planet.getLocation(), coords);
            if (!(dist < range + planet.getRadius())) continue;
            return false;
        }
        List entities = loc.getEntities(CustomCampaignEntityAPI.class);
        for (SectorEntityToken custom : entities) {
            float dist = Misc.getDistance(custom.getLocation(), coords);
            if (!(dist < range + custom.getRadius())) continue;
            return false;
        }
        for (CampaignTerrainAPI terrain : loc.getTerrainCopy()) {
            CampaignTerrainPlugin plugin = terrain.getPlugin();
            if (!(plugin instanceof DebrisFieldTerrainPlugin)) continue;
            DebrisFieldTerrainPlugin ring = (DebrisFieldTerrainPlugin)plugin;
            float r = ring.params.middleRadius + ring.params.bandWidthInEngine * 0.5f;
            float dist = Misc.getDistance(terrain.getLocation(), coords);
            if (!(dist < range + r)) continue;
            return false;
        }
        return true;
    }

    public static float getOrbitalRadius(SectorEntityToken center) {
        LocationAPI loc = center.getContainingLocation();
        if (loc == null) {
            return center.getRadius();
        }
        float max = center.getRadius();
        for (PlanetAPI planet : loc.getPlanets()) {
            float r;
            if (planet.getOrbitFocus() != center || !((r = planet.getCircularOrbitRadius() + BaseThemeGenerator.getOrbitalRadius(planet)) > max)) continue;
            max = r;
        }
        for (CampaignTerrainAPI terrain : loc.getTerrainCopy()) {
            CampaignTerrainPlugin plugin;
            if (terrain.getOrbitFocus() != center || (plugin = terrain.getPlugin()) instanceof PulsarBeamTerrainPlugin || plugin instanceof RadioChatterTerrainPlugin || !(plugin instanceof BaseRingTerrain)) continue;
            BaseRingTerrain ring = (BaseRingTerrain)plugin;
            float r = ring.params.middleRadius + ring.params.bandWidthInEngine * 0.5f;
            if (!(r > max)) continue;
            max = r;
        }
        List entities = loc.getEntities(CustomCampaignEntityAPI.class);
        for (SectorEntityToken custom : entities) {
            float r;
            if (custom.getOrbitFocus() != center || !((r = custom.getCircularOrbitRadius() + custom.getRadius()) > max)) continue;
            max = r;
        }
        return max;
    }

    public static AddedEntity addEntity(Random random, StarSystemAPI system, WeightedRandomPicker<EntityLocation> locs, String type, String faction) {
        EntityLocation loc = locs.pickAndRemove();
        return BaseThemeGenerator.addEntity(random, (LocationAPI)system, loc, type, faction);
    }

    public static AddedEntity addNonSalvageEntity(LocationAPI system, EntityLocation loc, String type, String faction) {
        if (loc != null) {
            CustomCampaignEntityAPI entity = system.addCustomEntity(null, null, type, faction);
            if (loc.orbit != null) {
                entity.setOrbit(loc.orbit);
                loc.orbit.setEntity(entity);
            } else {
                entity.setOrbit(null);
                entity.getLocation().set((ReadableVector2f)loc.location);
            }
            AddedEntity data = new AddedEntity(entity, loc, type);
            return data;
        }
        return null;
    }

    public static AddedEntity addEntityAutoDetermineType(Random random, LocationAPI system, EntityLocation loc, String type, String faction) {
        if (SalvageEntityGeneratorOld.hasSalvageSpec(type)) {
            return BaseThemeGenerator.addEntity(random, system, loc, type, faction);
        }
        return BaseThemeGenerator.addNonSalvageEntity(system, loc, type, faction);
    }

    public static AddedEntity addEntity(Random random, LocationAPI system, EntityLocation loc, String type, String faction) {
        if (loc != null) {
            if (random == null) {
                random = StarSystemGenerator.random;
            }
            SectorEntityToken entity = BaseThemeGenerator.addSalvageEntity(random, system, type, faction);
            if (loc.orbit != null) {
                entity.setOrbit(loc.orbit);
                loc.orbit.setEntity(entity);
            } else {
                entity.setOrbit(null);
                entity.getLocation().set((ReadableVector2f)loc.location);
            }
            AddedEntity data = new AddedEntity(entity, loc, type);
            return data;
        }
        return null;
    }

    public static AddedEntity setEntityLocation(SectorEntityToken entity, EntityLocation loc, String type) {
        if (loc != null) {
            if (loc.orbit != null) {
                entity.setOrbit(loc.orbit);
                loc.orbit.setEntity(entity);
            } else {
                entity.setOrbit(null);
                entity.getLocation().set((ReadableVector2f)loc.location);
            }
            AddedEntity data = new AddedEntity(entity, loc, type);
            return data;
        }
        return null;
    }

    public static SectorEntityToken addSalvageEntity(LocationAPI location, String id, String faction) {
        return BaseThemeGenerator.addSalvageEntity(null, location, id, faction);
    }

    public static SectorEntityToken addSalvageEntity(Random random, LocationAPI location, String id, String faction) {
        return BaseThemeGenerator.addSalvageEntity(random, location, id, faction, null);
    }

    public static SectorEntityToken addSalvageEntity(LocationAPI location, String id, String faction, Object pluginParams) {
        return BaseThemeGenerator.addSalvageEntity(null, location, id, faction, pluginParams);
    }

    public static SectorEntityToken addSalvageEntity(Random random, LocationAPI location, String id, String faction, Object pluginParams) {
        if (random == null) {
            random = StarSystemGenerator.random;
        }
        SalvageEntityGenDataSpec spec = SalvageEntityGeneratorOld.getSalvageSpec(id);
        CustomCampaignEntityAPI entity = location.addCustomEntity(null, spec.getNameOverride(), id, faction, pluginParams);
        if (spec.getRadiusOverride() > 0.0f) {
            entity.setRadius(spec.getRadiusOverride());
        }
        switch (spec.getType()) {
            case ALWAYS_VISIBLE: {
                entity.setSensorProfile(null);
                entity.setDiscoverable(null);
                break;
            }
            case DISCOVERABLE: {
                entity.setSensorProfile(Float.valueOf(1.0f));
                entity.setDiscoverable(true);
                break;
            }
            case NOT_DISCOVERABLE: {
                entity.setSensorProfile(Float.valueOf(1.0f));
                entity.setDiscoverable(false);
            }
        }
        long seed = random.nextLong();
        entity.getMemoryWithoutUpdate().set("$salvageSeed", seed);
        entity.getDetectedRangeMod().modifyFlat("gen", spec.getDetectionRange());
        return entity;
    }

    public static CargoAPI genCargoFromDrop(SectorEntityToken entity) {
        MemoryAPI memory = entity.getMemoryWithoutUpdate();
        long seed = memory.getLong("$salvageSeed");
        Random random = Misc.getRandom(seed, 1);
        ArrayList<SalvageEntityGenDataSpec.DropData> dropValue = new ArrayList<SalvageEntityGenDataSpec.DropData>(entity.getDropValue());
        ArrayList<SalvageEntityGenDataSpec.DropData> dropRandom = new ArrayList<SalvageEntityGenDataSpec.DropData>(entity.getDropRandom());
        SalvageEntityGenDataSpec spec = (SalvageEntityGenDataSpec)Global.getSettings().getSpec(SalvageEntityGenDataSpec.class, entity.getCustomEntityType(), true);
        if (spec != null) {
            dropValue.addAll(spec.getDropValue());
            dropRandom.addAll(spec.getDropRandom());
        }
        CargoAPI salvage = SalvageEntity.generateSalvage(random, 1.0f, 1.0f, 1.0f, 1.0f, dropValue, dropRandom);
        return salvage;
    }

    public static StarSystemData computeSystemData(StarSystemAPI system) {
        StarSystemData data = new StarSystemData();
        data.system = system;
        block0: for (PlanetAPI planet : system.getPlanets()) {
            if (planet.isStar()) {
                data.stars.add(planet);
            } else {
                data.planets.add(planet);
            }
            if (planet.isGasGiant()) {
                data.gasGiants.add(planet);
            }
            if (planet.getMarket() == null || !planet.getMarket().isPlanetConditionMarketOnly()) continue;
            MarketAPI market = planet.getMarket();
            if (market.hasCondition("habitable")) {
                data.habitable.add(planet);
            }
            for (String conditionId : DerelictThemeGenerator.interestingConditionsWithoutHabitable) {
                if (!market.hasCondition(conditionId)) continue;
                data.resourceRich.add(planet);
                continue block0;
            }
        }
        return data;
    }

    public static void clearRuins(MarketAPI market) {
        if (market == null) {
            return;
        }
        market.removeCondition("ruins_extensive");
        market.removeCondition("ruins_scattered");
        market.removeCondition("ruins_vast");
        market.removeCondition("ruins_widespread");
        market.removeCondition("decivilized");
    }

    public static void convertOrbitPointingDown(SectorEntityToken entity) {
        SectorEntityToken focus = entity.getOrbitFocus();
        if (focus != null) {
            float angle = entity.getCircularOrbitAngle();
            float period = entity.getCircularOrbitPeriod();
            float radius = entity.getCircularOrbitRadius();
            entity.setCircularOrbitPointingDown(focus, angle, radius, period);
        }
    }

    public static void convertOrbitNoSpin(SectorEntityToken entity) {
        BaseThemeGenerator.convertOrbitNoSpin(entity, 90.0f);
    }

    public static void convertOrbitNoSpin(SectorEntityToken entity, float facing) {
        SectorEntityToken focus = entity.getOrbitFocus();
        if (focus != null) {
            float angle = entity.getCircularOrbitAngle();
            float period = entity.getCircularOrbitPeriod();
            float radius = entity.getCircularOrbitRadius();
            entity.setCircularOrbit(focus, angle, radius, period);
            entity.setFacing(facing);
        }
    }

    public static void convertOrbitWithSpin(SectorEntityToken entity, float spin) {
        SectorEntityToken focus = entity.getOrbitFocus();
        if (focus != null) {
            float angle = entity.getCircularOrbitAngle();
            float period = entity.getCircularOrbitPeriod();
            float radius = entity.getCircularOrbitRadius();
            entity.setCircularOrbitWithSpin(focus, angle, radius, period, spin, spin);
            ((CircularOrbitWithSpinAPI)((Object)entity.getOrbit())).setSpinVel(spin);
        }
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public void setRandom(Random random) {
        this.random = random;
    }

    protected List<Constellation> getSortedAvailableConstellations(ThemeGenContext context, boolean emptyOk, final Vector2f sortFrom, List<Constellation> exclude) {
        ArrayList<Constellation> constellations = new ArrayList<Constellation>();
        for (Constellation c : context.constellations) {
            if (context.majorThemes.containsKey(c) || !emptyOk && BaseThemeGenerator.constellationIsEmpty(c)) continue;
            constellations.add(c);
        }
        if (exclude != null) {
            constellations.removeAll(exclude);
        }
        Collections.sort(constellations, new Comparator<Constellation>(){

            @Override
            public int compare(Constellation o1, Constellation o2) {
                float d1 = Misc.getDistance(o1.getLocation(), sortFrom);
                float d2 = Misc.getDistance(o2.getLocation(), sortFrom);
                return (int)Math.signum(d2 - d1);
            }
        });
        return constellations;
    }

    public static boolean constellationIsEmpty(Constellation c) {
        for (StarSystemAPI s : c.getSystems()) {
            if (BaseThemeGenerator.systemIsEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean systemIsEmpty(StarSystemAPI system) {
        for (PlanetAPI p : system.getPlanets()) {
            if (p.isStar()) continue;
            return false;
        }
        return true;
    }

    public static class AddedEntity {
        public SectorEntityToken entity;
        public EntityLocation location;
        public String entityType;

        public AddedEntity(SectorEntityToken entity, EntityLocation location, String entityType) {
            this.entity = entity;
            this.location = location;
            this.entityType = entityType;
        }
    }

    public static class EntityLocation {
        public LocationType type;
        public Vector2f location = null;
        public OrbitAPI orbit = null;

        public String toString() {
            return String.format("Type: %s, orbitPeriod: %s", this.type.name(), this.orbit == null ? "null" : "" + this.orbit.getOrbitalPeriod());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HabitationLevel {
        LOW,
        MEDIUM,
        HIGH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocationType {
        PLANET_ORBIT,
        GAS_GIANT_ORBIT,
        JUMP_ORBIT,
        NEAR_STAR,
        IN_ASTEROID_BELT,
        IN_ASTEROID_FIELD,
        IN_RING,
        L_POINT,
        IN_SMALL_NEBULA,
        OUTER_SYSTEM,
        STAR_ORBIT;

    }

    public static class OrbitGap {
        public float start;
        public float end;
    }

    public static class OrbitItem {
        public SectorEntityToken item;
        public float orbitRadius;
        public float orbitalWidth;
    }

    public static class StarSystemData {
        public StarSystemAPI system;
        public List<PlanetAPI> stars = new ArrayList<PlanetAPI>();
        public List<PlanetAPI> planets = new ArrayList<PlanetAPI>();
        public List<PlanetAPI> habitable = new ArrayList<PlanetAPI>();
        public List<PlanetAPI> gasGiants = new ArrayList<PlanetAPI>();
        public List<PlanetAPI> resourceRich = new ArrayList<PlanetAPI>();
        public Set<SectorEntityToken> alreadyUsed = new LinkedHashSet<SectorEntityToken>();
        public Set<AddedEntity> generated = new LinkedHashSet<AddedEntity>();

        public boolean isBlackHole() {
            return this.system.getStar() != null && this.system.getStar().getSpec().isBlackHole();
        }

        public boolean isPulsar() {
            return this.system.hasPulsar();
        }

        public boolean isNebula() {
            return this.system.isNebula();
        }

        public String toString() {
            return String.format(String.valueOf(this.system.getName()) + " %d %d %d %d %d", this.stars.size(), this.planets.size(), this.habitable.size(), this.gasGiants.size(), this.resourceRich.size());
        }
    }
}

