/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.List;

public class ScavengerPiracyScript
implements EveryFrameScript {
    protected IntervalUtil piracyCheck = new IntervalUtil(0.2f, 0.4f);
    protected CampaignFleetAPI fleet;

    public ScavengerPiracyScript(CampaignFleetAPI fleet) {
        this.fleet = fleet;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.piracyCheck.advance(days);
        if (this.piracyCheck.intervalElapsed()) {
            this.doPiracyCheck();
        }
    }

    protected void doPiracyCheck() {
        if (this.fleet.getBattle() != null) {
            return;
        }
        boolean isCurrentlyPirate = this.fleet.getFaction().getId().equals("pirates");
        if (this.fleet.isTransponderOn() && !isCurrentlyPirate) {
            return;
        }
        if (isCurrentlyPirate) {
            List<CampaignFleetAPI> visible = Misc.getVisibleFleets(this.fleet, false);
            if (visible.isEmpty()) {
                this.fleet.setFaction("independent", true);
                Misc.clearTarget(this.fleet, true);
            }
            return;
        }
        List<CampaignFleetAPI> visible = Misc.getVisibleFleets(this.fleet, false);
        if (visible.size() == 1) {
            int weakerCount = 0;
            for (CampaignFleetAPI other : visible) {
                boolean seesComp;
                CampaignFleetAIAPI.EncounterOption option;
                if (this.fleet.getAI() == null || !Global.getSector().getFaction("pirates").isHostileTo(other.getFaction()) || (option = this.fleet.getAI().pickEncounterOption(null, other, true)) != CampaignFleetAIAPI.EncounterOption.ENGAGE && option != CampaignFleetAIAPI.EncounterOption.HOLD) continue;
                float dist = Misc.getDistance(this.fleet.getLocation(), other.getLocation());
                SectorEntityToken.VisibilityLevel level = other.getVisibilityLevelTo(this.fleet);
                boolean bl = seesComp = level == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || level == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS;
                if (!(dist < 800.0f) || !seesComp) continue;
                ++weakerCount;
            }
            if (weakerCount == 1) {
                this.fleet.getMemoryWithoutUpdate().set("$isPirate", true);
                this.fleet.setNoFactionInName(true);
                this.fleet.setFaction("pirates", true);
            }
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

