/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CommDirectoryEntryAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RuleBasedDialog;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.ImportantPeopleAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeginConversation
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        String id = null;
        PersonAPI person = null;
        Object o = params.get(0).getObject(memoryMap);
        if (o instanceof PersonAPI) {
            person = (PersonAPI)o;
        } else {
            id = params.get(0).getStringWithTokenReplacement(ruleId, dialog, memoryMap);
        }
        boolean minimal = false;
        boolean showRel = true;
        if (params.size() > 1) {
            minimal = params.get(1).getBoolean(memoryMap);
        }
        if (params.size() > 2) {
            showRel = params.get(2).getBoolean(memoryMap);
        }
        if (person == null) {
            ImportantPeopleAPI.PersonDataAPI data = Global.getSector().getImportantPeople().getData(id);
            if (data == null) {
                if (dialog.getInteractionTarget() != null && dialog.getInteractionTarget().getMarket() != null) {
                    if (id.startsWith("POST:")) {
                        String postId = id.substring(id.indexOf(":") + 1);
                        for (CommDirectoryEntryAPI entry : dialog.getInteractionTarget().getMarket().getCommDirectory().getEntriesCopy()) {
                            PersonAPI curr;
                            if (entry.getType() != CommDirectoryEntryAPI.EntryType.PERSON || !(entry.getEntryData() instanceof PersonAPI) || !postId.equals((curr = (PersonAPI)entry.getEntryData()).getPostId())) continue;
                            person = curr;
                            break;
                        }
                    } else {
                        CommDirectoryEntryAPI entry;
                        for (PersonAPI curr : dialog.getInteractionTarget().getMarket().getPeopleCopy()) {
                            if (!curr.getId().equals(id)) continue;
                            person = curr;
                            break;
                        }
                        if (person == null && (entry = dialog.getInteractionTarget().getMarket().getCommDirectory().getEntryForPerson(id)) != null) {
                            person = (PersonAPI)entry.getEntryData();
                        }
                    }
                }
            } else {
                person = data.getPerson();
            }
        }
        if (person == null) {
            return false;
        }
        dialog.getInteractionTarget().setActivePerson(person);
        ((RuleBasedDialog)((Object)dialog.getPlugin())).notifyActivePersonChanged();
        dialog.getVisualPanel().showPersonInfo(person, minimal, showRel);
        return true;
    }
}

