/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.CargoScan;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoScanApplyResult
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CampaignFleetAPI other = (CampaignFleetAPI)dialog.getInteractionTarget();
        MemoryAPI memory = memoryMap.get("local");
        CargoScan.CargoScanResult result = (CargoScan.CargoScanResult)memory.get(CargoScan.RESULT_KEY);
        TextPanelAPI text = dialog.getTextPanel();
        Color red = Misc.getNegativeHighlightColor();
        for (CargoStackAPI stack : result.getIllegalFound().getStacksCopy()) {
            playerFleet.getCargo().removeItems(stack.getType(), stack.getData(), stack.getSize());
            if (stack.isCommodityStack()) {
                AddRemoveCommodity.addCommodityLossText(stack.getCommodityId(), (int)stack.getSize(), text);
            } else {
                text.setFontSmallInsignia();
                text.addParagraph("Lost " + (int)stack.getSize() + "\u00d7" + " " + stack.getDisplayName(), red);
                text.highlightLastInLastPara((int)stack.getSize() + "\u00d7", Misc.getHighlightColor());
            }
            text.setFontInsignia();
        }
        for (FleetMemberAPI member : result.shipsToDamage) {
            float crLost = Math.min(member.getRepairTracker().getBaseCR(), member.getDeployCost() * 0.5f);
            if (!((crLost += 0.01f * (float)Misc.random.nextInt(10)) > 0.0f)) continue;
            member.getRepairTracker().applyCREvent(-crLost, "Vindictive cargo inspection");
            AddRemoveCommodity.addCRLossText(member, text, crLost);
        }
        return true;
    }
}

