/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.events.InvestigationEvent;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomsInspectionGenerateResult
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CampaignFleetAPI other = (CampaignFleetAPI)dialog.getInteractionTarget();
        FactionAPI faction = other.getFaction();
        CargoInspectionResult result = new CargoInspectionResult();
        float totalLegal = 0.0f;
        float totalIllegal = 0.0f;
        float totalIllegalFound = 0.0f;
        CargoAPI legalFound = Global.getFactory().createCargo(true);
        CargoAPI illegalFound = Global.getFactory().createCargo(true);
        CargoAPI all = Global.getFactory().createCargo(true);
        for (CargoStackAPI stack : playerFleet.getCargo().getStacksCopy()) {
            boolean legal;
            boolean bl = legal = !faction.isIllegal(stack);
            if (legal) {
                totalLegal += stack.getSize();
            } else {
                totalIllegal += stack.getSize();
            }
            all.addFromStack(stack);
        }
        float guiltMult = InvestigationEvent.getPlayerRepGuiltMult(faction);
        float capacity = playerFleet.getCargo().getMaxCapacity();
        float shieldedFraction = Misc.getShieldedCargoFraction(playerFleet);
        float unshieldedFraction = 1.0f - shieldedFraction;
        float shieldedMult = 0.5f + 0.5f * unshieldedFraction;
        if (totalLegal + totalIllegal > 0.0f) {
            List<CargoStackAPI> stacks = all.getStacksCopy();
            Collections.shuffle(stacks);
            float illegalSoFar = 0.0f;
            for (CargoStackAPI cargoStackAPI : stacks) {
                if (cargoStackAPI.getSize() <= 0.0f) continue;
                boolean legal = !faction.isIllegal(cargoStackAPI);
                float chanceToFind = (illegalSoFar += cargoStackAPI.getSize()) / (totalLegal + totalIllegal);
                chanceToFind *= guiltMult;
                chanceToFind *= shieldedMult;
                if (legal) {
                    legalFound.addFromStack(cargoStackAPI);
                    continue;
                }
                if (!((float)Math.random() < chanceToFind)) continue;
                float qty = cargoStackAPI.getSize();
                qty *= 0.33f + (float)Math.random() * 0.67f;
                qty *= shieldedMult;
                if ((qty = (float)Math.round(qty)) < 1.0f) {
                    qty = 1.0f;
                }
                illegalFound.addItems(cargoStackAPI.getType(), cargoStackAPI.getData(), qty);
            }
        }
        result.setLegalFound(legalFound);
        result.setIllegalFound(illegalFound);
        if (illegalFound.isEmpty()) {
            result.setType(CargoInspectionResultType.TOLL);
        } else {
            result.setType(CargoInspectionResultType.TOLL_AND_FINE);
        }
        float shipTollAmount = 0.0f;
        for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
            shipTollAmount += member.getBaseSellValue() * 0.125f * faction.getTollFraction();
        }
        shipTollAmount = (int)shipTollAmount;
        float tollFraction = faction.getTollFraction();
        float f = faction.getFineFraction();
        float toll = 0.0f;
        float fine = 0.0f;
        for (CargoStackAPI stack : legalFound.getStacksCopy()) {
            toll += stack.getSize() * (float)stack.getBaseValuePerUnit() * tollFraction * shieldedMult;
        }
        for (CargoStackAPI stack : illegalFound.getStacksCopy()) {
            fine += stack.getSize() * (float)stack.getBaseValuePerUnit() * f;
            totalIllegalFound += stack.getSize();
        }
        float totalTollAndFine = shipTollAmount + toll + fine;
        toll = (int)toll;
        fine = (int)fine;
        result.setTollAmount(totalTollAndFine);
        MemoryAPI memory = memoryMap.get("local");
        memory.set("$tollAmount", "" + (int)result.getTollAmount(), 0.0f);
        memory.set("$inspectionResultType", result.getType().name(), 0.0f);
        memory.set("$playerCanAffordPayment", playerFleet.getCargo().getCredits().get() >= result.getTollAmount(), 0.0f);
        memory.set("$cargoInspectionResult", result, 0.0f);
        TextPanelAPI text = dialog.getTextPanel();
        text.setFontVictor();
        text.setFontSmallInsignia();
        Color hl = Misc.getHighlightColor();
        Color red = Misc.getNegativeHighlightColor();
        text.addParagraph("-----------------------------------------------------------------------------");
        text.addParagraph("Fleet size toll: " + (int)shipTollAmount);
        text.highlightInLastPara(hl, "" + (int)shipTollAmount);
        text.addParagraph("Cargo toll: " + (int)toll);
        text.highlightInLastPara(hl, "" + (int)toll);
        if (!illegalFound.isEmpty()) {
            text.addParagraph("Contraband found!", red);
            String para = "";
            ArrayList<String> highlights = new ArrayList<String>();
            for (CargoStackAPI stack : illegalFound.getStacksCopy()) {
                para = String.valueOf(para) + stack.getDisplayName() + " x " + (int)stack.getSize() + "\n";
                highlights.add("" + (int)stack.getSize());
            }
            para = para.substring(0, para.length() - 1);
            text.addParagraph(para);
            text.highlightInLastPara(hl, highlights.toArray(new String[0]));
            text.addParagraph("Fine: " + (int)fine);
            text.highlightInLastPara(hl, "" + (int)fine);
        }
        text.addParagraph("Total: " + (int)totalTollAndFine + " credits");
        text.highlightInLastPara(hl, "" + (int)totalTollAndFine);
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
        return true;
    }

    public static class CargoInspectionResult {
        private CargoInspectionResultType type;
        private float tollAmount;
        private CargoAPI legalFound;
        private CargoAPI illegalFound;

        public float getTollAmount() {
            return this.tollAmount;
        }

        public void setTollAmount(float tollAmount) {
            this.tollAmount = tollAmount;
        }

        public CargoInspectionResultType getType() {
            return this.type;
        }

        public void setType(CargoInspectionResultType type) {
            this.type = type;
        }

        public CargoAPI getLegalFound() {
            return this.legalFound;
        }

        public void setLegalFound(CargoAPI legalFound) {
            this.legalFound = legalFound;
        }

        public CargoAPI getIllegalFound() {
            return this.illegalFound;
        }

        public void setIllegalFound(CargoAPI illegalFound) {
            this.illegalFound = illegalFound;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CargoInspectionResultType {
        TOLL,
        TOLL_AND_FINE;

    }
}

