/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeNearbyFleetsNonHostile
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        if (dialog.getInteractionTarget() == null) {
            return false;
        }
        final String factionId = params.get(0).getString(memoryMap);
        String reason = params.get(1).getString(memoryMap);
        float range = params.get(2).getFloat(memoryMap);
        float days = params.get(3).getFloat(memoryMap);
        List<CampaignFleetAPI> fleets = Misc.findNearbyFleets(dialog.getInteractionTarget(), range, new Misc.FleetFilter(){

            public boolean accept(CampaignFleetAPI curr) {
                return curr.getFaction().getId().equals(factionId);
            }
        });
        for (CampaignFleetAPI curr : fleets) {
            MemoryAPI memory = curr.getMemoryWithoutUpdate();
            Misc.setFlagWithReason(memory, "$cfai_makeNonHostile", reason, true, days);
        }
        return true;
    }
}

