/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseStoryPointActionDelegate;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.StoryPointActionDelegate;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetStoryOption
extends BaseCommandPlugin {
    public static boolean set(String ruleId, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap, String params) {
        return new SetStoryOption().execute(ruleId, dialog, Misc.tokenize(params), memoryMap);
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        String optionId = "";
        String bonusXPID = "";
        String soundId = "";
        String logText = null;
        int numPoints = 1;
        if (params.size() == 3) {
            optionId = params.get((int)0).string;
            numPoints = 1;
            bonusXPID = optionId;
            soundId = params.get((int)1).string;
            logText = params.get(2).getStringWithTokenReplacement(params.get(2).getString(memoryMap), dialog, memoryMap);
        } else {
            optionId = params.get((int)0).string;
            numPoints = (int)params.get(1).getFloat(memoryMap);
            bonusXPID = params.get(2).getString(memoryMap);
            String string = soundId = params.size() >= 4 ? params.get((int)3).string : null;
            if (params.size() >= 5) {
                logText = params.get(4).getStringWithTokenReplacement(params.get(4).getString(memoryMap), dialog, memoryMap);
            }
        }
        return SetStoryOption.set(dialog, numPoints, optionId, bonusXPID, soundId, logText);
    }

    public static boolean set(InteractionDialogAPI dialog, int numPoints, Object optionId, String bonusXPID, String soundId, String logText) {
        StoryOptionParams params = new StoryOptionParams(optionId, numPoints, bonusXPID, soundId, logText);
        return SetStoryOption.set(dialog, params, new BaseOptionStoryPointActionDelegate(dialog, params));
    }

    public static boolean set(InteractionDialogAPI dialog, final StoryOptionParams params, StoryPointActionDelegate delegate) {
        final float bonusXPFraction = Global.getSettings().getBonusXP(params.bonusXPID);
        dialog.makeStoryOption(params.optionId, params.numPoints, bonusXPFraction, params.soundId);
        if (params.numPoints > Global.getSector().getPlayerStats().getStoryPoints()) {
            dialog.getOptionPanel().setEnabled(params.optionId, false);
        }
        dialog.getOptionPanel().addOptionTooltipAppender(params.optionId, new OptionPanelAPI.OptionTooltipCreator(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean hadOtherText) {
                float opad = 10.0f;
                float initPad = 0.0f;
                if (hadOtherText) {
                    initPad = opad;
                }
                tooltip.addStoryPointUseInfo(initPad, params.numPoints, bonusXPFraction, true);
                int sp = Global.getSector().getPlayerStats().getStoryPoints();
                String points = "points";
                if (sp == 1) {
                    points = "point";
                }
                tooltip.addPara("You have %s " + Misc.STORY + " " + points + ".", opad, Misc.getStoryOptionColor(), "" + sp);
            }
        });
        dialog.getOptionPanel().addOptionConfirmation(params.optionId, delegate);
        dialog.getOptionPanel().setStoryOptionParams(params.optionId, params, delegate);
        return true;
    }

    public static class BaseOptionStoryPointActionDelegate
    extends BaseStoryPointActionDelegate {
        protected Object optionId;
        protected float bonusXPFraction;
        protected InteractionDialogAPI dialog;
        protected int numPoints;
        protected String soundId;
        protected String logText;

        public BaseOptionStoryPointActionDelegate(InteractionDialogAPI dialog, StoryOptionParams params) {
            this.optionId = params.optionId;
            this.bonusXPFraction = Global.getSettings().getBonusXP(params.bonusXPID);
            this.dialog = dialog;
            this.numPoints = params.numPoints;
            this.soundId = params.soundId;
            this.logText = params.logText;
        }

        public void preConfirm() {
            if (this.dialog != null) {
                this.dialog.addOptionSelectedText(this.optionId, true);
            }
        }

        public void confirm() {
        }

        public void createDescription(TooltipMakerAPI info) {
            info.setParaInsigniaLarge();
            this.addActionCostSection(info);
            info.addSpacer(20.0f);
        }

        protected void addActionCostSection(TooltipMakerAPI info) {
            int sp = Global.getSector().getPlayerStats().getStoryPoints();
            float pad = -10.0f;
            float opad = 10.0f;
            int percent = Math.round(this.bonusXPFraction * 100.0f);
            if (this.numPoints == 1) {
                if (percent <= 0) {
                    info.addPara("This action requires a %s and does not grant any bonus experience.", pad, Misc.getStoryOptionColor(), Misc.STORY + " point");
                } else {
                    info.addPara("This action requires a %s and grants %s bonus experience.", pad, Misc.getStoryOptionColor(), Misc.STORY + " point", percent + "%");
                }
            } else if (percent <= 0) {
                info.addPara("This action requires %s and does not grant any bonus experience.", pad, Misc.getStoryOptionColor(), this.numPoints + " " + Misc.STORY + " points");
            } else {
                info.addPara("This action requires %s and grants %s bonus experience for each point.", pad, Misc.getStoryOptionColor(), this.numPoints + " " + Misc.STORY + " points", percent + "%");
            }
            if (sp <= 0) {
                info.addPara("No " + Misc.STORY + " points available", Misc.getNegativeHighlightColor(), opad);
            } else if (sp < this.numPoints) {
                String points = "points";
                if (sp == 1) {
                    points = "point";
                }
                info.addPara("Only %s " + Misc.STORY + " " + points + " available", opad, Misc.getNegativeHighlightColor(), Misc.getNegativeHighlightColor(), "" + sp);
            }
        }

        public float getBonusXPFraction() {
            return this.bonusXPFraction;
        }

        public String getConfirmSoundId() {
            String soundId = this.soundId;
            if ("leadership".equals(soundId)) {
                soundId = "ui_char_spent_story_point_leadership";
            }
            if ("combat".equals(soundId)) {
                soundId = "ui_char_spent_story_point_combat";
            }
            if ("industry".equals(soundId)) {
                soundId = "ui_char_spent_story_point_industry";
            }
            if ("technology".equals(soundId)) {
                soundId = "ui_char_spent_story_point_technology";
            }
            if ("general".equals(soundId)) {
                soundId = "ui_char_spent_story_point_combat";
            }
            if ("generic".equals(soundId)) {
                soundId = "ui_char_spent_story_point_combat";
            }
            return soundId;
        }

        public int getRequiredStoryPoints() {
            return this.numPoints;
        }

        public String getLogText() {
            return this.logText;
        }

        public TextPanelAPI getTextPanel() {
            if (this.dialog == null) {
                return null;
            }
            return this.dialog.getTextPanel();
        }

        public String getTitle() {
            return null;
        }

        public boolean withSPInfo() {
            return false;
        }
    }

    public static class StoryOptionParams {
        public Object optionId;
        public int numPoints;
        public String bonusXPID;
        public String soundId;
        public String logText;

        public StoryOptionParams(Object optionId, int numPoints, String bonusXPID, String soundId, String logText) {
            this.optionId = optionId;
            this.numPoints = numPoints;
            this.bonusXPID = bonusXPID;
            this.soundId = soundId;
            this.logText = logText;
        }
    }
}

