/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.GroundRaidObjectivesListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.graid.BaseGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.graid.GroundRaidObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRaidObjective
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String icon = params.get(0).getString(memoryMap);
        String name = params.get(1).getStringWithTokenReplacement(ruleId, dialog, memoryMap);
        MarketCMD.RaidDangerLevel danger = MarketCMD.RaidDangerLevel.valueOf(MarketCMD.RaidDangerLevel.class, params.get(2).getString(memoryMap));
        int xp = (int)params.get(3).getFloat(memoryMap);
        String trigger = params.get(4).getString(memoryMap);
        boolean showInCustomOnly = false;
        String tooltip = null;
        if (params.size() > 5) {
            if (params.size() > 6) {
                showInCustomOnly = params.get(5).getBoolean(memoryMap);
                tooltip = params.get(6).getStringWithTokenReplacement(params.get(5).getString(memoryMap), dialog, memoryMap);
            } else {
                String str = params.get(5).getString(memoryMap);
                if (str != null) {
                    if (str.toLowerCase().equals("true") || str.toLowerCase().equals("false")) {
                        showInCustomOnly = params.get(5).getBoolean(memoryMap);
                    } else {
                        tooltip = params.get(5).getStringWithTokenReplacement(params.get(5).getString(memoryMap), dialog, memoryMap);
                    }
                }
            }
        }
        SectorEntityToken entity = dialog.getInteractionTarget();
        MarketAPI market = entity.getMarket();
        new CustomRaidObjectiveAdder(market, entity, icon, name, trigger, xp, danger, showInCustomOnly, tooltip);
        return true;
    }

    public static class CustomRaidObjective
    extends BaseGroundRaidObjectivePluginImpl {
        public CustomRaidObjectiveAdder adder;

        public CustomRaidObjective(CustomRaidObjectiveAdder adder) {
            super(adder.market, null);
            this.adder = adder;
            int marines = adder.danger.marineTokens;
            this.setMarinesRequired(marines);
        }

        public boolean withContinueBeforeResult() {
            return true;
        }

        public String getQuantityString(int marines) {
            return "";
        }

        public String getValueString(int marines) {
            return "";
        }

        public float getValueSortValue() {
            return super.getValueSortValue();
        }

        public int getCargoSpaceNeeded() {
            return 0;
        }

        public int getFuelSpaceNeeded() {
            return 0;
        }

        public int getProjectedCreditsValue() {
            return 0;
        }

        public MarketCMD.RaidDangerLevel getDangerLevel() {
            return this.adder.danger;
        }

        public int getValue(int marines) {
            return 0;
        }

        public float getQuantitySortValue() {
            float add = this.adder.name.hashCode();
            return 0.0f + add;
        }

        public String getName() {
            return this.adder.name;
        }

        public String getIconName() {
            return Global.getSettings().getSpriteName("raidObjectives", this.adder.icon);
        }

        public float getQuantity(int marines) {
            return 0.0f;
        }

        public int performRaid(CargoAPI loot, Random random, float lootMult, TextPanelAPI text) {
            return this.adder.xp;
        }

        public boolean hasTooltip() {
            return this.adder.tooltip != null;
        }

        public void createTooltip(TooltipMakerAPI t, boolean expanded) {
            t.addPara(this.adder.tooltip, 0.0f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CustomRaidObjectiveAdder
    implements EveryFrameScript,
    GroundRaidObjectivesListener {
        protected boolean done = false;
        public String icon;
        public String name;
        public String trigger;
        public String tooltip;
        public int xp = 0;
        public boolean showInCustomOnly;
        public MarketCMD.RaidDangerLevel danger;
        public MarketAPI market;
        public SectorEntityToken entity;

        public CustomRaidObjectiveAdder(MarketAPI market, SectorEntityToken entity, String icon, String name, String trigger, int xp, MarketCMD.RaidDangerLevel danger, boolean showInCustomOnly, String tooltip) {
            this.market = market;
            this.entity = entity;
            this.icon = icon;
            this.name = name;
            this.trigger = trigger;
            this.tooltip = tooltip;
            this.xp = xp;
            this.danger = danger;
            this.showInCustomOnly = showInCustomOnly;
            for (CustomRaidObjectiveAdder adder : Global.getSector().getListenerManager().getListeners(CustomRaidObjectiveAdder.class)) {
                if (!adder.name.equals(name) || !adder.trigger.equals(trigger)) continue;
                return;
            }
            Global.getSector().getListenerManager().addListener(this);
            Global.getSector().addScript(this);
        }

        @Override
        public void advance(float amount) {
            if (amount > 0.0f && !this.done) {
                for (CustomRaidObjectiveAdder adder : Global.getSector().getListenerManager().getListeners(CustomRaidObjectiveAdder.class)) {
                    if (!adder.name.equals(this.name) || !adder.trigger.equals(this.trigger)) continue;
                    Global.getSector().getListenerManager().removeListener(this);
                    this.done = true;
                    break;
                }
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }

        @Override
        public void modifyRaidObjectives(MarketAPI market, SectorEntityToken entity, List<GroundRaidObjectivePlugin> objectives, MarketCMD.RaidType type, int marineTokens, int priority) {
            String restrict;
            if (priority != 0) {
                return;
            }
            if (type == MarketCMD.RaidType.DISRUPT) {
                return;
            }
            if (type != MarketCMD.RaidType.CUSTOM_ONLY && this.showInCustomOnly) {
                return;
            }
            if (type == MarketCMD.RaidType.CUSTOM_ONLY && entity != null && entity.getMemoryWithoutUpdate().contains("$raidRestrictToTrigger") && (restrict = entity.getMemoryWithoutUpdate().getString("$raidRestrictToTrigger")) != null && !restrict.isEmpty() && !restrict.equals(this.trigger)) {
                return;
            }
            if (this.market != null && market == this.market || this.entity != null && entity == this.entity) {
                CustomRaidObjective custom = new CustomRaidObjective(this);
                objectives.add(custom);
            }
        }

        @Override
        public void reportRaidObjectivesAchieved(GroundRaidObjectivesListener.RaidResultData data, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
            boolean found = false;
            for (GroundRaidObjectivePlugin obj : data.objectives) {
                if (!(obj instanceof CustomRaidObjective)) continue;
                CustomRaidObjective custom = (CustomRaidObjective)obj;
                if (custom.adder != this) continue;
                found = true;
                break;
            }
            if (found) {
                this.advance(0.1f);
                dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$raidMarinesLost", data.marinesLost, 0.0f);
                FireAll.fire(null, dialog, memoryMap, this.trigger);
            }
        }
    }
}

