/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.GenericPluginManagerAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.BaseGenericPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.procgen.DefenderDataOverride;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.themes.MiscellaneousThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantOfficerGeneratorPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageEntityGeneratorOld;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalvageGenFromSeed
extends BaseCommandPlugin {
    public static final String DEFEATED_DERELICT_STR = "$defeatedDerelictStr";
    public static final float DEFEATED_TO_ADDED_FACTOR = 0.2f;
    public static final float DEFEATED_TO_QUALITY_FACTOR = 0.005f;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        SectorEntityToken entity = dialog.getInteractionTarget();
        String specId = entity.getCustomEntityType();
        if (specId == null || entity.getMemoryWithoutUpdate().contains("$salvageSpecId")) {
            specId = entity.getMemoryWithoutUpdate().getString("$salvageSpecId");
        }
        SalvageEntityGenDataSpec spec = SalvageEntityGeneratorOld.getSalvageSpec(specId);
        MemoryAPI memory = memoryMap.get("local");
        if (memoryMap.containsKey("entity")) {
            memory = memoryMap.get("entity");
        }
        long seed = memory.getLong("$salvageSeed");
        Random random = Misc.getRandom(seed, 0);
        DefenderDataOverride override = null;
        if (memory.contains("$salvageDOv")) {
            override = (DefenderDataOverride)memory.get("$salvageDOv");
        }
        Random fleetRandom = Misc.getRandom(seed, 1);
        float strength = spec.getMinStr() + (float)Math.round((spec.getMaxStr() - spec.getMinStr()) * fleetRandom.nextFloat());
        float prob = spec.getProbDefenders();
        if (override != null) {
            strength = override.minStr + (float)Math.round((override.maxStr - override.minStr) * fleetRandom.nextFloat());
            prob = override.probDefenders;
        }
        String factionId = entity.getFaction().getId();
        if (spec.getDefFaction() != null) {
            factionId = spec.getDefFaction();
        }
        if (override != null && override.defFaction != null) {
            factionId = override.defFaction;
        }
        SDMParams p = new SDMParams();
        p.entity = entity;
        p.factionId = factionId;
        SalvageDefenderModificationPlugin plugin = Global.getSector().getGenericPlugins().pickPlugin(SalvageDefenderModificationPlugin.class, p);
        if (plugin != null) {
            strength = plugin.getStrength(p, strength, random, override != null);
            prob = plugin.getProbability(p, prob, random, override != null);
        }
        float probStation = spec.getProbStation();
        if (override != null) {
            probStation = override.probStation;
        }
        String stationRole = null;
        if (fleetRandom.nextFloat() < probStation) {
            stationRole = spec.getStationRole();
            if (override != null && override.stationRole != null) {
                stationRole = override.stationRole;
            }
        }
        if (((int)strength > 0 || stationRole != null) && random.nextFloat() < prob && !memory.getBoolean("$defenderFleetDefeated")) {
            CampaignFleetAPI defenders;
            memory.set("$hasDefenders", true, 0.0f);
            if (!memory.contains("$defenderFleet") || DebugFlags.FORCE_REGEN_AUTOMATED_DEFENSES) {
                CampaignFleetAPI defenders2;
                float quality = spec.getDefQuality();
                if (plugin != null) {
                    quality = plugin.getQuality(p, quality, fleetRandom, override != null);
                }
                FleetParamsV3 fParams = new FleetParamsV3(null, null, factionId, Float.valueOf(quality), "patrolSmall", (int)strength, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                fParams.random = fleetRandom;
                FactionAPI faction = Global.getSector().getFaction(factionId);
                fParams.withOfficers = faction.getCustomBoolean("officersOnAutomatedDefenses");
                fParams.maxShipSize = (int)spec.getMaxDefenderSize();
                if (override != null) {
                    fParams.maxShipSize = override.maxDefenderSize;
                }
                if (plugin != null) {
                    fParams.maxShipSize = (int)plugin.getMaxSize(p, fParams.maxShipSize, random, override != null);
                }
                fParams.minShipSize = (int)spec.getMinDefenderSize();
                if (override != null) {
                    fParams.minShipSize = override.minDefenderSize;
                }
                if (plugin != null) {
                    fParams.minShipSize = (int)plugin.getMinSize(p, fParams.minShipSize, random, override != null);
                }
                if (!(defenders2 = FleetFactoryV3.createFleet(fParams)).isEmpty()) {
                    defenders2.getInflater().setRemoveAfterInflating(false);
                    defenders2.setName("Automated Defenses");
                    if (stationRole != null) {
                        defenders2.getFaction().pickShipAndAddToFleet(stationRole, FactionAPI.ShipPickParams.all(), defenders2, fleetRandom);
                        defenders2.getFleetData().sort();
                    }
                    defenders2.clearAbilities();
                    if (plugin != null) {
                        plugin.modifyFleet(p, defenders2, fleetRandom, override != null);
                    }
                    defenders2.getFleetData().sort();
                    memory.set("$defenderFleet", defenders2, 0.0f);
                } else {
                    memory.set("$hasDefenders", false, 0.0f);
                }
            }
            if ((defenders = memory.getFleet("$defenderFleet")) != null) {
                boolean hasStation = false;
                boolean hasNonStation = false;
                for (FleetMemberAPI member : defenders.getFleetData().getMembersListCopy()) {
                    if (member.isStation()) {
                        hasStation = true;
                        continue;
                    }
                    hasNonStation = true;
                }
                memory.set("$hasStation", hasStation, 0.0f);
                memory.set("$hasNonStation", hasNonStation, 0.0f);
                defenders.setLocation(entity.getLocation().x, entity.getLocation().y);
            }
        } else {
            memory.set("$hasDefenders", false, 0.0f);
            memory.set("$hasStation", false, 0.0f);
        }
        return true;
    }

    public static class SDMParams {
        public SectorEntityToken entity;
        public String factionId;
    }

    public static interface SalvageDefenderModificationPlugin
    extends GenericPluginManagerAPI.GenericPlugin {
        public float getStrength(SDMParams var1, float var2, Random var3, boolean var4);

        public float getProbability(SDMParams var1, float var2, Random var3, boolean var4);

        public float getQuality(SDMParams var1, float var2, Random var3, boolean var4);

        public float getMaxSize(SDMParams var1, float var2, Random var3, boolean var4);

        public float getMinSize(SDMParams var1, float var2, Random var3, boolean var4);

        public void modifyFleet(SDMParams var1, CampaignFleetAPI var2, Random var3, boolean var4);

        public void reportDefeated(SDMParams var1, SectorEntityToken var2, CampaignFleetAPI var3);
    }

    public static class SalvageDefenderModificationPluginImpl
    extends BaseGenericPlugin
    implements SalvageDefenderModificationPlugin {
        public float getStrength(SDMParams p, float strength, Random random, boolean withOverride) {
            if (withOverride) {
                return strength;
            }
            if ("derelict".equals(p.factionId)) {
                float bonus = Global.getSector().getMemoryWithoutUpdate().getFloat(SalvageGenFromSeed.DEFEATED_DERELICT_STR) * 0.2f;
                String type = p.entity.getCustomEntityType();
                float limit = 300.0f;
                if ("derelict_probe".equals(type)) {
                    limit = 60.0f;
                } else if ("derelict_survey_ship".equals(type)) {
                    limit = 90.0f;
                } else if ("derelict_mothership".equals(type) || "derelict_cryosleeper".equals(type)) {
                    limit = 150.0f;
                }
                if (bonus > limit) {
                    bonus = limit;
                }
                return strength + (float)((int)bonus);
            }
            return strength;
        }

        public float getMinSize(SDMParams p, float minSize, Random random, boolean withOverride) {
            if (withOverride) {
                return minSize;
            }
            return minSize;
        }

        public float getMaxSize(SDMParams p, float maxSize, Random random, boolean withOverride) {
            if (withOverride) {
                return maxSize;
            }
            if ("derelict".equals(p.factionId)) {
                float bonus = Global.getSector().getMemoryWithoutUpdate().getFloat(SalvageGenFromSeed.DEFEATED_DERELICT_STR) * 0.2f;
                String type = p.entity.getCustomEntityType();
                float bonusSize = 1.0f;
                if ("derelict_probe".equals(type) && bonus >= 5.0f) {
                    bonusSize = 2.0f;
                }
                return Math.max(maxSize, bonusSize);
            }
            return maxSize;
        }

        public float getProbability(SDMParams p, float probability, Random random, boolean withOverride) {
            if (withOverride) {
                return probability;
            }
            if ("derelict".equals(p.factionId)) {
                String type = p.entity.getCustomEntityType();
                float limit = 0.0f;
                if ("derelict_probe".equals(type)) {
                    limit = 60.0f;
                } else if ("derelict_survey_ship".equals(type)) {
                    limit = 90.0f;
                }
                if (limit <= 0.0f || probability >= 1.0f) {
                    return probability;
                }
                float bonus = Global.getSector().getMemoryWithoutUpdate().getFloat(SalvageGenFromSeed.DEFEATED_DERELICT_STR) * 0.2f;
                if (bonus > limit) {
                    bonus = limit;
                }
                return probability * (1.0f - 0.5f * bonus / limit);
            }
            return probability;
        }

        public void reportDefeated(SDMParams p, SectorEntityToken entity, CampaignFleetAPI fleet) {
            if ("derelict".equals(p.factionId)) {
                float total = Global.getSector().getMemoryWithoutUpdate().getFloat(SalvageGenFromSeed.DEFEATED_DERELICT_STR);
                for (FleetMemberAPI member : Misc.getSnapshotMembersLost(fleet)) {
                    total += (float)member.getFleetPointCost();
                }
                Global.getSector().getMemoryWithoutUpdate().set(SalvageGenFromSeed.DEFEATED_DERELICT_STR, Float.valueOf(total));
            }
        }

        public void modifyFleet(SDMParams p, CampaignFleetAPI fleet, Random random, boolean withOverride) {
            block15: {
                block17: {
                    block16: {
                        block14: {
                            if (!"omega".equals(fleet.getFaction().getId())) break block14;
                            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                                ShipVariantAPI copy = member.getVariant().clone();
                                member.setVariant(copy, false, false);
                                copy.addTag("ship_limited_tooltip");
                            }
                            SalvageEntityGenDataSpec.DropData d = new SalvageEntityGenDataSpec.DropData();
                            d.chances = 5;
                            d.maxChances = 7;
                            d.group = "omega_weapons_small";
                            fleet.addDropRandom(d);
                            d = new SalvageEntityGenDataSpec.DropData();
                            d.chances = 3;
                            d.maxChances = 4;
                            d.group = "omega_weapons_medium";
                            fleet.addDropRandom(d);
                            long seed = Misc.getSalvageSeed(p.entity);
                            fleet.getMemoryWithoutUpdate().set("$salvageSeed", Misc.getRandom(seed, 11).nextLong());
                            break block15;
                        }
                        if (!"alpha_site_weapons_cache".equals(p.entity.getCustomEntityType())) break block16;
                        AICoreOfficerPlugin plugin = Misc.getAICoreOfficerPlugin("alpha_core");
                        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                            PersonAPI person = plugin.createPerson("alpha_core", fleet.getFaction().getId(), random);
                            member.setCaptain(person);
                            RemnantOfficerGeneratorPlugin.integrateAndAdaptCoreForAIFleet(member);
                            member.getRepairTracker().setCR(member.getRepairTracker().getMaxCR());
                        }
                        if (!(fleet.getInflater() instanceof DefaultFleetInflater)) break block15;
                        DefaultFleetInflater dfi = (DefaultFleetInflater)fleet.getInflater();
                        ((DefaultFleetInflaterParams)dfi.getParams()).allWeapons = true;
                        break block15;
                    }
                    if (p.entity == null || !p.entity.getMemoryWithoutUpdate().contains(MiscellaneousThemeGenerator.PLANETARY_SHIELD_PLANET)) break block17;
                    Object flagship = null;
                    for (ShipRolePick pick : fleet.getFaction().pickShip("combatCapital", FactionAPI.ShipPickParams.all(), null, random)) {
                        Object member;
                        flagship = member = fleet.getFleetData().addFleetMember(pick.variantId);
                        member.setShipName(fleet.getFaction().pickRandomShipName(random));
                    }
                    AICoreOfficerPlugin plugin = Misc.getAICoreOfficerPlugin("alpha_core");
                    for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                        member.getRepairTracker().setCR(member.getRepairTracker().getMaxCR());
                        member.setFlagship(member == flagship);
                        PersonAPI person = plugin.createPerson("alpha_core", fleet.getFaction().getId(), random);
                        member.setCaptain(person);
                        RemnantOfficerGeneratorPlugin.integrateAndAdaptCoreForAIFleet(member);
                    }
                    PersonAPI person = plugin.createPerson("alpha_core", fleet.getFaction().getId(), random);
                    fleet.setCommander(person);
                    fleet.getFlagship().setCaptain(person);
                    RemnantOfficerGeneratorPlugin.integrateAndAdaptCoreForAIFleet(fleet.getFlagship());
                    if (!(fleet.getInflater() instanceof DefaultFleetInflater)) break block15;
                    DefaultFleetInflater dfi = (DefaultFleetInflater)fleet.getInflater();
                    ((DefaultFleetInflaterParams)dfi.getParams()).allWeapons = true;
                    break block15;
                }
                if ("derelict_cryosleeper".equals(p.entity.getCustomEntityType())) {
                    fleet.getFleetData().clear();
                    for (ShipRolePick pick : fleet.getFaction().pickShip("combatCapital", FactionAPI.ShipPickParams.all(), null, random)) {
                        fleet.getFleetData().addFleetMember(pick.variantId);
                    }
                    AICoreOfficerPlugin plugin = Misc.getAICoreOfficerPlugin("alpha_core");
                    PersonAPI person = plugin.createPerson("alpha_core", fleet.getFaction().getId(), random);
                    person.setPortraitSprite(fleet.getFaction().createRandomPerson().getPortraitSprite());
                    fleet.setCommander(person);
                    fleet.getFlagship().setCaptain(person);
                    RemnantOfficerGeneratorPlugin.integrateAndAdaptCoreForAIFleet(fleet.getFlagship());
                    for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                        member.getRepairTracker().setCR(member.getRepairTracker().getMaxCR());
                    }
                } else if ("derelict_mothership".equals(p.entity.getCustomEntityType()) || "derelict_survey_ship".equals(p.entity.getCustomEntityType()) || "derelict_probe".equals(p.entity.getCustomEntityType())) {
                    float bonus = Global.getSector().getMemoryWithoutUpdate().getFloat(SalvageGenFromSeed.DEFEATED_DERELICT_STR) * 0.2f;
                    float coreMult = Math.max(0.0f, bonus / 100.0f - 0.1f);
                    if (coreMult > 1.0f) {
                        coreMult = 1.0f;
                    }
                    if (coreMult > 0.0f) {
                        RemnantOfficerGeneratorPlugin gen = new RemnantOfficerGeneratorPlugin(true, coreMult);
                        if (coreMult >= 1.0f) {
                            gen.setForceIntegrateCores(true);
                        }
                        gen.addCommanderAndOfficers(fleet, null, random);
                    }
                    for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                        if (member.isStation()) {
                            AICoreOfficerPlugin plugin = Misc.getAICoreOfficerPlugin("alpha_core");
                            PersonAPI person = plugin.createPerson("alpha_core", fleet.getFaction().getId(), random);
                            person.setPortraitSprite(fleet.getFaction().createRandomPerson().getPortraitSprite());
                            member.setCaptain(person);
                            RemnantOfficerGeneratorPlugin.integrateAndAdaptCoreForAIFleet(member);
                        }
                        member.getRepairTracker().setCR(member.getRepairTracker().getMaxCR());
                    }
                }
            }
        }

        public int getHandlingPriority(Object params) {
            if (!(params instanceof SDMParams)) {
                return 0;
            }
            SDMParams p = (SDMParams)params;
            if (p.entity != null && p.entity.getMemoryWithoutUpdate().contains(MiscellaneousThemeGenerator.PLANETARY_SHIELD_PLANET)) {
                return 1;
            }
            if ("derelict".equals(p.factionId)) {
                return 1;
            }
            if ("omega".equals(p.factionId)) {
                return 1;
            }
            if ("remnant".equals(p.factionId)) {
                return 1;
            }
            return -1;
        }

        public float getQuality(SDMParams p, float quality, Random random, boolean withOverride) {
            if (withOverride) {
                return quality;
            }
            if ("derelict".equals(p.factionId)) {
                float bonus = Global.getSector().getMemoryWithoutUpdate().getFloat(SalvageGenFromSeed.DEFEATED_DERELICT_STR) * 0.005f;
                return quality + bonus;
            }
            return quality;
        }
    }
}

