/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;

public class SleeperPodsSpecial
extends BaseSalvageSpecial {
    public static final String OPEN = "open";
    public static final String NOT_NOW = "not_now";
    private SleeperPodsSpecialData data;
    private int quantity = 1;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        SleeperSpecialType type;
        CampaignFleetAPI player;
        int crewBerths;
        super.init(dialog, specialData);
        this.data = (SleeperPodsSpecialData)specialData;
        this.quantity = this.data.min + this.random.nextInt(this.data.max - this.data.min + 1);
        if (this.data.type == SleeperSpecialType.ORGANS && this.quantity < 1) {
            this.quantity = 1;
        }
        if ((crewBerths = (int)((player = Global.getSector().getPlayerFleet()).getCargo().getMaxPersonnel() - (float)player.getCargo().getTotalPersonnel())) < 0) {
            crewBerths = 0;
        }
        if ((type = this.data.type) == SleeperSpecialType.CREW) {
            this.quantity = Math.min(crewBerths, this.quantity);
        }
        if (type == SleeperSpecialType.MARINES) {
            this.quantity = Math.min(crewBerths, this.quantity);
        }
        if (type == SleeperSpecialType.ADMIN || type == SleeperSpecialType.OFFICER) {
            this.quantity = 1;
        }
        switch (type) {
            case CREW: {
                this.initCrew();
                break;
            }
            case MARINES: {
                this.initMarines();
                break;
            }
            case OFFICER: {
                this.initOfficer();
                break;
            }
            case ADMIN: {
                this.initOfficer();
                break;
            }
            case ORGANS: {
                this.initOrgans();
            }
        }
    }

    protected void initCrew() {
        if (this.quantity <= 0) {
            this.initNothing();
        } else {
            this.addText("While making a preliminary assessment, your salvage crews find some occupied sleeper pods still running on backup power.");
            this.options.clearOptions();
            this.options.addOption("Attempt to open the pods", OPEN);
            this.options.addOption("Not now", NOT_NOW);
        }
    }

    protected void initMarines() {
        if (this.quantity <= 0) {
            this.initNothing();
        } else {
            this.addText("While making a preliminary assessment, your salvage crews find some occupied mil-grade sleeper pods still running on backup power.");
            this.options.clearOptions();
            this.options.addOption("Attempt to open the pods", OPEN);
            this.options.addOption("Not now", NOT_NOW);
        }
    }

    protected void initOfficer() {
        if (this.quantity <= 0) {
            this.initNothing();
        } else {
            this.addText("While making a preliminary assessment, your salvage crews find a single occupied sleeper pod still running on backup power.");
            this.options.clearOptions();
            this.options.addOption("Attempt to open the pod", OPEN);
            this.options.addOption("Not now", NOT_NOW);
        }
    }

    protected void initOrgans() {
        if (this.quantity <= 0) {
            this.initNothing();
        } else {
            this.addText("While making a preliminary assessment, your salvage crews find some occupied sleeper pods still running on backup power.");
            this.options.clearOptions();
            this.options.addOption("Attempt to open the pods", OPEN);
            this.options.addOption("Not now", NOT_NOW);
        }
    }

    public void optionSelected(String optionText, Object optionData) {
        if (OPEN.equals(optionData)) {
            switch (this.data.type) {
                case CREW: {
                    this.addText("One by one, the pods begin to open as the thawing process completes. Most of the occupants come through alive, if somewhat dazed.");
                    this.playerFleet.getCargo().addCommodity("crew", this.quantity);
                    AddRemoveCommodity.addCommodityGainText("crew", this.quantity, this.text);
                    break;
                }
                case MARINES: {
                    this.addText("One by one, the pods begin to open as the thawing process completes. Most of the occupants come through alive, if somewhat dazed.");
                    this.playerFleet.getCargo().addCommodity("marines", this.quantity);
                    AddRemoveCommodity.addCommodityGainText("marines", this.quantity, this.text);
                    break;
                }
                case OFFICER: {
                    this.addText("The thawing process completes, and the pod opens. It contains an experienced officer, who joins you out of gratitude for being rescued.");
                    this.playerFleet.getFleetData().addOfficer(this.data.officer);
                    AddRemoveCommodity.addOfficerGainText(this.data.officer, this.text);
                    break;
                }
                case ADMIN: {
                    this.addText("The thawing process completes, and the pod opens. It contains an experienced planetary administrator, who joins you out of gratitude for being rescued.");
                    Global.getSector().getCharacterData().addAdmin(this.data.officer);
                    AddRemoveCommodity.addAdminGainText(this.data.officer, this.text);
                    break;
                }
                case ORGANS: {
                    this.addText("One by one, the pods begin to open as the thawing process completes. Unfortunately, it's been too long, or something went wrong along the way, and there are no survivors - at least, not with any brain activity.");
                    this.playerFleet.getCargo().addCommodity("organs", this.quantity);
                    AddRemoveCommodity.addCommodityGainText("organs", this.quantity, this.text);
                }
            }
            this.setDone(true);
            this.setShowAgain(false);
        } else if (NOT_NOW.equals(optionData)) {
            this.setDone(true);
            this.setEndWithContinue(false);
            this.setShowAgain(true);
        }
    }

    public static class SleeperPodsSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public SleeperSpecialType type;
        public int min;
        public int max;
        public PersonAPI officer;

        public SleeperPodsSpecialData(SleeperSpecialType type, PersonAPI officer) {
            this.type = type;
            this.officer = officer;
            this.max = 1;
            this.min = 1;
        }

        public SleeperPodsSpecialData(SleeperSpecialType type, int min, int max) {
            this.type = type;
            this.min = min;
            this.max = max;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new SleeperPodsSpecial();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SleeperSpecialType {
        CREW,
        MARINES,
        OFFICER,
        ADMIN,
        ORGANS;

    }
}

