/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.MarketConditionSpecAPI;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.DerelictThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.plugins.SurveyPlugin;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;

public class SurveyDataSpecial
extends BaseSalvageSpecial {
    public static float MAX_RANGE = 16000.0f;
    private SurveyDataSpecialData data;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        StarSystemAPI system;
        super.init(dialog, specialData);
        this.data = (SurveyDataSpecialData)specialData;
        if (this.data.type == SurveyDataSpecialType.AUTO_PICK || this.data.type == SurveyDataSpecialType.AUTO_PICK_NOT_SYSTEM) {
            List<StarSystemAPI> systems;
            WeightedRandomPicker<SurveyDataSpecialType> picker = new WeightedRandomPicker<SurveyDataSpecialType>(this.random);
            picker.add(SurveyDataSpecialType.PLANET_INTERESTING_PROPERTY, 50.0f);
            picker.add(SurveyDataSpecialType.PLANET_SURVEY_DATA, 20.0f);
            if (this.data.type == SurveyDataSpecialType.AUTO_PICK) {
                picker.add(SurveyDataSpecialType.SYSTEM_PRELIMINARY_SURVEY, 5.0f);
            }
            this.data.type = (SurveyDataSpecialType)((Object)picker.pick());
            this.data.entityId = null;
            if (this.data.type == SurveyDataSpecialType.PLANET_INTERESTING_PROPERTY) {
                systems = Misc.getSystemsInRange(this.entity, null, true, MAX_RANGE);
                PlanetAPI planet = DerelictThemeGenerator.findInterestingPlanet(systems, null, false, this.data.includeRuins, this.random);
                String conditionId = DerelictThemeGenerator.getInterestingCondition(planet, this.data.includeRuins);
                if (planet != null && conditionId != null) {
                    this.data.entityId = planet.getId();
                    this.data.secondaryId = conditionId;
                }
            } else if (this.data.type == SurveyDataSpecialType.PLANET_SURVEY_DATA) {
                systems = Misc.getSystemsInRange(this.entity, null, true, MAX_RANGE);
                PlanetAPI planet = DerelictThemeGenerator.findInterestingPlanet(systems, null, false, this.data.includeRuins, this.random);
                if (planet != null) {
                    this.data.entityId = planet.getId();
                }
            } else if (this.data.type == SurveyDataSpecialType.SYSTEM_PRELIMINARY_SURVEY && (system = DerelictThemeGenerator.findNearbySystem(this.entity, null, this.random, MAX_RANGE)) != null) {
                this.data.entityId = system.getId();
            }
        }
        if (this.data.entityId != null) {
            SectorEntityToken entity = Global.getSector().getEntityById(this.data.entityId);
            system = Global.getSector().getStarSystem(this.data.entityId);
            if (entity == null && system == null) {
                this.data.entityId = null;
                this.data.type = SurveyDataSpecialType.SCRAMBLED;
            }
        } else {
            this.data.type = SurveyDataSpecialType.SCRAMBLED;
        }
        switch (this.data.type) {
            case SCRAMBLED: {
                this.initNothing();
                break;
            }
            case PLANET_INTERESTING_PROPERTY: {
                this.initInterestingProperty();
                break;
            }
            case PLANET_SURVEY_DATA: {
                this.initPlanetSurveyData();
                break;
            }
            case SYSTEM_PRELIMINARY_SURVEY: {
                this.initPreliminarySystemSurvey();
            }
        }
    }

    public void initNothing() {
        this.addText("The $shortName's memory banks have been scrubbed clean by hard radiation, and the systems are largely inert and non-functional.");
        this.setDone(true);
    }

    protected void initInterestingProperty() {
        if (this.data.entityId == null || this.data.secondaryId == null) {
            this.initNothing();
            return;
        }
        PlanetAPI planet = (PlanetAPI)Global.getSector().getEntityById(this.data.entityId);
        if (planet.getMarket() != null && planet.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.FULL) {
            this.initNothing();
            return;
        }
        String text1 = this.getString("The $shortName's memory banks are partially accessible, and the data therein ");
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (debris) {
            text1 = "Your salvage crews find a memory bank in the debris. The data therein ";
        }
        String desc = "";
        String world = String.valueOf(planet.getSpec().getAOrAn()) + " " + planet.getTypeNameWithWorld().toLowerCase();
        String loc = BreadcrumbSpecial.getLocatedString(planet, true);
        loc = loc.replaceFirst("located ", "");
        String subject = "";
        MarketConditionSpecAPI spec = Global.getSettings().getMarketConditionSpec(this.data.secondaryId);
        if (spec.getId().equals("habitable")) {
            subject = "Habitable World";
            desc = "points to the existence of " + world + " with a low hazard rating " + loc;
        } else {
            subject = String.valueOf(Misc.ucFirst(spec.getName())) + " Location";
            desc = "contained information about " + spec.getName().toLowerCase() + " on " + world + " " + loc;
        }
        desc = String.valueOf(desc) + ".";
        this.addText(String.valueOf(text1) + desc);
        String text1ForIntel = "While exploring $aOrAn $nameInText, your crews found partially accessible memory banks that ";
        BreadcrumbIntel intel = new BreadcrumbIntel(this.entity, planet);
        intel.setTitle(this.getString(subject));
        intel.setText(this.getString(String.valueOf(text1ForIntel) + desc));
        Global.getSector().getIntelManager().addIntel(intel, false, this.text);
        this.setDone(true);
    }

    protected void initPlanetSurveyData() {
        MarketConditionSpecAPI spec;
        String conditionId;
        if (this.data.entityId == null) {
            this.initNothing();
            return;
        }
        PlanetAPI planet = (PlanetAPI)Global.getSector().getEntityById(this.data.entityId);
        if (planet.getMarket() != null && planet.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.FULL) {
            this.initNothing();
            return;
        }
        String name = planet.getName();
        String world = String.valueOf(planet.getSpec().getAOrAn()) + " " + planet.getTypeNameWithWorld().toLowerCase();
        String loc = BreadcrumbSpecial.getLocatedString(planet, true);
        loc = loc.replaceFirst("located ", "");
        String text1 = "The $shortName's memory banks are partially accessible, and contain full survey data for " + name + ", " + world + " located " + loc + ".";
        String text1ForIntel = "While exploring $aOrAn $nameInText, your crews found partially accessible memory banks that contain full survey data for " + name + ", " + world + " located " + loc + ".";
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (debris) {
            text1 = "Your salvage crews find a functional memory bank in the debris. It contains full survey data for " + name + ", " + world + " located " + loc + ".";
        }
        if ((conditionId = DerelictThemeGenerator.getInterestingCondition(planet, this.data.includeRuins)) != null && (spec = Global.getSettings().getMarketConditionSpec(conditionId)) != null) {
            text1 = String.valueOf(text1) + " The world is notable for ";
            text1ForIntel = String.valueOf(text1ForIntel) + " The world is notable for ";
            if (conditionId.equals("habitable")) {
                text1 = String.valueOf(text1) + "being habitable.";
                text1ForIntel = String.valueOf(text1ForIntel) + "being habitable.";
            } else {
                text1 = String.valueOf(text1) + "having " + spec.getName().toLowerCase() + ".";
                text1ForIntel = String.valueOf(text1ForIntel) + "having " + spec.getName().toLowerCase() + ".";
            }
        }
        String subject = "Survey Data for " + name;
        this.addText(text1);
        Misc.setFullySurveyed(planet.getMarket(), null, false);
        Misc.addSurveyDataFor(planet, this.text);
        SurveyPlugin plugin = (SurveyPlugin)Global.getSettings().getNewPluginInstance("surveyPlugin");
        plugin.init(Global.getSector().getPlayerFleet(), planet);
        long xp = plugin.getXP();
        if (xp > 0L) {
            Global.getSector().getPlayerPerson().getStats().addXP(xp, this.text);
        }
        BreadcrumbIntel intel = new BreadcrumbIntel(this.entity, planet);
        intel.setTitle(this.getString(subject));
        intel.setText(this.getString(text1ForIntel));
        intel.setShowSpecificEntity(true);
        Global.getSector().getIntelManager().addIntel(intel, false, this.text);
        this.setDone(true);
    }

    protected void initPreliminarySystemSurvey() {
        if (this.data.entityId == null) {
            this.initNothing();
            return;
        }
        StarSystemAPI system = Global.getSector().getStarSystem(this.data.entityId);
        if (system == null) {
            this.initNothing();
            return;
        }
        String name = system.getNameWithLowercaseType();
        String text1 = "The $shortName's memory banks are partially accessible, and contain complete preliminary survey data for the " + name + ".";
        String text1ForIntel = "While exploring $aOrAn $nameInText, your crews found partially accessible memory banks that contain complete preliminary survey data for the " + name + ".";
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (debris) {
            text1 = "Your salvage crews find a functional memory bank in the debris. It contains complete preliminary survey data for the " + name + ".";
        }
        String subject = "Preliminary Survey of the " + system.getName();
        this.addText(text1);
        String data = "";
        Highlights h = new Highlights();
        for (PlanetAPI planet : system.getPlanets()) {
            if (planet.isStar() || planet.getMarket() == null || !planet.getMarket().isPlanetConditionMarketOnly() || planet.getMarket().getSurveyLevel().ordinal() > MarketAPI.SurveyLevel.PRELIMINARY.ordinal()) continue;
            String curr = String.valueOf(planet.getName()) + ", " + planet.getTypeNameWithWorld().toLowerCase();
            data = String.valueOf(data) + "    " + curr + "\n";
            h.append(curr, planet.getSpec().getIconColor());
            planet.getMarket().setSurveyLevel(MarketAPI.SurveyLevel.PRELIMINARY);
        }
        if (!data.isEmpty()) {
            this.text.setFontSmallInsignia();
            this.text.addParagraph("Preliminary survey data for:", Misc.getTooltipTitleAndLightHighlightColor());
            data = "    " + data.trim();
            this.text.addParagraph(data);
            this.text.setHighlightsInLastPara(h);
            this.text.setFontInsignia();
            BreadcrumbIntel intel = new BreadcrumbIntel(this.entity, system.getCenter());
            intel.setTitle(this.getString(subject));
            intel.setText(this.getString(text1ForIntel));
            Global.getSector().getIntelManager().addIntel(intel, false, this.text);
        } else {
            this.text.addParagraph("However, you've already acquired this data through other means.");
        }
        this.setDone(true);
    }

    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    public static class SurveyDataSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public SurveyDataSpecialType type = null;
        public String entityId = null;
        public String secondaryId = null;
        public boolean includeRuins = true;

        public SurveyDataSpecialData(SurveyDataSpecialType type) {
            this.type = type;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new SurveyDataSpecial();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SurveyDataSpecialType {
        SCRAMBLED,
        PLANET_INTERESTING_PROPERTY,
        PLANET_SURVEY_DATA,
        SYSTEM_PRELIMINARY_SURVEY,
        AUTO_PICK,
        AUTO_PICK_NOT_SYSTEM;

    }
}

