/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantSeededFleetManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class TransmitterTrapSpecial
extends BaseSalvageSpecial {
    private TransmitterTrapSpecialData data;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        super.init(dialog, specialData);
        this.data = (TransmitterTrapSpecialData)specialData;
        this.initEntityLocation();
    }

    private void initEntityLocation() {
        if (this.random.nextFloat() > this.data.prob) {
            if (this.random.nextFloat() > 0.5f) {
                this.addText("Your salvage crews discover a transmitter set to send a signal when tripped by an alarm system, but it doesn't appear to be functional. Closer examination indicates it was probably set many cycles ago.");
            } else {
                this.addText("Your salvage crews discover a transmitter set to send a signal when tripped by an alarm system. The alarm went off as intended, but the transmitter was fried by a power surge before it could do its job.");
            }
            this.setDone(true);
            this.setEndWithContinue(true);
            this.setShowAgain(false);
            return;
        }
        if (this.entity instanceof PlanetAPI) {
            this.addText("As your salvage crews begin their work, a transmitter hidden somewhere planetside sends out an encrypted, broadwave signal. Whatever destination it's meant for, it has to be nearby.");
        } else {
            this.addText("As your salvage crews begin their work, a transmitter inside the $shortName sends out an encrypted, broadwave signal. Whatever destination it's meant for, it has to be nearby.");
        }
        this.transmitterActivated();
        this.setDone(true);
        this.setEndWithContinue(true);
        this.setShowAgain(false);
    }

    public void transmitterActivated() {
        if (this.data == null) {
            return;
        }
        if (this.entity == null) {
            return;
        }
        if (this.data.fleetId != null) {
            SectorEntityToken found = Global.getSector().getEntityById(this.data.fleetId);
            if (found instanceof CampaignFleetAPI) {
                CampaignFleetAPI fleet = (CampaignFleetAPI)found;
                FleetMemberAPI flagship = fleet.getFlagship();
                boolean makeAggressive = false;
                if (flagship != null) {
                    makeAggressive = flagship.getVariant().hasHullMod("automated");
                }
                TransmitterTrapSpecial.makeFleetInterceptPlayer(fleet, makeAggressive, true, 30.0f);
            }
            return;
        }
        if (this.data.useAllFleetsInRange != null && this.data.useAllFleetsInRange.booleanValue()) {
            boolean foundSomeFleets = false;
            for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
                float dist;
                if (this.data.nearbyFleetFaction != null && !this.data.nearbyFleetFaction.equals(fleet.getFaction().getId()) || fleet.isStationMode() || fleet.getMemoryWithoutUpdate().is("$isTradeFleet", true) || !((dist = Misc.getDistance(fleet.getLocation(), this.entity.getLocation())) < this.data.maxRange)) continue;
                FleetMemberAPI flagship = fleet.getFlagship();
                boolean makeAggressive = false;
                if (flagship != null) {
                    makeAggressive = flagship.getVariant().hasHullMod("automated");
                }
                TransmitterTrapSpecial.makeFleetInterceptPlayer(fleet, makeAggressive, true, 30.0f);
                foundSomeFleets = true;
            }
            if (foundSomeFleets) {
                return;
            }
        }
        if (this.data.useClosestFleetInRange != null && this.data.useClosestFleetInRange.booleanValue()) {
            CampaignFleetAPI closest = null;
            float minDist = Float.MAX_VALUE;
            for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
                float dist;
                if (this.data.nearbyFleetFaction != null && !this.data.nearbyFleetFaction.equals(fleet.getFaction().getId()) || fleet.isStationMode() || fleet.getMemoryWithoutUpdate().is("$isTradeFleet", true) || !((dist = Misc.getDistance(fleet.getLocation(), this.entity.getLocation())) < this.data.maxRange) || !(dist < minDist)) continue;
                closest = fleet;
                minDist = dist;
            }
            if (closest != null) {
                FleetMemberAPI flagship = closest.getFlagship();
                boolean makeAggressive = false;
                if (flagship != null) {
                    makeAggressive = flagship.getVariant().hasHullMod("automated");
                }
                TransmitterTrapSpecial.makeFleetInterceptPlayer(closest, makeAggressive, true, 30.0f);
                return;
            }
        }
        if (this.data.params != null) {
            CampaignFleetAPI fleet = FleetFactoryV3.createFleet(this.data.params);
            if (fleet == null || fleet.isEmpty()) {
                return;
            }
            if ("remnant".equals(fleet.getFaction().getId())) {
                RemnantSeededFleetManager.initRemnantFleetProperties(null, fleet, false);
            } else {
                fleet.setTransponderOn(false);
                fleet.getMemoryWithoutUpdate().set("$isPirate", true);
                Misc.makeNoRepImpact(fleet, "tTrap");
            }
            float range = this.data.minRange + this.random.nextFloat() * (this.data.maxRange - this.data.minRange);
            Vector2f loc = Misc.getPointAtRadius(this.entity.getLocation(), range);
            this.entity.getContainingLocation().addEntity(fleet);
            fleet.setLocation(loc.x, loc.y);
            FleetMemberAPI flagship = fleet.getFlagship();
            boolean makeAggressive = false;
            if (flagship != null) {
                makeAggressive = flagship.getVariant().hasHullMod("automated");
            }
            TransmitterTrapSpecial.makeFleetInterceptPlayer(fleet, makeAggressive, true, 30.0f);
            Misc.giveStandardReturnToSourceAssignments(fleet, false);
            return;
        }
    }

    public static void makeFleetInterceptPlayer(CampaignFleetAPI fleet, boolean makeAggressive, boolean makeLowRepImpact, float interceptDays) {
        TransmitterTrapSpecial.makeFleetInterceptPlayer(fleet, makeAggressive, makeLowRepImpact, true, interceptDays);
    }

    public static void makeFleetInterceptPlayer(CampaignFleetAPI fleet, boolean makeAggressive, boolean makeLowRepImpact, boolean makeHostile, float interceptDays) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (fleet.getAI() == null) {
            fleet.setAI(Global.getFactory().createFleetAI(fleet));
            fleet.setLocation(fleet.getLocation().x, fleet.getLocation().y);
        }
        if (makeAggressive) {
            float expire2 = fleet.getMemoryWithoutUpdate().getExpire("$cfai_makeAggressive");
            fleet.getMemoryWithoutUpdate().set("$cfai_makeAggressive", true, Math.max(expire2, interceptDays));
            fleet.getMemoryWithoutUpdate().set("$cfai_makeAggressiveLastsOneBattle", true, Math.max(expire2, interceptDays));
        }
        if (makeHostile) {
            fleet.getMemoryWithoutUpdate().unset("$cfai_makeAllowDisengage");
            fleet.getMemoryWithoutUpdate().set("$cfai_makeHostile", true, interceptDays);
        }
        fleet.getMemoryWithoutUpdate().set("$ai_placeToLook", new Vector2f((ReadableVector2f)playerFleet.getLocation()), interceptDays);
        if (makeLowRepImpact) {
            Misc.makeLowRepImpact(fleet, "ttSpecial");
        }
        if (fleet.getAI() instanceof ModularFleetAIAPI) {
            ((ModularFleetAIAPI)fleet.getAI()).getTacticalModule().setTarget(playerFleet);
        }
        fleet.addAssignmentAtStart(FleetAssignment.INTERCEPT, playerFleet, interceptDays, null);
    }

    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    public static void main(String[] args) {
        Boolean b = null;
        System.out.println(b);
    }

    public static class TransmitterTrapSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public float prob = 0.5f;
        public String fleetId;
        public String nearbyFleetFaction = null;
        public Boolean useClosestFleetInRange = null;
        public Boolean useAllFleetsInRange = null;
        public FleetParamsV3 params;
        public float minRange = 2500.0f;
        public float maxRange = 5000.0f;

        public TransmitterTrapSpecialData() {
        }

        public TransmitterTrapSpecialData(FleetParamsV3 params) {
            this.params = params;
        }

        public TransmitterTrapSpecialData(float prob, FleetParamsV3 params) {
            this.prob = prob;
            this.params = params;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new TransmitterTrapSpecial();
        }
    }
}

