/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CustomSkillDescription;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.hullmods.Automated;
import com.fs.starfarer.api.ui.BaseTooltipCreator;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSkillEffectDescription
implements CustomSkillDescription {
    public static float TOOLTIP_WIDTH = 450.0f;
    public static float FIGHTER_BAYS_THRESHOLD = 8.0f;
    public static float OP_THRESHOLD = 1000.0f;
    public static float OP_LOW_THRESHOLD = 500.0f;
    public static float OP_ALL_LOW_THRESHOLD = 500.0f;
    public static float OP_ALL_THRESHOLD = 1000.0f;
    public static float PHASE_OP_THRESHOLD = 150.0f;
    public static float MILITARIZED_OP_THRESHOLD = 50.0f;
    public static float AUTOMATED_POINTS_THRESHOLD = 200.0f;
    public static boolean USE_RECOVERY_COST = true;
    public static String RECOVERY_COST = "deployment point cost";
    protected Color tc;
    protected Color dtc;
    protected Color hc;
    protected Color dhc;
    protected String indent;
    protected int alpha;

    static {
        if (USE_RECOVERY_COST) {
            OP_THRESHOLD = 240.0f;
            OP_LOW_THRESHOLD = 120.0f;
            OP_ALL_LOW_THRESHOLD = 120.0f;
            OP_ALL_THRESHOLD = 240.0f;
            PHASE_OP_THRESHOLD = 40.0f;
            MILITARIZED_OP_THRESHOLD = 5.0f;
            AUTOMATED_POINTS_THRESHOLD = 120.0f;
        }
    }

    public void init(MutableCharacterStatsAPI stats, SkillSpecAPI skill) {
        this.indent = "    - ";
        this.tc = Misc.getTextColor();
        this.hc = Misc.getHighlightColor();
        this.dhc = Misc.setAlpha(this.hc, 155);
        this.alpha = 255;
        float level = stats.getSkillLevel(skill.getId());
        if (level <= 0.0f) {
            this.tc = Misc.getGrayColor();
            this.hc = this.dhc;
            this.alpha = 155;
        }
        this.dtc = Misc.getGrayColor();
    }

    public void initElite(MutableCharacterStatsAPI stats, SkillSpecAPI skill) {
        this.indent = "    - ";
        this.tc = Misc.getTextColor();
        this.hc = Misc.getHighlightColor();
        this.dhc = Misc.setAlpha(this.hc, 155);
        this.alpha = 255;
        float level = stats.getSkillLevel(skill.getId());
        if (level <= 1.0f) {
            this.tc = Misc.getGrayColor();
            this.hc = this.dhc;
            this.alpha = 155;
        }
        this.dtc = Misc.getGrayColor();
    }

    public void addFighterBayThresholdInfo(TooltipMakerAPI info, FleetDataAPI data) {
        if (BaseSkillEffectDescription.isInCampaign()) {
            int bays = Math.round(BaseSkillEffectDescription.getNumFighterBays(data));
            String baysStr = "fighter bays";
            if (bays == 1) {
                baysStr = "fighter bay";
            }
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less fighter bays in fleet, your fleet has %s " + baysStr, 0.0f, this.tc, this.hc, "" + (int)FIGHTER_BAYS_THRESHOLD, "" + bays);
        } else {
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less fighter bays in fleet", 0.0f, this.tc, this.hc, "" + (int)FIGHTER_BAYS_THRESHOLD);
        }
    }

    public void addOPThresholdInfo(TooltipMakerAPI info, FleetDataAPI data, MutableCharacterStatsAPI cStats) {
        this.addOPThresholdInfo(info, data, cStats, OP_THRESHOLD);
    }

    public void addOPThresholdInfo(TooltipMakerAPI info, FleetDataAPI data, MutableCharacterStatsAPI cStats, float threshold) {
        if (USE_RECOVERY_COST) {
            if (BaseSkillEffectDescription.isInCampaign()) {
                float op = BaseSkillEffectDescription.getTotalCombatOP(data, cStats);
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total combat ship " + RECOVERY_COST + ", your fleet's total is %s", 0.0f, this.tc, this.hc, "" + (int)threshold, "" + Math.round(op));
            } else {
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total combat ship " + RECOVERY_COST + " for fleet", 0.0f, this.tc, this.hc, "" + (int)threshold);
            }
            return;
        }
        if (BaseSkillEffectDescription.isInCampaign()) {
            float op = BaseSkillEffectDescription.getTotalCombatOP(data, cStats);
            String opStr = "points";
            if (op == 1.0f) {
                opStr = "point";
            }
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total combat ship ordnance points in fleet, your fleet has %s " + opStr, 0.0f, this.tc, this.hc, "" + (int)threshold, "" + Math.round(op));
        } else {
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total combat ship ordnance points in fleet", 0.0f, this.tc, this.hc, "" + (int)threshold);
        }
    }

    public void addOPThresholdAll(TooltipMakerAPI info, FleetDataAPI data, MutableCharacterStatsAPI cStats, float threshold) {
        if (USE_RECOVERY_COST) {
            if (BaseSkillEffectDescription.isInCampaign()) {
                float op = BaseSkillEffectDescription.getTotalOP(data, cStats);
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total " + RECOVERY_COST + ", your fleet's total is %s", 0.0f, this.tc, this.hc, "" + (int)threshold, "" + Math.round(op));
            } else {
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total " + RECOVERY_COST + " for fleet", 0.0f, this.tc, this.hc, "" + (int)threshold);
            }
            return;
        }
        if (BaseSkillEffectDescription.isInCampaign()) {
            float op = BaseSkillEffectDescription.getTotalOP(data, cStats);
            String opStr = "points";
            if (op == 1.0f) {
                opStr = "point";
            }
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total ordnance points in fleet, your fleet has %s " + opStr, 0.0f, this.tc, this.hc, "" + (int)threshold, "" + Math.round(op));
        } else {
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total ordnance points in fleet", 0.0f, this.tc, this.hc, "" + (int)threshold);
        }
    }

    public void addPhaseOPThresholdInfo(TooltipMakerAPI info, FleetDataAPI data, MutableCharacterStatsAPI cStats) {
        if (USE_RECOVERY_COST) {
            if (BaseSkillEffectDescription.isInCampaign()) {
                float op = BaseSkillEffectDescription.getPhaseOP(data, cStats);
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total combat phase ship " + RECOVERY_COST + ", your fleet's total is %s", 0.0f, this.tc, this.hc, "" + (int)PHASE_OP_THRESHOLD, "" + Math.round(op));
            } else {
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total combat phase ship " + RECOVERY_COST + " for fleet", 0.0f, this.tc, this.hc, "" + (int)PHASE_OP_THRESHOLD);
            }
            return;
        }
        if (BaseSkillEffectDescription.isInCampaign()) {
            float op = BaseSkillEffectDescription.getPhaseOP(data, cStats);
            String opStr = "points";
            if (op == 1.0f) {
                opStr = "point";
            }
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total combat phase ship ordnance points in fleet, your fleet has %s " + opStr, 0.0f, this.tc, this.hc, "" + (int)PHASE_OP_THRESHOLD, "" + Math.round(op));
        } else {
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total combat phase ship ordnance points in fleet", 0.0f, this.tc, this.hc, "" + (int)PHASE_OP_THRESHOLD);
        }
    }

    public void addAutomatedThresholdInfo(TooltipMakerAPI info, FleetDataAPI data, MutableCharacterStatsAPI cStats) {
        if (USE_RECOVERY_COST) {
            if (BaseSkillEffectDescription.isInCampaign()) {
                float op = BaseSkillEffectDescription.getAutomatedPoints(data, cStats);
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total automated ship points*, your fleet's total is %s ", 0.0f, this.tc, this.hc, "" + (int)AUTOMATED_POINTS_THRESHOLD, "" + Math.round(op));
            } else {
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total automated ship points* for fleet", 0.0f, this.tc, this.hc, "" + (int)AUTOMATED_POINTS_THRESHOLD);
            }
            return;
        }
        if (BaseSkillEffectDescription.isInCampaign()) {
            float op = BaseSkillEffectDescription.getAutomatedPoints(data, cStats);
            String opStr = "points";
            if (op == 1.0f) {
                opStr = "point";
            }
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total automated ship points* in fleet, your fleet has %s " + opStr, 0.0f, this.tc, this.hc, "" + (int)AUTOMATED_POINTS_THRESHOLD, "" + Math.round(op));
        } else {
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total automated ship points* in fleet", 0.0f, this.tc, this.hc, "" + (int)AUTOMATED_POINTS_THRESHOLD);
        }
    }

    public void addMilitarizedOPThresholdInfo(TooltipMakerAPI info, FleetDataAPI data, MutableCharacterStatsAPI cStats) {
        if (USE_RECOVERY_COST) {
            if (BaseSkillEffectDescription.isInCampaign()) {
                float op = BaseSkillEffectDescription.getMilitarizedOP(data, cStats);
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total " + RECOVERY_COST + " for ships with Militarized Subsystems, your fleet's total is %s", 0.0f, this.tc, this.hc, "" + (int)MILITARIZED_OP_THRESHOLD, "" + Math.round(op));
            } else {
                info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total " + RECOVERY_COST + " for ships with Militarized Subsystems for fleet", 0.0f, this.tc, this.hc, "" + (int)MILITARIZED_OP_THRESHOLD);
            }
            return;
        }
        if (BaseSkillEffectDescription.isInCampaign()) {
            float op = BaseSkillEffectDescription.getMilitarizedOP(data, cStats);
            String opStr = "points";
            if (op == 1.0f) {
                opStr = "point";
            }
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total ordnance points for ships with Militarized Subsystems, your fleet has %s " + opStr, 0.0f, this.tc, this.hc, "" + (int)MILITARIZED_OP_THRESHOLD, "" + Math.round(op));
        } else {
            info.addPara(String.valueOf(this.indent) + "Maximum at %s or less total ordnance points for ships with Militarized Subsystems", 0.0f, this.tc, this.hc, "" + (int)MILITARIZED_OP_THRESHOLD);
        }
    }

    protected float computeAndCacheThresholdBonus(MutableShipStatsAPI stats, String key, float maxBonus, ThresholdBonusType type) {
        FleetDataAPI data = BaseSkillEffectDescription.getFleetData(stats);
        MutableCharacterStatsAPI cStats = BaseSkillEffectDescription.getCommanderStats(stats);
        return this.computeAndCacheThresholdBonus(data, cStats, key, maxBonus, type);
    }

    protected float computeAndCacheThresholdBonus(FleetDataAPI data, MutableCharacterStatsAPI cStats, String key, float maxBonus, ThresholdBonusType type) {
        if (data == null) {
            return maxBonus;
        }
        if (cStats.getFleet() == null) {
            return maxBonus;
        }
        Float bonus = (Float)data.getCacheClearedOnSync().get(key);
        if (bonus != null) {
            return bonus.floatValue();
        }
        float currValue = 0.0f;
        float threshold = 1.0f;
        if (type == ThresholdBonusType.FIGHTER_BAYS) {
            currValue = BaseSkillEffectDescription.getNumFighterBays(data);
            threshold = FIGHTER_BAYS_THRESHOLD;
        } else if (type == ThresholdBonusType.OP) {
            currValue = BaseSkillEffectDescription.getTotalCombatOP(data, cStats);
            threshold = OP_THRESHOLD;
        } else if (type == ThresholdBonusType.OP_LOW) {
            currValue = BaseSkillEffectDescription.getTotalCombatOP(data, cStats);
            threshold = OP_LOW_THRESHOLD;
        } else if (type == ThresholdBonusType.OP_ALL_LOW) {
            currValue = BaseSkillEffectDescription.getTotalOP(data, cStats);
            threshold = OP_ALL_LOW_THRESHOLD;
        } else if (type == ThresholdBonusType.OP_ALL) {
            currValue = BaseSkillEffectDescription.getTotalOP(data, cStats);
            threshold = OP_ALL_THRESHOLD;
        } else if (type == ThresholdBonusType.MILITARIZED_OP) {
            currValue = BaseSkillEffectDescription.getMilitarizedOP(data, cStats);
            threshold = MILITARIZED_OP_THRESHOLD;
        } else if (type == ThresholdBonusType.PHASE_OP) {
            currValue = BaseSkillEffectDescription.getPhaseOP(data, cStats);
            threshold = PHASE_OP_THRESHOLD;
        } else if (type == ThresholdBonusType.AUTOMATED_POINTS) {
            currValue = BaseSkillEffectDescription.getAutomatedPoints(data, cStats);
            threshold = AUTOMATED_POINTS_THRESHOLD;
        }
        bonus = Float.valueOf(this.getThresholdBasedRoundedBonus(maxBonus, currValue, threshold));
        data.getCacheClearedOnSync().put(key, bonus);
        return bonus.floatValue();
    }

    public FleetTotalItem getOPTotal() {
        final CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        final MutableCharacterStatsAPI stats = Global.getSector().getPlayerStats();
        FleetTotalItem item = new FleetTotalItem();
        item.label = "Total ordnance points";
        if (USE_RECOVERY_COST) {
            item.label = "All ships";
        }
        item.value = "" + (int)BaseSkillEffectDescription.getTotalOP(fleet.getFleetData(), stats);
        item.sortOrder = 50.0f;
        item.tooltipCreator = this.getTooltipCreator(new TooltipCreatorSkillEffectPlugin(){

            @Override
            public void addDescription(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("The total deployment points of all the ships in your fleet.", 0.0f);
            }

            @Override
            public List<FleetMemberPointContrib> getContributors() {
                return BaseSkillEffectDescription.getTotalOPDetail(fleet.getFleetData(), stats);
            }
        });
        return item;
    }

    public FleetTotalItem getCombatOPTotal() {
        final CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        final MutableCharacterStatsAPI stats = Global.getSector().getPlayerStats();
        FleetTotalItem item = new FleetTotalItem();
        item.label = "Combat ship ordnance points";
        if (USE_RECOVERY_COST) {
            item.label = "Combat ships";
        }
        item.value = "" + (int)BaseSkillEffectDescription.getTotalCombatOP(fleet.getFleetData(), stats);
        item.sortOrder = 100.0f;
        item.tooltipCreator = this.getTooltipCreator(new TooltipCreatorSkillEffectPlugin(){

            @Override
            public void addDescription(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("The total deployment points of all the combat ships in your fleet.", 0.0f);
            }

            @Override
            public List<FleetMemberPointContrib> getContributors() {
                return BaseSkillEffectDescription.getTotalCombatOPDetail(fleet.getFleetData(), stats);
            }
        });
        return item;
    }

    public FleetTotalItem getAutomatedPointsTotal() {
        final CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        final MutableCharacterStatsAPI stats = Global.getSector().getPlayerStats();
        FleetTotalItem item = new FleetTotalItem();
        item.label = "Automated ships";
        item.value = "" + (int)BaseSkillEffectDescription.getAutomatedPoints(fleet.getFleetData(), stats);
        item.sortOrder = 350.0f;
        item.tooltipCreator = this.getTooltipCreator(new TooltipCreatorSkillEffectPlugin(){

            @Override
            public void addDescription(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("The total deployment points of all the automated ships in your fleet, with additional points for ships controlled by AI cores.", 0.0f);
            }

            @Override
            public List<FleetMemberPointContrib> getContributors() {
                return BaseSkillEffectDescription.getAutomatedPointsDetail(fleet.getFleetData(), stats);
            }
        });
        return item;
    }

    public FleetTotalItem getPhaseOPTotal() {
        final CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        final MutableCharacterStatsAPI stats = Global.getSector().getPlayerStats();
        FleetTotalItem item = new FleetTotalItem();
        item.label = "Phase ship ordnance points";
        if (USE_RECOVERY_COST) {
            item.label = "Phase ships";
        }
        item.value = "" + (int)BaseSkillEffectDescription.getPhaseOP(fleet.getFleetData(), stats);
        item.sortOrder = 200.0f;
        item.tooltipCreator = this.getTooltipCreator(new TooltipCreatorSkillEffectPlugin(){

            @Override
            public void addDescription(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("The total deployment points of all the non-civilian phase ships in your fleet.", 0.0f);
            }

            @Override
            public List<FleetMemberPointContrib> getContributors() {
                return BaseSkillEffectDescription.getPhaseOPDetail(fleet.getFleetData(), stats);
            }
        });
        return item;
    }

    public FleetTotalItem getMilitarizedOPTotal() {
        final CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        final MutableCharacterStatsAPI stats = Global.getSector().getPlayerStats();
        FleetTotalItem item = new FleetTotalItem();
        item.label = "Militarized ship ordnance points";
        if (USE_RECOVERY_COST) {
            item.label = "Militarized ships";
        }
        item.value = "" + (int)BaseSkillEffectDescription.getMilitarizedOP(fleet.getFleetData(), stats);
        item.sortOrder = 300.0f;
        item.tooltipCreator = this.getTooltipCreator(new TooltipCreatorSkillEffectPlugin(){

            @Override
            public void addDescription(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("The total deployment points of all the ships in your fleet that have the \"Militarized Subsystems\" hullmod.", 0.0f);
            }

            @Override
            public List<FleetMemberPointContrib> getContributors() {
                return BaseSkillEffectDescription.getMilitarizedOPDetail(fleet.getFleetData(), stats);
            }
        });
        return item;
    }

    public FleetTotalItem getFighterBaysTotal() {
        final CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        FleetTotalItem item = new FleetTotalItem();
        item.label = "Fighter bays";
        item.value = "" + (int)BaseSkillEffectDescription.getNumFighterBays(fleet.getFleetData());
        item.sortOrder = 400.0f;
        item.tooltipCreator = this.getTooltipCreator(new TooltipCreatorSkillEffectPlugin(){

            @Override
            public void addDescription(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("The total number of fighter bays in your fleet. Both empty and filled fighter bays are counted. Built-in fighter bays can be removed from a ship by installing the \"Converted Fighter Bay\" hullmod.", 0.0f);
            }

            @Override
            public List<FleetMemberPointContrib> getContributors() {
                return BaseSkillEffectDescription.getNumFighterBaysDetail(fleet.getFleetData());
            }
        });
        return item;
    }

    public TooltipMakerAPI.TooltipCreator getTooltipCreator(final TooltipCreatorSkillEffectPlugin plugin) {
        return new BaseTooltipCreator(){

            public float getTooltipWidth(Object tooltipParam) {
                return TOOLTIP_WIDTH;
            }

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float pad = 3.0f;
                float opad = 10.0f;
                plugin.addDescription(tooltip, expanded, tooltipParam);
                tooltip.addPara("Certain skills will have reduced effects if this value exceeds a skill-specific threshold; see the specific skill for details. Mothballed ships are not counted towards the total.", opad);
                tooltip.addPara("Skills using this value:", opad);
                tooltip.setBulletedListMode("      ");
                List skills = (List)tooltipParam;
                HashSet<MutableCharacterStatsAPI.SkillLevelAPI> seen = new HashSet<MutableCharacterStatsAPI.SkillLevelAPI>();
                float initPad = opad;
                for (MutableCharacterStatsAPI.SkillLevelAPI skill : skills) {
                    if (seen.contains(skill)) continue;
                    seen.add(skill);
                    String label = String.valueOf(skill.getSkill().getName()) + " (" + skill.getSkill().getGoverningAptitudeName() + ")";
                    label = String.valueOf(skill.getSkill().getGoverningAptitudeName()) + " - " + skill.getSkill().getName();
                    tooltip.addPara(label, skill.getSkill().getGoverningAptitudeColor(), initPad);
                    initPad = pad;
                }
                tooltip.setBulletedListMode(null);
                List<FleetMemberPointContrib> members = plugin.getContributors();
                Collections.sort(members, new Comparator<FleetMemberPointContrib>(){

                    @Override
                    public int compare(FleetMemberPointContrib o1, FleetMemberPointContrib o2) {
                        return o2.points - o1.points;
                    }
                });
                tooltip.addPara("Ships contributing to this value:", opad);
                initPad = opad;
                if (members.isEmpty()) {
                    tooltip.setBulletedListMode("      ");
                    tooltip.addPara("None", initPad);
                    tooltip.setBulletedListMode(null);
                }
                float gridWidth = 450.0f;
                tooltip.beginGridFlipped(gridWidth, 1, 40.0f, opad);
                int i = 0;
                int max = 20;
                if (members.size() == max + 1) {
                    max = members.size();
                }
                for (FleetMemberPointContrib member : members) {
                    String label = tooltip.shortenString(BaseSkillEffectDescription.getValueLabelForMember(member.member), gridWidth - 60.0f);
                    tooltip.addToGrid(0, i++, label, "+" + member.points);
                    if (i >= max) break;
                }
                tooltip.addGrid(opad);
                if (members.size() > max) {
                    tooltip.addPara("And %s other ships with a smaller contribution.", opad, Misc.getHighlightColor(), "" + (members.size() - max));
                }
            }
        };
    }

    public static String getValueLabelForMember(FleetMemberAPI member) {
        String str = "";
        if (!member.isFighterWing()) {
            str = String.valueOf(str) + member.getShipName() + ", ";
            str = String.valueOf(str) + member.getHullSpec().getHullNameWithDashClass();
        } else {
            str = String.valueOf(str) + member.getVariant().getFullDesignationWithHullName();
        }
        if (member.isMothballed()) {
            str = String.valueOf(str) + " (mothballed)";
        }
        return str;
    }

    public float getThresholdBasedBonus(float maxBonus, float value, float threshold) {
        float bonus = maxBonus * threshold / Math.max(value, threshold);
        return bonus;
    }

    public float getThresholdBasedRoundedBonus(float maxBonus, float value, float threshold) {
        float bonus = maxBonus * threshold / Math.max(value, threshold);
        if (bonus > 0.0f && bonus < 1.0f) {
            bonus = 1.0f;
        }
        if (maxBonus > 1.0f) {
            if (bonus < maxBonus) {
                bonus = Math.min(bonus, maxBonus - 1.0f);
            }
            bonus = Math.round(bonus);
        }
        return bonus;
    }

    public static boolean isMilitarized(MutableShipStatsAPI stats) {
        if (stats == null || stats.getFleetMember() == null) {
            return false;
        }
        return BaseSkillEffectDescription.isMilitarized(stats.getFleetMember());
    }

    public static boolean isMilitarized(FleetMemberAPI member) {
        if (member == null) {
            return false;
        }
        MutableShipStatsAPI stats = member.getStats();
        return stats != null && stats.getVariant() != null && stats.getVariant().hasHullMod("militarized_subsystems");
    }

    public static boolean isCivilian(MutableShipStatsAPI stats) {
        if (stats == null || stats.getFleetMember() == null) {
            return false;
        }
        return BaseSkillEffectDescription.isCivilian(stats.getFleetMember());
    }

    public static boolean isCivilian(FleetMemberAPI member) {
        if (member == null) {
            return false;
        }
        MutableShipStatsAPI stats = member.getStats();
        return stats != null && stats.getVariant() != null && (stats.getVariant().hasHullMod("civgrade") && !stats.getVariant().hasHullMod("militarized_subsystems") || !stats.getVariant().hasHullMod("civgrade") && stats.getVariant().getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.CIVILIAN));
    }

    public static boolean hasFighterBays(MutableShipStatsAPI stats) {
        if (stats == null || stats.getFleetMember() == null) {
            return false;
        }
        return BaseSkillEffectDescription.hasFighterBays(stats.getFleetMember());
    }

    public static boolean hasFighterBays(FleetMemberAPI member) {
        if (member == null) {
            return false;
        }
        MutableShipStatsAPI stats = member.getStats();
        return stats != null && stats.getNumFighterBays().getModifiedInt() > 0;
    }

    protected static float getPoints(FleetMemberAPI member, MutableCharacterStatsAPI stats) {
        if (USE_RECOVERY_COST) {
            return member.getDeploymentPointsCost();
        }
        return member.getHullSpec().getOrdnancePoints(stats);
    }

    public static float getTotalOP(FleetDataAPI data, MutableCharacterStatsAPI stats) {
        float op = 0.0f;
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed()) continue;
            op += BaseSkillEffectDescription.getPoints(curr, stats);
        }
        return Math.round(op);
    }

    public static List<FleetMemberPointContrib> getTotalOPDetail(FleetDataAPI data, MutableCharacterStatsAPI stats) {
        ArrayList<FleetMemberPointContrib> result = new ArrayList<FleetMemberPointContrib>();
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed()) continue;
            int pts = Math.round(BaseSkillEffectDescription.getPoints(curr, stats));
            result.add(new FleetMemberPointContrib(curr, pts));
        }
        return result;
    }

    public static float getTotalCombatOP(FleetDataAPI data, MutableCharacterStatsAPI stats) {
        float op = 0.0f;
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed() || BaseSkillEffectDescription.isCivilian(curr)) continue;
            op += BaseSkillEffectDescription.getPoints(curr, stats);
        }
        return Math.round(op);
    }

    public static List<FleetMemberPointContrib> getTotalCombatOPDetail(FleetDataAPI data, MutableCharacterStatsAPI stats) {
        ArrayList<FleetMemberPointContrib> result = new ArrayList<FleetMemberPointContrib>();
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed() || BaseSkillEffectDescription.isCivilian(curr)) continue;
            int pts = Math.round(BaseSkillEffectDescription.getPoints(curr, stats));
            result.add(new FleetMemberPointContrib(curr, pts));
        }
        return result;
    }

    public static float getPhaseOP(FleetDataAPI data, MutableCharacterStatsAPI stats) {
        float op = 0.0f;
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed() || !curr.isPhaseShip() || BaseSkillEffectDescription.isCivilian(curr)) continue;
            op += BaseSkillEffectDescription.getPoints(curr, stats);
        }
        return Math.round(op);
    }

    public static List<FleetMemberPointContrib> getPhaseOPDetail(FleetDataAPI data, MutableCharacterStatsAPI stats) {
        ArrayList<FleetMemberPointContrib> result = new ArrayList<FleetMemberPointContrib>();
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed() || !curr.isPhaseShip() || BaseSkillEffectDescription.isCivilian(curr)) continue;
            int pts = Math.round(BaseSkillEffectDescription.getPoints(curr, stats));
            result.add(new FleetMemberPointContrib(curr, pts));
        }
        return result;
    }

    public static float getMilitarizedOP(FleetDataAPI data, MutableCharacterStatsAPI stats) {
        float op = 0.0f;
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed() || !BaseSkillEffectDescription.isMilitarized(curr)) continue;
            op += BaseSkillEffectDescription.getPoints(curr, stats);
        }
        return Math.round(op);
    }

    public static List<FleetMemberPointContrib> getMilitarizedOPDetail(FleetDataAPI data, MutableCharacterStatsAPI stats) {
        ArrayList<FleetMemberPointContrib> result = new ArrayList<FleetMemberPointContrib>();
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed() || !BaseSkillEffectDescription.isMilitarized(curr)) continue;
            int pts = Math.round(BaseSkillEffectDescription.getPoints(curr, stats));
            result.add(new FleetMemberPointContrib(curr, pts));
        }
        return result;
    }

    public static float getNumFighterBays(FleetDataAPI data) {
        if (data == null) {
            return FIGHTER_BAYS_THRESHOLD;
        }
        float bays = 0.0f;
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed()) continue;
            bays += BaseSkillEffectDescription.getNumBaysIncludingModules(curr);
        }
        return bays;
    }

    public static float getNumBaysIncludingModules(FleetMemberAPI member) {
        float bays = 0.0f;
        bays += (float)member.getNumFlightDecks();
        if (member.getVariant().getModuleSlots() != null) {
            for (String slotId : member.getVariant().getModuleSlots()) {
                ShipVariantAPI variant;
                if (slotId == null || (variant = member.getVariant().getModuleVariant(slotId)) == null) continue;
                bays += (float)variant.getHullSpec().getFighterBays();
            }
        }
        return bays;
    }

    public static List<FleetMemberPointContrib> getNumFighterBaysDetail(FleetDataAPI data) {
        ArrayList<FleetMemberPointContrib> result = new ArrayList<FleetMemberPointContrib>();
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            int pts;
            if (curr.isMothballed() || (pts = Math.round(BaseSkillEffectDescription.getNumBaysIncludingModules(curr))) <= 0) continue;
            result.add(new FleetMemberPointContrib(curr, pts));
        }
        return result;
    }

    public static float getAutomatedPoints(FleetDataAPI data, MutableCharacterStatsAPI stats) {
        float points = 0.0f;
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed() || !Misc.isAutomated(curr) || Automated.isAutomatedNoPenalty(curr)) continue;
            float mult = 1.0f;
            points += curr.getCaptain().getMemoryWithoutUpdate().getFloat("$autoPointsValue");
            mult = curr.getCaptain().getMemoryWithoutUpdate().getFloat("$autoPointsMult");
            if (mult == 0.0f) {
                mult = 1.0f;
            }
            points += (float)Math.round(BaseSkillEffectDescription.getPoints(curr, stats) * mult);
        }
        return Math.round(points);
    }

    public static List<FleetMemberPointContrib> getAutomatedPointsDetail(FleetDataAPI data, MutableCharacterStatsAPI stats) {
        ArrayList<FleetMemberPointContrib> result = new ArrayList<FleetMemberPointContrib>();
        for (FleetMemberAPI curr : data.getMembersListCopy()) {
            if (curr.isMothballed() || !Misc.isAutomated(curr) || Automated.isAutomatedNoPenalty(curr)) continue;
            float mult = 1.0f;
            int pts = Math.round(BaseSkillEffectDescription.getPoints(curr, stats));
            pts += Math.round(curr.getCaptain().getMemoryWithoutUpdate().getFloat("$autoPointsValue"));
            mult = curr.getCaptain().getMemoryWithoutUpdate().getFloat("$autoPointsMult");
            if (mult == 0.0f) {
                mult = 1.0f;
            }
            result.add(new FleetMemberPointContrib(curr, Math.round((float)pts * mult)));
        }
        return result;
    }

    public static boolean isInCampaign() {
        return Global.getCurrentState() == GameState.CAMPAIGN && Global.getSector() != null && Global.getSector().getPlayerFleet() != null;
    }

    public static MutableCharacterStatsAPI getCommanderStats(MutableShipStatsAPI stats) {
        if (stats == null) {
            if (BaseSkillEffectDescription.isInCampaign()) {
                return Global.getSector().getPlayerStats();
            }
            return null;
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return null;
        }
        PersonAPI commander = member.getFleetCommanderForStats();
        if (commander == null) {
            boolean orig = false;
            if (member.getFleetData() != null) {
                orig = member.getFleetData().isForceNoSync();
                member.getFleetData().setForceNoSync(true);
            }
            commander = member.getFleetCommander();
            if (member.getFleetData() != null) {
                member.getFleetData().setForceNoSync(orig);
            }
        }
        if (commander != null) {
            return commander.getStats();
        }
        return null;
    }

    public static FleetDataAPI getFleetData(MutableShipStatsAPI stats) {
        if (stats == null) {
            if (BaseSkillEffectDescription.isInCampaign()) {
                return Global.getSector().getPlayerFleet().getFleetData();
            }
            return null;
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return null;
        }
        FleetDataAPI data = member.getFleetDataForStats();
        if (data == null) {
            data = member.getFleetData();
        }
        return data;
    }

    @Override
    public boolean hasCustomDescription() {
        return true;
    }

    @Override
    public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
    }

    @Override
    public String getEffectDescription(float level) {
        return null;
    }

    @Override
    public String getEffectPerLevelDescription() {
        return null;
    }

    @Override
    public LevelBasedEffect.ScopeDescription getScopeDescription() {
        return null;
    }

    public static class FleetMemberPointContrib {
        public FleetMemberAPI member;
        public int points;

        public FleetMemberPointContrib(FleetMemberAPI member, int points) {
            this.member = member;
            this.points = points;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThresholdBonusType {
        OP,
        OP_LOW,
        OP_ALL,
        OP_ALL_LOW,
        MILITARIZED_OP,
        PHASE_OP,
        FIGHTER_BAYS,
        AUTOMATED_POINTS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TooltipCreatorSkillEffectPlugin {
        public void addDescription(TooltipMakerAPI var1, boolean var2, Object var3);

        public List<FleetMemberPointContrib> getContributors();
    }
}

