/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class CoordinatedManeuvers {
    public static final float CP_BONUS = 3.0f;
    public static float NAV_FRIGATES = 6.0f;
    public static float NAV_DESTROYERS = 3.0f;
    public static float NAV_OTHER = 1.0f;
    public static float CP_REGEN_FRIGATES = 50.0f;
    public static float CP_REGEN_DESTROYERS = 25.0f;

    public static boolean isFrigateOrDestroyerAndOfficer(MutableShipStatsAPI stats) {
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        return !member.getCaptain().isDefault();
    }

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            String max = "20%";
            return "*The total nav rating for the deployed ships of the fleet increases the top speed of all ships in the fleet, up to a maximum of " + max + ". Does not apply to fighters.";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h, h};
        }

        public String[] getHighlights() {
            String max = "20%";
            String jammer = "+5%";
            return new String[]{jammer, max};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1A
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (CoordinatedManeuvers.isFrigateOrDestroyerAndOfficer(stats)) {
                float bonus = 0.0f;
                if (hullSize == ShipAPI.HullSize.FRIGATE) {
                    bonus = NAV_FRIGATES;
                }
                if (hullSize == ShipAPI.HullSize.DESTROYER) {
                    bonus = NAV_DESTROYERS;
                }
                if (hullSize == ShipAPI.HullSize.CRUISER || hullSize == ShipAPI.HullSize.CAPITAL_SHIP) {
                    bonus = NAV_OTHER;
                }
                if (bonus > 0.0f) {
                    stats.getDynamic().getMod("coord_maneuvers_flat").modifyFlat(id, bonus);
                }
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("coord_maneuvers_flat").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            info.addPara("+%s to nav rating* of fleet for deployed frigates, +%s for destroyers, +%s for larger hulls", 0.0f, this.hc, this.hc, (int)NAV_FRIGATES + "%", (int)NAV_DESTROYERS + "%", (int)NAV_OTHER + "%");
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level1B
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getCommandPoints().modifyFlat(id, 3.0f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getCommandPoints().unmodify(id);
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("+%s command points", 0.0f, this.hc, this.hc, "3");
        }

        public String getEffectDescription(float level) {
            return "+3 command points";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level1C
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (CoordinatedManeuvers.isFrigateOrDestroyerAndOfficer(stats)) {
                float bonus = 0.0f;
                if (hullSize == ShipAPI.HullSize.FRIGATE) {
                    bonus = CP_REGEN_FRIGATES;
                }
                if (hullSize == ShipAPI.HullSize.DESTROYER) {
                    bonus = CP_REGEN_DESTROYERS;
                }
                if (bonus > 0.0f) {
                    stats.getDynamic().getMod("command_point_rate_flat").modifyFlat(id, bonus * 0.01f);
                }
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("command_point_rate_flat").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("+%s to command point recovery rate from deployed frigates, +%s from destroyers", 0.0f, this.hc, this.hc, (int)CP_REGEN_FRIGATES + "%", (int)CP_REGEN_DESTROYERS + "%");
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

