/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class DefensiveSystems {
    public static final float FLUX_UPKEEP_REDUCTION = 25.0f;
    public static final float SHIELD_DAMAGE_REDUCTION = 20.0f;
    public static final float PHASE_COOLDOWN_REDUCTION = 25.0f;
    public static final float FLUX_SHUNT_DISSIPATION = 10.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getShieldUpkeepMult().modifyMult(id, 0.75f);
            stats.getPhaseCloakUpkeepCostBonus().modifyMult(id, 0.75f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getShieldUpkeepMult().unmodify(id);
            stats.getPhaseCloakUpkeepCostBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-25% flux generated by active shields and phase cloak";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getShieldDamageTakenMult().modifyMult(id, 0.8f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getShieldDamageTakenMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-20% damage taken by shields";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2B
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPhaseCloakCooldownBonus().modifyMult(id, 0.75f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPhaseCloakCooldownBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-25% phase cloak cooldown";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getHardFluxDissipationFraction().modifyFlat(id, 0.1f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getHardFluxDissipationFraction().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "10% hard flux dissipation while shields are active";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3B
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getStat("phase_time_mult").modifyFlat(id, 0.5f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getStat("phase_time_mult").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "Phase cloak time acceleration increased from 3\u00d7 to 4\u00d7";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

