/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class EnergyWeaponMastery {
    public static float FLUX_COST_MULT = 0.9f;
    public static float MIN_RANGE = 600.0f;
    public static float MAX_RANGE = 1000.0f;
    public static float ENERGY_DAMAGE_PERCENT = 30.0f;
    public static float ENERGY_DAMAGE_MIN_FLUX_LEVEL = 0.0f;
    public static Object DAM_BONUS_STATUS_KEY = new Object();

    public static class EWMDamageDealtMod
    implements DamageDealtModifier,
    AdvanceableListener {
        protected ShipAPI ship;

        public EWMDamageDealtMod(ShipAPI ship) {
            this.ship = ship;
        }

        public void advance(float amount) {
            int damageBonus;
            if (Global.getCurrentState() == GameState.COMBAT && Global.getCombatEngine() != null && Global.getCombatEngine().getPlayerShip() == this.ship && (damageBonus = Math.round(this.ship.getFluxBasedEnergyWeaponDamageMultiplier() * 100.0f - 100.0f)) > 0) {
                Global.getCombatEngine().maintainStatusForPlayerShip(DAM_BONUS_STATUS_KEY, Global.getSettings().getSpriteName("ui", "icon_energy"), "Energy weapon mastery", "+" + damageBonus + "% energy weapon damage", false);
            }
        }

        public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            Vector2f from = null;
            WeaponAPI weapon = null;
            if (param instanceof DamagingProjectileAPI) {
                from = ((DamagingProjectileAPI)param).getSpawnLocation();
                weapon = ((DamagingProjectileAPI)param).getWeapon();
            } else if (param instanceof BeamAPI) {
                from = ((BeamAPI)param).getFrom();
                weapon = ((BeamAPI)param).getWeapon();
            } else {
                return null;
            }
            if (weapon == null || this.ship == null) {
                return null;
            }
            if (weapon.getSpec().getType() != WeaponAPI.WeaponType.ENERGY) {
                return null;
            }
            float mag = this.ship.getFluxBasedEnergyWeaponDamageMultiplier() - 1.0f;
            if (mag <= 0.0f) {
                return null;
            }
            float dist = Misc.getDistance(from, point);
            float f = 1.0f;
            if (dist > MAX_RANGE) {
                f = 0.0f;
            } else if (dist > MIN_RANGE) {
                f = 1.0f - (dist - MIN_RANGE) / (MAX_RANGE - MIN_RANGE);
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            String id = "ewm_dam_mod";
            damage.getModifier().modifyPercent(id, mag * f * 100.0f);
            return id;
        }
    }

    public static class Level1
    extends BaseSkillEffectDescription
    implements AfterShipCreationSkillEffect {
        public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.addListener(new EWMDamageDealtMod(ship));
        }

        public void unapplyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.removeListenerOfClass(EWMDamageDealtMod.class);
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getEnergyWeaponFluxBasedBonusDamageMagnitude().modifyFlat(id, ENERGY_DAMAGE_PERCENT * 0.01f);
            stats.getEnergyWeaponFluxBasedBonusDamageMinLevel().modifyFlat(id, ENERGY_DAMAGE_MIN_FLUX_LEVEL);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getEnergyWeaponFluxBasedBonusDamageMagnitude().unmodifyFlat(id);
            stats.getEnergyWeaponFluxBasedBonusDamageMinLevel().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            if (ENERGY_DAMAGE_MIN_FLUX_LEVEL > 0.0f) {
                info.addPara("Energy weapons deal up to %s damage at close range as the firing ship's flux level increases above %s", 0.0f, this.hc, this.hc, "+" + (int)ENERGY_DAMAGE_PERCENT + "%", String.valueOf(Math.round(ENERGY_DAMAGE_MIN_FLUX_LEVEL * 100.0f)) + "%");
            } else {
                info.addPara("Energy weapons deal up to %s damage at close range, based on the firing ship's flux level", 0.0f, this.hc, this.hc, "+" + (int)ENERGY_DAMAGE_PERCENT + "%");
            }
            info.addPara(String.valueOf(this.indent) + "Full bonus damage at %s range and below, " + "no bonus damage at %s range and above", 0.0f, this.tc, this.hc, "" + (int)MIN_RANGE, "" + (int)MAX_RANGE);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getEnergyWeaponFluxCostMod().modifyMult(id, FLUX_COST_MULT);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getEnergyWeaponFluxCostMod().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + Math.round((1.0f - FLUX_COST_MULT) * 100.0f) + "% flux generated by energy weapons";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

