/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class FighterUplink {
    public static float MAX_SPEED_PERCENT = 20.0f;
    public static float CREW_LOSS_PERCENT = 50.0f;
    public static float TARGET_LEADING_BONUS = 50.0f;
    public static float OFFICER_MULT = 1.5f;

    public static boolean isOfficer(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            if (ship == null) {
                return false;
            }
            if (ship.isFighter() && ship.getWing() != null && ship.getWing().getSourceShip() != null) {
                ship = ship.getWing().getSourceShip();
            }
            return ship.getCaptain() != null && !ship.getCaptain().isDefault();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        return !member.getCaptain().isDefault();
    }

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float crewLossReduction = this.computeAndCacheThresholdBonus(stats, "fu_crew_loss", CREW_LOSS_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.FIGHTER_BAYS);
            if (FighterUplink.isOfficer(stats)) {
                crewLossReduction *= OFFICER_MULT;
            }
            stats.getDynamic().getStat("fighter_crew_loss_mult").modifyMult(id, 1.0f - crewLossReduction / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getStat("fighter_crew_loss_mult").unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float crewLossReduction = this.computeAndCacheThresholdBonus(data, stats, "fu_crew_loss", CREW_LOSS_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.FIGHTER_BAYS);
            info.addPara("-%s crew lost due to fighter losses in combat (maximum: %s)", 0.0f, this.hc, this.hc, (int)crewLossReduction + "%", (int)CREW_LOSS_PERCENT + "%");
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getFighterBaysTotal();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float speedBonus = this.getMaxSpeedBonus(stats);
            if (FighterUplink.isOfficer(stats)) {
                speedBonus *= OFFICER_MULT;
            }
            stats.getMaxSpeed().modifyPercent(id, speedBonus);
            stats.getAcceleration().modifyPercent(id, speedBonus * 2.0f);
            stats.getDeceleration().modifyPercent(id, speedBonus * 2.0f);
            float aimBonus = this.getAimBonus(stats);
            if (FighterUplink.isOfficer(stats)) {
                aimBonus *= OFFICER_MULT;
            }
            stats.getAutofireAimAccuracy().modifyFlat(id, aimBonus * 0.01f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxSpeed().unmodifyPercent(id);
            stats.getAcceleration().unmodifyPercent(id);
            stats.getDeceleration().unmodifyPercent(id);
            stats.getAutofireAimAccuracy().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        protected float getMaxSpeedBonus(MutableShipStatsAPI stats) {
            FleetDataAPI data = Level2.getFleetData(stats);
            return this.getMaxSpeedBonus(data);
        }

        protected float getMaxSpeedBonus(FleetDataAPI data) {
            if (data == null) {
                return MAX_SPEED_PERCENT;
            }
            String key = "fighter_uplink_max_speed";
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float bays = Level2.getNumFighterBays(data);
            bonus = Float.valueOf(this.getThresholdBasedRoundedBonus(MAX_SPEED_PERCENT, bays, FIGHTER_BAYS_THRESHOLD));
            data.getCacheClearedOnSync().put(key, bonus);
            return bonus.floatValue();
        }

        protected float getAimBonus(MutableShipStatsAPI stats) {
            FleetDataAPI data = Level2.getFleetData(stats);
            return this.getAimBonus(data);
        }

        protected float getAimBonus(FleetDataAPI data) {
            if (data == null) {
                return TARGET_LEADING_BONUS;
            }
            String key = "fighter_uplink_aim";
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float bays = Level2.getNumFighterBays(data);
            bonus = Float.valueOf(this.getThresholdBasedRoundedBonus(TARGET_LEADING_BONUS, bays, FIGHTER_BAYS_THRESHOLD));
            data.getCacheClearedOnSync().put(key, bonus);
            return bonus.floatValue();
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level2.getFleetData(null);
            float speedBonus = this.getMaxSpeedBonus(data);
            float aimBonus = this.getAimBonus(data);
            info.addPara("+%s top speed (maximum: %s)", 0.0f, this.hc, this.hc, (int)speedBonus + "%", (int)MAX_SPEED_PERCENT + "%");
            info.addPara("+%s target leading accuracy (maximum: %s)", 0.0f, this.hc, this.hc, (int)aimBonus + "%", (int)TARGET_LEADING_BONUS + "%");
            this.addFighterBayThresholdInfo(info, data);
            info.addPara(String.valueOf(this.indent) + "Effect increased by %s for ships with offcers, including flagship", 0.0f, this.tc, this.hc, Misc.getRoundedValueMaxOneAfterDecimal(OFFICER_MULT) + "\u00d7");
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_FIGHTERS;
        }
    }
}

