/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class GunneryImplants {
    public static float RECOIL_BONUS = 25.0f;
    public static float TARGET_LEADING_BONUS = 100.0f;
    public static float RANGE_BONUS = 15.0f;
    public static float EW_FRIGATES = 4.0f;
    public static float EW_DESTROYERS = 2.0f;
    public static float EW_OTHER = 1.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxRecoilMult().modifyMult(id, 1.0f - 0.01f * RECOIL_BONUS);
            stats.getRecoilPerShotMult().modifyMult(id, 1.0f - 0.01f * RECOIL_BONUS);
            stats.getRecoilDecayMult().modifyMult(id, 1.0f - 0.01f * RECOIL_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxRecoilMult().unmodify(id);
            stats.getRecoilPerShotMult().unmodify(id);
            stats.getRecoilDecayMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)RECOIL_BONUS + "% weapon recoil";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level1A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float bonus = 0.0f;
            if (hullSize == ShipAPI.HullSize.FRIGATE) {
                bonus = EW_FRIGATES;
            }
            if (hullSize == ShipAPI.HullSize.DESTROYER) {
                bonus = EW_DESTROYERS;
            }
            if (hullSize == ShipAPI.HullSize.CRUISER || hullSize == ShipAPI.HullSize.CAPITAL_SHIP) {
                bonus = EW_OTHER;
            }
            if (bonus > 0.0f) {
                stats.getDynamic().getMod("electronic_warfare_flat").modifyFlat(id, bonus);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("electronic_warfare_flat").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)EW_FRIGATES + "% to ECM rating* of fleet when piloting a frigate, " + "+" + (int)EW_DESTROYERS + "% when piloting a destroyer, " + "+" + (int)EW_OTHER + "% for larger hulls";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getAutofireAimAccuracy().modifyFlat(id, TARGET_LEADING_BONUS * 0.01f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getAutofireAimAccuracy().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)TARGET_LEADING_BONUS + "% target leading accuracy for autofiring weapons";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getBallisticWeaponRangeBonus().modifyPercent(id, RANGE_BONUS);
            stats.getEnergyWeaponRangeBonus().modifyPercent(id, RANGE_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getBallisticWeaponRangeBonus().unmodify(id);
            stats.getEnergyWeaponRangeBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)RANGE_BONUS + "% ballistic and energy weapon range";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

