/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;

public class OrdnanceExpertise {
    public static float MAX_CR_BONUS = 15.0f;
    public static float FLUX_PER_OP = 2.0f;
    public static float CAP_PER_OP = 20.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (stats.getVariant() != null) {
                MutableCharacterStatsAPI cStats = BaseSkillEffectDescription.getCommanderStats(stats);
                float flux = FLUX_PER_OP * (float)stats.getVariant().computeWeaponOPCost(cStats);
                stats.getFluxDissipation().modifyFlat(id, flux);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFluxDissipation().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)FLUX_PER_OP + " flux dissipation per ordnance point spent on weapons";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxCombatReadiness().modifyFlat(id, MAX_CR_BONUS * 0.01f, "Ordnance Expertise skill");
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)MAX_CR_BONUS + "% maximum combat readiness";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (stats.getVariant() != null) {
                MutableCharacterStatsAPI cStats = BaseSkillEffectDescription.getCommanderStats(stats);
                float flux = CAP_PER_OP * (float)stats.getVariant().computeWeaponOPCost(cStats);
                stats.getFluxCapacity().modifyFlat(id, flux);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFluxCapacity().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)CAP_PER_OP + " flux capacity per ordnance point spent on weapons";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

