/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import java.awt.Color;

public class Sensors {
    public static float DETECTED_BONUS = 25.0f;
    public static float SENSOR_BONUS = 25.0f;
    public static float SLOW_BURN_BONUS = 3.0f;
    public static float GO_DARK_MULT = 0.5f;
    public static float SENSOR_BURST_PENALTY_MULT = 0.5f;

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            return "*A slow-moving fleet is harder to detect in some types of terrain, and can avoid some hazards. Some abilities also make the fleet move slowly when activated. A fleet is considered slow-moving at a burn level of half that of its slowest ship.";
        }

        public Color[] getHighlightColors() {
            return null;
        }

        public String[] getHighlights() {
            return null;
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDetectedRangeMod().modifyMult(id, 1.0f - DETECTED_BONUS / 100.0f, "Sensors skill");
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDetectedRangeMod().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)DETECTED_BONUS + "% detected-at range";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getSensorRangeMod().modifyPercent(id, SENSOR_BONUS, "Sensors skill");
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getSensorRangeMod().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)SENSOR_BONUS + "% sensor range";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("move_slow_speed_bonus_mod").modifyFlat(id, SLOW_BURN_BONUS);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("move_slow_speed_bonus_mod").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)SLOW_BURN_BONUS + " to burn level at which the fleet is considered to be moving slowly*";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

