/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MarketSkillEffect;

public class SpaceOperations {
    public static final float ACCESS = 0.3f;
    public static final float FLEET_SIZE = 25.0f;

    public static class Level1
    implements MarketSkillEffect {
        public void apply(MarketAPI market, String id, float level) {
            market.getAccessibilityMod().modifyFlat(id, 0.3f, "Space operations");
        }

        public void unapply(MarketAPI market, String id) {
            market.getAccessibilityMod().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + Math.round(30.000002f) + "% accessibility";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Level2
    implements MarketSkillEffect {
        public void apply(MarketAPI market, String id, float level) {
            market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlat(id, 0.25f, "Fleet logistics");
        }

        public void unapply(MarketAPI market, String id) {
            market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + Math.round(25.0f) + "% fleet size";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }
}

