/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LocalResourcesSubmarketPlugin
extends BaseSubmarketPlugin
implements EconomyAPI.EconomyUpdateListener,
EconomyTickListener {
    public static float STOCKPILE_MULT_PRODUCTION = Global.getSettings().getFloat("stockpileMultProduction");
    public static float STOCKPILE_MULT_EXCESS = Global.getSettings().getFloat("stockpileMultExcess");
    public static float STOCKPILE_MULT_IMPORTS = Global.getSettings().getFloat("stockpileMultImports");
    public static float STOCKPILE_MAX_MONTHS = Global.getSettings().getFloat("stockpileMaxMonths");
    public static float STOCKPILE_COST_MULT = Global.getSettings().getFloat("stockpileCostMult");
    public static float STOCKPILE_SHORTAGE_COST_MULT = Global.getSettings().getFloat("stockpileShortageCostMult");
    protected CargoAPI taken;
    protected CargoAPI left;
    protected Map<String, MutableStat> stockpilingBonus = new HashMap<String, MutableStat>();
    protected transient CargoAPI preTransactionCargoCopy = null;

    public LocalResourcesSubmarketPlugin() {
        this.taken = Global.getFactory().createCargo(true);
        this.left = Global.getFactory().createCargo(true);
    }

    public void init(SubmarketAPI submarket) {
        super.init(submarket);
        Global.getSector().getEconomy().addUpdateListener(this);
        Global.getSector().getListenerManager().addListener(this);
    }

    public boolean showInFleetScreen() {
        return false;
    }

    public boolean showInCargoScreen() {
        return true;
    }

    public boolean isEnabled(CoreUIAPI ui) {
        return true;
    }

    public void advance(float amount) {
        super.advance(amount);
        this.addAndRemoveStockpiledResources(amount, true, false, true);
    }

    public boolean shouldHaveCommodity(CommodityOnMarketAPI com) {
        if (this.market.isIllegal(com)) {
            return !com.getCommodityMarketData().getMarketShareData(this.market).isSourceIsIllegal();
        }
        return true;
    }

    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        if (stack.getCommodityId() == null) {
            return true;
        }
        return stack.getResourceIfResource().hasTag("nonecon");
    }

    public String getIllegalTransferText(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return "Can only store resources";
    }

    public int getStockpileLimit(CommodityOnMarketAPI com) {
        int demand = com.getMaxDemand();
        int shippingGlobal = com.getCommodityMarketData().getMaxShipping(com.getMarket(), false);
        int available = com.getAvailable();
        String modId = this.submarket.getSpecId();
        MutableStat.StatMod mod = com.getAvailableStat().getFlatStatMod(modId);
        if (mod != null && (available -= (int)mod.value) < 0) {
            available = 0;
        }
        int production = com.getMaxSupply();
        production = Math.min(production, available);
        int export = 0;
        demand = com.getMaxDemand();
        export = Math.min(production, shippingGlobal);
        int extra = available - Math.max(export, demand);
        if (extra < 0) {
            extra = 0;
        }
        int deficit = demand - available;
        int imports = available - production;
        if (imports < 0) {
            imports = 0;
        }
        float unit = com.getCommodity().getEconUnit();
        float limit = 0.0f;
        limit += STOCKPILE_MULT_EXCESS * BaseIndustry.getSizeMult(extra) * unit;
        limit += STOCKPILE_MULT_PRODUCTION * BaseIndustry.getSizeMult(production -= extra) * unit;
        limit += STOCKPILE_MULT_IMPORTS * BaseIndustry.getSizeMult(imports) * unit;
        String cid = com.getId();
        if (this.stockpilingBonus.containsKey(cid)) {
            limit += this.stockpilingBonus.get(cid).getModifiedValue() * unit;
        }
        limit *= STOCKPILE_MAX_MONTHS;
        if (deficit > 0) {
            limit = 0.0f;
        }
        if (limit < 0.0f) {
            limit = 0.0f;
        }
        return (int)limit;
    }

    public float getStockpilingAddRateMult(CommodityOnMarketAPI com) {
        return 1.0f / STOCKPILE_MAX_MONTHS;
    }

    public void commodityUpdated(String commodityId) {
        if (Global.getSector().isPaused()) {
            CommodityOnMarketAPI com = this.market.getCommodityData(commodityId);
            this.addAndRemoveStockpiledResources(com, 0.0f, true, false, false);
        }
    }

    public void economyUpdated() {
        if (Global.getSector().isPaused()) {
            this.addAndRemoveStockpiledResources(0.0f, true, false, false);
        }
    }

    public boolean isEconomyListenerExpired() {
        return !this.market.hasSubmarket(this.submarket.getSpecId());
    }

    public boolean isParticipatesInEconomy() {
        return false;
    }

    public boolean isHidden() {
        return !this.market.isPlayerOwned();
    }

    public float getTariff() {
        return 0.0f;
    }

    public boolean isFreeTransfer() {
        return true;
    }

    public void updateCargoPrePlayerInteraction() {
        this.preTransactionCargoCopy = this.getCargo().createCopy();
        this.preTransactionCargoCopy.sort();
        this.getCargo().sort();
    }

    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
        this.sinceLastCargoUpdate = 0.0f;
        this.preTransactionCargoCopy = this.getCargo().createCopy();
        this.preTransactionCargoCopy.sort();
        this.taken.addAll(transaction.getBought());
        this.left.addAll(transaction.getSold());
        CargoAPI copy = this.taken.createCopy();
        this.taken.removeAll(this.left);
        this.left.removeAll(copy);
    }

    protected Object readResolve() {
        super.readResolve();
        if (this.taken == null) {
            this.taken = Global.getFactory().createCargo(true);
        }
        if (this.left == null) {
            this.left = Global.getFactory().createCargo(true);
        }
        if (this.stockpilingBonus == null) {
            this.stockpilingBonus = new HashMap<String, MutableStat>();
        }
        return this;
    }

    public MutableStat getStockpilingBonus(String cid) {
        MutableStat stat = this.stockpilingBonus.get(cid);
        if (stat == null) {
            stat = new MutableStat(0.0f);
            this.stockpilingBonus.put(cid, stat);
        }
        return stat;
    }

    public CargoAPI getLeft() {
        return this.left;
    }

    public int getEstimatedShortageCounteringCostPerMonth() {
        ArrayList<CommodityOnMarketAPI> all = new ArrayList<CommodityOnMarketAPI>(this.market.getAllCommodities());
        float totalCost = 0.0f;
        CargoAPI cargo = this.getCargo();
        for (CommodityOnMarketAPI com : all) {
            int curr = (int)cargo.getCommodityQuantity(com.getId());
            if (curr <= 0) continue;
            float units = LocalResourcesSubmarketPlugin.getDeficitMonthlyCommodityUnits(com);
            units = Math.min(units, cargo.getCommodityQuantity(com.getId()));
            if (!((units -= this.taken.getCommodityQuantity(com.getId())) > 0.0f)) continue;
            float per = LocalResourcesSubmarketPlugin.getStockpilingUnitPrice(com.getCommodity(), true);
            totalCost += units * per;
        }
        return (int)totalCost;
    }

    public static int getStockpilingUnitPrice(CommoditySpecAPI spec, boolean forShortageCountering) {
        int result;
        float mult = STOCKPILE_COST_MULT;
        if (forShortageCountering) {
            mult = STOCKPILE_SHORTAGE_COST_MULT;
        }
        if ((result = Math.round(spec.getBasePrice() * mult)) < 1) {
            result = 1;
        }
        return result;
    }

    public static float getDeficitMonthlyCommodityUnits(CommodityOnMarketAPI com) {
        int available;
        int demand;
        String modId = "local_resources";
        MutableStat.StatMod mod = com.getAvailableStat().getFlatMods().get(modId);
        float modAlready = 0.0f;
        if (mod != null) {
            modAlready = mod.value;
        }
        if ((demand = com.getMaxDemand()) > (available = Math.round((float)com.getAvailable() - modAlready))) {
            float deficitDrawBaseAmount = BaseIndustry.getSizeMult(demand) - BaseIndustry.getSizeMult(available);
            return deficitDrawBaseAmount *= com.getCommodity().getEconUnit();
        }
        return 0.0f;
    }

    protected boolean doShortageCountering(CommodityOnMarketAPI com, float amount, boolean withShortageCountering) {
        CargoAPI cargo = this.getCargo();
        String modId = this.submarket.getSpecId();
        com.getAvailableStat().unmodifyFlat(modId);
        int demand = com.getMaxDemand();
        int available = com.getAvailable();
        if (withShortageCountering && demand > available) {
            int deficit = demand - available;
            if (deficit != deficit) {
                return false;
            }
            float deficitDrawBaseAmount = BaseIndustry.getSizeMult(demand) - BaseIndustry.getSizeMult(available);
            float days = Global.getSector().getClock().convertToDays(amount);
            float drawAmount = (deficitDrawBaseAmount *= com.getCommodity().getEconUnit()) * days / 30.0f;
            float curr = cargo.getCommodityQuantity(com.getId());
            if (curr > 0.0f && deficitDrawBaseAmount > 0.0f) {
                int daysLeft = (int)(curr / deficitDrawBaseAmount * 30.0f);
                String daysStr = "days";
                if (daysLeft <= 1) {
                    daysLeft = 1;
                    daysStr = "day";
                }
                com.getAvailableStat().modifyFlat(modId, deficit, "Local resource stockpiles (" + daysLeft + " " + daysStr + " left)");
                float free = this.left.getCommodityQuantity(com.getId());
                free = Math.min(drawAmount, free);
                this.left.removeCommodity(com.getId(), free);
                if (drawAmount > 0.0f) {
                    cargo.removeCommodity(com.getId(), drawAmount);
                }
                drawAmount -= free;
                if (this.market.isPlayerOwned() && drawAmount > 0.0f) {
                    MonthlyReport report = SharedData.getData().getCurrentReport();
                    MonthlyReport.FDNode node = report.getCounterShortageNode(this.market);
                    CargoAPI tooltipCargo = (CargoAPI)node.custom2;
                    float addToTooltipCargo = drawAmount;
                    float q = tooltipCargo.getCommodityQuantity(com.getId()) + addToTooltipCargo;
                    if (q < 1.0f) {
                        addToTooltipCargo = 1.0f;
                    }
                    tooltipCargo.addCommodity(com.getId(), addToTooltipCargo);
                    float unitPrice = LocalResourcesSubmarketPlugin.getStockpilingUnitPrice(com.getCommodity(), true);
                    MonthlyReport.FDNode comNode = report.getNode(node, com.getId());
                    CommoditySpecAPI spec = com.getCommodity();
                    comNode.icon = spec.getIconName();
                    comNode.upkeep += unitPrice * drawAmount;
                    comNode.custom = com;
                    if (comNode.custom2 == null) {
                        comNode.custom2 = Float.valueOf(0.0f);
                    }
                    comNode.custom2 = Float.valueOf(((Float)comNode.custom2).floatValue() + drawAmount);
                    float qty = Math.max(1.0f, ((Float)comNode.custom2).floatValue());
                    qty = (float)Math.ceil(qty);
                    comNode.name = String.valueOf(spec.getName()) + " " + "\u00d7" + Misc.getWithDGS(qty);
                    comNode.tooltipCreator = report.getMonthlyReportTooltip();
                }
            }
            return true;
        }
        return false;
    }

    public void reportEconomyMonthEnd() {
        if (this.isEconomyListenerExpired()) {
            Global.getSector().getListenerManager().removeListener(this);
            return;
        }
    }

    public void reportEconomyTick(int iterIndex) {
        if (this.isEconomyListenerExpired()) {
            Global.getSector().getListenerManager().removeListener(this);
            return;
        }
        int lastIterInMonth = (int)Global.getSettings().getFloat("economyIterPerMonth") - 1;
        if (iterIndex != lastIterInMonth) {
            return;
        }
        if (this.market.isPlayerOwned()) {
            CargoAPI copy = this.taken.createCopy();
            this.taken.removeAll(this.left);
            this.left.removeAll(copy);
            MonthlyReport report = SharedData.getData().getCurrentReport();
            for (CargoStackAPI stack : this.taken.getStacksCopy()) {
                if (!stack.isCommodityStack()) continue;
                MonthlyReport.FDNode node = report.getRestockingNode(this.market);
                CargoAPI tooltipCargo = (CargoAPI)node.custom2;
                float addToTooltipCargo = stack.getSize();
                String cid = stack.getCommodityId();
                float q = tooltipCargo.getCommodityQuantity(cid) + addToTooltipCargo;
                if (q < 1.0f) {
                    addToTooltipCargo = 1.0f;
                }
                tooltipCargo.addCommodity(cid, addToTooltipCargo);
                float unitPrice = LocalResourcesSubmarketPlugin.getStockpilingUnitPrice(stack.getResourceIfResource(), false);
                MonthlyReport.FDNode comNode = report.getNode(node, cid);
                CommoditySpecAPI spec = stack.getResourceIfResource();
                comNode.icon = spec.getIconName();
                comNode.upkeep += unitPrice * addToTooltipCargo;
                comNode.custom = this.market.getCommodityData(cid);
                if (comNode.custom2 == null) {
                    comNode.custom2 = Float.valueOf(0.0f);
                }
                comNode.custom2 = Float.valueOf(((Float)comNode.custom2).floatValue() + addToTooltipCargo);
                float qty = Math.max(1.0f, ((Float)comNode.custom2).floatValue());
                qty = (float)Math.ceil(qty);
                comNode.name = String.valueOf(spec.getName()) + " " + "\u00d7" + Misc.getWithDGS(qty);
                comNode.tooltipCreator = report.getMonthlyReportTooltip();
            }
        }
        this.taken.clear();
    }

    public String getBuyVerb() {
        return "Take";
    }

    public String getSellVerb() {
        return "Leave";
    }

    public String getTariffTextOverride() {
        return "End of month";
    }

    public String getTariffValueOverride() {
        if (this.preTransactionCargoCopy == null) {
            return null;
        }
        CargoAPI cargo = this.getCargo();
        float total = 0.0f;
        HashSet<String> seen = new HashSet<String>();
        for (CargoStackAPI stack : this.preTransactionCargoCopy.getStacksCopy()) {
            String cid;
            if (!stack.isCommodityStack() || seen.contains(cid = stack.getCommodityId())) continue;
            seen.add(cid);
            CommodityOnMarketAPI com = this.market.getCommodityData(cid);
            int pre = (int)this.preTransactionCargoCopy.getCommodityQuantity(cid);
            int post = (int)cargo.getCommodityQuantity(cid);
            int units = pre - post;
            units = (int)((float)units - this.left.getCommodityQuantity(cid));
            if (units <= 0) continue;
            float price = LocalResourcesSubmarketPlugin.getStockpilingUnitPrice(com.getCommodity(), false);
            total += price * (float)units;
        }
        return Misc.getDGSCredits(total);
    }

    public String getTotalTextOverride() {
        return "Now";
    }

    public String getTotalValueOverride() {
        return "0\u00a2";
    }

    public boolean isTooltipExpandable() {
        return false;
    }

    public float getTooltipWidth() {
        return 500.0f;
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        ArrayList<CommodityOnMarketAPI> all = new ArrayList<CommodityOnMarketAPI>(this.market.getAllCommodities());
        Collections.sort(all, new Comparator<CommodityOnMarketAPI>(){

            @Override
            public int compare(CommodityOnMarketAPI o1, CommodityOnMarketAPI o2) {
                int limit1 = LocalResourcesSubmarketPlugin.this.getStockpileLimit(o1);
                int limit2 = LocalResourcesSubmarketPlugin.this.getStockpileLimit(o2);
                return limit2 - limit1;
            }
        });
        float opad = 10.0f;
        tooltip.beginGridFlipped(400.0f, 1, 70.0f, opad);
        int j = 0;
        for (CommodityOnMarketAPI com : all) {
            int limit;
            if (com.isNonEcon() || com.getCommodity().isMeta() || !this.shouldHaveCommodity(com) || (limit = Math.round((float)this.getStockpileLimit(com) * this.getStockpilingAddRateMult(com))) <= 0) continue;
            tooltip.addToGrid(0, j++, com.getCommodity().getName(), Misc.getWithDGS(limit));
        }
        tooltip.addPara("A portion of the resources produced by the colony will be made available here. These resources can be extracted from the colony's economy for a cost equal to %s of their base value. This cost will be deducted at the end of the month.", opad, Misc.getHighlightColor(), Math.round(STOCKPILE_COST_MULT * 100.0f) + "%");
        tooltip.addPara("These resources can also be used to counter temporary shortages, for a cost equal to %s of their base value. If additional resources are placed here, they will be used as well, at no cost.", opad, Misc.getHighlightColor(), Math.round(STOCKPILE_SHORTAGE_COST_MULT * 100.0f) + "%");
        tooltip.addSectionHeading("Stockpiled per month", this.market.getFaction().getBaseUIColor(), this.market.getFaction().getDarkUIColor(), Alignment.MID, opad);
        if (j > 0) {
            tooltip.addGrid(opad);
            tooltip.addPara("Stockpiles are limited to %s the monthly rate.", opad, Misc.getHighlightColor(), (int)STOCKPILE_MAX_MONTHS + "\u00d7");
        } else {
            tooltip.addPara("No stockpiling.", opad);
        }
    }
}

