/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTerrain;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.xml.bind.DatatypeConverter;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public abstract class BaseTiledTerrain
extends BaseTerrain {
    protected TileParams params;
    protected transient SpriteAPI texture;
    protected transient SpriteAPI mapTexture;
    protected transient int[][] tiles;
    protected long tileSeed;
    protected String savedTiles;
    protected float elapsed = 0.0f;

    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.params = (TileParams)param;
        this.name = this.params.name;
        if (this.name == null) {
            this.name = "Unknown";
        }
        this.tiles = new int[this.params.w][this.params.h];
        this.tileSeed = new Random().nextLong();
        int i = 0;
        while (i < this.tiles.length) {
            int j = 0;
            while (j < this.tiles[0].length) {
                int index = i + (this.tiles[0].length - j - 1) * this.tiles.length;
                char c = this.params.tiles.charAt(index);
                this.tiles[i][j] = !Character.isWhitespace(c) ? 1 : -1;
                ++j;
            }
            ++i;
        }
        this.savedTiles = BaseTiledTerrain.encodeTiles(this.tiles);
        this.readResolve();
        this.params.tiles = null;
    }

    protected void regenTiles() {
        Random random = new Random(this.tileSeed);
        int i = 0;
        while (i < this.tiles.length) {
            int j = 0;
            while (j < this.tiles[0].length) {
                if (this.tiles[i][j] >= 0) {
                    int texX = (int)(random.nextFloat() * (float)this.params.tW);
                    int texY = (int)(random.nextFloat() * (float)this.params.tH);
                    this.tiles[i][j] = texX + texY * this.params.tW;
                } else {
                    this.tiles[i][j] = -1;
                }
                ++j;
            }
            ++i;
        }
    }

    public int[][] getTiles() {
        return this.tiles;
    }

    public TileParams getParams() {
        return this.params;
    }

    Object readResolve() {
        this.texture = Global.getSettings().getSprite(this.params.cat, this.params.key);
        this.mapTexture = Global.getSettings().getSprite(this.params.cat, String.valueOf(this.params.key) + "_map");
        if (this.savedTiles != null) {
            try {
                this.tiles = BaseTiledTerrain.decodeTiles(this.savedTiles, this.params.w, this.params.h);
            }
            catch (DataFormatException e) {
                throw new RuntimeException("Error decoding tiled terrain tiles", e);
            }
        } else {
            this.tiles = new int[this.params.w][this.params.h];
        }
        this.regenTiles();
        return this;
    }

    Object writeReplace() {
        this.params.tiles = null;
        this.savedTiles = BaseTiledTerrain.encodeTiles(this.tiles);
        return this;
    }

    public boolean containsEntity(SectorEntityToken other) {
        if (other.getContainingLocation() != this.entity.getContainingLocation()) {
            return false;
        }
        return this.containsPoint(other.getLocation(), other.getRadius()) && !this.isPreventedFromAffecting(other);
    }

    public boolean containsPoint(Vector2f test, float r) {
        float dist = Misc.getDistance(this.entity.getLocation(), test) - r;
        if (dist > this.getRenderRange()) {
            return false;
        }
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float containsSize = this.getTileContainsSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        x -= w / 2.0f;
        y -= h / 2.0f;
        float extra = (containsSize - size) / 2.0f;
        if (test.x + r + extra < x) {
            return false;
        }
        if (test.y + r + extra < y) {
            return false;
        }
        if (test.x > x + w + r + extra) {
            return false;
        }
        if (test.y > y + h + r + extra) {
            return false;
        }
        int xIndex = (int)((test.x - x) / size);
        int yIndex = (int)((test.y - y) / size);
        if (xIndex < 0) {
            xIndex = 0;
        }
        if (yIndex < 0) {
            yIndex = 0;
        }
        if (xIndex >= this.tiles.length) {
            xIndex = this.tiles.length - 1;
        }
        if (yIndex >= this.tiles[0].length) {
            yIndex = this.tiles[0].length - 1;
        }
        float i = Math.max(0, xIndex - 1);
        while (i <= (float)(xIndex + 1) && i < (float)this.tiles.length) {
            float j = Math.max(0, yIndex - 1);
            while (j <= (float)(yIndex + 1) && j < (float)this.tiles[0].length) {
                int texIndex = this.tiles[(int)i][(int)j];
                if (texIndex >= 0) {
                    float tx = x + i * size + size / 2.0f - containsSize / 2.0f;
                    float ty = y + j * size + size / 2.0f - containsSize / 2.0f;
                    if (!(test.x + r < tx || test.y + r < ty || test.x > tx + containsSize + r || test.y > ty + containsSize + r)) {
                        return true;
                    }
                }
                j += 1.0f;
            }
            i += 1.0f;
        }
        return false;
    }

    public abstract float getTileSize();

    public abstract float getTileRenderSize();

    public abstract float getTileContainsSize();

    public abstract void preRender(CampaignEngineLayers var1, float var2);

    public abstract void preMapRender(float var1);

    public abstract Color getRenderColor();

    public float getRenderRange() {
        float size = this.getTileSize();
        float renderSize = this.getTileRenderSize();
        float w = (float)this.tiles.length * size * 0.5f + (renderSize - size) * 0.5f;
        float h = (float)this.tiles[0].length * size * 0.5f + (renderSize - size) * 0.5f;
        return Math.max(w, h) * 1.5f;
    }

    public void render(CampaignEngineLayers layer, ViewportAPI v) {
        float yEnd;
        float xEnd;
        float yStart;
        this.texture.bindTexture();
        GL11.glEnable((int)3553);
        this.preRender(layer, v.getAlphaMult());
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float renderSize = this.getTileRenderSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        x -= w / 2.0f;
        y -= h / 2.0f;
        float extra = (renderSize - size) / 2.0f + 100.0f;
        float llx = v.getLLX();
        float lly = v.getLLY();
        float vw = v.getVisibleWidth();
        float vh = v.getVisibleHeight();
        if (llx > x + w + extra) {
            return;
        }
        if (lly > y + h + extra) {
            return;
        }
        if (llx + vw + extra < x) {
            return;
        }
        if (lly + vh + extra < y) {
            return;
        }
        float xStart = (int)((llx - x - extra) / size);
        if (xStart < 0.0f) {
            xStart = 0.0f;
        }
        if ((yStart = (float)((int)((lly - y - extra) / size))) < 0.0f) {
            yStart = 0.0f;
        }
        if ((xEnd = (float)((int)((llx + vw - x + extra) / size) + 1)) >= (float)this.tiles.length) {
            xEnd = this.tiles.length - 1;
        }
        if ((yEnd = (float)((int)((lly + vw - y + extra) / size) + 1)) >= (float)this.tiles.length) {
            yEnd = this.tiles[0].length - 1;
        }
        this.renderSubArea(xStart, xEnd, yStart, yEnd, 1.0f, 1, v.getAlphaMult());
    }

    public boolean isTileVisible(int i, int j) {
        float yEnd;
        float xEnd;
        float yStart;
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float renderSize = this.getTileRenderSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        x -= w / 2.0f;
        y -= h / 2.0f;
        float extra = (renderSize - size) / 2.0f + 100.0f;
        ViewportAPI v = Global.getSector().getViewport();
        float llx = v.getLLX();
        float lly = v.getLLY();
        float vw = v.getVisibleWidth();
        float vh = v.getVisibleHeight();
        if (llx > x + w + extra) {
            return false;
        }
        if (lly > y + h + extra) {
            return false;
        }
        if (llx + vw + extra < x) {
            return false;
        }
        if (lly + vh + extra < y) {
            return false;
        }
        float xStart = (int)((llx - x - extra) / size);
        if (xStart < 0.0f) {
            xStart = 0.0f;
        }
        if ((yStart = (float)((int)((lly - y - extra) / size))) < 0.0f) {
            yStart = 0.0f;
        }
        if ((xEnd = (float)((int)((llx + vw - x + extra) / size) + 1)) >= (float)this.tiles.length) {
            xEnd = this.tiles.length - 1;
        }
        if ((yEnd = (float)((int)((lly + vw - y + extra) / size) + 1)) >= (float)this.tiles.length) {
            yEnd = this.tiles[0].length - 1;
        }
        if ((float)i < xStart) {
            return false;
        }
        if ((float)i > xEnd) {
            return false;
        }
        if ((float)j < yStart) {
            return false;
        }
        return !((float)j > yEnd);
    }

    public void renderOnMap(float factor, float alphaMult) {
        this.mapTexture.bindTexture();
        GL11.glEnable((int)3553);
        this.preMapRender(alphaMult);
        this.renderSubArea(0.0f, this.tiles.length, 0.0f, this.tiles[0].length, factor, this.getNumMapSamples(), alphaMult);
    }

    public int getNumMapSamples() {
        return 5;
    }

    public void renderOnMapAbove(float factor, float alphaMult) {
    }

    public float[] getTileCenter(int i, int j) {
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        float[] result = new float[]{x - w / 2.0f + (float)i * size + size / 2.0f, y - h / 2.0f + (float)j * size + size / 2.0f};
        return result;
    }

    protected void renderSubArea(float startColumn, float endColumn, float startRow, float endRow, float factor, int samples, float alphaMult) {
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float renderSize = this.getTileRenderSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        if (samples == 1) {
            GL11.glBegin((int)7);
            float i = startColumn;
            while (i <= endColumn) {
                if (!(i < 0.0f) && !(i >= (float)this.tiles.length)) {
                    float j = startRow;
                    while (j <= endRow) {
                        int texIndex;
                        if (!(j < 0.0f) && !(j >= (float)this.tiles[0].length) && (texIndex = this.tiles[(int)i][(int)j]) >= 0) {
                            int texCellX = texIndex % this.params.tW;
                            int texCellY = texIndex / this.params.tW;
                            Random rand = new Random((long)(i + j * (float)this.tiles.length) * 1000000L);
                            float angle = rand.nextFloat() * 360.0f;
                            float offRange = renderSize * 0.25f;
                            float xOff = -offRange / 2.0f + offRange * rand.nextFloat();
                            float yOff = -offRange / 2.0f + offRange * rand.nextFloat();
                            this.renderQuad((int)i, (int)j, (x + xOff - w / 2.0f + i * size + size / 2.0f - renderSize / 2.0f) * factor, (y + yOff - h / 2.0f + j * size + size / 2.0f - renderSize / 2.0f) * factor, renderSize * factor, renderSize * factor, (float)texCellX * 0.25f, (float)texCellY * 0.25f, 0.25f, 0.25f, angle);
                        }
                        j += 1.0f;
                    }
                }
                i += 1.0f;
            }
            GL11.glEnd();
        } else {
            renderSize *= (float)samples;
            size *= (float)samples;
            alphaMult *= 0.67f;
            GL11.glBegin((int)7);
            float max = samples * samples;
            float i = startColumn;
            while (i <= endColumn) {
                if (!(i < 0.0f) && !(i >= (float)this.tiles.length)) {
                    float j = startRow;
                    while (j <= endRow) {
                        int texIndex = -1;
                        float angle = 0.0f;
                        float xOff = 0.0f;
                        float yOff = 0.0f;
                        float weight = 0.0f;
                        int m = 0;
                        while (m < samples && i + (float)m <= endColumn) {
                            if (!(i + (float)m < 0.0f) && !(i + (float)m >= (float)this.tiles.length)) {
                                int n = 0;
                                while (n < samples && j + (float)n < endRow) {
                                    if (!(j + (float)n < 0.0f) && !(j + (float)n >= (float)this.tiles[0].length)) {
                                        int currIndex = this.tiles[(int)i + m][(int)j + n];
                                        if (currIndex >= 0 && texIndex < 0) {
                                            texIndex = currIndex;
                                            Random rand = new Random((long)(i + j * (float)this.tiles.length) * 1000000L);
                                            angle = rand.nextFloat() * 360.0f;
                                            float offRange = renderSize * 0.25f;
                                            xOff = -offRange / 2.0f + offRange * rand.nextFloat();
                                            yOff = -offRange / 2.0f + offRange * rand.nextFloat();
                                        }
                                        if (currIndex >= 0) {
                                            weight += 1.0f;
                                        }
                                    }
                                    ++n;
                                }
                            }
                            ++m;
                        }
                        if (texIndex >= 0) {
                            int texCellX = texIndex % this.params.tW;
                            int texCellY = texIndex / this.params.tW;
                            Color color = this.getRenderColor();
                            float b = alphaMult * weight / max;
                            GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * b)));
                            this.renderQuad((int)i, (int)j, (x + xOff - w / 2.0f + i / (float)samples * size + size / 2.0f - renderSize / 2.0f) * factor, (y + yOff - h / 2.0f + j / (float)samples * size + size / 2.0f - renderSize / 2.0f) * factor, renderSize * factor, renderSize * factor, (float)texCellX * 0.25f, (float)texCellY * 0.25f, 0.25f, 0.25f, angle);
                        }
                        j += (float)samples;
                    }
                }
                i += (float)samples;
            }
            GL11.glEnd();
        }
    }

    public void advance(float amount) {
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsed += days;
    }

    protected void renderQuad(int i, int j, float x, float y, float width, float height, float texX, float texY, float texW, float texH, float angle) {
        if (angle != 0.0f) {
            float vw = width / 2.0f;
            float vh = height / 2.0f;
            float cx = x + vw;
            float cy = y + vh;
            float cos = (float)Math.cos(angle * Misc.RAD_PER_DEG);
            float sin = (float)Math.sin(angle * Misc.RAD_PER_DEG);
            GL11.glTexCoord2f((float)texX, (float)texY);
            GL11.glVertex2f((float)(cx + (-vw * cos + vh * sin)), (float)(cy + (-vw * sin - vh * cos)));
            GL11.glTexCoord2f((float)texX, (float)(texY + texH));
            GL11.glVertex2f((float)(cx + (-vw * cos - vh * sin)), (float)(cy + (-vw * sin + vh * cos)));
            GL11.glTexCoord2f((float)(texX + texW), (float)(texY + texH));
            GL11.glVertex2f((float)(cx + (vw * cos - vh * sin)), (float)(cy + (vw * sin + vh * cos)));
            GL11.glTexCoord2f((float)(texX + texW), (float)texY);
            GL11.glVertex2f((float)(cx + (vw * cos + vh * sin)), (float)(cy + (vw * sin - vh * cos)));
        } else {
            GL11.glTexCoord2f((float)texX, (float)texY);
            GL11.glVertex2f((float)x, (float)y);
            GL11.glTexCoord2f((float)texX, (float)(texY + texH));
            GL11.glVertex2f((float)x, (float)(y + height));
            GL11.glTexCoord2f((float)(texX + texW), (float)(texY + texH));
            GL11.glVertex2f((float)(x + width), (float)(y + height));
            GL11.glTexCoord2f((float)(texX + texW), (float)texY);
            GL11.glVertex2f((float)(x + width), (float)y);
        }
    }

    public float getMaxEffectRadius(Vector2f locFrom) {
        float size = this.getTileSize();
        float renderSize = this.getTileRenderSize();
        float w = (float)this.tiles.length * size * 0.5f + (renderSize - size) * 0.5f;
        float h = (float)this.tiles[0].length * size * 0.5f + (renderSize - size) * 0.5f;
        return Math.max(w, h) * 1.5f;
    }

    public float getMinEffectRadius(Vector2f locFrom) {
        return 0.0f;
    }

    public float getOptimalEffectRadius(Vector2f locFrom) {
        return this.getMaxEffectRadius(locFrom);
    }

    protected float getExtraSoundRadius() {
        return 200.0f;
    }

    public float getProximitySoundFactor() {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float r = player.getRadius() + this.getExtraSoundRadius();
        Vector2f test = player.getLocation();
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float containsSize = this.getTileContainsSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        x -= w / 2.0f;
        y -= h / 2.0f;
        float extra = (containsSize - size) / 2.0f;
        if (test.x + r + extra < x) {
            return 0.0f;
        }
        if (test.y + r + extra < y) {
            return 0.0f;
        }
        if (test.x > x + w + r + extra) {
            return 0.0f;
        }
        if (test.y > y + h + r + extra) {
            return 0.0f;
        }
        int xIndex = (int)((test.x - x) / size);
        int yIndex = (int)((test.y - y) / size);
        if (xIndex < 0) {
            xIndex = 0;
        }
        if (yIndex < 0) {
            yIndex = 0;
        }
        if (xIndex >= this.tiles.length) {
            xIndex = this.tiles.length - 1;
        }
        if (yIndex >= this.tiles[0].length) {
            yIndex = this.tiles[0].length - 1;
        }
        float closestDist = Float.MAX_VALUE;
        float i = Math.max(0, xIndex - 2);
        while (i <= (float)(xIndex + 2) && i < (float)this.tiles.length) {
            float j = Math.max(0, yIndex - 2);
            while (j <= (float)(yIndex + 2) && j < (float)this.tiles[0].length) {
                int texIndex = this.tiles[(int)i][(int)j];
                if (texIndex >= 0) {
                    float dy;
                    float dx;
                    float dist;
                    float tx = x + i * size + size / 2.0f - containsSize / 2.0f;
                    float ty = y + j * size + size / 2.0f - containsSize / 2.0f;
                    if (!(test.x + r < tx || test.y + r < ty || test.x > tx + containsSize + r || test.y > ty + containsSize + r || !((dist = Math.max(dx = Math.abs(test.x - tx - containsSize / 2.0f), dy = Math.abs(test.y - ty - containsSize / 2.0f))) < closestDist))) {
                        closestDist = dist;
                    }
                }
                j += 1.0f;
            }
            i += 1.0f;
        }
        float max = containsSize * 0.5f + this.getExtraSoundRadius();
        if (closestDist < containsSize * 0.5f) {
            return 1.0f;
        }
        float p = (max - closestDist) / (max - containsSize * 0.5f);
        if (p < 0.0f) {
            p = 0.0f;
        }
        if (p > 1.0f) {
            p = 1.0f;
        }
        return p;
    }

    public static String encodeTiles(int[][] tiles) {
        int w = tiles.length;
        int h = tiles[0].length;
        int total = w * h;
        int[] masks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
        int bit = 0;
        int curr = 0;
        byte[] input = new byte[(int)Math.ceil((float)total / 8.0f)];
        int i = 0;
        while (i < total) {
            int x = i % w;
            int y = i / w;
            int val = tiles[x][y];
            int mask = masks[bit];
            if (val >= 0) {
                curr |= mask;
            }
            ++bit;
            if ((bit %= 8) == 0) {
                input[i / 8] = (byte)curr;
                curr = 0;
            }
            ++i;
        }
        if (bit != 0) {
            input[input.length - 1] = (byte)curr;
            curr = 0;
        }
        Deflater compressor = new Deflater();
        compressor.setInput(input);
        compressor.finish();
        StringBuilder result = new StringBuilder();
        byte[] temp = new byte[100];
        while (!compressor.finished()) {
            int read = compressor.deflate(temp);
            result.append(BaseTiledTerrain.toHexString(Arrays.copyOf(temp, read)));
        }
        compressor.end();
        return result.toString();
    }

    public static int[][] decodeTiles(String string, int w, int h) throws DataFormatException {
        byte[] input = BaseTiledTerrain.toByteArray(string);
        Inflater decompressor = new Inflater();
        decompressor.setInput(input);
        int[][] tiles = new int[w][h];
        int total = w * h;
        int curr = 0;
        byte[] temp = new byte[100];
        block0: while (!decompressor.finished()) {
            int read = decompressor.inflate(temp);
            int i = 0;
            while (i < read) {
                byte b = temp[i];
                int j = 7;
                while (j >= 0) {
                    int x = curr % w;
                    int y = curr / w;
                    if (++curr > total) break block0;
                    tiles[x][y] = (b & 1 << j) > 0 ? 1 : -1;
                    --j;
                }
                ++i;
            }
        }
        decompressor.end();
        return tiles;
    }

    public static String toHexString(byte[] array) {
        return DatatypeConverter.printBase64Binary((byte[])array);
    }

    public static byte[] toByteArray(String s) {
        return DatatypeConverter.parseBase64Binary((String)s);
    }

    public static void main(String[] args) throws DataFormatException {
        int[][] tiles = new int[][]{{-1, 1, 1, 1, -1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, -1}, {1, 1, 1, -1, 1}};
        System.out.println("Original:");
        int i = 0;
        while (i < tiles.length) {
            int j = 0;
            while (j < tiles[0].length) {
                System.out.print(String.format("% 2d,", tiles[i][j]));
                ++j;
            }
            System.out.println();
            ++i;
        }
        String result = BaseTiledTerrain.encodeTiles(tiles);
        System.out.println(result);
        int[][] tilesBack = BaseTiledTerrain.decodeTiles(result, tiles.length, tiles[0].length);
        System.out.println("Decoded:");
        int i2 = 0;
        while (i2 < tilesBack.length) {
            int j = 0;
            while (j < tilesBack[0].length) {
                System.out.print(String.format("% 2d,", tilesBack[i2][j]));
                ++j;
            }
            System.out.println();
            ++i2;
        }
        boolean equals = true;
        int i3 = 0;
        while (i3 < tiles.length) {
            int j = 0;
            while (j < tiles[0].length) {
                if (tiles[i3][j] != tilesBack[i3][j]) {
                    equals = false;
                }
                ++j;
            }
            ++i3;
        }
        System.out.println("Equal: " + equals);
    }

    public static class TileParams {
        public String tiles;
        public int w;
        public int h;
        public String cat;
        public String key;
        public int tW;
        public int tH;
        public String name;

        public TileParams(String tiles, int width, int height, String tileTexCat, String tileTexKey, int tilesWide, int tilesHigh, String name) {
            this.tiles = tiles;
            this.w = width;
            this.h = height;
            this.cat = tileTexCat;
            this.key = tileTexKey;
            this.tW = tilesWide;
            this.tH = tilesHigh;
            this.name = name;
        }
    }
}

