/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTerrain;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WavefrontTerrainPlugin
extends BaseTerrain {
    protected transient SpriteAPI texture = null;
    protected WavefrontParams params;
    protected Vector2f arcOrigin = new Vector2f();
    protected Vector2f velDir = new Vector2f();
    protected Vector2f p1 = new Vector2f();
    protected Vector2f p2 = new Vector2f();
    protected float distanceTravelled = 0.0f;
    protected float currentWidth;
    protected float currentThickness;
    protected float currentArc = 0.0f;
    protected float phaseAngle;
    protected int numSegments;
    protected FaderUtil fader = new FaderUtil(0.0f, 0.2f, 1.0f);
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.TERRAIN_6, CampaignEngineLayers.TERRAIN_10);

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.params = (WavefrontParams)param;
        this.fader.fadeIn();
        this.velDir = Misc.getUnitVectorAtDegreeAngle(this.params.angle);
        this.currentThickness = this.params.startThickness;
        this.currentWidth = this.params.startWidth;
        this.numSegments = (int)((this.params.startWidth + this.params.widthExpansionRate * this.params.duration) / this.getPixelsPerSegment());
        if (this.numSegments < 5) {
            this.numSegments = 5;
        }
        this.phaseAngle = (float)Math.random() * 360.0f;
        this.readResolve();
    }

    Object readResolve() {
        this.texture = Global.getSettings().getSprite("terrain", "wavefront");
        this.layers = EnumSet.of(CampaignEngineLayers.TERRAIN_6, CampaignEngineLayers.TERRAIN_10);
        return this;
    }

    protected float getPixelsPerSegment() {
        return 25.0f;
    }

    Object writeReplace() {
        return this;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public WavefrontParams getParams() {
        return this.params;
    }

    protected void updateArcOrigin() {
        this.arcOrigin = Misc.getUnitVectorAtDegreeAngle(this.params.angle);
        this.arcOrigin.scale(this.params.arcOriginRange + this.distanceTravelled);
        this.arcOrigin.negate();
        Vector2f.add((Vector2f)this.entity.getLocation(), (Vector2f)this.arcOrigin, (Vector2f)this.arcOrigin);
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        this.updateArcOrigin();
        this.updateArcOfCurrWidth();
        float days = Global.getSector().getClock().convertToDays(amount);
        this.fader.advance(days);
        this.params.duration -= days;
        if (this.params.duration <= 0.0f) {
            this.fader.fadeOut();
        }
        if (this.fader.isFadedOut()) {
            this.entity.getContainingLocation().removeEntity(this.entity);
            return;
        }
        this.currentWidth += this.params.widthExpansionRate * days;
        this.currentThickness += this.params.thicknessExpansionRate * days;
        float speed = Misc.getSpeedForBurnLevel(this.params.burnLevel);
        this.distanceTravelled += (speed *= this.fader.getBrightness()) * amount;
        this.entity.getVelocity().set((ReadableVector2f)this.velDir);
        this.entity.getVelocity().scale(speed);
        this.phaseAngle += days * 360.0f * 0.2f * 1.0f * (1.0f / (this.currentWidth / 800.0f));
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        float endRad;
        float alphaMult = viewport.getAlphaMult();
        if ((alphaMult *= this.fader.getBrightness()) <= 0.0f) {
            return;
        }
        float xOff = 0.0f;
        float yOff = 0.0f;
        if (layer == CampaignEngineLayers.TERRAIN_10) {
            float offset = 50.0f;
            if (offset > this.currentThickness * 0.5f) {
                offset = this.currentThickness * 0.5f;
            }
            xOff = this.velDir.x * -offset;
            yOff = this.velDir.y * -offset;
        }
        float bandWidthInTexture = 256.0f;
        float max = this.params.arcOriginRange + this.distanceTravelled;
        float radEnd = max;
        float min = max - this.currentThickness;
        float radStart = min;
        if (radEnd < radStart + 10.0f) {
            radEnd = radStart + 10.0f;
        }
        float segments = this.numSegments;
        float angle1 = Misc.getAngleInDegrees(this.arcOrigin, this.p1);
        float angle2 = Misc.getAngleInDegrees(this.arcOrigin, this.p2);
        float turnDir = Misc.getClosestTurnDirection(Misc.getUnitVectorAtDegreeAngle(angle1), Misc.getUnitVectorAtDegreeAngle(angle2));
        float startRad = (float)Math.toRadians(angle1);
        if (startRad > (endRad = (float)Math.toRadians(angle2))) {
            endRad = (float)((double)endRad + Math.PI * 2);
        }
        float spanRad = Math.abs(endRad - startRad);
        float anglePerSegment = spanRad / segments;
        Vector2f loc = this.arcOrigin;
        float x = loc.x;
        float y = loc.y;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glEnable((int)3553);
        this.texture.bindTexture();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float thickness = (radEnd - radStart) * 1.0f;
        float radius = radStart;
        float texProgress = 0.0f;
        float texHeight = this.texture.getTextureHeight();
        float imageHeight = this.texture.getHeight();
        float texPerSegment = this.getPixelsPerSegment() * texHeight / imageHeight * bandWidthInTexture / this.params.startThickness;
        texPerSegment *= 0.78125f;
        texPerSegment *= 0.78125f;
        float totalTex = Math.max(1.0f, (float)Math.round((texPerSegment *= 1.0f) * segments));
        texPerSegment = totalTex / segments;
        float texWidth = this.texture.getTextureWidth();
        float imageWidth = this.texture.getWidth();
        float fadeDist = this.getFadeDist();
        float periodMult = 6.283f / spanRad * 0.25f * this.currentWidth / 800.0f;
        texProgress = this.phaseAngle / 360.0f * 5.0f * 0.25f;
        if (layer == CampaignEngineLayers.TERRAIN_10) {
            periodMult *= 1.25f;
            texProgress = this.phaseAngle / 360.0f * -1.0f * 0.25f;
        }
        int iter = 0;
        while (iter < 4) {
            float bandIndex = iter == 0 ? 1.0f : (iter == 2 ? 2.0f : (iter == 3 ? 3.0f : 0.0f));
            float leftTX = bandIndex * texWidth * bandWidthInTexture / imageWidth;
            float rightTX = (bandIndex + 1.0f) * texWidth * bandWidthInTexture / imageWidth - 0.001f;
            float temp = leftTX;
            leftTX = rightTX;
            rightTX = temp;
            GL11.glBegin((int)8);
            float i = 0.0f;
            while (i < segments) {
                float angleIncrementBase = anglePerSegment;
                float phaseAngleRad = iter == 0 ? (float)Math.toRadians(this.phaseAngle) + i * angleIncrementBase * 10.0f : (iter == 2 ? (float)Math.toRadians(-this.phaseAngle) + i * angleIncrementBase * 15.0f : (iter == 3 ? (float)Math.toRadians(this.phaseAngle) + i * angleIncrementBase * 5.0f : (float)Math.toRadians(-this.phaseAngle) + i * angleIncrementBase * 5.0f));
                float pulseSin = (float)Math.sin(phaseAngleRad * periodMult * 1.0f);
                float pulseAmount = pulseSin * thickness * 0.25f;
                float pulseInner = pulseAmount * 0.5f;
                pulseInner *= 1.0f;
                float r = radius;
                float thicknessMult = 1.25f;
                float thicknessFlat = 0.0f;
                float theta = startRad + turnDir * anglePerSegment * i;
                float cos = (float)Math.cos(theta);
                float sin = (float)Math.sin(theta);
                float x1 = cos * (r - pulseInner);
                float y1 = sin * (r - pulseInner);
                float x2 = cos * (r + thickness * thicknessMult - pulseAmount + thicknessFlat);
                float y2 = sin * (r + thickness * thicknessMult - pulseAmount + thicknessFlat);
                if (iter == 3) {
                    x1 = cos * (r - pulseInner - thickness * 1.0f);
                    y1 = sin * (r - pulseInner - thickness * 1.0f);
                    x2 = cos * (r + thickness * thicknessMult - pulseAmount + thicknessFlat - thickness * 0.0f);
                    y2 = sin * (r + thickness * thicknessMult - pulseAmount + thicknessFlat - thickness * 0.0f);
                }
                x1 += xOff;
                x2 += xOff;
                y1 += yOff;
                y2 += yOff;
                Color color = Color.white;
                float alpha = alphaMult;
                float distFromEdge = i < segments / 2.0f ? i * this.currentWidth / segments : (segments - i - 1.0f) * this.currentWidth / segments;
                GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * (alpha *= Math.min(1.0f, distFromEdge / fadeDist)))));
                GL11.glTexCoord2f((float)leftTX, (float)texProgress);
                GL11.glVertex2f((float)x1, (float)y1);
                GL11.glTexCoord2f((float)rightTX, (float)texProgress);
                GL11.glVertex2f((float)x2, (float)y2);
                texProgress += texPerSegment;
                i += 1.0f;
            }
            GL11.glEnd();
            ++iter;
        }
        GL11.glPopMatrix();
    }

    @Override
    public float getRenderRange() {
        return (this.currentThickness + this.currentWidth) * 0.5f + 200.0f;
    }

    protected void updateArcOfCurrWidth() {
        float diff;
        Vector2f perp = Misc.getPerp(this.velDir);
        this.p1.set((ReadableVector2f)perp);
        this.p2.set((ReadableVector2f)perp).negate();
        this.p1.scale(this.currentWidth * 0.5f);
        this.p2.scale(this.currentWidth * 0.5f);
        Vector2f.add((Vector2f)this.p1, (Vector2f)this.entity.getLocation(), (Vector2f)this.p1);
        Vector2f.add((Vector2f)this.p2, (Vector2f)this.entity.getLocation(), (Vector2f)this.p2);
        float angle1 = Misc.getAngleInDegrees(this.arcOrigin, this.p1);
        float angle2 = Misc.getAngleInDegrees(this.arcOrigin, this.p2);
        this.currentArc = diff = Misc.getAngleDiff(angle1, angle2);
    }

    protected float getFadeDist() {
        float fadeDist = Math.max(300.0f, this.currentWidth / (float)this.numSegments * 4.0f);
        if (fadeDist > this.currentWidth / 3.0f) {
            fadeDist = this.currentWidth / 3.0f;
        }
        return fadeDist;
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        float max;
        float min;
        if (!Misc.isInArc(this.params.angle, this.currentArc, this.arcOrigin, point)) {
            return false;
        }
        float dist = Misc.getDistance(point, this.arcOrigin);
        return dist >= (min = (max = this.params.arcOriginRange + this.distanceTravelled) - this.currentThickness) - radius && dist <= max + radius;
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        if (entity instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            float intensity = this.getIntensityAtPoint(fleet.getLocation());
            if (intensity <= 0.0f) {
                return;
            }
            fleet.getStats().removeTemporaryMod(this.getModId());
            float maxFleetBurn = fleet.getFleetData().getBurnLevel();
            float currFleetBurn = fleet.getCurrBurnLevel();
            float maxWindBurn = this.params.burnLevel;
            float currWindBurn = intensity * maxWindBurn;
            float burnDiff = maxFleetBurn - currWindBurn;
            float maxFleetBurnIntoWind = 0.0f;
            maxFleetBurnIntoWind = burnDiff >= 5.9f ? -this.params.burnLevel + 4.0f : (burnDiff >= 3.9f ? -this.params.burnLevel + 3.0f : (burnDiff >= 2.9f ? -this.params.burnLevel + 2.0f : (burnDiff >= 0.9f ? -this.params.burnLevel + 1.0f : -this.params.burnLevel + 1.0f)));
            float angle = this.getForceDirAtPoint(fleet.getLocation());
            Vector2f windDir = Misc.getUnitVectorAtDegreeAngle(angle);
            Vector2f velDir = Misc.normalise(new Vector2f((ReadableVector2f)fleet.getVelocity()));
            float dot = Vector2f.dot((Vector2f)windDir, (Vector2f)velDir);
            velDir.scale(currFleetBurn);
            float fleetBurnAgainstWind = -1.0f * Vector2f.dot((Vector2f)windDir, (Vector2f)velDir);
            float burnBonus = (currWindBurn - maxFleetBurn) * dot;
            if (dot > 0.0f) {
                if ((burnBonus = (float)Math.round(burnBonus)) < 1.0f) {
                    burnBonus = 1.0f;
                }
                fleet.getStats().addTemporaryModFlat(0.1f, this.getModId(), "In wavefront", burnBonus, fleet.getStats().getFleetwideMaxBurnMod());
            }
            float accelMult = 0.5f;
            if (fleetBurnAgainstWind < maxFleetBurnIntoWind) {
                accelMult = 0.5f;
            } else {
                float diff = Math.abs(fleetBurnAgainstWind - maxFleetBurnIntoWind);
                accelMult = 2.0f + diff * 0.25f;
            }
            float maxSpeed = fleet.getTravelSpeed();
            float baseAccel = Math.max(10.0f, maxSpeed * fleet.getStats().getAccelerationMult().getBaseValue());
            float seconds = days * Global.getSector().getClock().getSecondsPerDay();
            Vector2f vel = fleet.getVelocity();
            windDir.scale(seconds * baseAccel * accelMult);
            fleet.setVelocity(vel.x + windDir.x, vel.y + windDir.y);
            Color glowColor = new Color(100, 200, 255, 75);
            int alpha = glowColor.getAlpha();
            if (alpha < 75) {
                glowColor = Misc.setAlpha(glowColor, 75);
            }
            float durIn = 1.0f;
            float durOut = 2.0f;
            Misc.normalise(windDir);
            float sizeNormal = 5.0f + 10.0f * intensity;
            for (FleetMemberViewAPI view : fleet.getViews()) {
                view.getWindEffectDirX().shift(this.getModId(), windDir.x * sizeNormal, durIn, durOut, 1.0f);
                view.getWindEffectDirY().shift(this.getModId(), windDir.y * sizeNormal, durIn, durOut, 1.0f);
                view.getWindEffectColor().shift(this.getModId(), glowColor, durIn, durOut, intensity);
            }
        }
    }

    public float getForceDirAtPoint(Vector2f point) {
        float angle1 = Misc.getAngleInDegrees(this.arcOrigin, this.p1);
        float angle2 = Misc.getAngleInDegrees(this.arcOrigin, this.p2);
        float angle3 = Misc.getAngleInDegrees(this.arcOrigin, point);
        float widthPerDegree = this.currentWidth / Misc.getAngleDiff(angle1, angle2);
        float dist1 = Misc.getAngleDiff(angle1, angle3) * widthPerDegree;
        float dist2 = Misc.getAngleDiff(angle2, angle3) * widthPerDegree;
        float fadeDist = this.getFadeDist();
        float turnDir = 0.0f;
        float brightness = 0.0f;
        if (dist1 < fadeDist && dist1 <= dist2) {
            brightness = dist1 / fadeDist;
            turnDir = Misc.getClosestTurnDirection(angle3, this.arcOrigin, this.p1);
        }
        if (dist2 < fadeDist && dist2 <= dist1) {
            brightness = dist2 / fadeDist;
            turnDir = Misc.getClosestTurnDirection(angle3, this.arcOrigin, this.p2);
        }
        return angle3 + (1.0f - brightness) * 45.0f * turnDir;
    }

    public float getIntensityAtPoint(Vector2f point) {
        float angle3;
        float angle2;
        float angle1 = Misc.getAngleInDegrees(this.arcOrigin, this.p1);
        if (!Misc.isBetween(angle1, angle2 = Misc.getAngleInDegrees(this.arcOrigin, this.p2), angle3 = Misc.getAngleInDegrees(this.arcOrigin, point))) {
            return 0.0f;
        }
        float widthPerDegree = this.currentWidth / Misc.getAngleDiff(angle1, angle2);
        float dist1 = Misc.getAngleDiff(angle1, angle3) * widthPerDegree;
        float dist2 = Misc.getAngleDiff(angle2, angle3) * widthPerDegree;
        float fadeDist = this.getFadeDist();
        float sideMult = 1.0f;
        if (dist1 < fadeDist && dist1 <= dist2) {
            sideMult = dist1 / fadeDist;
        }
        if (dist2 < fadeDist && dist2 <= dist1) {
            sideMult = dist2 / fadeDist;
        }
        float distToPoint = Misc.getDistance(this.arcOrigin, point);
        float max = this.params.arcOriginRange + this.distanceTravelled;
        float min = max - this.currentThickness;
        max -= min;
        distToPoint -= min;
        min = 0.0f;
        float f = distToPoint / max;
        f = f > 0.75f ? (1.0f - f) / 0.25f : (f < 0.25f ? (f /= 0.25f) : 1.0f);
        return sideMult * f * this.fader.getBrightness();
    }

    @Override
    public Color getNameColor() {
        Color bad = Misc.getNegativeHighlightColor();
        Color base = super.getNameColor();
        return Misc.interpolateColor(base, bad, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 1.0f);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addTitle("Wavefront");
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("Travel", Alignment.MID, pad);
            nextPad = small;
        }
        tooltip.addPara("Reduces the combat readiness of all ships in the corona at a steady pace.", nextPad);
        tooltip.addPara("The heavy solar wind also makes the star difficult to approach.", pad);
        tooltip.addPara("Occasional solar flare activity takes these effects to even more dangerous levels.", pad);
        if (expanded) {
            tooltip.addSectionHeading("Combat", Alignment.MID, pad);
            tooltip.addPara("Reduces the peak performance time of ships and increases the rate of combat readiness degradation in protracted engagements.", small);
        }
    }

    @Override
    public boolean isTooltipExpandable() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return 350.0f;
    }

    @Override
    public String getTerrainName() {
        return "Wavefront";
    }

    @Override
    public String getNameForTooltip() {
        return this.getTerrainName();
    }

    @Override
    public String getEffectCategory() {
        return null;
    }

    @Override
    public float getMaxEffectRadius(Vector2f locFrom) {
        return this.getRenderRange();
    }

    @Override
    public float getMinEffectRadius(Vector2f locFrom) {
        return 0.0f;
    }

    @Override
    public float getOptimalEffectRadius(Vector2f locFrom) {
        return this.getMaxEffectRadius(locFrom);
    }

    @Override
    public boolean hasMapIcon() {
        return false;
    }

    @Override
    public boolean canPlayerHoldStationIn() {
        return false;
    }

    public static class WavefrontParams {
        public float burnLevel;
        public float crLossMult;
        public float arcOriginRange;
        public float startWidth;
        public float widthExpansionRate;
        public float startThickness;
        public float thicknessExpansionRate;
        public float duration;
        public float angle;

        public WavefrontParams(float burnLevel, float crLossMult, float arcOriginRange, float startWidth, float widthExpansionRate, float startThickness, float thicknessExpansionRate, float duration, float angle) {
            this.burnLevel = burnLevel;
            this.crLossMult = crLossMult;
            this.arcOriginRange = arcOriginRange;
            this.startWidth = startWidth;
            this.widthExpansionRate = widthExpansionRate;
            this.startThickness = startThickness;
            this.thicknessExpansionRate = thicknessExpansionRate;
            this.duration = duration;
            this.angle = angle;
        }
    }
}

